/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Tipos;
import jalis.comum.dados.DadosExameRequisicao;
import jalis.util.ModeloGridTable;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class RenderizarExameColeta
extends DefaultTableCellRenderer {
    private int colunaExterno = 0;
    private int colunaSituacao = 8;
    private int colunaDadosExameRequisicao = 2;
    private String externo = "";

    public RenderizarExameColeta(int colunaDadosExameRequisicao, int colunaExterno, String externo, int colunaSituacao) {
        this.colunaExterno = colunaExterno;
        this.externo = externo;
        this.colunaSituacao = colunaSituacao;
        this.colunaDadosExameRequisicao = colunaDadosExameRequisicao;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ModeloGridTable m = (ModeloGridTable)table.getModel();
        this.setText(value.toString());
        this.setFont(table.getFont());
        this.setOpaque(true);
        Color corFore = this.getForeground();
        String situacao = m.getValueAt(row, this.colunaSituacao) != null ? m.getValueAt(row, this.colunaSituacao).toString() : "";
        Color[] corSituacao = Tipos.getCorSituacaoExame(situacao);
        if (isSelected && m.getValueAt(row, this.colunaExterno).toString().equals(this.externo)) {
            this.setBackground(Tipos.COR_MATERIAL_EXTERNO_SELECIONADO);
        } else if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else if (m.getValueAt(row, this.colunaExterno).toString().equals(this.externo)) {
            this.setBackground(Tipos.COR_MATERIAL_EXTERNO);
        } else {
            this.setBackground(corSituacao[0]);
            this.setForeground(corSituacao[1]);
        }
        if (m.getValueAt(row, this.colunaDadosExameRequisicao) != null && m.getValueAt(row, this.colunaDadosExameRequisicao) instanceof DadosExameRequisicao && ((DadosExameRequisicao)m.getValueAt(row, this.colunaDadosExameRequisicao)).isUrgente()) {
            this.setForeground(Color.RED);
        } else {
            this.setForeground(corFore);
        }
        return this;
    }
}

