/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class Renderizar
extends DefaultTableCellRenderer {
    private int colunaExterno = 0;
    private String externo = "";
    private int colunaEntrega = 0;
    private int colunaCortesia = 0;
    private int colunaEtqColeta = 0;
    private int colunaEtqTriagem = 0;
    private int colunaNaoFaturar = 0;
    private int colunaValorExame = -1;
    private int colunaDadosExames = -1;
    private int colunaSituacao = -1;
    private int colunaUrgente = -1;

    public Renderizar(int coluna, String externo, int colunaEntrega, int colunaCortesia, int colunaEtqColeta, int colunaEtqTriagem, int colunaSituacao, int colunaNaoFaturar, int colunaUrgente, int colunaValorExame, int colunaDadosExames) {
        this.colunaExterno = coluna;
        this.colunaEntrega = colunaEntrega;
        this.externo = externo;
        this.colunaCortesia = colunaCortesia;
        this.colunaEtqColeta = colunaEtqColeta;
        this.colunaEtqTriagem = colunaEtqTriagem;
        this.colunaSituacao = colunaSituacao;
        this.colunaNaoFaturar = colunaNaoFaturar;
        this.colunaUrgente = colunaUrgente;
        this.colunaValorExame = colunaValorExame;
        this.colunaDadosExames = colunaDadosExames;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        ModeloGridTable m = (ModeloGridTable)table.getModel();
        this.setOpaque(true);
        if (column == this.colunaEntrega) {
            if (value == null) {
                this.setText(!Acesso.getAcesso(200500187L) ? "Avisar" : "");
            } else {
                this.setText(Funcoes.formataData((Date)value));
            }
        } else if (value == null) {
            this.setText("");
        } else {
            this.setText(value.toString());
        }
        if (this.colunaValorExame > -1 && column == this.colunaValorExame && value != null) {
            this.setText(Funcoes.formataDecimal(((BigDecimal)value).doubleValue(), ParametrosGerais.getCasasPrecoExame()));
        }
        if (m.getValueAt(row, this.colunaNaoFaturar) != null && !Funcoes.textoVazio(m.getValueAt(row, this.colunaNaoFaturar).toString())) {
            this.setText("<html><u>" + this.getText() + "</u></html>");
        }
        String situacao = this.colunaSituacao > -1 && m.getValueAt(row, this.colunaSituacao) != null ? m.getValueAt(row, this.colunaSituacao).toString() : "";
        String naoFaturar = (String)m.getValueAt(row, this.colunaNaoFaturar);
        if (isSelected) {
            if (((String)m.getValueAt(row, this.colunaExterno)).equals(this.externo)) {
                this.setBackground(Tipos.COR_MATERIAL_EXTERNO_SELECIONADO);
            } else if (m.getValueAt(row, this.colunaCortesia) != null) {
                this.setBackground(ScreenUtil.escurecerCor(Color.cyan, 50));
            } else if (situacao.equals("A")) {
                this.setBackground(ScreenUtil.escurecerCor(Tipos.COR_APENAS_FATURAMENTO[0], 20));
            } else if (situacao.equals("N")) {
                this.setBackground(Tipos.COR_TRANSPORTE[0]);
            } else if (!Funcoes.textoVazio(naoFaturar)) {
                this.setBackground(table.getSelectionBackground());
                this.setText("<html><u>" + this.getText() + "</u></html>");
            } else {
                this.setBackground(table.getSelectionBackground());
            }
        } else if (((String)m.getValueAt(row, this.colunaExterno)).equals(this.externo)) {
            this.setBackground(Tipos.COR_MATERIAL_EXTERNO);
        } else if (m.getValueAt(row, this.colunaCortesia) != null) {
            this.setBackground(Color.cyan);
        } else if (situacao.equals("A")) {
            this.setBackground(Tipos.COR_APENAS_FATURAMENTO[0]);
        } else if (situacao.equals("N")) {
            this.setBackground(Tipos.COR_TRANSPORTE[0]);
        } else if (!Funcoes.textoVazio(naoFaturar)) {
            this.setBackground(table.getBackground());
            this.setText("<html><u>" + this.getText() + "</u></html>");
        } else if (situacao.equals("R")) {
            this.setBackground(Tipos.COR_RECOLETA[0]);
        } else if (situacao.equals("O")) {
            this.setBackground(Tipos.COR_REPETICAO[0]);
        } else if (situacao.equals("F")) {
            this.setBackground(Tipos.COR_FALTA_MATERIAL[0]);
        } else {
            this.setBackground(table.getBackground());
        }
        if (m.getValueAt(row, this.colunaEtqColeta) != null && !Funcoes.textoVazio(m.getValueAt(row, this.colunaEtqColeta).toString()) || m.getValueAt(row, this.colunaEtqTriagem) != null && !Funcoes.textoVazio(m.getValueAt(row, this.colunaEtqTriagem).toString())) {
            this.setFont(table.getFont().deriveFont(2));
        } else {
            this.setFont(table.getFont());
        }
        if (m.getValueAt(row, this.colunaUrgente) != null && m.getValueAt(row, this.colunaUrgente) instanceof Boolean && ((Boolean)m.getValueAt(row, this.colunaUrgente)).booleanValue()) {
            this.setForeground(Color.RED);
        } else if (situacao.equals("A")) {
            this.setForeground(Color.WHITE);
        } else {
            this.setForeground(table.getForeground());
        }
        return this;
    }
}

