/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.laboratorio.recepcao.coletar.ColetarMaterial;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.util.Funcoes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class RenderColetarMaterial
extends JPanel
implements ListCellRenderer {
    private boolean ignorarBoxColeta = false;
    private boolean apresentarSituacao = false;
    private JLabel labelColetar = new JLabel("EM COLETA");

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DadosRequisicao dados = (DadosRequisicao)value;
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        StringBuilder buf = new StringBuilder(String.valueOf(dados.getCodigo()));
        if (!Funcoes.textoVazio(dados.getIdRequisicaoSalux())) {
            buf.append(" / ").append("ID: ").append(dados.getIdRequisicaoSalux());
        }
        p.add((Component)this.criarJLabel(buf.toString()), c);
        this.labelColetar.setForeground(Color.green);
        ++c.gridx;
        if (dados.getEmColetaSalux() != null && dados.getEmColetaSalux().booleanValue()) {
            p.add((Component)this.labelColetar, c);
        }
        this.labelColetar.setVisible(dados != null && !Funcoes.textoVazio(dados.getIdRequisicaoSalux()));
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 0;
        JLabel labelBox = this.criarJLabel("", 60);
        if (!Funcoes.textoVazio(dados.getBoxColeta())) {
            if (dados.getBoxColeta().equals(ColetarMaterial.TEXTO_APENAS_CHAMADO) || this.ignorarBoxColeta) {
                labelBox.setText("Em coleta");
            } else if (!this.ignorarBoxColeta) {
                labelBox.setText("Box: " + dados.getBoxColeta());
            }
        }
        p.add((Component)labelBox, c);
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        JLabel l = this.criarJLabel(dados.getPaciente());
        l.setFont(new Font(l.getFont().getName(), 1, l.getFont().getSize()));
        p.add((Component)l, c);
        if (null != dados.getNomeSocial()) {
            c.gridx = 1;
            c.gridwidth = 0;
            JLabel lNomeSocial = this.criarJLabel("Social: " + dados.getNomeSocial());
            lNomeSocial.setFont(new Font(lNomeSocial.getFont().getName(), 1, lNomeSocial.getFont().getSize()));
            p.add((Component)lNomeSocial, c);
        }
        if (this.apresentarSituacao) {
            ++c.gridy;
            p.add((Component)this.criarJLabel("Sit: " + dados.getSituacao()), c);
        }
        if (dados.isGHosp()) {
            ++c.gridy;
            c.gridx = 0;
            p.add((Component)this.criarJLabel("Ala: " + dados.getAla()), c);
            c.gridx = 1;
            c.gridwidth = 0;
            JLabel setor = this.criarJLabel("Setor: " + dados.getSetor());
            p.add((Component)setor, c);
            c.gridx = 0;
        }
        if (!Funcoes.textoVazio(dados.getIdRequisicaoSalux())) {
            ++c.gridy;
            c.gridx = 0;
            StringBuilder dataNascimento = new StringBuilder("DN: ").append(Funcoes.formataData(dados.getDataNascimento()));
            p.add((Component)this.criarJLabel(dataNascimento.toString()), c);
            c.gridx = 1;
            c.gridwidth = 0;
            StringBuilder sexo = new StringBuilder("Sexo: ").append(dados.getSexo());
            p.add((Component)this.criarJLabel(sexo.toString()), c);
            c.gridx = 0;
        }
        ++c.gridy;
        int tempoEspera = 0;
        if (dados.getDataParaTempo() != null) {
            tempoEspera = Funcoes.diferencaEmMinutos(dados.getDataParaTempo(), new Date());
        }
        if (tempoEspera < 0) {
            tempoEspera = 0;
        }
        if (null != dados.getNomeSocial()) {
            c.gridx = 0;
            p.add((Component)this.criarJLabel("Tempo de espera: " + (tempoEspera < 60 ? tempoEspera + " minuto(s)" : tempoEspera / 60 + " hora(s)")), c);
        } else {
            p.add((Component)this.criarJLabel("Tempo de espera: " + (tempoEspera < 60 ? tempoEspera + " minuto(s)" : tempoEspera / 60 + " hora(s)")), c);
        }
        c.weighty = 1.0;
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        p.add((Component)new JPanel(), c);
        p.setOpaque(isSelected);
        p.setBackground(list.getSelectionBackground());
        return p;
    }

    private JLabel criarJLabel(String texto) {
        return this.criarJLabel(texto, 80);
    }

    private JLabel criarJLabel(String texto, int width) {
        JLabel l = new JLabel(texto);
        l.setFont(new Font(l.getFont().getName(), 0, 10));
        if (width > 0) {
            l.setPreferredSize(new Dimension(width, 16));
            l.setMinimumSize(new Dimension(width, 16));
        }
        return l;
    }

    public void setIgnorarBoxColeta(boolean b) {
        this.ignorarBoxColeta = b;
    }

    public void setApresentarSituacao(boolean b) {
        this.apresentarSituacao = b;
    }
}

