/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.utils.ThreadDaoException;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class RemoverMultiguia
extends AbstractDialogoOKCancelar {
    private final String[] colunas = new String[]{"Requisi\u00e7\u00e3o", "Data", "Hora"};
    private final ModeloGridTable modelo = new ModeloGridTable(this.colunas);
    private final JTable tabela = new JTable(this.modelo){

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return super.getColumnClass(c);
        }
    };
    private JScrollPane scrollPane = new JScrollPane(this.tabela);
    private String codigoRequisicao = null;
    private String codigoFilial = null;
    private boolean isOK = false;
    private RequisicaoBean reqBean = null;
    private int COLUNA_REQUISICAO = 0;
    private int COLUNA_DATA_REQUISICAO = 1;
    private int COLUNA_HORA_REQUISICAO = 2;
    private int COLUNA_OBJETO_REQUISICAO = 3;
    private int COLUNA_REQUISICAO_PAI = 4;

    public static RemoverMultiguia novaInstancia(Object owner, String codigoPaciente, String codigoRequisicaoEdicao, String codigoFilial) {
        if (owner instanceof Frame) {
            return new RemoverMultiguia((Frame)owner, codigoPaciente, codigoRequisicaoEdicao, codigoFilial);
        }
        if (owner instanceof Dialog) {
            return new RemoverMultiguia((Dialog)owner, codigoPaciente, codigoRequisicaoEdicao, codigoFilial);
        }
        return null;
    }

    public RemoverMultiguia(Frame owner, String codigoPaciente, String codigoRequisicaoEdicao, String codigoFilial) {
        super(owner, "Remover Multiguia");
        this.codigoRequisicao = codigoRequisicaoEdicao;
        this.codigoFilial = codigoFilial;
        this.montaTela(owner);
        this.selecionaRequisicao(codigoRequisicaoEdicao);
    }

    public RemoverMultiguia(Dialog owner, String codigoPaciente, String codigoRequisicaoEdicao, String codigoFilial) {
        super(owner, "Remover Multiguia");
        this.codigoRequisicao = codigoRequisicaoEdicao;
        this.codigoFilial = codigoFilial;
        this.montaTela(owner);
        this.selecionaRequisicao(codigoRequisicaoEdicao);
    }

    private void selecionaRequisicao(String codigoRequisicao) {
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!this.modelo.getValueAt(i, this.COLUNA_REQUISICAO).toString().equalsIgnoreCase(codigoRequisicao)) continue;
            this.tabela.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
    }

    private void montaTela(Component comp) {
        this.setSize(new Dimension(300, 250));
        this.setLocationRelativeTo(comp);
        this.setResizable(false);
        this.buttonOK.setText("Remover");
        this.tabela.getSelectionModel().setSelectionMode(0);
        this.modelo.setColumnSize(new int[]{80, 100, 0}, this.tabela);
        this.scrollPane.setPreferredSize(new Dimension(this.getWidth() - 20, this.getHeight() - 70));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.scrollPane, "Center");
        ScreenUtil.centralizar(this);
        this.adicionaRequisicoesMultiguia();
    }

    private void adicionaRequisicoesMultiguia() {
        Integer[] codigos = null;
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        try {
            codigos = RecepcaoUtil.verificaMultiGuias(this.getCodigoFilial(), this.codigoRequisicao, true);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar as multiguias.\n" + e.getMessage(), e.getStackTrace());
        }
        if (codigos != null) {
            for (Integer codigo : codigos) {
                chaves.clear();
                chaves.put("fil_codigo", this.getCodigoFilial());
                chaves.put("req_codigo", codigo);
                try {
                    this.reqBean = (RequisicaoBean)new RequisicaoService().getBean(chaves);
                }
                catch (ThreadDaoException e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar as requisi\u00e7\u00f5es multiguias.\n" + e.getMessage(), e.getStackTrace());
                }
                if (codigos.length <= 1) continue;
                this.modelo.addLine(new Object[]{this.reqBean.getCodigo(), Funcoes.formataData("dd/MM/yyyy", this.reqBean.getData()), Funcoes.formataHora(this.reqBean.getHora(), false), this.reqBean, this.procuraPai(this.reqBean.getCodigo())});
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.isOK = this.removerLigacao();
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean removerLigacao() {
        StringBuilder buf = new StringBuilder();
        buf.append("delete from requisicaorequisicao ");
        buf.append(" where fil_codigo = ?");
        buf.append("   and req_kodigo = ?");
        PreparedStatement stDeletaFilho = Conexao.getPreparedStatement(buf.toString());
        buf.delete(0, buf.length());
        buf.append("delete from requisicaorequisicao ");
        buf.append(" where fil_codigo = ?");
        buf.append("   and req_kodigo = ?");
        PreparedStatement stDeletaPai = Conexao.getPreparedStatement(buf.toString());
        buf.delete(0, buf.length());
        buf.append("update requisicaorequisicao set req_codigo = ?");
        buf.append(" where fil_codigo = ?");
        buf.append("   and req_kodigo = ?");
        PreparedStatement stPai = Conexao.getPreparedStatement(buf.toString());
        int linhaSelecionada = this.tabela.getSelectedRow();
        boolean isPai = (Boolean)this.modelo.getValueAt(linhaSelecionada, this.COLUNA_REQUISICAO_PAI);
        if (Funcoes.mensagem(Laboratorio.getInstancia(), "A liga\u00e7\u00e3o da multiguia ser\u00e1 removida.\nDeseja continuar? ", 4) == 0) {
            if (linhaSelecionada > -1 && isPai) {
                int i;
                RequisicaoBean beanPai = (RequisicaoBean)this.modelo.getValueAt(linhaSelecionada, this.COLUNA_OBJETO_REQUISICAO);
                int menorCodigo = 0;
                int pos = -1;
                for (i = 0; i < this.modelo.getRowCount(); ++i) {
                    int codigoRequisicao = (Integer)this.modelo.getValueAt(i, this.COLUNA_REQUISICAO);
                    if (codigoRequisicao != beanPai.getCodigo() && menorCodigo == 0) {
                        menorCodigo = codigoRequisicao;
                        pos = i;
                    }
                    if (codigoRequisicao == beanPai.getCodigo() || codigoRequisicao >= menorCodigo) continue;
                    menorCodigo = codigoRequisicao;
                    pos = i;
                }
                for (i = 0; i < this.modelo.getRowCount(); ++i) {
                    RequisicaoBean bean = (RequisicaoBean)this.modelo.getValueAt(i, this.COLUNA_OBJETO_REQUISICAO);
                    if (bean.getCodigo() == menorCodigo || i == linhaSelecionada) continue;
                    try {
                        stPai.setInt(1, menorCodigo);
                        stPai.setInt(2, bean.getFilial().getCodigo());
                        stPai.setInt(3, bean.getCodigo());
                        Conexao.executeUpdate(this.getCodigoFilial(), Conexao.getStatement(), stPai.toString());
                        Conexao.arquivaSQL();
                        continue;
                    }
                    catch (Exception e) {
                        try {
                            stPai.cancel();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar a multiguia.\n" + e.getMessage(), e.getStackTrace());
                    }
                }
                beanPai = (RequisicaoBean)this.modelo.getValueAt(pos, this.COLUNA_OBJETO_REQUISICAO);
                try {
                    stDeletaPai.setInt(1, beanPai.getFilial().getCodigo());
                    stDeletaPai.setInt(2, menorCodigo);
                    Conexao.executeUpdate(this.getCodigoFilial(), Conexao.getStatement(), stDeletaPai.toString());
                    stDeletaPai.close();
                }
                catch (SQLException e) {
                    try {
                        Conexao.anulaSQL();
                        stDeletaPai.cancel();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel atualizar a multiguia.\n" + e.getMessage(), e.getStackTrace());
                }
                try {
                    Conexao.arquivaSQL();
                    this.codigoRequisicao = String.valueOf(menorCodigo);
                    stPai.close();
                    this.setVisible(false);
                    return true;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            RequisicaoBean bean = null;
            if (linhaSelecionada > -1) {
                bean = (RequisicaoBean)this.modelo.getValueAt(linhaSelecionada, this.COLUNA_OBJETO_REQUISICAO);
            }
            try {
                if (bean != null) {
                    stDeletaFilho.setInt(1, bean.getFilial().getCodigo());
                    stDeletaFilho.setInt(2, bean.getCodigo());
                }
                Conexao.executeUpdate(this.getCodigoFilial(), Conexao.getStatement(), stDeletaFilho.toString());
                stDeletaFilho.close();
                Conexao.arquivaSQL();
                this.codigoRequisicao = bean.getCodigo().toString();
                this.setVisible(false);
                return true;
            }
            catch (SQLException e) {
                try {
                    Conexao.anulaSQL();
                    stDeletaFilho.cancel();
                    return false;
                }
                catch (SQLException e1) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel cancelar opera\u00e7\u00e3o.\n" + e1.getMessage(), e1.getStackTrace());
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel executar opera\u00e7\u00e3o.\n" + e.getMessage(), e.getStackTrace());
                }
            }
        }
        return false;
    }

    @Override
    public boolean acaoOk() {
        return this.isOK;
    }

    public int codigoRemovido() {
        return Integer.parseInt(this.codigoRequisicao);
    }

    private boolean procuraPai(Integer value) {
        boolean isPai = false;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select req_kodigo from requisicaorequisicao ");
        buf.append("where fil_codigo = '").append(this.getCodigoFilial()).append("' ");
        buf.append("  and req_codigo = ").append(value);
        buf.append("\tlimit 1");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            isPai = rs.next();
            rs.close();
            st.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar multiguia.\n" + e.getMessage(), e.getStackTrace());
            return false;
        }
        return isPai;
    }

    private String getCodigoFilial() {
        if (this.codigoFilial == null || this.codigoFilial.isEmpty()) {
            this.codigoFilial = Variaveis.filialPadrao;
        }
        return this.codigoFilial;
    }
}

