/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;

public enum RacaCorPaciente {
    BRANCO("Branco", "B"),
    PARDO("Pardo", "P"),
    AMARELO("Amarelo", "A"),
    NEGRO("Negro", "N"),
    INDIGENA("Ind\u00edgena", "M"),
    OUTRO("Outro", "O"),
    NAO_INFORMADO("N\u00e3o informado", "I");

    private String descricao;
    private String codigo;

    private RacaCorPaciente(String descricao, String codigo) {
        this.descricao = descricao;
        this.codigo = codigo;
    }

    public String getCodigo() {
        return this.codigo;
    }

    public String toString() {
        return this.descricao;
    }

    public static RacaCorPaciente getRacaCorPorCodigo(String codigo) {
        if (!Funcoes.textoVazio(codigo)) {
            for (RacaCorPaciente r : RacaCorPaciente.values()) {
                if (!codigo.equalsIgnoreCase(r.getCodigo())) continue;
                return r;
            }
        }
        return BRANCO;
    }
}

