/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class PedirToken
extends JDialog
implements DisposeListener {
    private JLabel lblToken = new JLabel("Token:");
    private TTextField txtToken = new TTextField(10);
    private JButton btnOK = new JButton("OK");
    private JButton btnCancelar = new JButton("Cancelar");
    private JPanel panelBotao = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(null);
    private String mascaraToken = "";
    private boolean obrigaToken = false;
    private boolean ok = false;

    public PedirToken(Frame owner, String mascaraToken, boolean obrigaToken) {
        super(owner, "Informa\u00e7\u00f5es de token");
        this.montaTela(owner, mascaraToken, obrigaToken);
    }

    public PedirToken(Dialog owner, String mascaraToken, boolean obrigaToken) {
        super(owner, "Informa\u00e7\u00f5es de token");
        this.montaTela(owner, mascaraToken, obrigaToken);
    }

    private void montaTela(Object owner, String mascaraToken, boolean obrigaToken) {
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelBotao, "South");
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setSize(310, 110);
        ScreenUtil.centralizar(this);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotao);
        this.lblToken.setBounds(new Rectangle(5, 10, 69, 14));
        this.txtToken.setBounds(new Rectangle(55, 8, 230, 20));
        if (!obrigaToken) {
            this.txtToken.setFocusLostBehavior(0);
        }
        this.panelBotao.add(this.btnOK);
        this.panelBotao.add(this.btnCancelar);
        this.panelCentro.add(this.lblToken);
        this.panelCentro.add(this.txtToken);
        this.txtToken.grabFocus();
        this.btnOK.setMnemonic('O');
        this.btnCancelar.setMnemonic('C');
        this.btnOK.addActionListener(action -> this.getBtnOk());
        this.btnCancelar.addActionListener(naction -> {
            this.ok = false;
            this.setVisible(false);
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PedirToken.this.ok = false;
                PedirToken.this.setVisible(false);
            }
        });
        this.validaMascara(mascaraToken);
    }

    public void getBtnOk() {
        boolean tokenObrigatorio;
        boolean bl = tokenObrigatorio = this.getObrigaToken() && Funcoes.textoVazio(this.txtToken.getText());
        if (tokenObrigatorio || PedirToken.tokenSomenteZero(this.txtToken.getText()) || !Funcoes.textoVazio(this.getMascaraToken()) && this.tamanhoTokenInvalido()) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Token Inv\u00e1lido", 2);
            this.txtToken.grabFocus();
        } else {
            this.ok = true;
            this.setVisible(false);
        }
    }

    private boolean tamanhoTokenInvalido() {
        return this.txtToken.getText().trim().length() != this.getMascaraToken().length();
    }

    public void validaMascara(String mascaraToken) {
        block7: {
            String token = "";
            if (!Funcoes.textoVazio(mascaraToken)) {
                try {
                    token = this.getToken();
                    this.txtToken.setFormatterFactory(null);
                    MaskFormatter format = new MaskFormatter(mascaraToken);
                    format.setPlaceholder(this.getToken());
                    this.txtToken.setFormatterFactory(new DefaultFormatterFactory(format));
                    this.txtToken.setValue(null);
                    if (this.quantidadeDeDigitos(mascaraToken).intValue() == this.auxiliarMascara(token).length() || Funcoes.textoVazio(this.auxiliarMascara(token))) {
                        this.txtToken.setText(this.auxiliarMascara(token));
                        break block7;
                    }
                    this.txtToken.clear();
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
            } else {
                this.txtToken.setFormatterFactory(null);
                this.txtToken.setValue(null);
                if (!Funcoes.textoVazio(token)) {
                    this.txtToken.setText(token);
                } else {
                    this.txtToken.clear();
                }
            }
        }
    }

    public String auxiliarMascara(String token) {
        StringBuilder auxMatricula = new StringBuilder();
        for (int i = 0; i < token.length(); ++i) {
            String aux = token.substring(i, i + 1);
            if (!Funcoes.isNumeric(aux)) continue;
            auxMatricula.append(aux);
        }
        return auxMatricula.toString();
    }

    public Integer quantidadeDeDigitos(String mascara) {
        int qtdeDigitos = 0;
        for (int i = 0; i < mascara.length(); ++i) {
            String aux = mascara.substring(i, i + 1);
            if (!aux.equalsIgnoreCase("#")) continue;
            ++qtdeDigitos;
        }
        return qtdeDigitos;
    }

    public static String limpaMascaraToken(String token) {
        return token.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static boolean tokenSomenteZero(String reqToken) {
        return reqToken.matches("^0*$");
    }

    public boolean getOK() {
        return this.ok;
    }

    public String getToken() {
        return this.txtToken.getText();
    }

    public void setToken(String requisicaoToken) {
        this.txtToken.setText(requisicaoToken);
    }

    public String getMascaraToken() {
        return this.mascaraToken;
    }

    public void setMascaraToken(String mascaraToken) {
        this.mascaraToken = mascaraToken;
    }

    public boolean getObrigaToken() {
        return this.obrigaToken;
    }

    public void setObrigaToken(boolean pedirToken) {
        this.obrigaToken = pedirToken;
    }
}

