/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Pais;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.recepcao.util.TipoRecebimento;
import jalis.model.bean.cadastro.PaisBean;
import jalis.model.bean.cadastro.material.EmbalagemRecebidaBean;
import jalis.model.bean.recepcao.RequisicaoBean;
import jalis.model.vo.cadastro.auxiliares.PaisVO;
import jalis.model.vo.cadastro.material.EmbalagemRecebidaVO;
import jalis.model.vo.estoque.UnidadeMedidaVO;
import jalis.service.cadastro.auxiliares.PaisService;
import jalis.service.cadastro.material.EmbalagemRecebidaService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class PanelAlimentos
extends JPanel
implements ActionListener {
    private final JLabel labelDecricaoPais = new JLabel();
    private final JLabel labelPais = ComponenteFactory.novoJLabel(" Pa\u00eds origem:", 'W', null, null, null);
    private final JButton buttonPais = ComponenteFactory.novoJButton(this, true);
    private final TTextField textCodVPais = new TTextField(10, 1);
    private final JLabel labelCodCertificadoAlimentos = new JLabel(" N. certificado:");
    private final JLabel labelProgramaAlimentos = new JLabel(" Programa:");
    private TTextField numeroCertificado = new TTextField(40);
    private final JLabel labelTca = new JLabel("Termo coleta amostra:");
    private TTextField termoColetaAmostra = new TTextField(20);
    private TTextField textFornecedor = new TTextField(150);
    private TTextField textDescricaoProduto = new TTextField(150);
    private TTextField textAreaProduto = new TTextField(10);
    private JLabel labelArea = new JLabel("\u00c1rea:");
    private JLabel labelDataCertificado = new JLabel("Data certificado:");
    private JLabel labelOrdemCompra = new JLabel("Ordem de compra:");
    private TTextField textDataFabricacao = new TTextField(40);
    private TTextField certificadoOrigem = new TTextField(40);
    private TTextField textNumeroRegistro = new TTextField(25);
    private TTextField textTemperaturaColeta = new TTextField(40);
    private TTextField textNumeroLote = new TTextField(25);
    private TTextField textDataValidade = new TTextField(30);
    private TTextField textMarcaProduto = new TTextField(100);
    private TTextField textLacre = new TTextField(25);
    private TTextField textLacreContraprova = new TTextField(25);
    private TTextField textLacreContraprovaEmpresa = new TTextField(25);
    private TTextField textDoctoReferencia = new TTextField(20);
    private TTextField textNumeroSolicitacao = new TTextField(20);
    private TTextField textLocalColetado = new TTextField(100);
    private TTextField textTemperaturaRecebimento = new TTextField(40);
    private TTextField textDataColeta = new TTextField(10, 4);
    private TTextField textHoraColeta = new TTextField(5, 6);
    private TTextField textOrdemCompra = new TTextField(100);
    private JButton buttonDataColeta = ComponenteFactory.novoJButton(this, true);
    private JTextArea textSanitarias = new JTextArea(new TTextAreaDocument(500));
    private JTextArea textCondicoes = new JTextArea(new TTextAreaDocument(500));
    private JTextArea textProcedimento = new JTextArea(new TTextAreaDocument(500));
    private TTextField textPartida = new TTextField(20);
    private JButton buttonDataFabricacao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataCertificadoAlimento = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataValidade = ComponenteFactory.novoJButton(this, true);
    private TTextField textDataRecebimento = new TTextField(10, 4);
    private TTextField textHoraRecebimento = new TTextField(5, 6);
    private JButton buttonDataRecebimento = ComponenteFactory.novoJButton(this, true);
    private JComboBox comboTipoRecebimento = new JComboBox<TipoRecebimento>(new TipoRecebimento[]{new TipoRecebimento("C", Tipos.tipoRecebimentoProduto("C")), new TipoRecebimento("G", Tipos.tipoRecebimentoProduto("G")), new TipoRecebimento("R", Tipos.tipoRecebimentoProduto("R")), new TipoRecebimento("A", Tipos.tipoRecebimentoProduto("A")), new TipoRecebimento("D", Tipos.tipoRecebimentoProduto("D"))});
    private TTextField textQtdeAmostras = new TTextField(4, 1);
    private TTextField textQtdeUnidade = new TTextField(8, 2, 3);
    private JComboBox comboUnidade = new JComboBox<String>(this.pegaUnidades());
    private JComboBox comboEmbalagem = new JComboBox();
    private JComboBox comboProduto = ComponenteFactory.novoJcomboBoxPopup(new Object[]{""}, 50, 0);
    private JComboBox comboCategoria = ComponenteFactory.novoJcomboBoxPopup(new Object[]{""}, 90, 0);
    private JPanel panelPRP = new JPanel(new GridBagLayout());
    private TTextField textAnoPRP = new TTextField(4, 1);
    private TTextField textCicloPRP = new TTextField(10);
    private TTextField textAmostraPRP = new TTextField(10);
    private TTextField textAmostraSupPRP = new TTextField(10);
    private TTextField textHoraInicioTurnoPRP = new TTextField(5, 6);
    private TTextField textTurnoPRP = new TTextField(10);
    private TTextField textLinhaPRP = new TTextField(10);
    private TTextField textProgramaPRP = new TTextField(50);
    private TTextField textVolumeAbatePRP = new TTextField(15);
    private HashMap<String, TipoRecebimento> produtoAlimentos = new HashMap();
    private static String codigoProdutoAlimento = null;
    private Requisicao requisicao;
    private Integer codigoFilial = null;

    public PanelAlimentos(Requisicao requisicao) {
        super(new GridBagLayout());
        this.requisicao = requisicao;
        this.montaTela();
        this.setMostrarCamposArea(false);
        this.setMostrarPRP(false);
        this.carregaEmbalagens();
    }

    public PanelAlimentos() {
        super(new GridBagLayout());
        this.montaTela();
        this.setMostrarCamposArea(false);
        this.setMostrarPRP(false);
        this.carregaEmbalagens();
    }

    private void montaTela() {
        this.textCondicoes.setWrapStyleWord(true);
        this.textCondicoes.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textCondicoes);
        this.textProcedimento.setWrapStyleWord(true);
        this.textProcedimento.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textProcedimento);
        this.textSanitarias.setWrapStyleWord(true);
        this.textSanitarias.setLineWrap(true);
        ScreenUtil.montaSaidaTextArea(this.textSanitarias);
        this.textCodVPais.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelAlimentos.this.pesquisarPais();
                }
            }
        });
        this.textCodVPais.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    if (!Funcoes.textoVazio(PanelAlimentos.this.textCodVPais.getText())) {
                        HashMap<String, Object> chaves = new HashMap<String, Object>();
                        chaves.put("fil_codigo", Variaveis.filialPadrao);
                        chaves.put("pai_codigo", PanelAlimentos.this.textCodVPais.getText());
                        PaisBean paisBean = (PaisBean)new PaisService().getBean(chaves);
                        if (paisBean != null) {
                            PanelAlimentos.this.textCodVPais.setText(paisBean.getCodigo().toString());
                            PanelAlimentos.this.labelDecricaoPais.setText(paisBean.getNome());
                        } else {
                            PanelAlimentos.this.labelDecricaoPais.setText("N\u00e3o cadastrado");
                            PanelAlimentos.this.textCodVPais.selectAll();
                        }
                    }
                }
                catch (Exception e1) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Fornecedor n\u00e3o identificado", 1);
                }
            }
        });
        this.textDataColeta.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelAlimentos.this.buttonDataColeta.doClick();
                }
            }
        });
        this.textDataFabricacao.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelAlimentos.this.buttonDataFabricacao.doClick();
                }
            }
        });
        this.certificadoOrigem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelAlimentos.this.buttonDataCertificadoAlimento.doClick();
                }
            }
        });
        this.textDataValidade.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelAlimentos.this.buttonDataValidade.doClick();
                }
            }
        });
        this.textDataRecebimento.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    PanelAlimentos.this.buttonDataRecebimento.doClick();
                }
            }
        });
        this.textDataRecebimento.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (Variaveis.tipoFilialPadrao.equals("A") && PanelAlimentos.this.requisicao.validaDataRecebimento()) {
                    PanelAlimentos.this.requisicao.recalcularData(PanelAlimentos.this.textDataRecebimento.getText());
                }
            }
        });
        this.comboCategoria.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TipoRecebimento categoria = (TipoRecebimento)PanelAlimentos.this.comboCategoria.getSelectedItem();
                ArrayList listaProduto = categoria != null && categoria.getLista() != null && !categoria.getLista().isEmpty() ? categoria.getLista() : new ArrayList();
                PanelAlimentos.this.comboProduto.removeAllItems();
                if (listaProduto != null) {
                    boolean existe = false;
                    for (TipoRecebimento produto : listaProduto) {
                        PanelAlimentos.this.comboProduto.addItem(produto);
                        if (!produto.codigo.equalsIgnoreCase(codigoProdutoAlimento)) continue;
                        PanelAlimentos.this.comboProduto.setSelectedItem(produto);
                    }
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        Insets insetsPadrao = new Insets(0, 0, 0, 0);
        c.anchor = 17;
        this.add((Component)new JLabel("Descri\u00e7\u00e3o:"), c);
        c.gridy = 1;
        this.add((Component)new JLabel("Marca:"), c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 5;
        c.fill = 2;
        c.weightx = 1.0;
        JPanel p1 = new JPanel(new GridBagLayout());
        p1.setPreferredSize(new Dimension(100, 20));
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.fill = 2;
        c1.weightx = 1.0;
        c1.anchor = 17;
        this.setPreferredMinimumSize(this.textDescricaoProduto, new Dimension(100, 20));
        p1.add((Component)this.textDescricaoProduto, c1);
        c1.weightx = 0.0;
        c1.gridx = 1;
        p1.add((Component)this.labelArea, c1);
        this.setPreferredMinimumSize(this.textAreaProduto, new Dimension(100, 20));
        c1.gridx = 2;
        p1.add((Component)this.textAreaProduto, c1);
        this.add((Component)p1, c);
        c.gridy = 1;
        this.setPreferredMinimumSize(this.textMarcaProduto, new Dimension(100, 20));
        this.add((Component)this.textMarcaProduto, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Categoria:"), c);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.insets = new Insets(0, 0, 1, 1);
        c.fill = 2;
        this.setPreferredMinimumSize(this.comboCategoria, new Dimension(150, 20));
        this.add((Component)this.comboCategoria, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        this.add((Component)new JLabel("Produto:"), c);
        c.gridx = 4;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.setPreferredMinimumSize(this.comboProduto, new Dimension(120, 20));
        this.add((Component)this.comboProduto, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c1.fill = 2;
        this.add((Component)new JLabel("Data Fabrica\u00e7\u00e3o:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Lote:"), c);
        c.gridx = 4;
        this.add((Component)new JLabel(" Validade:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        this.setPreferredMinimumSize(this.textDataFabricacao, new Dimension(100, 20));
        this.setPreferredMinimumSize(this.buttonDataFabricacao, new Dimension(20, 20));
        p.add(this.textDataFabricacao);
        p.add(this.buttonDataFabricacao);
        this.add((Component)p, c);
        c.gridwidth = 1;
        c.gridx = 3;
        this.setPreferredMinimumSize(this.textNumeroLote, new Dimension(70, 20));
        this.add((Component)this.textNumeroLote, c);
        c.insets = insetsPadrao;
        c.gridx = 5;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.textDataValidade, new Dimension(100, 20));
        this.setPreferredMinimumMaximumSize(this.buttonDataValidade, new Dimension(20, 20));
        p = new JPanel(new FlowLayout(0, 0, 0));
        p.add(this.textDataValidade);
        p.add(this.buttonDataValidade);
        this.add((Component)p, c);
        c.gridy = 4;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("N\u00famero registro:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Documento:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.textNumeroRegistro, new Dimension(100, 20));
        this.add((Component)this.textNumeroRegistro, c);
        c.gridwidth = 3;
        c.gridx = 3;
        this.setPreferredMinimumSize(this.textDoctoReferencia, new Dimension(100, 20));
        this.add((Component)this.textDoctoReferencia, c);
        c.gridy = 5;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Lacre:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Lacre cp:"), c);
        c.gridx = 4;
        this.add((Component)new JLabel(" Lacre empresa:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.textLacre, new Dimension(100, 20));
        this.add((Component)this.textLacre, c);
        c.gridwidth = 1;
        c.gridx = 3;
        this.setPreferredMinimumSize(this.textLacreContraprova, new Dimension(100, 20));
        this.add((Component)this.textLacreContraprova, c);
        c.gridx = 5;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.textLacreContraprovaEmpresa, new Dimension(100, 20));
        this.add((Component)this.textLacreContraprovaEmpresa, c);
        c.gridy = 6;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Solicita\u00e7\u00e3o:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Local coleta:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.textNumeroSolicitacao, new Dimension(100, 20));
        this.add((Component)this.textNumeroSolicitacao, c);
        c.gridwidth = 3;
        c.gridx = 3;
        this.setPreferredMinimumSize(this.textLocalColetado, new Dimension(100, 20));
        this.add((Component)this.textLocalColetado, c);
        c.gridy = 7;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Data coleta:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Hora:"), c);
        c.gridx = 4;
        this.add((Component)new JLabel(" Temp.coleta:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        p = new JPanel(new FlowLayout(0, 0, 0));
        this.setPreferredMinimumSize(this.textDataColeta, new Dimension(100, 20));
        this.setPreferredMinimumMaximumSize(this.buttonDataColeta, new Dimension(20, 20));
        p.add(this.textDataColeta);
        p.add(this.buttonDataColeta);
        this.add((Component)p, c);
        c.gridwidth = 1;
        c.insets = insetsPadrao;
        c.gridx = 3;
        this.setPreferredMinimumSize(this.textHoraColeta, new Dimension(55, 20));
        this.add((Component)this.textHoraColeta, c);
        c.gridx = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)this.textTemperaturaColeta, c);
        this.setPreferredMinimumSize(this.textTemperaturaColeta, new Dimension(80, 20));
        c.gridy = 8;
        c.gridx = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.add((Component)new JLabel("Data recebimento:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Hora:"), c);
        c.gridx = 4;
        this.add((Component)new JLabel(" Temp.receb:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        p = new JPanel(new FlowLayout(0, 0, 0));
        this.setPreferredMinimumSize(this.textDataRecebimento, new Dimension(100, 20));
        this.setPreferredMinimumMaximumSize(this.buttonDataRecebimento, new Dimension(20, 20));
        p.add(this.textDataRecebimento);
        p.add(this.buttonDataRecebimento);
        this.add((Component)p, c);
        c.gridwidth = 1;
        c.insets = insetsPadrao;
        c.gridx = 3;
        this.setPreferredMinimumSize(this.textHoraRecebimento, new Dimension(55, 20));
        this.add((Component)this.textHoraRecebimento, c);
        c.gridx = 5;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.add((Component)this.textTemperaturaRecebimento, c);
        this.setPreferredMinimumSize(this.textTemperaturaRecebimento, new Dimension(80, 20));
        c.gridy = 9;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Partida:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Embalagem:"), c);
        c.gridwidth = 1;
        c.gridx = 1;
        this.setPreferredMinimumSize(this.textPartida, new Dimension(100, 20));
        this.add((Component)this.textPartida, c);
        c.gridx = 3;
        c.gridwidth = 3;
        this.setPreferredMinimumSize(this.comboEmbalagem, new Dimension(100, 20));
        this.add((Component)this.comboEmbalagem, c);
        c.gridy = 10;
        c.gridx = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Qtde amostras:"), c);
        c.gridx = 2;
        this.add((Component)new JLabel(" Unidade:"), c);
        c.gridx = 4;
        this.add((Component)new JLabel(" Recebido:"), c);
        c.gridx = 1;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.textQtdeAmostras, new Dimension(80, 20));
        this.add((Component)this.textQtdeAmostras, c);
        c.gridwidth = 1;
        c.gridx = 3;
        p = new JPanel(new FlowLayout(0, 0, 0));
        this.setPreferredMinimumSize(this.textQtdeUnidade, new Dimension(55, 20));
        this.setPreferredMinimumSize(this.comboUnidade, new Dimension(65, 20));
        p.add(this.textQtdeUnidade);
        p.add(this.comboUnidade);
        this.add((Component)p, c);
        c.gridx = 5;
        c.gridwidth = 1;
        this.setPreferredMinimumSize(this.comboTipoRecebimento, new Dimension(100, 20));
        this.add((Component)this.comboTipoRecebimento, c);
        c.gridy = 12;
        c.gridx = 1;
        c.weightx = 1.0;
        this.panelPRP.setBorder(new TitledBorder("PRP"));
        this.panelPRP.setPreferredSize(new Dimension(0, 68));
        this.panelPRP.setMinimumSize(new Dimension(0, 68));
        c.gridwidth = 5;
        GridBagConstraints g = new GridBagConstraints();
        g.gridx = 0;
        g.gridy = 0;
        g.anchor = 17;
        this.panelPRP.add((Component)new JLabel(" Ano:"), g);
        g.gridx = 2;
        this.panelPRP.add((Component)new JLabel(" Ciclo:"), g);
        g.gridx = 4;
        this.panelPRP.add((Component)new JLabel(" Amostra:"), g);
        g.gridx = 6;
        this.panelPRP.add((Component)new JLabel(" Am.Sup.:"), g);
        g.gridx += 2;
        this.panelPRP.add((Component)this.labelProgramaAlimentos, g);
        this.setPreferredMinimumSize(this.textAnoPRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textCicloPRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textAmostraPRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textAmostraSupPRP, new Dimension(70, 20));
        g.weightx = 1.0;
        g.fill = 2;
        g.gridx = 1;
        this.panelPRP.add((Component)this.textAnoPRP, g);
        g.gridx = 3;
        this.panelPRP.add((Component)this.textCicloPRP, g);
        g.gridx = 5;
        this.panelPRP.add((Component)this.textAmostraPRP, g);
        g.gridx = 7;
        this.panelPRP.add((Component)this.textAmostraSupPRP, g);
        g.gridx = 0;
        g.gridy = 1;
        g.weightx = 0.0;
        g.anchor = 17;
        this.panelPRP.add((Component)new JLabel(" In\u00edcio turno:"), g);
        g.gridx = 2;
        this.panelPRP.add((Component)new JLabel(" Turno:"), g);
        g.gridx = 4;
        this.panelPRP.add((Component)new JLabel(" Linha:"), g);
        g.gridx = 6;
        this.panelPRP.add((Component)new JLabel(" Vol. abate/dia:"), g);
        this.setPreferredMinimumSize(this.textHoraInicioTurnoPRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textTurnoPRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textLinhaPRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textVolumeAbatePRP, new Dimension(70, 20));
        this.setPreferredMinimumSize(this.textProgramaPRP, new Dimension(70, 20));
        g.weightx = 1.0;
        g.gridx = 1;
        this.panelPRP.add((Component)this.textHoraInicioTurnoPRP, g);
        g.gridx = 3;
        this.panelPRP.add((Component)this.textTurnoPRP, g);
        g.gridx = 5;
        this.panelPRP.add((Component)this.textLinhaPRP, g);
        g.gridx = 7;
        this.panelPRP.add((Component)this.textVolumeAbatePRP, g);
        g.gridx += 2;
        g.gridy = 0;
        this.panelPRP.add((Component)this.textProgramaPRP, g);
        c.gridx = 0;
        c.gridwidth = 11;
        this.add((Component)this.panelPRP, c);
        c.gridy = 11;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 18;
        this.add((Component)new JLabel("Fornecedor:"), c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 5;
        this.add((Component)this.textFornecedor, c);
        this.setPreferredMinimumSize(this.textFornecedor, new Dimension(100, 20));
        ScreenUtil.setBorda(new JComponent[]{this.labelDecricaoPais}, new TitledBorder(""));
        c.insets = new Insets(0, 0, 0, 0);
        c.gridy = 13;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 2;
        this.add((Component)this.labelTca, c);
        ++c.gridx;
        c.gridy = 13;
        c.gridx = 1;
        c.gridwidth = 1;
        this.termoColetaAmostra.setPreferredSize(new Dimension(132, 20));
        this.termoColetaAmostra.setMinimumSize(new Dimension(132, 20));
        this.add((Component)this.termoColetaAmostra, c);
        c.gridy = 13;
        c.gridx = 2;
        c.gridwidth = 1;
        this.add((Component)this.labelPais, c);
        c.gridy = 13;
        c.gridx = 3;
        c.gridwidth = 5;
        c.fill = 2;
        JPanel panelPais = new JPanel(new GridBagLayout());
        GridBagConstraints bagConstraints = new GridBagConstraints();
        bagConstraints.insets = new Insets(0, 0, 0, 0);
        bagConstraints.anchor = 17;
        bagConstraints.gridx = 0;
        bagConstraints.gridy = 0;
        this.textCodVPais.setHorizontalAlignment(4);
        this.textCodVPais.setPreferredSize(new Dimension(53, 20));
        this.textCodVPais.setMinimumSize(new Dimension(53, 20));
        panelPais.add((Component)this.textCodVPais, bagConstraints);
        ++bagConstraints.gridx;
        this.buttonPais.setPreferredSize(new Dimension(20, 20));
        this.buttonPais.setMinimumSize(new Dimension(20, 20));
        panelPais.add((Component)this.buttonPais, bagConstraints);
        ++bagConstraints.gridx;
        bagConstraints.weightx = 1.0;
        bagConstraints.gridwidth = 5;
        bagConstraints.fill = 2;
        this.labelDecricaoPais.setPreferredSize(new Dimension(60, 20));
        this.labelDecricaoPais.setMinimumSize(new Dimension(60, 20));
        panelPais.add((Component)this.labelDecricaoPais, bagConstraints);
        this.add((Component)panelPais, c);
        c.gridy = 14;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)this.labelDataCertificado, c);
        c.gridy = 14;
        c.gridx = 1;
        c.gridwidth = 1;
        c.fill = 2;
        JPanel panelDataCertificado = new JPanel(new BorderLayout());
        this.setPreferredMinimumSize(this.certificadoOrigem, new Dimension(80, 20));
        this.setPreferredMinimumSize(this.buttonDataCertificadoAlimento, new Dimension(20, 20));
        panelDataCertificado.add((Component)this.certificadoOrigem, "Center");
        panelDataCertificado.add((Component)this.buttonDataCertificadoAlimento, "East");
        this.add((Component)panelDataCertificado, c);
        c.gridy = 14;
        c.gridx = 2;
        c.gridwidth = 1;
        this.add((Component)this.labelCodCertificadoAlimentos, c);
        c.gridy = 14;
        c.gridx = 3;
        c.gridwidth = 3;
        this.setPreferredMinimumSize(this.numeroCertificado, new Dimension(80, 20));
        this.add((Component)this.numeroCertificado, c);
        c.gridy = 15;
        c.gridx = 0;
        c.gridwidth = 1;
        c.anchor = 18;
        this.add((Component)this.labelOrdemCompra, c);
        ++c.gridx;
        c.fill = 2;
        c.gridwidth = 5;
        this.add((Component)this.textOrdemCompra, c);
        this.setPreferredMinimumSize(this.textOrdemCompra, new Dimension(100, 20));
        c.gridy = 16;
        c.gridx = 0;
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 18;
        this.add((Component)new JLabel("<html>Caracter\u00edsticas. <br>sanit\u00e1rias:</html>"), c);
        c.gridy = 17;
        this.add((Component)new JLabel("<html>Condi\u00e7\u00f5es <br>ambientais:</html>"), c);
        c.gridy = 18;
        this.add((Component)new JLabel("<html>Procedimento <br>de coleta:</html>"), c);
        c.gridwidth = 5;
        c.gridx = 1;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 16;
        this.add((Component)new JScrollPane(this.textSanitarias), c);
        c.gridy = 17;
        this.add((Component)new JScrollPane(this.textCondicoes), c);
        c.gridy = 18;
        this.add((Component)new JScrollPane(this.textProcedimento), c);
    }

    private void carregaEmbalagens() {
        this.comboEmbalagem.removeAllItems();
        this.comboEmbalagem.addItem("");
        EmbalagemRecebidaService s = new EmbalagemRecebidaService();
        try {
            Set e = s.load(" where fil_codigo = " + (this.codigoFilial == null ? Variaveis.filialPadrao : String.valueOf(this.codigoFilial)));
            for (EmbalagemRecebidaBean bean : e) {
                this.comboEmbalagem.addItem(bean);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PanelAlimentos: 462");
        }
    }

    private void setPreferredMinimumSize(JComponent o, Dimension dim) {
        o.setPreferredSize(dim);
        o.setMinimumSize(dim);
    }

    private void setPreferredMinimumMaximumSize(JComponent o, Dimension dim) {
        this.setPreferredMinimumSize(o, dim);
        this.setMaximumSize(dim);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonDataColeta) {
            Funcoes.mostraData(this.textDataColeta, this.buttonDataColeta, (JPanel)this.textDataColeta.getParent(), true);
        } else if (o == this.buttonDataFabricacao) {
            Funcoes.mostraData(this.textDataFabricacao, this.buttonDataFabricacao, (JPanel)this.textDataFabricacao.getParent(), true);
        } else if (o == this.buttonDataValidade) {
            Funcoes.mostraData(this.textDataValidade, this.buttonDataValidade, (JPanel)this.textDataValidade.getParent(), true);
        } else if (o == this.buttonDataRecebimento) {
            Funcoes.mostraData(this.textDataRecebimento, this.buttonDataRecebimento, (JPanel)this.textDataRecebimento.getParent(), true);
        } else if (o == this.buttonPais) {
            this.pesquisarPais();
        } else if (o == this.buttonDataCertificadoAlimento) {
            Funcoes.mostraData(this.certificadoOrigem, this.buttonDataCertificadoAlimento, (JPanel)this.certificadoOrigem.getParent(), true);
        }
    }

    private void pesquisarPais() {
        try {
            PaisService paisService = new PaisService();
            PaisVO vo = (PaisVO)paisService.pesquisaVO(this.getTopLevelAncestor(), new PaisVO(), "Pesquisando pa\u00edses", Acesso.getAcesso(Pais.getModuloAcesso()));
            if (vo != null) {
                HashMap<String, Object> chaves = new HashMap<String, Object>();
                chaves.put("fil_codigo", vo.getFilial().getCodigo());
                chaves.put("pai_codigo", vo.getCodigo());
                PaisBean paisBean = (PaisBean)paisService.getBean(chaves);
                this.textCodVPais.setText(paisBean.getCodigo().toString());
                this.labelDecricaoPais.setText(paisBean.getNome());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    public String getDescricaoProduto() {
        return this.textDescricaoProduto.getText();
    }

    public String getDataFabricacao() {
        return this.textDataFabricacao.getText();
    }

    public String getNumeroRegistro() {
        return this.textNumeroRegistro.getText();
    }

    public String getNumeroSolicitacao() {
        return this.textNumeroSolicitacao.getText();
    }

    public String getLocalColeta() {
        return this.textLocalColetado.getText();
    }

    public String getTemperaturaColeta() {
        return this.textTemperaturaColeta.getText();
    }

    public String getNumeroLote() {
        return this.textNumeroLote.getText();
    }

    public String getDataValidade() {
        return this.textDataValidade.getText();
    }

    public String getMarcaProduto() {
        return this.textMarcaProduto.getText();
    }

    public String getLacre() {
        return this.textLacre.getText();
    }

    public String getLacreContraprova() {
        return this.textLacreContraprova.getText();
    }

    public String getLacreContraprovaEmpresa() {
        return this.textLacreContraprovaEmpresa.getText();
    }

    public String getDoctoReferencia() {
        return this.textDoctoReferencia.getText();
    }

    public String getTemperaturaRecebimento() {
        return this.textTemperaturaRecebimento.getText();
    }

    public String getDataColeta() {
        return !Funcoes.verificaData(this.textDataColeta.getText()) ? null : this.textDataColeta.getText();
    }

    public String getHoraColeta() {
        return !Funcoes.verificaHora(this.textHoraColeta.getText()) ? null : this.textHoraColeta.getText();
    }

    public String getDataRecebimento() {
        return !Funcoes.verificaData(this.textDataRecebimento.getText()) ? null : this.textDataRecebimento.getText();
    }

    public String getHoraRecebimento() {
        return !Funcoes.verificaHora(this.textHoraRecebimento.getText()) ? null : this.textHoraRecebimento.getText();
    }

    public String getSanitarias() {
        return this.textSanitarias.getText();
    }

    public String getCondicoes() {
        return this.textCondicoes.getText();
    }

    public String getProcedimento() {
        return this.textProcedimento.getText();
    }

    public String getPartida() {
        return this.textPartida.getText();
    }

    public String getTermoColetaAmostra() {
        return this.termoColetaAmostra.getText();
    }

    public void setTermoColetaAmostra(String textCodTca) {
        this.termoColetaAmostra.setText(textCodTca);
    }

    public JLabel getLabelPais() {
        return this.labelPais;
    }

    public JLabel getLabelCodCertificadoAlimentos() {
        return this.labelCodCertificadoAlimentos;
    }

    public String getTipoRecebimento() {
        return this.comboTipoRecebimento.getSelectedItem() != null ? ((TipoRecebimento)this.comboTipoRecebimento.getSelectedItem()).codigo : "A";
    }

    public Integer getEmbalagem() {
        return this.comboEmbalagem.getSelectedItem() == null && this.comboEmbalagem.getSelectedIndex() <= 0 ? null : (this.comboEmbalagem.getSelectedItem() instanceof EmbalagemRecebidaBean ? ((EmbalagemRecebidaBean)this.comboEmbalagem.getSelectedItem()).getCodigo() : null);
    }

    public int getQtdeAmostras() {
        return Funcoes.isNumeric(this.textQtdeAmostras.getText()) ? Integer.parseInt(this.textQtdeAmostras.getText()) : 0;
    }

    public Double getQtdeUnidade() {
        return Funcoes.isNumeric(this.textQtdeUnidade.getText()) ? Double.parseDouble(this.textQtdeUnidade.getText()) : 0.0;
    }

    public String getUnidade() {
        Object selectedItem = this.comboUnidade.getSelectedItem();
        return selectedItem != null ? selectedItem.toString() : "";
    }

    public int getAnoPRP() {
        return Funcoes.isNumeric(this.textAnoPRP.getText()) ? Integer.parseInt(this.textAnoPRP.getText()) : 0;
    }

    public String getCicloPRP() {
        return this.textCicloPRP.getText();
    }

    public String getAmostraPRP() {
        return this.textAmostraPRP.getText();
    }

    public String getAmostraSupervisaoPRP() {
        return this.textAmostraSupPRP.getText();
    }

    public String getHoraTurnoPRP() {
        return this.textHoraInicioTurnoPRP.getText();
    }

    public String getTurnoPRP() {
        return this.textTurnoPRP.getText();
    }

    public String getLinhaPRP() {
        return this.textLinhaPRP.getText();
    }

    public String getVolumeAbatePRP() {
        return this.textVolumeAbatePRP.getText();
    }

    public void focoPrimeiroComponente() {
        this.textDescricaoProduto.grabFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] pegaUnidades() {
        ArrayList<String> a = new ArrayList<String>();
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder("select unm_codigo from unidademedida where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" order by unm_codigo ");
            ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
            while (rs.next()) {
                a.add(new String(rs.getString("unm_codigo")));
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PanelAlimentos (369)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return a.toArray(new String[a.size()]);
    }

    public void limparValores() {
        this.textCodVPais.setText("");
        this.textDescricaoProduto.clear();
        this.textDataFabricacao.clear();
        this.textNumeroRegistro.clear();
        this.textTemperaturaColeta.clear();
        this.textNumeroLote.clear();
        this.textDataValidade.clear();
        this.textMarcaProduto.clear();
        this.textLacre.clear();
        this.textLacreContraprova.clear();
        this.textLacreContraprovaEmpresa.clear();
        this.textDoctoReferencia.clear();
        this.textTemperaturaRecebimento.clear();
        this.textDataColeta.clear();
        this.textHoraColeta.clear();
        this.textDataRecebimento.clear();
        this.textHoraRecebimento.clear();
        this.textSanitarias.setText("");
        this.textCondicoes.setText("");
        this.textProcedimento.setText("");
        this.textOrdemCompra.clear();
        this.textPartida.clear();
        this.textAreaProduto.clear();
        this.textFornecedor.clear();
        this.comboEmbalagem.setSelectedIndex(0);
        this.termoColetaAmostra.setText("");
        this.textCodVPais.setText("");
        this.labelDecricaoPais.setText("");
        this.certificadoOrigem.setText("");
        this.numeroCertificado.setText("");
        this.setCategoriaProdutoAlimento(null, null);
        Funcoes.limpa(this.panelPRP);
        this.setMostrarCamposArea(false);
        this.setMostrarPRP(false);
    }

    public void setFilial(int codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public void setDescricaoProduto(String descricao) {
        this.textDescricaoProduto.setText(descricao);
    }

    public void setDataFabricacao(String data) {
        if (data != null) {
            this.textDataFabricacao.setText(data);
        }
    }

    public void setNumeroRegistro(String numero) {
        this.textNumeroRegistro.setText(numero);
    }

    public void setTemperaturaColeta(String temperatura) {
        if (temperatura != null) {
            this.textTemperaturaColeta.setText(temperatura);
        }
    }

    public void setNumeroLote(String numero) {
        this.textNumeroLote.setText(numero);
    }

    public void setNumeroSolicitacao(String numero) {
        this.textNumeroSolicitacao.setText(numero);
    }

    public void setLocalColeta(String local) {
        this.textLocalColetado.setText(local);
    }

    public void setDataValidade(String data) {
        this.textDataValidade.setText(data);
    }

    public void setMarcaProduto(String marca) {
        this.textMarcaProduto.setText(marca);
    }

    public void setLacre(String lacre) {
        this.textLacre.setText(lacre);
    }

    public void setLacreContraprova(String lacre) {
        this.textLacreContraprova.setText(lacre);
    }

    public void setLacreContraprovaEmpresa(String lacre) {
        this.textLacreContraprovaEmpresa.setText(lacre);
    }

    public void setDoctoReferencia(String docto) {
        this.textDoctoReferencia.setText(docto);
    }

    public void setTemperaturaRecebimento(String temperatura) {
        if (temperatura != null) {
            this.textTemperaturaRecebimento.setText(temperatura);
        }
    }

    public void setDataColeta(Date data) {
        if (data != null) {
            this.textDataColeta.setText(Funcoes.formataData(data));
        }
    }

    public void setHoraColeta(String hora) {
        this.textHoraColeta.setText(hora);
    }

    public void setTextCodVPais(String valor) {
        this.textCodVPais.setText(valor);
    }

    public TTextField getTextCodVPais() {
        return this.textCodVPais;
    }

    public void setCertificadoOrigem(String certificadoOrigem) {
        this.certificadoOrigem.setText(certificadoOrigem);
    }

    public String getCertificadoOrigem() {
        return !Funcoes.verificaData(this.certificadoOrigem.getText()) ? null : this.certificadoOrigem.getText();
    }

    public void setDataRecebimento(Date data) {
        if (data != null) {
            this.textDataRecebimento.setText(Funcoes.formataData(data));
        }
    }

    public void setHoraRecebimento(String hora) {
        this.textHoraRecebimento.setText(hora);
    }

    public void setSanitarias(String sanitarias) {
        this.textSanitarias.setText(sanitarias);
    }

    public void setCondicoes(String condicoes) {
        this.textCondicoes.setText(condicoes);
    }

    public void setProcedimento(String procedimento) {
        this.textProcedimento.setText(procedimento);
    }

    public void setPartida(String partida) {
        this.textPartida.setText(partida);
    }

    public void setCategoriaProdutoAlimento(String categoria, String produto) {
        codigoProdutoAlimento = produto;
        this.comboCategoria.removeAllItems();
        this.comboProduto.removeAllItems();
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            this.carregarCategoriaProdutos(categoria, produto);
        }
    }

    public String getCodigoProdutoAlimento() {
        TipoRecebimento produto = (TipoRecebimento)this.comboProduto.getSelectedItem();
        return produto == null ? null : produto.codigo;
    }

    public String getCodigoCategoriaProdutoAlimento() {
        TipoRecebimento categoria = (TipoRecebimento)this.comboCategoria.getSelectedItem();
        return categoria == null ? null : categoria.codigo;
    }

    public String getCodigoFilial() {
        return this.codigoFilial == null ? Variaveis.filialPadrao : String.valueOf(this.codigoFilial);
    }

    private ArrayList<TipoRecebimento> carregarProdutos(String codigoProduto) {
        if (Funcoes.textoVazio(codigoProduto)) {
            return null;
        }
        Statement st = Conexao.getStatement();
        ArrayList<TipoRecebimento> lista = new ArrayList<TipoRecebimento>();
        try {
            if (st != null) {
                StringBuffer buf = new StringBuffer("select cpl_codigo, pal_codigo, pal_descricao from produtoalimentos where fil_codigo = ").append(this.getCodigoFilial());
                buf.append(" and cpl_codigo = ").append(codigoProduto).append(" order by to_ascii(pal_descricao)");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                while (rs.next()) {
                    TipoRecebimento produto = new TipoRecebimento(rs.getString("pal_codigo"), rs.getString("pal_descricao"), rs.getString("cpl_codigo"));
                    lista.add(produto);
                }
            }
            if (st != null) {
                st.close();
            }
            return lista;
        }
        catch (SQLException sqlex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar os produtos.\n" + sqlex.getMessage(), sqlex.getStackTrace());
            return null;
        }
    }

    private void carregarCategoriaProdutos(String codigoCategoria, String codigoProduto) {
        Statement st = Conexao.getStatement();
        try {
            if (st != null) {
                TipoRecebimento categoria;
                StringBuffer buf = new StringBuffer("select cpl_codigo, cpl_descricao from categoriaprodutoalimentos where fil_codigo = ").append(this.getCodigoFilial()).append(" order by to_ascii(cpl_descricao)");
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                this.comboCategoria.addItem(new TipoRecebimento("", ""));
                while (rs.next()) {
                    categoria = new TipoRecebimento(rs.getString("cpl_codigo"), rs.getString("cpl_descricao"));
                    categoria.setLista(this.carregarProdutos(rs.getString("cpl_codigo")));
                    this.comboCategoria.addItem(categoria);
                    if (Funcoes.textoVazio(codigoCategoria) || !categoria.codigo.equals(codigoCategoria)) continue;
                    this.comboCategoria.setSelectedItem(categoria);
                }
                categoria = (TipoRecebimento)this.comboCategoria.getSelectedItem();
                ArrayList listaProduto = categoria != null && categoria.getLista() != null && !categoria.getLista().isEmpty() ? categoria.getLista() : new ArrayList();
                for (TipoRecebimento produto : listaProduto) {
                    if (!produto.codigo.equals(codigoProduto)) continue;
                    this.comboProduto.setSelectedItem(produto);
                }
            }
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException sqlex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar as categorias dos produtos.\n" + sqlex.getMessage(), sqlex.getStackTrace());
        }
    }

    public void setTipoRecebimento(String tipo) {
        if (tipo != null) {
            for (int i = 0; i < this.comboTipoRecebimento.getItemCount(); ++i) {
                TipoRecebimento r = (TipoRecebimento)this.comboTipoRecebimento.getItemAt(i);
                if (!r.codigo.equalsIgnoreCase(tipo)) continue;
                this.comboTipoRecebimento.setSelectedIndex(i);
                break;
            }
        }
    }

    public void setEmbalagem(int codigo) {
        for (int i = 0; i < this.comboEmbalagem.getItemCount(); ++i) {
            EmbalagemRecebidaBean bean;
            if (!(this.comboEmbalagem.getItemAt(i) instanceof EmbalagemRecebidaBean) || (bean = (EmbalagemRecebidaBean)this.comboEmbalagem.getItemAt(i)).getCodigo() != codigo) continue;
            this.comboEmbalagem.setSelectedIndex(i);
            break;
        }
    }

    public void setQtdeAmostras(int qtde) {
        this.textQtdeAmostras.setText(String.valueOf(qtde));
    }

    public void setQtdeUnidade(Double unidade) {
        this.textQtdeUnidade.setText(Funcoes.formataDecimal(this.textQtdeUnidade.getMaskDecimal(), Double.parseDouble(Funcoes.limpaDecimal(unidade))));
    }

    public boolean getMostrarPRP() {
        return this.panelPRP.isVisible();
    }

    public void setUnidade(String unidade) {
        if (unidade != null) {
            for (int i = 0; i < this.comboUnidade.getItemCount(); ++i) {
                if (!this.comboUnidade.getItemAt(i).toString().equalsIgnoreCase(unidade)) continue;
                this.comboUnidade.setSelectedIndex(i);
                break;
            }
        }
    }

    public void setMostrarPRP(boolean b) {
        this.panelPRP.setVisible(b);
    }

    public void setAnoPRP(int ano) {
        this.textAnoPRP.setText(String.valueOf(ano));
    }

    public void setCicloPRP(String s) {
        this.textCicloPRP.setText(s);
    }

    public void setAmostraPRP(String s) {
        this.textAmostraPRP.setText(s);
    }

    public void setAmostraSupervisaoPRP(String s) {
        this.textAmostraSupPRP.setText(s);
    }

    public void setHoraTurnoPRP(String s) {
        this.textHoraInicioTurnoPRP.setText(s);
    }

    public void setTurnoPRP(String s) {
        this.textTurnoPRP.setText(s);
    }

    public void setLinhaPRP(String s) {
        this.textLinhaPRP.setText(s);
    }

    public void setVolumeAbatePRP(String s) {
        this.textVolumeAbatePRP.setText(s);
    }

    public boolean validarCampos() {
        if (!Funcoes.textoVazio(this.textDataColeta.getText()) && !Funcoes.verificaData(this.textDataColeta.getText())) {
            Funcoes.mensagem(this, "Campo data de coleta com valor incorreto", 1);
            return false;
        }
        if (!Funcoes.textoVazio(this.textDataRecebimento.getText()) && !Funcoes.verificaData(this.textDataRecebimento.getText())) {
            Funcoes.mensagem(this, "Campo data de recebimento com valor incorreto", 1);
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraColeta.getText()) && !Funcoes.verificaHora(this.textHoraColeta.getText())) {
            Funcoes.mensagem(this, "Campo hora de coleta com valor incorreto", 1);
            return false;
        }
        if (!Funcoes.textoVazio(this.textHoraRecebimento.getText()) && !Funcoes.verificaHora(this.textHoraRecebimento.getText())) {
            Funcoes.mensagem(this, "Campo hora de recebimento com valor incorreto", 1);
            return false;
        }
        if (this.panelPRP.isVisible() && !Funcoes.textoVazio(this.textHoraInicioTurnoPRP.getText()) && !Funcoes.verificaHora(this.textHoraInicioTurnoPRP.getText())) {
            Funcoes.mensagem(this, "Campo hora de in\u00edcio do turno com valor incorreto", 1);
            return false;
        }
        return true;
    }

    public void setMostrarCamposArea(boolean b) {
        this.labelArea.setVisible(b);
        this.textAreaProduto.setVisible(b);
    }

    public boolean getMostrarCamposArea() {
        return this.labelArea.isVisible();
    }

    public void setOrdemCompra(String ordemCompra) {
        this.textOrdemCompra.setText(ordemCompra);
    }

    public String getOrdemCompra() {
        return this.textOrdemCompra.getText();
    }

    public void setAreaProduto(String area) {
        this.textAreaProduto.setText(area);
    }

    public String getAreaProduto() {
        return this.textAreaProduto.getText();
    }

    public void setFornecedor(String fornecedor) {
        this.textFornecedor.setText(fornecedor);
    }

    public String getFornecedor() {
        return this.textFornecedor.getText();
    }

    public String getNumeroCertificado() {
        return this.numeroCertificado.getText();
    }

    public void setNumeroCertificado(String valor) {
        this.numeroCertificado.setText(valor);
    }

    public void setTextPais(String valor) {
        this.labelDecricaoPais.setText(valor);
    }

    public JLabel getTextPais() {
        return this.labelDecricaoPais;
    }

    public void atualizarValores(RequisicaoBean bean) {
        if (bean != null) {
            PaisVO pais = bean.getPais();
            if (pais != null) {
                this.textCodVPais.setText(String.valueOf(pais.getCodigo()));
                this.labelDecricaoPais.setText(pais.getNome());
            }
            this.numeroCertificado.setText(bean.getNumeroCertificado());
            this.termoColetaAmostra.setText(bean.getTermoColetaAmostra());
            this.textFornecedor.setText(bean.getFornecedor());
            this.textDescricaoProduto.setText(bean.getDescricaoProduto());
            this.textAreaProduto.setText(bean.getAreaProduto());
            this.textDataFabricacao.setText(bean.getDataFabricacao());
            Date certificadoBean = bean.getCertificadoOrigem();
            this.certificadoOrigem.setText(certificadoBean != null ? Funcoes.formataData(certificadoBean) : "");
            this.textNumeroRegistro.setText(bean.getNumeroRegistroProduto());
            this.textTemperaturaColeta.setText(bean.getTemperaturaColetaProduto());
            this.textNumeroLote.setText(bean.getNumeroLoteProduto());
            this.textDataValidade.setText(bean.getDataValidadeProduto());
            this.textMarcaProduto.setText(bean.getMarcaProduto());
            this.textLacre.setText(bean.getLacreProduto());
            this.textLacreContraprova.setText(bean.getLacreProdutoContra());
            this.textLacreContraprovaEmpresa.setText(bean.getLacreProdutoContraEmpresa());
            this.textDoctoReferencia.setText(bean.getDocumentoReferenciaProduto());
            this.textNumeroSolicitacao.setText(bean.getNumeroSolicitacaoProduto());
            this.textLocalColetado.setText(bean.getLocalColetaProduto());
            this.textTemperaturaRecebimento.setText(bean.getTemperaturaRecebimentoProduto());
            Date dataColetaProduto = bean.getDataColetaProduto();
            this.textDataColeta.setText(dataColetaProduto != null ? Funcoes.formataData(dataColetaProduto) : "");
            Date horaColetaProduto = bean.getHoraColetaProduto();
            this.textHoraColeta.setText(horaColetaProduto != null ? horaColetaProduto.toString() : "");
            this.textSanitarias.setText(bean.getCaracteristicasSanitariasProduto());
            this.textCondicoes.setText(bean.getCondicoesAmbientaisProduto());
            this.textProcedimento.setText(bean.getProcedimentoColetaProduto());
            this.textPartida.setText(bean.getPartidaProduto());
            this.textOrdemCompra.setText(bean.getOrdemCompra());
            Date dataRecebimentoProduto = bean.getDataRecebimentoProduto();
            this.textDataRecebimento.setText(dataRecebimentoProduto != null ? Funcoes.formataData(dataRecebimentoProduto) : "");
            Date horaRecebimentoProduto = bean.getHoraRecebimentoProduto();
            this.textHoraRecebimento.setText(horaRecebimentoProduto != null ? Funcoes.formataHora(horaRecebimentoProduto, false) : "");
            UnidadeMedidaVO unidadeMedida = bean.getUnidadeMedida();
            if (unidadeMedida != null) {
                this.setUnidade(unidadeMedida.getCodigo());
            }
            this.textQtdeAmostras.setText(String.valueOf(bean.getQuantidadeAmostrasProduto()));
            String qntdUnidadeMedida = String.valueOf(bean.getQuantidadeUnidadeProduto());
            this.textQtdeUnidade.setText(qntdUnidadeMedida.replace(".", ","));
            EmbalagemRecebidaVO embalagem = bean.getEmbalagem();
            if (embalagem != null) {
                this.setEmbalagem(embalagem.getCodigo());
            }
            this.setCategoriaProdutoAlimento(String.valueOf(bean.getCategoria()), String.valueOf(bean.getCodigoProduto()));
            this.setTipoRecebimento(bean.getTipoRecebimentoProduto());
            this.textAnoPRP.setText(String.valueOf(bean.getAnoPrpProduto()));
            this.textCicloPRP.setText(bean.getCicloPrpProduto());
            this.textAmostraPRP.setText(bean.getAmostraPrpProduto());
            this.textAmostraSupPRP.setText(bean.getAmostraSuplementarPrpProduto());
            this.textHoraInicioTurnoPRP.setText(bean.getHoraInicioTurnoPrpProduto());
            this.textTurnoPRP.setText(bean.getTurnoPrpProduto());
            this.textLinhaPRP.setText(bean.getLinhaPrpProduto());
            this.textVolumeAbatePRP.setText(bean.getVolumeAbatePrpProduto());
            this.textProgramaPRP.setText(bean.getPrograma());
            this.carregarProdutos(String.valueOf(bean.getCodigoProduto()));
            this.codigoFilial = bean.getFilial().getCodigo();
            this.setTipoRecebimento(bean.getTipoRecebimentoProduto());
        }
    }

    public void atualizarValores(PanelAlimentos alimentos) {
        if (alimentos != null) {
            this.textCodVPais.setText(alimentos.getTextCodVPais().getText());
            this.numeroCertificado.setText(alimentos.getNumeroCertificado());
            this.termoColetaAmostra.setText(alimentos.getTermoColetaAmostra());
            this.textFornecedor.setText(alimentos.getFornecedor());
            this.textDescricaoProduto.setText(alimentos.getDescricaoProduto());
            this.textAreaProduto.setText(alimentos.getAreaProduto());
            this.textDataFabricacao.setText(alimentos.getDataFabricacao());
            this.certificadoOrigem.setText(alimentos.getCertificadoOrigem());
            this.textNumeroRegistro.setText(alimentos.getNumeroRegistro());
            this.textTemperaturaColeta.setText(alimentos.getTemperaturaColeta());
            this.textNumeroLote.setText(alimentos.getNumeroLote());
            this.textDataValidade.setText(alimentos.getDataValidade());
            this.textMarcaProduto.setText(alimentos.getMarcaProduto());
            this.textLacre.setText(alimentos.getLacre());
            this.textLacreContraprova.setText(alimentos.getLacreContraprova());
            this.textLacreContraprovaEmpresa.setText(alimentos.getLacreContraprovaEmpresa());
            this.textDoctoReferencia.setText(alimentos.getDoctoReferencia());
            this.textNumeroSolicitacao.setText(alimentos.getNumeroSolicitacao());
            this.textLocalColetado.setText(alimentos.getLocalColeta());
            this.textTemperaturaRecebimento.setText(alimentos.getTemperaturaRecebimento());
            this.textOrdemCompra.setText(alimentos.getOrdemCompra());
            this.textDataColeta.setText(alimentos.getDataColeta());
            this.textHoraColeta.setText(alimentos.getHoraColeta());
            this.textSanitarias.setText(alimentos.getSanitarias());
            this.textCondicoes.setText(alimentos.getCondicoes());
            this.textProcedimento.setText(alimentos.getProcedimento());
            this.textPartida.setText(alimentos.getPartida());
            this.textDataRecebimento.setText(alimentos.getDataRecebimento());
            this.textHoraRecebimento.setText(alimentos.getHoraRecebimento());
            this.comboTipoRecebimento.setSelectedItem(alimentos.comboTipoRecebimento.getSelectedItem());
            this.textQtdeAmostras.setText(String.valueOf(alimentos.getQtdeAmostras()));
            this.textQtdeUnidade.setText(String.valueOf(alimentos.getQtdeUnidade()));
            this.comboUnidade.setSelectedItem(alimentos.comboUnidade.getSelectedItem());
            this.comboEmbalagem.setSelectedItem(alimentos.comboEmbalagem.getSelectedItem());
            this.comboProduto.setSelectedItem(alimentos.comboProduto.getSelectedItem());
            Object categoria = alimentos.comboCategoria.getSelectedItem();
            if (!Funcoes.textoVazio(categoria.toString())) {
                this.comboCategoria.setSelectedItem(categoria.toString());
            }
            this.textAnoPRP.setText(alimentos.textAnoPRP.getText());
            this.textCicloPRP.setText(alimentos.getCicloPRP());
            this.textAmostraPRP.setText(alimentos.getAmostraPRP());
            this.textAmostraSupPRP.setText(alimentos.getAmostraSupervisaoPRP());
            this.textHoraInicioTurnoPRP.setText(alimentos.textHoraInicioTurnoPRP.getText());
            this.textTurnoPRP.setText(alimentos.getTurnoPRP());
            this.textLinhaPRP.setText(alimentos.getLinhaPRP());
            this.textVolumeAbatePRP.setText(alimentos.getVolumeAbatePRP());
            this.textProgramaPRP.setText(alimentos.getTextProgramaPRP());
            this.produtoAlimentos = alimentos.produtoAlimentos;
            this.codigoFilial = alimentos.codigoFilial;
        }
    }

    public String getTextProgramaPRP() {
        return this.textProgramaPRP.getText();
    }

    public void setProgramaPRP(String textProgramaPRP) {
        this.textProgramaPRP.setText(textProgramaPRP);
    }

    public PanelAlimentos clone() {
        PanelAlimentos clone = new PanelAlimentos();
        clone.atualizarValores(this);
        return clone;
    }
}

