/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.util.RacaCorPaciente;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NacionalidadeEtniaIndigena
extends AbstractDialogoOKCancelar {
    private static final String titulo = "Dados complementares";
    private static final String NAO_LOCALIZADO = "N\u00e3o localizado";
    private boolean usuarioPodeCancelar = true;
    private boolean cancelado = false;
    private TTextField textNumNacionalidade = new TTextField(3, 1);
    private TTextField textNacionalidade = new TTextField();
    private JButton buttonNacionalidade = new JButton();
    private TTextField textNumEtnia = new TTextField(4, 1);
    private TTextField textEtnia = new TTextField();
    private JButton buttonEtnia = new JButton();
    private int codigoNacionalidade;
    private int codigoEtnia;
    private RacaCorPaciente racaCorPaciente;

    public static NacionalidadeEtniaIndigena novaInstancia(Object owner, RacaCorPaciente rcp) {
        if (owner instanceof Dialog) {
            return new NacionalidadeEtniaIndigena((Dialog)owner, titulo, rcp);
        }
        return new NacionalidadeEtniaIndigena((Frame)owner, titulo, rcp);
    }

    public NacionalidadeEtniaIndigena(Dialog pai, String titulo, RacaCorPaciente rcp) {
        super(pai, titulo);
        this.racaCorPaciente = rcp;
        this.montaTela();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public NacionalidadeEtniaIndigena(Frame pai, String titulo, RacaCorPaciente rcp) {
        super(pai, titulo);
        this.racaCorPaciente = rcp;
        this.montaTela();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok && this.usuarioPodeCancelar) {
                this.cancelado = true;
                this.acaoCancelar();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                this.validaCampos();
                this.setCodNacionalidade(Integer.valueOf(this.textNumNacionalidade.getText()));
                if (!Funcoes.textoVazio(this.textNumEtnia.getText())) {
                    this.setCodEtnia(Integer.valueOf(this.textNumEtnia.getText()));
                }
                this.dispose();
            }
        }
    }

    private void montaTela() {
        this.montaBotoes();
        this.setSize(new Dimension(550, 150));
        this.setLocationRelativeTo(this.getParent());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.setResizable(false);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(1, 1, 0, 0);
        panelCentro.add((Component)new JLabel("Nacionalidade:"), c);
        ++c.gridx;
        panelCentro.add((Component)this.textNumNacionalidade, c);
        ++c.gridx;
        panelCentro.add((Component)this.buttonNacionalidade, c);
        ++c.gridx;
        panelCentro.add((Component)this.textNacionalidade, c);
        c.gridx = 0;
        ++c.gridy;
        panelCentro.add((Component)new JLabel("Etnia Ind\u00edgena:"), c);
        ++c.gridx;
        panelCentro.add((Component)this.textNumEtnia, c);
        ++c.gridx;
        panelCentro.add((Component)this.buttonEtnia, c);
        ++c.gridx;
        panelCentro.add((Component)this.textEtnia, c);
        boolean indigena = this.racaCorPaciente.equals((Object)RacaCorPaciente.INDIGENA);
        this.textNumEtnia.setEnabled(indigena);
        this.buttonEtnia.setEnabled(indigena);
        this.textEtnia.setEnabled(indigena);
    }

    private void montaBotoes() {
        Dimension d = null;
        this.textNumNacionalidade.setPreferredSize(new Dimension(60, 20));
        this.textNumNacionalidade.setMinimumSize(this.textNumNacionalidade.getPreferredSize());
        this.textNacionalidade.setPreferredSize(new Dimension(350, 20));
        this.textNacionalidade.setEditable(false);
        this.textNacionalidade.setMinimumSize(this.textNacionalidade.getPreferredSize());
        d = new Dimension(20, 20);
        this.buttonNacionalidade.setPreferredSize(d);
        this.buttonNacionalidade.setMaximumSize(d);
        this.buttonNacionalidade.setMinimumSize(d);
        this.buttonNacionalidade.setText("");
        this.buttonNacionalidade.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonNacionalidade);
        this.textNumEtnia.setPreferredSize(new Dimension(60, 20));
        this.textNumEtnia.setMinimumSize(this.textNumEtnia.getPreferredSize());
        this.textEtnia.setPreferredSize(new Dimension(350, 20));
        this.textEtnia.setEditable(false);
        this.textEtnia.setMinimumSize(this.textEtnia.getPreferredSize());
        d = new Dimension(20, 20);
        this.buttonEtnia.setPreferredSize(d);
        this.buttonEtnia.setMaximumSize(d);
        this.buttonEtnia.setMinimumSize(d);
        this.buttonEtnia.setText("");
        this.buttonEtnia.setFocusable(false);
        Funcoes.imagemPesquisa(this.buttonEtnia);
    }

    private void validaCampos() {
        if (this.textNacionalidade.getText().equals(NAO_LOCALIZADO) || Funcoes.textoVazio(this.textNacionalidade.getText())) {
            this.textNumNacionalidade.setText("10");
        }
        if (this.textEtnia.getText().equals(NAO_LOCALIZADO)) {
            this.textNumEtnia.setText("");
            this.textEtnia.setText("");
        }
    }

    public void jbInit() throws Exception {
        this.textNumNacionalidade.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(NacionalidadeEtniaIndigena.this.textNumNacionalidade.getText())) {
                    String descricao = NacionalidadeEtniaIndigena.this.buscaNacionalidade(NacionalidadeEtniaIndigena.this.textNumNacionalidade.getText());
                    NacionalidadeEtniaIndigena.this.textNacionalidade.setText(descricao);
                } else {
                    NacionalidadeEtniaIndigena.this.textNacionalidade.setText("");
                }
            }
        });
        this.textNumEtnia.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(NacionalidadeEtniaIndigena.this.textNumEtnia.getText())) {
                    String descricao = NacionalidadeEtniaIndigena.this.buscaEtnia(NacionalidadeEtniaIndigena.this.textNumEtnia.getText());
                    NacionalidadeEtniaIndigena.this.textEtnia.setText(descricao);
                } else {
                    NacionalidadeEtniaIndigena.this.textEtnia.setText("");
                    NacionalidadeEtniaIndigena.this.setCodEtnia(0);
                }
            }
        });
        this.buttonNacionalidade.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NacionalidadeEtniaIndigena.this.pesquisaNacionalidade();
            }
        });
        this.buttonEtnia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NacionalidadeEtniaIndigena.this.pesquisaEtnia();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscaNacionalidade(String codigo) {
        Statement st;
        String retorno;
        block5: {
            retorno = "";
            StringBuilder buf = new StringBuilder();
            buf.append(" select nli_descricao from nacionalidade where nli_codigo = ").append(codigo);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
                if (rs.next()) {
                    retorno = rs.getString("nli_descricao");
                }
                if (!Funcoes.textoVazio(retorno)) break block5;
                retorno = NAO_LOCALIZADO;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscaEtnia(String codigo) {
        Statement st;
        String retorno;
        block5: {
            retorno = "";
            StringBuilder buf = new StringBuilder();
            buf.append(" select ein_descricao from etniaindigena where ein_codigo = ").append(codigo);
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQueryPerformance(st, buf.toString());
                if (rs.next()) {
                    retorno = rs.getString("ein_descricao");
                }
                if (!Funcoes.textoVazio(retorno)) break block5;
                retorno = NAO_LOCALIZADO;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    private void pesquisaNacionalidade() {
        Hashtable resultado = Pesquisas.nacionalidades(this, true);
        if (resultado != null) {
            this.textNumNacionalidade.setText(resultado.get("nli_codigo").toString());
            this.textNacionalidade.setText(resultado.get("nli_descricao").toString());
        }
        this.textNumNacionalidade.requestFocus();
    }

    private void pesquisaEtnia() {
        Hashtable resultado = Pesquisas.etnias(this, true);
        if (resultado != null) {
            this.textNumEtnia.setText(resultado.get("ein_codigo").toString());
            this.textEtnia.setText(resultado.get("ein_descricao").toString());
        }
        this.textNumNacionalidade.requestFocus();
    }

    public int getCodNacionalidade() {
        return this.codigoNacionalidade;
    }

    public void setCodNacionalidade(int codigoNacionalidade) {
        if (codigoNacionalidade == 0) {
            this.textNumNacionalidade.setText("010");
            this.textNacionalidade.setText(this.buscaNacionalidade("010"));
        } else {
            this.textNumNacionalidade.setText(String.valueOf(codigoNacionalidade));
            this.textNacionalidade.setText(this.buscaNacionalidade(String.valueOf(codigoNacionalidade)));
        }
        this.codigoNacionalidade = codigoNacionalidade;
    }

    public int getCodEtnia() {
        return this.codigoEtnia;
    }

    public void setCodEtnia(int codigoEtnia) {
        if (!this.racaCorPaciente.equals((Object)RacaCorPaciente.INDIGENA)) {
            this.textNumEtnia.setText("");
            this.textEtnia.setText("");
            this.codigoEtnia = 0;
        } else {
            if (codigoEtnia == 0 || this.textEtnia.getText().equals(NAO_LOCALIZADO)) {
                this.textNumEtnia.setText("");
                codigoEtnia = 0;
            } else {
                this.textNumEtnia.setText(String.valueOf(codigoEtnia));
                this.textEtnia.setText(this.buscaEtnia(String.valueOf(codigoEtnia)));
            }
            this.codigoEtnia = codigoEtnia;
        }
    }
}

