/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Conexao;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.Pagamento;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class MostraCaixa
extends JDialog
implements DisposeListener {
    private Caixa caixa;
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private boolean isOK = false;

    public MostraCaixa(Frame owner, Caixa caixa) {
        super(owner, "Caixa");
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.caixa = caixa;
        this.montaTela();
    }

    private void montaTela() {
        this.caixa.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.caixa, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.setSize(720, 440);
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MostraCaixa.this.validarPagamentosAdicionados();
                MostraCaixa.this.setVisible(false);
                MostraCaixa.this.isOK = true;
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Conexao.anulaSQL();
                    MostraCaixa.this.removerPagamentosAdicionados();
                    MostraCaixa.this.caixa.limparPagamentosEstornados();
                    MostraCaixa.this.setVisible(false);
                    MostraCaixa.this.caixa.setOK(false);
                    MostraCaixa.this.isOK = false;
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    public boolean isOK() {
        return this.isOK;
    }

    private void validarPagamentosAdicionados() {
        for (int i = 0; i < this.caixa.modeloListaAnteriores.getSize(); ++i) {
            Pagamento pagamento = (Pagamento)this.caixa.modeloListaAnteriores.getElementAt(i);
            pagamento.adicionado = true;
        }
    }

    private void removerPagamentosAdicionados() {
        for (int i = 0; i < this.caixa.modeloListaAnteriores.getSize(); ++i) {
            Pagamento pagamento = (Pagamento)this.caixa.modeloListaAnteriores.getElementAt(i);
            if (pagamento.adicionado || pagamento.salvo) continue;
            this.caixa.modeloListaAnteriores.removeElement(pagamento);
        }
    }
}

