/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.laboratorio.recepcao.util.DadosEntrega;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ListaEntregas {
    private Integer filial;
    private Set<DadosEntrega> dados;

    private ListaEntregas(Integer filial, Set<DadosEntrega> dados) {
        this.filial = filial;
        this.dados = dados;
    }

    public static ListaEntregas criar(Integer filial) {
        return new ListaEntregas(filial, new HashSet<DadosEntrega>());
    }

    public boolean contains(String exame, String material) {
        for (DadosEntrega dado : this.dados) {
            if (!dado.getCodigoExame().equalsIgnoreCase(exame) || !dado.getAbreviaturaMaterial().equalsIgnoreCase(material)) continue;
            return true;
        }
        return false;
    }

    public DadosEntrega buscarEntrega(Integer requisicao, String exame, String material) {
        for (DadosEntrega dado : this.dados) {
            if (!dado.getCodigoRequisicao().equals(requisicao) || !dado.getCodigoExame().equalsIgnoreCase(exame) || !dado.getAbreviaturaMaterial().equalsIgnoreCase(material)) continue;
            return dado;
        }
        return new DadosEntrega(-1, "", -1, "", "", "", null);
    }

    public void adicionar(DadosEntrega entrega) {
        if (entrega.dadosSaoValidos()) {
            if (this.dados.contains(entrega)) {
                this.atualizarEntrega(entrega);
            } else {
                this.dados.add(entrega);
            }
        }
    }

    private void atualizarEntrega(DadosEntrega entrega) {
        this.dados.remove(entrega);
        this.dados.add(entrega);
    }

    public void remover(DadosEntrega outra) {
        this.dados.remove(outra);
    }

    public String getData(Integer requisicao, String exame, String material) {
        for (DadosEntrega entrega : this.dados) {
            if (!entrega.getCodigoRequisicao().equals(requisicao) || !entrega.getCodigoExame().equals(exame) || !entrega.getAbreviaturaMaterial().equals(material)) continue;
            return entrega.getDataHoraFormatada();
        }
        return "";
    }

    public Iterator<DadosEntrega> getIterator() {
        return this.dados.iterator();
    }

    public void limpar() {
        this.dados.clear();
    }

    public Integer getFilial() {
        return this.filial;
    }
}

