/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class InformarNumerosGuia
extends AbstractDialogoOKCancelar {
    private JLabel labelGuia = new JLabel("Guia");
    private TTextField textGuia = new TTextField(20, "[a-zA-Z0-9./-]+");
    private JButton buttonOkGuia = new JButton("Ok");
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Guias"});
    private JTable tableGuia = new JTable(this.modelo);
    private JScrollPane scrollGuias;

    public static InformarNumerosGuia novaInstancia(Component owner) {
        if (owner instanceof Frame) {
            return new InformarNumerosGuia((Frame)owner);
        }
        return new InformarNumerosGuia((Dialog)owner);
    }

    public InformarNumerosGuia(Frame owner) {
        super(owner, "Guias para solicita\u00e7\u00e3o");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public InformarNumerosGuia(Dialog owner) {
        super(owner, "Guias para solicita\u00e7\u00e3o");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() {
        this.setSize(260, 310);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.scrollGuias = new JScrollPane(this.tableGuia);
        this.scrollGuias.setPreferredSize(new Dimension(20, 200));
        this.scrollGuias.setMinimumSize(new Dimension(20, 200));
        this.textGuia.setPreferredSize(new Dimension(170, 20));
        this.textGuia.setMaximumSize(new Dimension(170, 20));
        this.buttonOkGuia.setMargin(new Insets(1, 1, 1, 1));
        this.buttonOkGuia.setPreferredSize(new Dimension(20, 20));
        this.buttonOkGuia.setMaximumSize(new Dimension(20, 20));
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.labelGuia, c);
        ++c.gridy;
        panel.add((Component)this.textGuia, c);
        ++c.gridx;
        panel.add((Component)this.buttonOkGuia, c);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        panel.add((Component)this.scrollGuias, c);
        ++c.gridy;
        Funcoes.montaEnter((JComponent)panel);
        this.montaListener();
        ScreenUtil.requisitarFoco(this.textGuia);
    }

    private void montaListener() {
        this.buttonOkGuia.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < InformarNumerosGuia.this.modelo.getRowCount(); ++i) {
                    Object[] guia = InformarNumerosGuia.this.modelo.getLineValue(i);
                    if (!((String)guia[0]).equals(InformarNumerosGuia.this.textGuia.getText())) continue;
                    InformarNumerosGuia.this.textGuia.setText("");
                    return;
                }
                InformarNumerosGuia.this.modelo.addLine(new Object[]{InformarNumerosGuia.this.textGuia.getText()});
                InformarNumerosGuia.this.textGuia.setText("");
                ScreenUtil.requisitarFoco(InformarNumerosGuia.this.textGuia);
            }
        });
        this.tableGuia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    InformarNumerosGuia.this.modelo.removeLine(InformarNumerosGuia.this.tableGuia.getSelectedRow());
                }
            }
        });
    }

    public List<String> getGuias() {
        ArrayList<String> listaGuias = new ArrayList<String>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            Object[] objeto = this.modelo.getLineValue(i);
            listaGuias.add((String)objeto[0]);
        }
        return listaGuias;
    }

    public void setGuias(List<String> listaGuias) {
        if (listaGuias != null && !listaGuias.isEmpty()) {
            for (String guia : listaGuias) {
                this.modelo.addLine(new Object[]{guia});
            }
        }
    }
}

