/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.dados.DadosConvenios;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;

public class InformacoesRepasse
extends AbstractDialogoOKCancelar {
    private TTextField textGuia = new TTextField(20);
    private TTextField textGuiaPrincipal = new TTextField(20);
    private TTextField textMatricula = new TTextField(20);
    private TTextField textValidadeGuia = new TTextField(10, 4);
    private TTextField textPlano = new TTextField(50);
    private TTextField textValidadeCarteira = new TTextField(10, 4);
    private JCheckBox checkDeveGuia = ComponenteFactory.novoJCheckBox("Deve guia", 'D');
    private JButton buttonValidadeGuia = ComponenteFactory.novoJButton(this, true);
    private JButton buttonValidadeCarteira = ComponenteFactory.novoJButton(this, true);
    private DadosConvenios convenio = null;

    public static InformacoesRepasse novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new InformacoesRepasse((Dialog)pai, "Informa\u00e7\u00f5es do conv\u00eanio de repasse");
        }
        if (pai instanceof Frame) {
            return new InformacoesRepasse((Frame)pai, "Informa\u00e7\u00f5es do conv\u00eanio de repasse");
        }
        return null;
    }

    public InformacoesRepasse(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public InformacoesRepasse(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(350, 210));
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.textMatricula.setFocusLostBehavior(0);
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)ComponenteFactory.novoJLabel("Guia:", 'G', this.textGuia), c);
        this.textGuia.setPreferredSize(new Dimension(100, 20));
        this.textGuia.setMinimumSize(this.textGuia.getPreferredSize());
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panelCentro.add((Component)this.textGuia, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)new JLabel("Guia principal:"), c);
        this.textGuiaPrincipal.setPreferredSize(new Dimension(100, 20));
        this.textGuiaPrincipal.setMinimumSize(this.textGuiaPrincipal.getPreferredSize());
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panelCentro.add((Component)this.textGuiaPrincipal, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)new JLabel("Matr\u00edcula:"), c);
        this.textMatricula.setPreferredSize(new Dimension(100, 20));
        this.textMatricula.setMinimumSize(this.textMatricula.getPreferredSize());
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panelCentro.add((Component)this.textMatricula, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panelCentro.add((Component)new JLabel("Plano:"), c);
        this.textPlano.setPreferredSize(new Dimension(100, 20));
        this.textPlano.setMinimumSize(this.textPlano.getPreferredSize());
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        panelCentro.add((Component)this.textPlano, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panelCentro.add((Component)new JLabel("Validade guia:"), c);
        this.textValidadeGuia.setPreferredSize(new Dimension(100, 20));
        this.textValidadeGuia.setMinimumSize(this.textValidadeGuia.getPreferredSize());
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelCentro.add((Component)this.textValidadeGuia, c);
        this.buttonValidadeGuia.setPreferredSize(new Dimension(20, 20));
        this.buttonValidadeGuia.setMinimumSize(this.buttonValidadeGuia.getPreferredSize());
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.buttonValidadeGuia, c);
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.gridwidth = 1;
        panelCentro.add((Component)new JLabel("Validade carteira:"), c);
        this.textValidadeCarteira.setPreferredSize(new Dimension(100, 20));
        this.textValidadeCarteira.setMinimumSize(this.textValidadeCarteira.getPreferredSize());
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelCentro.add((Component)this.textValidadeCarteira, c);
        this.buttonValidadeCarteira.setPreferredSize(new Dimension(20, 20));
        this.buttonValidadeCarteira.setMinimumSize(this.buttonValidadeCarteira.getPreferredSize());
        ++c.gridx;
        c.fill = 0;
        c.weightx = 0.0;
        panelCentro.add((Component)this.buttonValidadeCarteira, c);
        ++c.gridy;
        c.gridx = 1;
        this.buttonValidadeCarteira.setPreferredSize(new Dimension(20, 20));
        this.buttonValidadeCarteira.setMinimumSize(this.buttonValidadeCarteira.getPreferredSize());
        c.fill = 2;
        c.weightx = 1.0;
        panelCentro.add((Component)this.checkDeveGuia, c);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ScreenUtil.consumirEventoAtual();
                ScreenUtil.requisitarFoco(InformacoesRepasse.this.textGuia);
            }
        });
        this.textValidadeCarteira.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(InformacoesRepasse.this.textValidadeCarteira, InformacoesRepasse.this.buttonValidadeCarteira, (JPanel)InformacoesRepasse.this.buttonValidadeCarteira.getParent(), true);
                }
            }
        });
        this.textValidadeGuia.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(InformacoesRepasse.this.textValidadeGuia, InformacoesRepasse.this.buttonValidadeGuia, (JPanel)InformacoesRepasse.this.buttonValidadeGuia.getParent(), true);
                }
            }
        });
    }

    @Override
    public boolean acaoOk() {
        if (this.convenio != null && !this.checkDeveGuia.isSelected()) {
            if (this.convenio.getExigeCodigoGuia() && Funcoes.textoVazio(this.textGuia.getText())) {
                Funcoes.mensagem(this, "O c\u00f3digo da guia deve ser informado", 1);
                ScreenUtil.requisitarFoco(this.textGuia);
                return false;
            }
            if (this.convenio.getExigeMatricula() && Funcoes.textoVazio(this.textMatricula.getText())) {
                Funcoes.mensagem(this, "A matr\u00edcula deve ser informada", 1);
                ScreenUtil.requisitarFoco(this.textMatricula);
                return false;
            }
            if (this.convenio.getValidadeGuia() && !Funcoes.verificaData(this.textValidadeGuia.getText())) {
                Funcoes.mensagem(this, "A validade da guia deve ser informada", 1);
                ScreenUtil.requisitarFoco(this.textValidadeGuia);
                return false;
            }
            if (this.convenio.isObrigaValidadeCarteira() && !Funcoes.verificaData(this.textValidadeCarteira.getText())) {
                Funcoes.mensagem(this, "A validade da carteira/matr\u00edcula deve ser informada", 1);
                ScreenUtil.requisitarFoco(this.textValidadeCarteira);
                return false;
            }
            if (this.convenio.isObrigaNomePlano() && Funcoes.textoVazio(this.textPlano.getText())) {
                Funcoes.mensagem(this, "O nome do plano deve ser informado", 1);
                ScreenUtil.requisitarFoco(this.textPlano);
                return false;
            }
            if (!this.validaMatriculaDigitada()) {
                Funcoes.mensagem(this, "A matr\u00edcula digitada n\u00e3o foi validada pelo formato estipulado pelo conv\u00eanio", 1);
                ScreenUtil.requisitarFoco(this.textMatricula);
                return false;
            }
        }
        return true;
    }

    public void setGuia(String guia) {
        this.textGuia.setText(guia);
    }

    public void setGuiaPrincipal(String guia) {
        this.textGuiaPrincipal.setText(guia);
    }

    public void setMatricula(String matricula) {
        if (this.textMatricula.getFormatter() != null) {
            this.textMatricula.setValue(matricula);
        } else {
            this.textMatricula.setText(matricula);
        }
    }

    public void setValidadeGuia(Date data) {
        if (data != null) {
            this.textValidadeGuia.setText(Funcoes.formataData(data));
        } else {
            this.textValidadeGuia.setText("");
        }
    }

    public void setPlano(String plano) {
        this.textPlano.setText(plano);
    }

    public void setValidadeCarteira(Date data) {
        if (data != null) {
            this.textValidadeCarteira.setText(Funcoes.formataData(data));
        } else {
            this.textValidadeCarteira.setText("");
        }
    }

    public void setDeveGuia(boolean b) {
        this.checkDeveGuia.setSelected(b);
    }

    public String getGuia() {
        return this.textGuia.getText();
    }

    public String getGuiaPrincipal() {
        return this.textGuiaPrincipal.getText();
    }

    public String getMatricula() {
        return this.textMatricula.getText();
    }

    public Date getValidadeGuia() {
        return this.textValidadeGuia.getData();
    }

    public String getPlano() {
        return this.textPlano.getText();
    }

    public Date getValidadeCarteira() {
        return this.textValidadeCarteira.getData();
    }

    public boolean isDeveGuia() {
        return this.checkDeveGuia.isSelected();
    }

    public DadosConvenios getConvenio() {
        return this.convenio;
    }

    public void setConvenio(DadosConvenios convenio) {
        this.convenio = convenio;
        if (!Funcoes.textoVazio(convenio.getMatricula())) {
            try {
                this.textMatricula.setValue(null);
                this.textMatricula.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter(convenio.getMatricula())));
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InformacoesRepasse (280)");
            }
        } else {
            this.textMatricula.setValue(null);
            this.textMatricula.setFormatterFactory(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonValidadeCarteira) {
            Funcoes.mostraData(this.textValidadeCarteira, this.buttonValidadeCarteira, (JPanel)this.buttonValidadeCarteira.getParent(), true);
        } else if (e.getSource() == this.buttonValidadeGuia) {
            Funcoes.mostraData(this.textValidadeGuia, this.buttonValidadeGuia, (JPanel)this.buttonValidadeGuia.getParent(), true);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean validaMatriculaDigitada() {
        boolean erro = false;
        if (this.textMatricula.getFormatter() != null) {
            try {
                this.textMatricula.getFormatter().stringToValue(this.textMatricula.getText());
            }
            catch (Exception ex) {
                erro = true;
            }
        }
        return !erro;
    }
}

