/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.padroes.FrmPadrao;
import jalis.comum.padroes.TeclasEvent;
import jalis.comum.padroes.TeclasListener;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DialogoDataColeta
extends JDialog
implements DisposeListener {
    private JLabel lblData = new JLabel("Data:");
    private JLabel lblHora = new JLabel("Hora:");
    private JLabel lblUsuario = new JLabel("Usu\u00e1rio:");
    private TTextField txtData = new TTextField(10, 4);
    private TTextField txtHora = new TTextField(5, 6);
    private TTextField txtUsuario = new TTextField();
    private FrmPadrao panel = new FrmPadrao();
    private JPanel panelCentro = new JPanel(null);
    private JPanel panelBotao = new JPanel(new FlowLayout(2));
    private JButton btnSalvar = new JButton("OK");
    private JButton btnFechar = new JButton("Cancelar");
    private JButton bBuscaData = new JButton("");
    private JCheckBox checkNaoColetado = new JCheckBox("N\u00e3o coletado");
    private JCheckBox checkAlterarTodos = new JCheckBox("Alterar todos");
    private boolean salvarPressionado = false;

    public DialogoDataColeta(Window owner) {
        super(owner);
        try {
            if (owner instanceof Laboratorio) {
                ((Laboratorio)owner).addDisposeListener(this);
            }
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panel, "Center");
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.panelCentro, "Center");
        this.panel.add((Component)this.panelBotao, "South");
        this.panelBotao.add(this.btnSalvar);
        this.panelBotao.add(this.btnFechar);
        this.panelCentro.add(this.lblData);
        this.panelCentro.add(this.lblHora);
        this.panelCentro.add(this.lblUsuario);
        this.panelCentro.add(this.txtData);
        this.panelCentro.add(this.txtHora);
        this.panelCentro.add(this.txtUsuario);
        this.panelCentro.add(this.bBuscaData);
        this.panelCentro.add(this.checkNaoColetado);
        this.panelCentro.add(this.checkAlterarTodos);
        this.setResizable(false);
        this.setSize(new Dimension(240, 200));
        ScreenUtil.centralizar(this);
        this.setTitle("Informa\u00e7\u00f5es de coleta");
        this.setModal(true);
        this.lblData.setBounds(new Rectangle(5, 10, 69, 14));
        this.lblHora.setBounds(new Rectangle(5, 31, 69, 14));
        this.lblUsuario.setBounds(new Rectangle(5, 52, 69, 14));
        this.txtData.setBounds(new Rectangle(83, 8, 100, 20));
        this.bBuscaData.setBounds(new Rectangle(184, 8, 20, 20));
        this.txtHora.setBounds(new Rectangle(83, 29, 100, 20));
        this.txtUsuario.setBounds(new Rectangle(83, 50, 100, 20));
        this.txtUsuario.setEditable(false);
        this.txtUsuario.setFocusable(false);
        this.checkNaoColetado.setBounds(new Rectangle(83, 71, 110, 20));
        this.checkNaoColetado.setMnemonic('o');
        this.checkAlterarTodos.setBounds(new Rectangle(83, 92, 110, 20));
        this.checkAlterarTodos.setMnemonic('A');
        this.btnSalvar.setMnemonic('O');
        this.btnFechar.setMnemonic('C');
        this.bBuscaData.setFocusable(false);
        Funcoes.imagemPesquisa(this.bBuscaData);
        this.bBuscaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(DialogoDataColeta.this.txtData, DialogoDataColeta.this.bBuscaData, DialogoDataColeta.this.panelCentro, true);
            }
        });
        this.panel.addTeclasListener(new TeclasListener(){

            @Override
            public void teclaPressionada(TeclasEvent e) {
                if (e.getTecla() == 113) {
                    Funcoes.mostraData(DialogoDataColeta.this.txtData, DialogoDataColeta.this.bBuscaData, DialogoDataColeta.this.panelCentro, true);
                }
            }
        });
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogoDataColeta.this.salvarPressionado = false;
                DialogoDataColeta.this.setVisible(false);
            }
        });
        this.btnSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogoDataColeta.this.validaCampos()) {
                    DialogoDataColeta.this.salvarPressionado = true;
                    DialogoDataColeta.this.setVisible(false);
                }
            }
        });
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.txtData.getText()) || !Funcoes.verificaData(this.txtData.getText())) {
            Funcoes.mensagem(this, "Campo data com valor incorreto", 1);
            this.txtData.selectAll();
            this.txtData.grabFocus();
            return false;
        }
        if (Funcoes.textoVazio(this.txtHora.getText()) || !Funcoes.verificaHora(this.txtHora.getText())) {
            Funcoes.mensagem(this, "Campo hora com valor incorreto", 1);
            this.txtHora.selectAll();
            this.txtHora.grabFocus();
            return false;
        }
        return true;
    }

    public void setData(String data) {
        if (data != null) {
            this.txtData.setText(data);
        }
    }

    public void setHora(String hora) {
        if (hora != null) {
            this.txtHora.setText(hora);
        }
    }

    public void setUsuario(String usuario) {
        if (usuario != null) {
            this.txtUsuario.setText(usuario);
        }
    }

    public void setNaoColetado(boolean naoColetado) {
        this.checkNaoColetado.setSelected(naoColetado);
    }

    public String getData() {
        return this.txtData.getText();
    }

    public String getHora() {
        return this.txtHora.getText();
    }

    public String getUsuario() {
        return this.txtUsuario.getText();
    }

    public boolean getNaoColetado() {
        return this.checkNaoColetado.isSelected();
    }

    public boolean getAlterarTodos() {
        return this.checkAlterarTodos.isSelected();
    }

    public boolean isSalvarPressionado() {
        return this.salvarPressionado;
    }
}

