/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.util.Funcoes;
import java.util.Date;

public class DadosEntrega {
    private final Integer codigoRequisicao;
    private final String codigoExame;
    private final Integer codigoMaterial;
    private final String abreviaturaMaterial;
    private final String codigoUsuario;
    private final String entreguePara;
    private final Date dataHora;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abreviaturaMaterial == null ? 0 : this.abreviaturaMaterial.hashCode());
        result = 31 * result + (this.codigoExame == null ? 0 : this.codigoExame.hashCode());
        result = 31 * result + (this.codigoMaterial == null ? 0 : this.codigoMaterial.hashCode());
        result = 31 * result + (this.codigoRequisicao == null ? 0 : this.codigoRequisicao.hashCode());
        result = 31 * result + (this.codigoUsuario == null ? 0 : this.codigoUsuario.hashCode());
        result = 31 * result + (this.getDataHoraFormatada() == null ? 0 : this.getDataHoraFormatada().hashCode());
        result = 31 * result + (this.entreguePara == null ? 0 : this.entreguePara.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DadosEntrega other = (DadosEntrega)obj;
        if (this.abreviaturaMaterial == null ? other.abreviaturaMaterial != null : !this.abreviaturaMaterial.equals(other.abreviaturaMaterial)) {
            return false;
        }
        if (this.codigoExame == null ? other.codigoExame != null : !this.codigoExame.equals(other.codigoExame)) {
            return false;
        }
        if (this.codigoRequisicao == null ? other.codigoRequisicao != null : !this.codigoRequisicao.equals(other.codigoRequisicao)) {
            return false;
        }
        if (this.codigoUsuario == null ? other.codigoUsuario != null : !this.codigoUsuario.equals(other.codigoUsuario)) {
            return false;
        }
        if (this.dataHora == null ? other.dataHora != null : !this.getDataHoraFormatada().equals(other.getDataHoraFormatada())) {
            return false;
        }
        return !(this.entreguePara == null ? other.entreguePara != null : !this.entreguePara.equals(other.entreguePara));
    }

    public DadosEntrega(Integer codigoRequisicao, String exame, Integer codigoMaterial, String abreviaturaMaterial, String usuario, String entreguePara, Date data) {
        this.codigoRequisicao = codigoRequisicao;
        this.codigoExame = exame;
        this.codigoMaterial = codigoMaterial;
        this.abreviaturaMaterial = abreviaturaMaterial;
        this.codigoUsuario = usuario;
        this.entreguePara = entreguePara;
        this.dataHora = data;
    }

    public boolean dadosSaoValidos() {
        return this.requisicaoEstaPreenchida() && this.exameEstaPreenchido() && this.materialEstaPreenchido() && this.dataEstaPreenchida() && this.codigoUsuarioEstaPreenchido();
    }

    private boolean requisicaoEstaPreenchida() {
        return this.codigoRequisicao != -1;
    }

    private boolean codigoUsuarioEstaPreenchido() {
        return !Funcoes.textoVazio(this.codigoUsuario);
    }

    private boolean dataEstaPreenchida() {
        return this.dataHora != null;
    }

    private boolean materialEstaPreenchido() {
        return !Funcoes.textoVazio(this.abreviaturaMaterial);
    }

    private boolean exameEstaPreenchido() {
        return !Funcoes.textoVazio(this.codigoExame);
    }

    public Integer getCodigoRequisicao() {
        return this.codigoRequisicao;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public Integer getCodigoMaterial() {
        return this.codigoMaterial;
    }

    public String getAbreviaturaMaterial() {
        return this.abreviaturaMaterial;
    }

    public Date getDataHora() {
        return this.dataHora;
    }

    public String getUsuarioEntrega() {
        return this.codigoUsuario;
    }

    public String getEntreguePara() {
        return this.entreguePara;
    }

    public String getDataHoraFormatada() {
        if (this.dataHora == null) {
            return "";
        }
        return Funcoes.formataData(this.dataHora) + " " + Funcoes.formataHora(this.dataHora, false);
    }
}

