/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Paciente;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JDialog;

public class CadastrarPaciente
extends JDialog
implements DisposeListener {
    Paciente paciente = new Paciente(Variaveis.tipoFilialPadrao);

    public CadastrarPaciente(Frame owner, boolean bloqueiaNomePessoa) {
        this(owner, "", "", bloqueiaNomePessoa);
    }

    private static String tituloJanela() {
        String retorno = "pacientes";
        if (Variaveis.tipoFilialPadrao.equals("V")) {
            retorno = "animais";
        } else if (Variaveis.tipoFilialPadrao.equals("A")) {
            retorno = "clientes";
        }
        return retorno;
    }

    public CadastrarPaciente(Frame owner, String filial, String codigo, boolean bloqueiaNomePessoa) {
        super(owner, "Cadastro de " + CadastrarPaciente.tituloJanela());
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        if (Laboratorio.getInstancia().getExtendedState() != 6) {
            this.setSize(Laboratorio.getAreaUtil());
        } else {
            int width = (int)Laboratorio.getAreaUtil().getWidth() - 20;
            int height = (int)Laboratorio.getAreaUtil().getHeight() - 20;
            this.setSize(width, height);
        }
        ScreenUtil.centralizar(this);
        this.paciente.defineAcessos();
        if (!Funcoes.textoVazio(filial)) {
            this.paciente.setFilial(filial);
        }
        if (!Funcoes.textoVazio(codigo)) {
            this.paciente.setPaciente(codigo, bloqueiaNomePessoa);
        }
        this.getContentPane().add((Component)this.paciente, "Center");
    }

    public CadastrarPaciente(Dialog owner, boolean bloqueiaNomePessoa) {
        this(owner, "", "", bloqueiaNomePessoa);
    }

    public CadastrarPaciente(Dialog owner, String filial, String codigo, boolean bloqueiaNomePessoa) {
        super(owner, "Cadastro de pacientes");
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(875, 720);
        ScreenUtil.centralizar(this);
        this.paciente.defineAcessos();
        if (!Funcoes.textoVazio(filial)) {
            this.paciente.setFilial(filial);
        }
        if (!Funcoes.textoVazio(codigo)) {
            this.paciente.setPaciente(codigo, bloqueiaNomePessoa);
        }
        this.getContentPane().add((Component)this.paciente, "Center");
    }

    public int getCodigoPaciente() {
        return this.paciente.getCodigoPaciente();
    }

    public void setFilial(String filial) {
        this.paciente.setFilial(filial);
    }

    public void setCodigoPacienteEdicao(String codigoPacienteEdicao) {
        this.paciente.setCodigoPacienteEdicao(codigoPacienteEdicao);
    }

    public ArrayList getListaMedicamentos() {
        return this.paciente.getListaMedicamentos();
    }

    public ArrayList getListaMedicamentosModificados() {
        return this.paciente.getListaMedicamentosModificados();
    }
}

