/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AlterarDataEntrega
extends JDialog
implements DisposeListener {
    private Date data;
    private boolean ok = false;
    private JButton btnOK = new JButton("OK");
    private JButton btnFechar = new JButton("Cancelar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(null);
    private JLabel lblData = new JLabel("Data:");
    private JLabel lblHora = new JLabel("Hora:");
    private TTextField txtData = new TTextField(10, 4);
    private TTextField txtHora = new TTextField(5, 6);
    private JButton btnBuscaData = new JButton();
    private JCheckBox checkTodos = new JCheckBox("Alterar todos");
    private JCheckBox checkAvisarPaciente = new JCheckBox("Avisar paciente");
    private boolean acessoAlterarTodos = false;

    public AlterarDataEntrega(Frame owner, boolean podeAlterarTodos) {
        super(owner, true);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.acessoAlterarTodos = podeAlterarTodos;
        this.construirTela(owner);
    }

    public AlterarDataEntrega(Dialog owner, boolean podeAlterarTodos) {
        super(owner, true);
        this.acessoAlterarTodos = podeAlterarTodos;
        this.construirTela(owner);
    }

    private void construirTela(Component owner) {
        this.setTitle("Data de entrega");
        this.setSize(new Dimension(194, 160 - (this.acessoAlterarTodos ? 0 : 14)));
        this.setLocationRelativeTo(owner);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelCentro, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.setResizable(false);
        this.lblData.setDisplayedMnemonic('D');
        this.lblData.setLabelFor(this.txtData);
        this.lblHora.setDisplayedMnemonic('H');
        this.lblHora.setLabelFor(this.txtHora);
        this.checkAvisarPaciente.setMnemonic('A');
        this.checkAvisarPaciente.setToolTipText("N\u00e3o calcular o prazo de entrega do exame, apenas avisar quando ficar pronto");
        this.checkAvisarPaciente.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AlterarDataEntrega.this.txtData.clear();
                    AlterarDataEntrega.this.txtHora.clear();
                    AlterarDataEntrega.this.txtData.setEnabled(false);
                    AlterarDataEntrega.this.txtHora.setEnabled(false);
                    AlterarDataEntrega.this.btnBuscaData.setEnabled(false);
                } else {
                    AlterarDataEntrega.this.txtData.setEnabled(true);
                    AlterarDataEntrega.this.txtHora.setEnabled(true);
                    AlterarDataEntrega.this.btnBuscaData.setEnabled(true);
                    if (AlterarDataEntrega.this.data != null) {
                        AlterarDataEntrega.this.txtData.setText(Funcoes.formataData(AlterarDataEntrega.this.data));
                        AlterarDataEntrega.this.txtHora.setText(Funcoes.formataHora(AlterarDataEntrega.this.data, false));
                    }
                }
            }
        });
        this.checkTodos.setMnemonic('T');
        this.checkTodos.setToolTipText("Altera a data de entrega de todos os exames da requisi\u00e7\u00e3o");
        this.checkTodos.setVisible(this.acessoAlterarTodos);
        this.panelBotoes.add(this.btnOK);
        this.panelBotoes.add(this.btnFechar);
        this.panelCentro.add(this.lblData);
        this.panelCentro.add(this.lblHora);
        this.panelCentro.add(this.txtData);
        this.panelCentro.add(this.txtHora);
        this.panelCentro.add(this.btnBuscaData);
        this.panelCentro.add(this.checkTodos);
        this.panelCentro.add(this.checkAvisarPaciente);
        this.lblData.setDisplayedMnemonic('D');
        this.lblData.setLabelFor(this.txtData);
        this.btnOK.setMnemonic('O');
        this.btnFechar.setMnemonic('C');
        this.lblData.setBounds(new Rectangle(5, 7, 69, 14));
        this.lblHora.setBounds(new Rectangle(5, 28, 69, 14));
        this.txtData.setBounds(new Rectangle(50, 5, 100, 20));
        this.txtHora.setBounds(new Rectangle(50, 26, 100, 20));
        this.btnBuscaData.setBounds(new Rectangle(151, 5, 20, 20));
        this.checkAvisarPaciente.setBounds(new Rectangle(50, 47, 130, 14));
        this.checkTodos.setBounds(new Rectangle(50, 68, 130, 14));
        this.btnBuscaData.setFocusable(false);
        Funcoes.imagemPesquisa(this.btnBuscaData);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        ScreenUtil.requisitarFoco(this.txtData);
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(Funcoes.verificaData(AlterarDataEntrega.this.txtData.getText()) && Funcoes.verificaHora(AlterarDataEntrega.this.txtHora.getText()) && !AlterarDataEntrega.this.checkAvisarPaciente.isSelected() || Funcoes.textoVazio(AlterarDataEntrega.this.txtData) && Funcoes.textoVazio(AlterarDataEntrega.this.txtHora) && AlterarDataEntrega.this.checkAvisarPaciente.isSelected())) {
                    Funcoes.mensagem(AlterarDataEntrega.this, "Valores inv\u00e1lidos", 1);
                    AlterarDataEntrega.this.txtData.grabFocus();
                    return;
                }
                AlterarDataEntrega.this.data = Funcoes.textoVazio(AlterarDataEntrega.this.txtData) ? null : Funcoes.getData("dd/MM/yyyy HH:mm", AlterarDataEntrega.this.txtData.getText() + " " + AlterarDataEntrega.this.txtHora.getText());
                AlterarDataEntrega.this.ok = true;
                AlterarDataEntrega.this.setVisible(false);
            }
        });
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlterarDataEntrega.this.ok = false;
                AlterarDataEntrega.this.setVisible(false);
            }
        });
        this.btnBuscaData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Funcoes.mostraData(AlterarDataEntrega.this.txtData, AlterarDataEntrega.this.btnBuscaData, AlterarDataEntrega.this.panelCentro, true);
            }
        });
        this.txtData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(AlterarDataEntrega.this.txtData, AlterarDataEntrega.this.btnBuscaData, AlterarDataEntrega.this.panelCentro, true);
                }
            }
        });
    }

    public void setOcultarAvisarPaciente(boolean b) {
        this.checkAvisarPaciente.setVisible(b);
    }

    public void setData(Date data) {
        this.data = data;
        if (data == null) {
            this.txtData.setEnabled(false);
            this.txtHora.setEnabled(false);
            this.btnBuscaData.setEnabled(false);
            this.checkAvisarPaciente.setSelected(true);
            if (!this.checkAvisarPaciente.isVisible()) {
                this.checkAvisarPaciente.setVisible(this.checkAvisarPaciente.isSelected());
            }
        } else {
            this.txtData.setText(Funcoes.formataData(data));
            this.txtHora.setText(Funcoes.formataHora(data, false));
        }
    }

    public Boolean getAvisarPaciente() {
        return this.checkAvisarPaciente.isSelected();
    }

    public Date getData() {
        if (this.checkAvisarPaciente.isSelected()) {
            return null;
        }
        return this.data;
    }

    public boolean isOK() {
        return this.ok;
    }

    public boolean getAlterarTodos() {
        return this.checkTodos.isSelected();
    }
}

