/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.util;

import jalis.comum.Conexao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TPasswordField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AlterarColetor
extends JDialog
implements ActionListener {
    private final JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private final JPanel panelCentro = new JPanel(new GridBagLayout());
    private final JLabel labelCodigo = new JLabel("C\u00f3digo coletor:");
    private final TPasswordField txtCodigo = new TPasswordField(10);
    private final JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null, true);
    private final JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this, null, null, true);
    private boolean ok = false;
    private String login = "";

    public AlterarColetor(Frame owner) {
        super(owner, "Alterar coletor");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ColetarMaterial (1570)");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.add((Component)this.panelCentro, "Center");
        this.setSize(new Dimension(200, 112));
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelCentro.setBorder(ScreenUtil.criarBordaVazia());
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.fill = 2;
        con.anchor = 17;
        this.panelCentro.add((Component)this.labelCodigo, con);
        con.gridy = 1;
        con.weightx = 1.0;
        this.txtCodigo.setMinimumSize(new Dimension(10, 20));
        this.txtCodigo.setPreferredSize(new Dimension(10, 20));
        this.panelCentro.add((Component)this.txtCodigo, con);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                AlterarColetor.this.txtCodigo.grabFocus();
            }
        });
    }

    public void setOcultarBotaoCancelar(boolean b) {
        this.buttonCancelar.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.ok = false;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonOK) {
            if (!Funcoes.textoVazio(String.valueOf(this.txtCodigo.getPassword()))) {
                Statement st = Conexao.getStatement();
                StringBuilder bui = new StringBuilder("select usr_codigo from usuario where usr_codcoletor = '");
                bui.append(StringUtil.textoDB(String.valueOf(this.txtCodigo.getPassword())));
                bui.append("' and (usr_inativo = false or usr_inativo is null) ");
                try {
                    ResultSet rs = Conexao.executeQuery(st, bui.toString());
                    this.ok = rs.next();
                    if (this.ok) {
                        this.login = rs.getString("usr_codigo");
                    } else {
                        Funcoes.mensagem(this, "O c\u00f3digo informado n\u00e3o foi localizado", 1);
                        this.txtCodigo.selectAll();
                        ScreenUtil.requisitarFoco(this.txtCodigo);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ColetarMaterial (1631)");
                }
                Conexao.fecharStatement(st);
            } else {
                Funcoes.mensagem(this, "O c\u00f3digo n\u00e3o foi informado", 1);
                this.txtCodigo.selectAll();
                ScreenUtil.requisitarFoco(this.txtCodigo);
            }
            if (this.ok) {
                this.setVisible(false);
            }
        }
    }

    public boolean isOK() {
        return this.ok;
    }

    public String getLogin() {
        return this.login;
    }
}

