/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.selecionarimagem;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.financeiro.faturamento.AuditoriaIPERGS;
import jalis.laboratorio.recepcao.selecionarimagem.ButtonEditor;
import jalis.laboratorio.recepcao.selecionarimagem.ButtonRenderer;
import jalis.laboratorio.recepcao.selecionarimagem.DescricaoImagem;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.recepcao.RequisicaoVO;
import jalis.model.vo.recepcao.selecionarimagem.PacienteImagensVO;
import jalis.model.vo.recepcao.selecionarimagem.RequisicaoImagensVO;
import jalis.service.recepcao.selecionarimagem.SelecionarImagemService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class SelecionarImagem
extends AbstractDialogoOKCancelar {
    private int COLUNA_DESCRICAO = 0;
    private int COLUNA_TIPO = 3;
    private int COLUNA_CODIGO_IMAGEM = 4;
    public static int TIPO_IMAGEM_PACIENTE = 1;
    public static int TIPO_IMAGEM_REQUISICAO = 2;
    public static int COLUNA_BOTAO = 4;
    public static int COLUNA_OBJETO = 5;
    private String mensagemInformarDescricao = "A descri\u00e7\u00e3o da imagem deve ser informada";
    private int tipo = SelecionarImagemService.TIPO_IMAGEM_REQUISICAO;
    private String filial;
    private String requisicao;
    private String paciente;
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o", "Data", "Usu\u00e1rio", "Tipo", "", ""});
    private JTable table = new JTable(this.modelo){

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == SelecionarImagem.this.COLUNA_CODIGO_IMAGEM) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == SelecionarImagem.this.COLUNA_CODIGO_IMAGEM;
        }
    };
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', this);
    private JButton buttonCapturar = ComponenteFactory.novoJButton("Capturar", 'p', this);
    private static Integer tipoTela;

    public SelecionarImagem(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public SelecionarImagem(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public static SelecionarImagem novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new SelecionarImagem((Dialog)pai, "Anexos");
        }
        if (pai instanceof Frame) {
            return new SelecionarImagem((Frame)pai, "Anexos");
        }
        return null;
    }

    public static SelecionarImagem novaInstancia(Object pai, Integer tela) {
        tipoTela = tela;
        if (pai instanceof Dialog) {
            return new SelecionarImagem((Dialog)pai, "Anexos");
        }
        if (pai instanceof Frame) {
            return new SelecionarImagem((Frame)pai, "Anexos");
        }
        return null;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    private boolean temScanner() {
        return !Funcoes.textoVazio(ParametrosLocais.getParametro("scannerCaptura")) && !ParametrosLocais.getParametro("scannerCaptura").equals("Sem scanner");
    }

    private void montaTela() {
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumn("").setCellRenderer(new ButtonRenderer());
        this.table.getColumn("").setCellEditor(new ButtonEditor(this, this.table, this.COLUNA_CODIGO_IMAGEM));
        this.setResizable(false);
        this.getPanelBotoesEsquerda().setLayout(new FlowLayout(2));
        this.getPanelBotoesEsquerda().add(this.buttonAdicionar);
        if (this.temScanner()) {
            this.getPanelBotoesEsquerda().add(this.buttonCapturar);
        }
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.table.getColumnModel().getColumn(COLUNA_OBJETO).setMaxWidth(0);
        this.table.getColumnModel().getColumn(COLUNA_OBJETO).setMinWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(COLUNA_OBJETO).setMaxWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(COLUNA_OBJETO).setMinWidth(0);
        this.setSize(new Dimension(600, 400));
        this.modelo.setColumnSize(new int[]{0, 120, 90, 76, 35, 0}, this.table);
        this.table.setRowHeight(20);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (SelecionarImagem.this.table.getRowCount() > 0) {
                    SelecionarImagem.this.table.setRowSelectionInterval(0, 0);
                    ScreenUtil.requisitarFoco(SelecionarImagem.this.table);
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int linha = SelecionarImagem.this.table.getSelectedRow();
                if (linha >= 0) {
                    SelecionarImagemService serviceSelecionarImagem = new SelecionarImagemService();
                    if (SelecionarImagem.this.pressionouTecla(e.getKeyCode(), 113)) {
                        DescricaoImagem descricaoImagem = DescricaoImagem.novaInstancia(SelecionarImagem.this);
                        descricaoImagem.setDescricao(SelecionarImagem.this.modelo.getValueAt(linha, SelecionarImagem.this.COLUNA_DESCRICAO).toString());
                        descricaoImagem.setTipoOperacao(SelecionarImagem.this.modelo.getValueAt(linha, SelecionarImagem.this.COLUNA_TIPO).toString());
                        descricaoImagem.setVisible(true);
                        if (!descricaoImagem.getDescricao().isEmpty()) {
                            try {
                                serviceSelecionarImagem.atualizarRequisicaoImagem(SelecionarImagem.this.filial, SelecionarImagem.this.requisicao, descricaoImagem.getDescricao(), descricaoImagem.getTipoOperacao(), SelecionarImagem.this.modelo.getValueAt(linha, SelecionarImagem.this.COLUNA_CODIGO_IMAGEM).toString());
                                SelecionarImagem.this.modelo.setValueAt(descricaoImagem.getDescricao(), linha, SelecionarImagem.this.COLUNA_DESCRICAO);
                                SelecionarImagem.this.modelo.setValueAt(DescricaoImagem.getDescricaoOperacao(descricaoImagem.getTipoOperacao()), linha, SelecionarImagem.this.COLUNA_TIPO);
                            }
                            catch (SQLException e1) {
                                ErrorLogger.mostraMensagem(SelecionarImagem.this, "N\u00e3o foi poss\u00edvel atualizar as informa\u00e7\u00f5es da imagem.\n" + e1.getMessage(), e1.getStackTrace());
                            }
                        } else {
                            Funcoes.mensagem(SelecionarImagem.this, SelecionarImagem.this.mensagemInformarDescricao, 1);
                        }
                    }
                    if (SelecionarImagem.this.pressionouTecla(e.getKeyCode(), 127) && SelecionarImagem.this.autorizaExclusao(linha)) {
                        String codigo = SelecionarImagem.this.modelo.getValueAt(linha, SelecionarImagem.this.COLUNA_CODIGO_IMAGEM).toString();
                        try {
                            serviceSelecionarImagem.deletarImagens(Variaveis.filialPadrao, codigo, SelecionarImagem.this.tipo);
                            SelecionarImagem.this.modelo.removeLine(linha);
                        }
                        catch (Exception e2) {
                            ErrorLogger.mostraMensagem(SelecionarImagem.this, "N\u00e3o foi poss\u00edvel remover a imagem \n" + e2.getMessage(), e2.getStackTrace());
                        }
                    }
                }
            }
        });
    }

    private boolean podeAdicionar() {
        if (Funcoes.objectIsNull(tipoTela)) {
            return true;
        }
        if (tipoTela == 0) {
            return Acesso.getAcesso(400100145L);
        }
        if (tipoTela == 1) {
            return Acesso.getAcesso(400300145L);
        }
        if (tipoTela == AuditoriaIPERGS.getCodigoIdentificadorJanela()) {
            return Acesso.getAcesso(AuditoriaIPERGS.getModuloAdicionarImagens());
        }
        return true;
    }

    private boolean podeExcluir() {
        if (Funcoes.objectIsNull(tipoTela)) {
            return true;
        }
        if (tipoTela == 0) {
            return Acesso.getAcesso(400100146L);
        }
        if (tipoTela == 1) {
            return Acesso.getAcesso(400300146L);
        }
        if (tipoTela == AuditoriaIPERGS.getCodigoIdentificadorJanela()) {
            return Acesso.getAcesso(AuditoriaIPERGS.getModuloExcluirImagens());
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.botaoPressionado(e.getSource(), this.buttonAdicionar)) {
            this.adicionarImagem();
        } else if (this.botaoPressionado(e.getSource(), this.buttonCapturar)) {
            this.capturarImagem();
        } else {
            super.actionPerformed(e);
            this.executaCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adicionarImagem() {
        ImageIcon imagem = null;
        JFileChooser fc = ComponenteFactory.novoJFileChooser();
        fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem ou PDF", "bmp", "jpg", "jpeg", "gif", "png", "pdf"));
        if (this.imagemSelecionada(fc.showOpenDialog(this))) {
            imagem = new ImageIcon(fc.getSelectedFile().getPath());
            double tamPDF = fc.getSelectedFile().length();
            if (tamPDF < 1.0) {
                Funcoes.mensagem(this, "PDF Inv\u00e1lido", 1);
                return;
            }
        }
        if (this.contemImage(imagem)) {
            String extensaoDoArquivo = jalis.laboratorio.recepcao.SelecionarImagem.getFileExtension(fc.getSelectedFile().getPath());
            if (this.possuiImagem(imagem)) {
                if (!extensaoDoArquivo.equals("pdf") && imagem != null) {
                    this.salvarImagem(ImagemUtils.imageToByte(imagem.getImage()), extensaoDoArquivo);
                } else {
                    FileInputStream inputStream = null;
                    try {
                        inputStream = new FileInputStream(fc.getSelectedFile().getPath());
                        int numberBytes = inputStream.available();
                        byte[] bytearray = new byte[numberBytes];
                        int count = inputStream.read(bytearray);
                        if (count > 0) {
                            this.salvarImagem(bytearray, extensaoDoArquivo);
                        }
                    }
                    catch (IOException e) {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }

    private void capturarImagem() {
        Scanner scanner = Scanner.getDevice();
        try {
            scanner.addListener(new ScannerListener(){

                public void update(ScannerIOMetadata.Type type, ScannerIOMetadata siom) {
                    if (type.equals(ScannerIOMetadata.ACQUIRED)) {
                        BufferedImage bufferedImage = siom.getImage();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                            SelecionarImagem.this.salvarImagem(ImagemUtils.imageToByte(bufferedImage), null);
                        }
                        catch (IOException e) {
                            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel converter a imagem importada", e.getStackTrace());
                        }
                    }
                }
            });
            scanner.select(ParametrosLocais.getParametro("scannerCaptura"));
            scanner.acquire();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel capturar imagem", e.getStackTrace());
        }
    }

    private void salvarImagem(byte[] bts, String extensaoArquivo) {
        block10: {
            if (bts == null) {
                Funcoes.mensagem(this, this.mensagemInformarDescricao, 1);
            } else {
                DescricaoImagem descricaoImagem = DescricaoImagem.novaInstancia(this);
                if (tipoTela != null && tipoTela == AuditoriaIPERGS.getCodigoIdentificadorJanela()) {
                    descricaoImagem.setTipoOperacao(DescricaoImagem.getDescricaoOperacao("A"));
                }
                descricaoImagem.setVisible(true);
                if (!Funcoes.textoVazio(descricaoImagem.getDescricao())) {
                    try {
                        SelecionarImagemService serviceSelecionarImagem = new SelecionarImagemService();
                        serviceSelecionarImagem.inserirImagens(Variaveis.filialPadrao, Variaveis.login, descricaoImagem.getDescricao(), descricaoImagem.getTipoOperacao(), this.requisicao, descricaoImagem.getDescricao(), jalis.laboratorio.recepcao.SelecionarImagem.transformarBase64(bts), this.tipo, extensaoArquivo);
                        if (this.tipo == SelecionarImagemService.TIPO_IMAGEM_REQUISICAO) {
                            this.setRequisicao(this.filial, this.requisicao, extensaoArquivo);
                            break block10;
                        }
                        this.setPaciente(this.filial, this.paciente);
                    }
                    catch (SQLException e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel adicionar a imagem", e.getStackTrace(), "SelecionarImagem (173)");
                    }
                } else {
                    Funcoes.mensagem(this, this.mensagemInformarDescricao, 1);
                }
            }
        }
    }

    public void executaCommit() {
        try {
            if (this.getOK()) {
                Conexao.arquivaSQL();
                return;
            }
            Conexao.anulaSQL();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel processar as informa\u00e7\u00f5es na base de dados.", e.getStackTrace(), "SelecionarImagem (173)");
        }
    }

    public void setPaciente(String filial, String paciente) {
        if (this.parametrosVazio(filial, paciente)) {
            return;
        }
        this.filial = filial;
        this.paciente = paciente;
        this.modelo.clear();
        PacienteImagensVO pacienteImagensVO = new PacienteImagensVO();
        pacienteImagensVO.setFilial(new FilialVOAux(Integer.valueOf(filial)));
        pacienteImagensVO.setPacienteVO(new PacienteVO());
        SelecionarImagemService serviceSelecionarImagem = new SelecionarImagemService();
        try {
            List<PacienteImagensVO> listaPacienteImagem = serviceSelecionarImagem.setPaciente(pacienteImagensVO);
            for (PacienteImagensVO pacienteImagens : listaPacienteImagem) {
                this.modelo.addLine(new String[]{pacienteImagens.getPimDescricao(), pacienteImagens.getPimDataHora(), pacienteImagens.getUsuarioVO().getCodigo(), pacienteImagens.getPimCodigo()});
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar imagens do paciente", e.getStackTrace());
        }
    }

    public void setRequisicao(String filial, String requisicao, String extensaoArquivo) {
        if (this.parametrosVazio(filial, requisicao)) {
            return;
        }
        this.filial = filial;
        this.requisicao = requisicao;
        this.modelo.clear();
        RequisicaoImagensVO requisicaoImagensVO = new RequisicaoImagensVO();
        requisicaoImagensVO.setFilial(new FilialVOAux(Integer.valueOf(filial)));
        requisicaoImagensVO.setExtensaoDoArquivo(extensaoArquivo);
        RequisicaoVO requisicaoVO = new RequisicaoVO();
        requisicaoVO.setCodigo(Integer.valueOf(requisicao));
        requisicaoImagensVO.setRequisicaoVO(requisicaoVO);
        try {
            SelecionarImagemService serviceSelecionarImagem = new SelecionarImagemService();
            List<RequisicaoImagensVO> listaRequisicao = serviceSelecionarImagem.setRequisicao(requisicaoImagensVO);
            for (RequisicaoImagensVO requisicaoImagens : listaRequisicao) {
                this.modelo.addLine(new String[]{requisicaoImagens.getRimDescricao(), requisicaoImagens.getRimDataHora(), requisicaoImagens.getUsuarioVO().getCodigo(), DescricaoImagem.getDescricaoOperacao(requisicaoImagens.getRimTipo()), requisicaoImagens.getRimCodigo(), requisicaoImagens.getExtensaoDoArquivo()});
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar imagens da requisi\u00e7\u00e3o \n" + e.getMessage(), e.getStackTrace());
        }
    }

    private boolean linhaSelecionadaTabela() {
        return this.table.getRowCount() > 0;
    }

    private boolean possuiScannerConfigurado() {
        return !Funcoes.textoVazio(ParametrosLocais.getParametro("scannerCaptura")) && !ParametrosLocais.getParametro("scannerCaptura").equals("Sem scanner");
    }

    private boolean pressionouTecla(int keyCode, int vkevent) {
        return keyCode == vkevent;
    }

    private boolean autorizaExclusao(Integer linha) {
        return this.podeExcluir() && linha > -1 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0;
    }

    private boolean parametrosVazio(String filial, String parametro) {
        return filial == null || parametro == null;
    }

    private boolean possuiImagem(ImageIcon imagem) {
        return imagem != null;
    }

    private boolean imagemSelecionada(int showOpenDialog) {
        return showOpenDialog == 0;
    }

    private boolean botaoPressionado(Object source, JButton botao) {
        return source == botao;
    }

    private boolean contemImage(ImageIcon ii) {
        return ii != null;
    }
}

