/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.selecionarimagem;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class DescricaoImagem
extends AbstractDialogoOKCancelar {
    private static final String tituloJanela = "Descri\u00e7\u00e3o do anexo";
    private static String[] tipoOperacao = new String[]{"Guia", "Documento", "Auditoria", "Pedido", "Outros"};
    private static int indexItemPadraoCombo = 3;
    public static final String TIPO_AUDITORIO = "A";
    public static final String TIPO_PEDIDO = "P";
    private JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    private JLabel labelTipo = new JLabel("Tipo:");
    private TTextField textDescricao = new TTextField(100, 3);
    private JComboBox comboTipo = new JComboBox<String>(tipoOperacao);

    public DescricaoImagem(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public DescricaoImagem(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    public static DescricaoImagem novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new DescricaoImagem((Dialog)pai, tituloJanela);
        }
        return new DescricaoImagem((Frame)pai, tituloJanela);
    }

    private void montaTela() {
        this.setResizable(false);
        this.setSize(new Dimension(230, 130));
        this.setLocationRelativeTo(this.getParent());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone16x16.png").getImage());
        this.textDescricao.setPreferredSize(new Dimension(30, 20));
        this.comboTipo.setPreferredSize(new Dimension(30, 20));
        this.getBotaoCancelar().setVisible(false);
        this.setUsuarioPodeCancelar(false);
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 0, 0);
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getPanelCentral().add((Component)this.labelDescricao, gbc);
        gbc.fill = 2;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.getPanelCentral().add((Component)this.textDescricao, gbc);
        gbc.fill = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        this.getPanelCentral().add((Component)this.labelTipo, gbc);
        gbc.fill = 2;
        ++gbc.gridx;
        gbc.weightx = 1.0;
        this.getPanelCentral().add((Component)this.comboTipo, gbc);
        this.comboTipo.setSelectedIndex(indexItemPadraoCombo);
        ScreenUtil.requisitarFoco(this.textDescricao);
    }

    public void setTipoOperacao(String tipo) {
        this.comboTipo.setSelectedItem(tipo);
    }

    public String getDescricao() {
        return this.textDescricao.getText().trim();
    }

    public void setDescricao(String descricao) {
        this.textDescricao.setText(descricao);
    }

    public String getTipoOperacao() {
        return this.comboTipo.getSelectedItem().toString().substring(0, 1);
    }

    public static String getDescricaoOperacao(String operacao) {
        for (String descricaoOperacao : tipoOperacao) {
            if (!descricaoOperacao.substring(0, 1).equals(operacao)) continue;
            return descricaoOperacao;
        }
        return "";
    }
}

