/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.selecionarimagem;

import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.selecionarimagem.DialogoImagem;
import jalis.laboratorio.resultados.DialogoVisualizarResultadoPdf;
import jalis.service.recepcao.selecionarimagem.SelecionarImagemService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JTable;
import org.apache.commons.codec.binary.Base64;

public class ButtonEditor
extends DefaultCellEditor {
    private JButton button;
    private int linha = -1;
    private JDialog pai = null;
    private JTable table;
    private int coluna = 0;

    public ButtonEditor(JDialog pai, JTable table, int coluna) {
        super(new JCheckBox());
        this.table = table;
        this.pai = pai;
        this.coluna = coluna;
        this.button = new JButton();
        this.button.setOpaque(true);
        Funcoes.imagemPesquisa(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonEditor.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.linha = row;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.linha > -1) {
            String extensao = this.buscarExtensao(this.linha, 0);
            if (extensao != null && !extensao.equals("pdf")) {
                DialogoImagem dialogo = new DialogoImagem(this.pai);
                dialogo.setImagem(this.pegaImagem(this.linha));
                dialogo.setModal(true);
                dialogo.setVisible(true);
                ScreenUtil.requisitarFoco(this.table);
            } else {
                DialogoImagem dialogo = new DialogoImagem(this.pai);
                DialogoVisualizarResultadoPdf pdf = DialogoVisualizarResultadoPdf.novaInstancia(Laboratorio.getInstancia(), true);
                try {
                    pdf.setPDf(this.pegaPDF(this.linha));
                    pdf.setVisible(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.table.getValueAt(this.linha, this.coluna);
    }

    private String buscarExtensao(int linha, int parametro) {
        String extensao = null;
        if (linha > -1) {
            extensao = parametro == 0 ? this.buscaObjeto(linha) : this.pegaPDF(linha);
        }
        return extensao;
    }

    private String buscaObjeto(int linha) {
        Object obj = null;
        if (linha > -1 && this.table.getColumnCount() == 6) {
            obj = this.table.getValueAt(linha, 5);
        }
        return (String)obj;
    }

    private boolean linhaSelecionada(Integer linha) {
        return linha > -1;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    private Image pegaImagem(int linha) {
        Image retorno = null;
        if (this.linhaSelecionada(linha)) {
            try {
                SelecionarImagemService serviceSelecionarImagem = new SelecionarImagemService();
                ModeloGridTable modelo = (ModeloGridTable)this.table.getModel();
                String rimCodigo = (String)this.table.getValueAt(linha, this.coluna);
                String imagem = serviceSelecionarImagem.retornaImagem(Variaveis.filialPadrao, rimCodigo);
                new Base64();
                retorno = new ImageIcon(Base64.decodeBase64((String)imagem)).getImage();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel identificar o objeto imagem \n" + e.getMessage(), e.getStackTrace());
            }
        }
        return retorno;
    }

    private String pegaPDF(int linha) {
        String imagem = "";
        if (this.linhaSelecionada(linha)) {
            try {
                SelecionarImagemService serviceSelecionarImagem = new SelecionarImagemService();
                String rimCodigo = (String)this.table.getValueAt(linha, this.coluna);
                imagem = serviceSelecionarImagem.retornaImagem(Variaveis.filialPadrao, rimCodigo);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel identificar o objeto imagem \n" + e.getMessage(), e.getStackTrace());
            }
        }
        return imagem;
    }
}

