/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.requisicao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.util.impressao.ImprimirTermoConsentimento;
import jalis.model.vo.cadastro.auxiliares.TermoConsentimentoVO;
import jalis.service.cadastro.auxiliares.TermoConsentimentoService;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class TermoConsentimentoImpressaoAutomatica
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modeloTermo = new ModeloGridTable(new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"});
    private JTable tableTermo = null;
    private JScrollPane scrollTermo = null;
    private String termoSelecionado = "";
    private final TermoConsentimentoService service = new TermoConsentimentoService();
    private final ImprimirTermoConsentimento imprimirTermoConsentimento = new ImprimirTermoConsentimento();
    private TermoConsentimentoVO termoConsentimento = null;
    private static final int COLUNA_CODIGO = 0;
    private static final int COLUNA_DESCRICAO = 1;

    public static TermoConsentimentoImpressaoAutomatica novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new TermoConsentimentoImpressaoAutomatica((Dialog)owner, "Termo de consentimento");
        }
        if (owner instanceof Frame) {
            return new TermoConsentimentoImpressaoAutomatica((Frame)owner, "Termo de consentimento");
        }
        return null;
    }

    public TermoConsentimentoImpressaoAutomatica(Dialog owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
        this.setLocationRelativeTo(owner);
    }

    public TermoConsentimentoImpressaoAutomatica(Frame owner, String titulo) {
        super(owner, titulo);
        this.montaTela();
        this.setLocationRelativeTo(owner);
    }

    private void montaTela() {
        this.setSize(new Dimension(500, 250));
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.getBotaoCancelar().setMnemonic('C');
        this.tableTermo = new JTable(this.modeloTermo);
        this.tableTermo.getTableHeader().addMouseListener(this.modeloTermo);
        this.modeloTermo.setColumnSize(new int[]{50, 0}, this.tableTermo);
        try {
            List<Object> listaTermos = new ArrayList();
            listaTermos = this.service.getTermosAtivos();
            for (TermoConsentimentoVO termoConsentimentoVO : listaTermos) {
                this.modeloTermo.addLine(new Object[]{termoConsentimentoVO.getCodigo(), termoConsentimentoVO.getDescricao()});
            }
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(this, e1.getMessage(), e1.getStackTrace(), "TermoConsentimentoImpressaoAutomatica (55)");
        }
        this.scrollTermo = new JScrollPane(this.tableTermo);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.scrollTermo);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add(this.getPanelCentral().add(panel), "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    @Override
    public boolean acaoOk() {
        if (!this.getCancelado() && this.tableTermo.getSelectedRow() > -1) {
            this.setTermoSelecionado(this.modeloTermo.getValueAt(this.tableTermo.getSelectedRow(), 0).toString());
            return true;
        }
        return false;
    }

    public String getTermoSelecionado() {
        return this.termoSelecionado;
    }

    public void setTermoSelecionado(String termoSelecionado) {
        this.termoSelecionado = termoSelecionado;
    }
}

