/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.preagendamento;

import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.laboratorio.recepcao.preagendamento.DialogoZoom;
import jalis.laboratorio.recepcao.preagendamento.ObservadorRequisicao;
import jalis.model.vo.recepcao.preagendamento.PreAgendamentoVO;
import jalis.service.recepcao.RequisicaoPreAgendamentoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class RequisicaoPreAgendamento
extends JDialog
implements DisposeListener,
ObservadorRequisicao {
    public Requisicao requisicao;
    private String situacaoAgendamento = "";
    private JTable table;
    private JPanel painelDadosPaciente = null;
    private JPanel painelExames = null;
    private boolean isNovaRequisicao = false;
    private boolean imagensAdicionadas = false;
    private transient TreeMap<Integer, Image> imagens;
    private DialogoZoom dialogoZoom = new DialogoZoom();
    private static final int ALTURA_PADRAO_TELA = 690;
    public static final int ALTURA_IMAGEM = 230;
    public static final int LARGURA_IMAGEM = 215;
    private PreAgendamentoVO dadosPacienteInformados;
    private final RequisicaoPreAgendamentoService service;
    private JScrollPane scrollPanel;
    private JScrollPane scrollPanelExame;
    private GlassPaneMensagem glassPaneMensagem;
    static RequisicaoPreAgendamento instancia;

    public RequisicaoPreAgendamento(Frame owner, boolean isNovaRequisicao, String situacaoAgendamento, Date dataAgendamento, Registro registro, GlassPaneMensagem glassPaneMensagem) {
        super(owner, "Criando requisi\u00e7\u00e3o");
        this.isNovaRequisicao = isNovaRequisicao;
        this.situacaoAgendamento = situacaoAgendamento;
        new PreAgendamentoVO();
        this.dadosPacienteInformados = PreAgendamentoVO.registroToPreAgendamentoVO(registro);
        this.service = new RequisicaoPreAgendamentoService();
        this.glassPaneMensagem = glassPaneMensagem;
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        instancia = this;
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(1045, 690);
        ScreenUtil.centralizar(this);
        this.requisicao = new Requisicao(Variaveis.tipoFilialPadrao, true, dataAgendamento);
        this.requisicao.adcionarObservador(this);
        this.getContentPane().add((Component)this.requisicao, "Center");
        this.construirPainelDadosPaciente();
        this.setLocationRelativeTo(owner);
        this.requisicao.setFecharAoSalvar(true);
        this.requisicao.defineAcessos();
        if (!Funcoes.textoVazio(situacaoAgendamento)) {
            this.requisicao.setRequisicaoAgendamento(true, situacaoAgendamento);
        }
        this.dialogoZoom.setFilial(this.dadosPacienteInformados.getFilial().getCodigo());
    }

    public JPanel getPainelExames() {
        return this.painelExames;
    }

    public TreeMap<Integer, Image> getImagens() {
        return this.imagens;
    }

    public DialogoZoom getDialogoZoom() {
        return this.dialogoZoom;
    }

    public void setImagem(Integer codigo, Image image) {
        this.imagens.put(codigo, image);
    }

    public static RequisicaoPreAgendamento getInstancia() {
        return instancia;
    }

    @Override
    public void cardReposicionado(int posicaoAtual) {
        if (posicaoAtual == this.requisicao.EXAMES) {
            this.scrollPanel.setVisible(false);
            this.construirPainelExames();
            this.scrollPanelExame.setVisible(true);
        } else if (this.scrollPanelExame != null) {
            this.scrollPanelExame.setVisible(false);
            this.scrollPanelExame = null;
            this.construirPainelDadosPaciente();
        }
    }

    public void construirPainelExames() {
        if (this.dadosPacienteInformados.preAgendamentoComImagens()) {
            if (this.painelExames == null) {
                this.painelExames = ComponenteFactory.novoJPanel(new GridLayout(24, 1, 0, 0), new TitledBorder("Dados Exames"));
            }
            try {
                if (!this.imagensAdicionadas) {
                    this.imagens = this.service.getImagensExames(this.dadosPacienteInformados);
                }
                this.painelExames = new JPanel();
                this.painelExames.setBorder(BorderFactory.createTitledBorder("Dados Exames"));
                this.imagens.forEach((codigo, imagem) -> {
                    ImageIcon icon = new ImageIcon((Image)imagem);
                    icon.setImage(icon.getImage().getScaledInstance(100, 100, 100));
                    JButton img = new JButton(icon);
                    img.setEnabled(true);
                    img.setName(String.valueOf(codigo));
                    img.addActionListener(new ActionListener((Image)imagem, (Integer)codigo){
                        final /* synthetic */ Image val$imagem;
                        final /* synthetic */ Integer val$codigo;
                        {
                            this.val$imagem = image;
                            this.val$codigo = n;
                        }

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (this.val$imagem != null) {
                                DialogoZoom z = new DialogoZoom((JDialog)RequisicaoPreAgendamento.this.requisicao.getTopLevelAncestor());
                                z.setImagem(new ImageIcon((Image)RequisicaoPreAgendamento.this.imagens.get(this.val$codigo)));
                                z.setFilial(RequisicaoPreAgendamento.this.dadosPacienteInformados.getFilial().getCodigo());
                                z.setCodigoImagem(this.val$codigo);
                                z.setVisible(true);
                            }
                        }
                    });
                    this.painelExames.add(img);
                    this.imagensAdicionadas = true;
                });
                this.painelExames.setPreferredSize(new Dimension(135, 800));
                this.scrollPanelExame = new JScrollPane(this.painelExames);
                this.scrollPanelExame.setHorizontalScrollBarPolicy(31);
                this.getContentPane().add((Component)this.scrollPanelExame, "West");
            }
            catch (Exception e) {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel recuperar as imagens do pr\u00e9-agendamento", 1);
            }
        } else {
            this.adicionaExamesPanel(this.dadosPacienteInformados.getFilial().getCodigo(), this.dadosPacienteInformados.getCodigo());
        }
    }

    private void construirPainelDadosPaciente() {
        this.setGlassPane(this.glassPaneMensagem);
        if (this.painelDadosPaciente == null) {
            this.painelDadosPaciente = ComponenteFactory.novoJPanel(new GridLayout(24, 1, 0, 0), new TitledBorder("Dados Informados"));
        }
        this.painelDadosPaciente = new JPanel(new GridLayout(24, 1, 0, 0));
        this.painelDadosPaciente.setBorder(BorderFactory.createTitledBorder("Dados informados"));
        TTextField textNomePaciente = new TTextField(200, 3);
        textNomePaciente.setEditable(false);
        textNomePaciente.setText(this.dadosPacienteInformados.getNomePaciente());
        textNomePaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Nome"));
        this.painelDadosPaciente.add(textNomePaciente);
        TTextField textCodFilial = new TTextField(6, 3);
        textCodFilial.setEditable(false);
        textCodFilial.setText(this.dadosPacienteInformados.getFilial().getCodigo().toString());
        textCodFilial.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Filial"));
        this.painelDadosPaciente.add(textCodFilial);
        TTextField textCodigo = new TTextField(20, 3);
        textCodigo.setEditable(false);
        textCodigo.setText(this.dadosPacienteInformados.getCodigoPaciente().toString());
        textCodigo.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("C\u00f3digo"));
        this.painelDadosPaciente.add(textCodigo);
        TTextField textEnderecoPaciente = new TTextField(200, 3);
        textEnderecoPaciente.setEditable(false);
        textEnderecoPaciente.setText(this.dadosPacienteInformados.getEnderecoPaciente());
        textEnderecoPaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Endere\u00e7o"));
        this.painelDadosPaciente.add(textEnderecoPaciente);
        TTextField textNumeroEnderecoPaciente = new TTextField(20, 3);
        textNumeroEnderecoPaciente.setEditable(false);
        textNumeroEnderecoPaciente.setText(this.dadosPacienteInformados.getNumeroEnderecoPaciente());
        textNumeroEnderecoPaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("N\u00famero endere\u00e7o"));
        this.painelDadosPaciente.add(textNumeroEnderecoPaciente);
        TTextField textBairroPaciente = new TTextField(200, 3);
        textBairroPaciente.setEditable(false);
        textBairroPaciente.setText(this.dadosPacienteInformados.getBairroPaciente());
        textBairroPaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Bairro"));
        this.painelDadosPaciente.add(textBairroPaciente);
        TTextField textCidadePaciente = new TTextField(200, 3);
        textCidadePaciente.setEditable(false);
        textCidadePaciente.setText(this.dadosPacienteInformados.getCidadePaciente());
        textCidadePaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Cidade"));
        this.painelDadosPaciente.add(textCidadePaciente);
        TTextField textSexoPaciente = new TTextField(10, 3);
        textSexoPaciente.setEditable(false);
        String sexoPaciente = this.dadosPacienteInformados.getSexoPaciente().equalsIgnoreCase("F") ? "Feminino" : "Masculino";
        textSexoPaciente.setText(sexoPaciente);
        textSexoPaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Sexo"));
        this.painelDadosPaciente.add(textSexoPaciente);
        TTextField textCelularPaciente = new TTextField(20, 3);
        textCelularPaciente.setEditable(false);
        textCelularPaciente.setText(this.dadosPacienteInformados.getCelularPaciente());
        textCelularPaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Celular"));
        this.painelDadosPaciente.add(textCelularPaciente);
        TTextField textFonePaciente = new TTextField(20, 3);
        textFonePaciente.setEditable(false);
        textFonePaciente.setText(this.dadosPacienteInformados.getFonePaciente());
        textFonePaciente.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Telefone"));
        this.painelDadosPaciente.add(textFonePaciente);
        TTextField textConvenio = new TTextField(50, 3);
        textConvenio.setEditable(false);
        textConvenio.setText(this.dadosPacienteInformados.getConvenioInformado());
        textConvenio.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("Conv\u00eanio"));
        this.painelDadosPaciente.add(textConvenio);
        TTextField textMedico = new TTextField(50, 3);
        textMedico.setEditable(false);
        textMedico.setText(this.dadosPacienteInformados.getMedicoInformado());
        textMedico.setCaretPosition(0);
        this.painelDadosPaciente.add(new JLabel("M\u00e9dico"));
        this.painelDadosPaciente.add(textMedico);
        this.painelDadosPaciente.setPreferredSize(new Dimension(142, 690));
        this.scrollPanel = new JScrollPane(this.painelDadosPaciente);
        this.getContentPane().add((Component)this.scrollPanel, "West");
    }

    private void adicionaExamesPanel(int filial, int codigo) {
        if (this.painelExames == null) {
            this.painelExames = ComponenteFactory.novoJPanel(new GridLayout(25, 1, 0, 0), new TitledBorder("Dados Exames"));
        }
        this.adicionaExames();
        this.painelExames.setPreferredSize(new Dimension(200, 690));
        this.scrollPanelExame = new JScrollPane(this.painelExames);
        this.scrollPanelExame.setHorizontalScrollBarPolicy(31);
        this.getContentPane().add((Component)this.scrollPanelExame, "West");
    }

    private void adicionaExames() {
        if (Funcoes.textoVazio(this.dadosPacienteInformados.getDescritivoExames())) {
            this.painelExames = new JPanel(new GridLayout(24, 1, 0, 0));
            this.painelExames.setBorder(BorderFactory.createTitledBorder("Dados Exames"));
            HashMap<String, String> exames = this.service.getExames(this.dadosPacienteInformados);
            if (!exames.isEmpty()) {
                this.adicionaExamesJalis(exames);
            } else {
                this.examesNaoIdentificados();
            }
        } else {
            this.examesInformadosManualmente();
        }
    }

    private void examesInformadosManualmente() {
        this.painelExames = new JPanel();
        this.painelExames.setBorder(BorderFactory.createTitledBorder("Dados Exames"));
        JTextArea textExame = new JTextArea();
        textExame.setSize(new Dimension(190, 50));
        textExame.setText(this.dadosPacienteInformados.getDescritivoExames());
        textExame.setWrapStyleWord(true);
        textExame.setLineWrap(true);
        textExame.setEditable(false);
        this.painelExames.add(textExame);
    }

    private void examesNaoIdentificados() {
        this.painelExames = new JPanel();
        this.painelExames.setBorder(BorderFactory.createTitledBorder("Dados Exames"));
        JTextArea textExame = new JTextArea();
        textExame.setSize(new Dimension(190, 50));
        textExame.setText("Os exames n\u00e3o foram identificados ");
        textExame.setWrapStyleWord(true);
        textExame.setLineWrap(true);
        textExame.setEditable(false);
        this.painelExames.add(textExame);
    }

    private void adicionaExamesJalis(HashMap<String, String> exames) {
        for (final String codigoExa : exames.keySet()) {
            JLabel labelExame = new JLabel();
            labelExame.setText(exames.get(codigoExa));
            this.painelExames.add(labelExame);
            labelExame.setCursor(Cursor.getPredefinedCursor(12));
            labelExame.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RequisicaoPreAgendamento.this.adicionaExameGrid(codigoExa);
                }
            });
        }
    }

    private void adicionaExameGrid(String codigoExame) {
        this.requisicao.getTxtCodExame().setText(codigoExame);
        this.requisicao.adicionarExamePreAgendamento();
    }

    public void adicionarComponenteMensagem(JComponent componente, String mensagem, int posicao, boolean quebrarLinha) {
        if (this.getRootPane() != null && (this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || this.getRootPane().getGlassPane() instanceof JPanel) && componente != null && mensagem != null && !Funcoes.textoVazio(mensagem)) {
            this.glassPaneMensagem.adicionarComponenteMensagem(componente, mensagem, posicao, quebrarLinha);
        }
    }

    public void setComponenteMensagemVisivel(boolean isVisible) {
        if (this.getRootPane() != null && (this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || this.getRootPane().getGlassPane() instanceof JPanel)) {
            this.glassPaneMensagem.setVisible(isVisible);
        }
    }

    public void removerComponenteMensagem(JComponent componente) {
        if (this.getRootPane() != null && (this.getRootPane().getGlassPane() instanceof GlassPaneMensagem || this.getRootPane().getGlassPane() instanceof JPanel) && componente != null) {
            this.glassPaneMensagem.removerComponenteMensagem(componente);
        }
    }
}

