/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.preagendamento;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class MotivoCancelamentoPreAgendamento
extends AbstractDialogoOKCancelar {
    JTextArea textMotivo = new JTextArea(new TTextAreaDocument(200));

    public MotivoCancelamentoPreAgendamento(Frame owner) {
        super(owner, "Motivo de cancelamento");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    private void iniciar() {
        this.setUsuarioPodeCancelar(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Funcoes.mensagem(MotivoCancelamentoPreAgendamento.this, "O motivo deve ser informado", 2);
            }
        });
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("Motivo", 'D', null, this.textMotivo), c);
        c.weightx = 1.0;
        c.fill = 2;
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.textMotivo), c);
        this.setSize(new Dimension(300, 200));
        ScreenUtil.requisitarFoco(this.textMotivo);
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textMotivo.getText())) {
            Funcoes.mensagem(this, "O motivo do cancelamento n\u00e3o foi informado.", 2);
            ScreenUtil.requisitarFoco(this.textMotivo);
            return false;
        }
        return true;
    }

    @Override
    public void acaoCancelar() {
        this.dispose();
    }

    public void setDescricaoMotivo(String motivo) {
        this.textMotivo.setText(motivo);
    }

    public String getDescricaoMotivo() {
        return this.textMotivo.getText();
    }
}

