/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.preagendamento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.Impressao;
import jalis.laboratorio.recepcao.preagendamento.AumentarImagemPreAgendamento;
import jalis.laboratorio.recepcao.preagendamento.DialogoZoom;
import jalis.laboratorio.recepcao.preagendamento.ImageComponent;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.componentes.ComponenteFactory;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;

public class ImagensPreAgendamento
extends AbstractDialogoOKCancelar {
    private JPanel panelImagens = new JPanel(new GridBagLayout());
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this);
    private JButton buttonProximo = ComponenteFactory.novoJButton("Pr\u00f3ximo", 'P', this);
    private JButton buttonAnterior = ComponenteFactory.novoJButton("Anterior", 'A', this);
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonGirar = ComponenteFactory.novoJButton("Girar", 'G', this);
    private JButton buttonSalvar = ComponenteFactory.novoJButton("Salvar", 'S', this);
    private int codigoImg;
    private transient TreeMap<Integer, Image> imagens = new TreeMap();
    private transient TreeMap<Integer, Image> imagensEditadas = new TreeMap();
    private DialogoZoom dialogoZoom = new DialogoZoom();

    public ImagensPreAgendamento(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
    }

    private void montaTela() {
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setVisible(false);
        this.buttonSalvar.setEnabled(false);
        this.setModal(true);
        this.setResizable(false);
        this.setSize(new Dimension(550, 675));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)new JScrollPane(this.panelImagens), "Center");
        this.getPanelBotoesEsquerda().setLayout(new FlowLayout(2));
        this.getPanelBotoesDireita().setLayout(new FlowLayout(0));
        this.getPanelBotoesEsquerda().add(this.buttonImprimir);
        this.getPanelBotoesEsquerda().add(this.buttonGirar);
        this.getPanelBotoesDireita().add(this.buttonSalvar);
        this.getPanelBotoesDireita().add(this.buttonAnterior);
        this.getPanelBotoesDireita().add(this.buttonProximo);
        this.getPanelBotoesDireita().add(this.getBotaoCancelar());
        this.getPanelBotoesDireita().add(this.buttonFechar);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonImprimir) {
            if (this.getImagemParaImprimir() != null) {
                Documento doc = this.gerarDocumento();
                Impressao imp = new Impressao(jalis.laboratorio.util.impressao.Impressao.comparaNomeImpressoraReduzido(ParametrosLocais.getParametro("impressoraRelatorio")));
                imp.imprimir(doc);
            }
        } else if (o == this.buttonProximo) {
            if (this.dialogoZoom.getImagemGirada() != null) {
                this.imagensEditadas.put(this.codigoImg, this.dialogoZoom.getImagemGirada());
                this.dialogoZoom.setImagemGirada(null);
            }
            ++this.codigoImg;
            this.alternarImagem();
        } else if (o == this.buttonAnterior) {
            if (this.dialogoZoom.getImagemGirada() != null) {
                this.imagensEditadas.put(this.codigoImg, this.dialogoZoom.getImagemGirada());
                this.dialogoZoom.setImagemGirada(null);
            }
            --this.codigoImg;
            this.alternarImagem();
        } else if (o == this.buttonGirar) {
            this.dialogoZoom.setImagemGirada(ImagemUtils.girarImagem(this.imagens.get(this.codigoImg), this.dialogoZoom.getAnguloGirar()));
            this.imagensEditadas.put(this.codigoImg, this.dialogoZoom.getImagemGirada());
            this.setImagem(this.dialogoZoom.getImagemGirada());
            this.habilitarBotoesEdicao();
        } else if (o == this.getBotaoCancelar()) {
            if (Funcoes.mensagem(this, "As altera\u00e7\u00f5es ser\u00e3o descartadas. Deseja continuar?", 4) == 0) {
                this.cancelarEdicao();
            }
        } else if (o == this.buttonSalvar) {
            this.salvarImagens();
        } else {
            this.setVisible(false);
        }
    }

    private Documento gerarDocumento() {
        String corpo = "<exame>   <versaoExame>0</versaoExame>   <versao>3.0</versao>   <tipo>configuracao</tipo>   <versaoExameLabExterno></versaoExameLabExterno>   <pagina>      <propriedades>         <tipoConfiguracao>0</tipoConfiguracao>         <margemEsquerda>14</margemEsquerda>         <margemDireita>14</margemDireita>         <margemInferior>34</margemInferior>         <margemSuperior>36</margemSuperior>         <alturaCabecalho>56</alturaCabecalho>         <alturaSumario>56</alturaSumario>         <alturaRodape>56</alturaRodape>         <alturaRodapeExame>20</alturaRodapeExame>         <exibirSumario>true</exibirSumario>         <exibirRodapeExame>false</exibirRodapeExame>         <dimensoes><largura>588</largura><altura>831</altura></dimensoes>         <distanciaExames>0</distanciaExames>         <assinaturaSumario><exibir>false</exibir><exibirReferencia>false</exibirReferencia><campoBanco>assinaturaUsuarioConferencia</campoBanco><assinatura>assinaturaUsuarioConferencia</assinatura><quantidade>5</quantidade><alinhamento>4</alinhamento><altura>75</altura><posicao>3</posicao><tipo>0</tipo><absoluto>0</absoluto><imprime_assinatura_eletronica>false</imprime_assinatura_eletronica><margem_assinatura_eletronica>0.0</margem_assinatura_eletronica></assinaturaSumario>         <assinaturaRodape><exibir>false</exibir><exibirReferencia>false</exibirReferencia><campoBanco>assinaturaUsuarioConferencia</campoBanco><assinatura>assinaturaUsuarioConferencia</assinatura><quantidade>5</quantidade><alinhamento>4</alinhamento><altura>75</altura><posicao>3</posicao><tipo>0</tipo><absoluto>0</absoluto><imprime_assinatura_eletronica>false</imprime_assinatura_eletronica><margem_assinatura_eletronica>0.0</margem_assinatura_eletronica></assinaturaRodape>         <linhasGuia></linhasGuia>         <parametrosAreaLivre>null</parametrosAreaLivre>         <parametrosLinhasCorpo>null</parametrosLinhasCorpo>         <separadorExames>,</separadorExames>         <separadorCOA>,</separadorCOA>         <separadorSOA>,</separadorSOA>         <qualidadeImagensLaudo>null</qualidadeImagensLaudo>      </propriedades>      <itens>         <cabecalho></cabecalho>         <corpo>            <componente><tipo>jalis.laboratorio.configurador.componente.Imagem</tipo><atributos><local>0</local><altura>760</altura><esquerda>0</esquerda><largura>560</largura><topo>0</topo><nome>Imagem1</nome><resultadoAnterior>false</resultadoAnterior><imprimir>true</imprimir><ligacoes></ligacoes><valorPadrao></valorPadrao><alinhamentoHorizontal>0</alinhamentoHorizontal><alinhamentoVertical>0</alinhamentoVertical><salvoValor>false</salvoValor><removerVazio>true</removerVazio><valorResultado></valorResultado><contadorPagina>1</contadorPagina><campoInterfaceamento></campoInterfaceamento><campoImportacao><campo></campo></campoImportacao><estender>false</estender><imagem></imagem><campoBanco>imagemPreAgendamento</campoBanco><campoInterfaceamento></campoInterfaceamento><condicao></condicao></atributos></componente>         </corpo>         <sumario></sumario>         <rodape></rodape>         <rodapeExame></rodapeExame>      </itens>   </pagina>   <parametros><condicao></condicao><mensagemErro></mensagemErro><validacao></validacao><mensagemValidacao></mensagemValidacao>      <validacaoCompulsoria></validacaoCompulsoria><mensagemCompulsoria></mensagemCompulsoria>      <modificarHistorico><![CDATA[false]]></modificarHistorico><reposicionarComponentes><![CDATA[true]]></reposicionarComponentes>      <naoRemoverParcial><![CDATA[false]]></naoRemoverParcial><conferenciaAutomatica><tipoCalculo><![CDATA[Desativada]]></tipoCalculo><qtdeMinResultados></qtdeMinResultados></conferenciaAutomatica></parametros>   <mascaraPDF></mascaraPDF></exame>";
        HashMap<String, Object> hash = new HashMap<String, Object>();
        hash.put("imagemPreAgendamento".toLowerCase(), new Base64().encodeAsString(ImagemUtils.imageToByte(this.getImagemParaImprimir())));
        Digitacao digitacao = new Digitacao();
        digitacao.carregarCampos(corpo, hash);
        String resultado = digitacao.getResultado();
        Documento doc = new Documento();
        doc.setSempreReposicionarEntrePaginas(true);
        doc.addResultados(null, new String[]{resultado});
        doc.setCabecalhoRodape("<exame>   <versaoExame>1</versaoExame>   <versao>3.0</versao>   <tipo>configuracao</tipo>   <versaoExameLabExterno></versaoExameLabExterno>   <pagina>      <propriedades>         <tipoConfiguracao>1</tipoConfiguracao>         <margemEsquerda>14</margemEsquerda>         <margemDireita>14</margemDireita>         <margemInferior>14</margemInferior>         <margemSuperior>14</margemSuperior>         <alturaCabecalho>22</alturaCabecalho>         <alturaSumario>56</alturaSumario>         <alturaRodape>20</alturaRodape>         <alturaRodapeExame>20</alturaRodapeExame>         <exibirSumario>false</exibirSumario>         <exibirRodapeExame>false</exibirRodapeExame>         <dimensoes><largura>588</largura><altura>831</altura></dimensoes>         <distanciaExames>0</distanciaExames>         <assinaturaSumario><exibir>false</exibir><exibirReferencia>false</exibirReferencia><campoBanco></campoBanco><assinatura></assinatura><quantidade>5</quantidade><alinhamento>4</alinhamento><altura>75</altura><posicao>3</posicao><tipo>0</tipo><absoluto>0</absoluto><imprime_assinatura_eletronica>false</imprime_assinatura_eletronica><margem_assinatura_eletronica>0.0</margem_assinatura_eletronica></assinaturaSumario>         <assinaturaRodape><exibir>false</exibir><exibirReferencia>false</exibirReferencia><campoBanco></campoBanco><assinatura></assinatura><quantidade>5</quantidade><alinhamento>4</alinhamento><altura>75</altura><posicao>3</posicao><tipo>0</tipo><absoluto>0</absoluto><imprime_assinatura_eletronica>false</imprime_assinatura_eletronica><margem_assinatura_eletronica>0.0</margem_assinatura_eletronica></assinaturaRodape>         <linhasGuia></linhasGuia>         <parametrosAreaLivre><arealivre><preencher>false</preencher><tipo>texto</tipo><valor></valor><fontemensagem></fontemensagem></arealivre></parametrosAreaLivre>         <parametrosLinhasCorpo><linhascorpo><habilitarlinhascorpo>nao</habilitarlinhascorpo><acompanharresultado>nao</acompanharresultado><linhax><pontoslinhas></pontoslinhas><tipolinhas>Fixo</tipolinhas></linhax><linhay><pontoslinhas></pontoslinhas><tipolinhas>Fixo</tipolinhas></linhay><corlinhas>-1</corlinhas></linhascorpo></parametrosLinhasCorpo>         <separadorExames>,</separadorExames>         <separadorCOA>,</separadorCOA>         <separadorSOA>,</separadorSOA>         <qualidadeImagensLaudo>100</qualidadeImagensLaudo>         <referencias>            <alinhamentoReferenciaSumario>0</alinhamentoReferenciaSumario>            <fonteReferenciaSumario><nome></nome><estilo>0</estilo><tamanho>0</tamanho></fonteReferenciaSumario>            <alturaReferenciaSumario>0</alturaReferenciaSumario>            <posicaoReferenciaSumario>0</posicaoReferenciaSumario>            <identificadorReferencias><imprimirIdentificadorReferencia>false</imprimirIdentificadorReferencia><fonteIdentificadorReferencia></fonteIdentificadorReferencia><posicaoXIdentificadorReferencia>0</posicaoXIdentificadorReferencia><posicaoYIdentificadorReferencia>0</posicaoYIdentificadorReferencia></identificadorReferencias>         </referencias>      </propriedades>      <itens><cabecalho></cabecalho><corpo></corpo><sumario></sumario><rodape></rodape><rodapeExame></rodapeExame></itens>   </pagina>   <parametros></parametros>   <mascaraPDF></mascaraPDF></exame>");
        return doc;
    }

    private void alternarImagem() {
        if (this.imagensEditadas.get(this.codigoImg) != null) {
            this.setImagem(this.imagensEditadas.get(this.codigoImg));
        } else if (this.imagens.get(this.codigoImg) != null) {
            this.setImagem(this.imagens.get(this.codigoImg));
        }
        this.dialogoZoom.resetaAngulo();
        this.validarBotoesNavegacao();
    }

    private void cancelarEdicao() {
        this.dialogoZoom.resetaAngulo();
        this.dialogoZoom.setImagemGirada(null);
        this.imagensEditadas.clear();
        this.setImagem(this.imagens.get(this.codigoImg));
        this.validarBotoesNavegacao();
        this.getBotaoCancelar().setVisible(false);
        this.buttonFechar.setVisible(true);
        this.buttonSalvar.setEnabled(false);
    }

    private void salvarImagens() {
        if (this.dialogoZoom.salvarImagens(this.imagensEditadas)) {
            this.imagens.putAll(this.imagensEditadas);
            Funcoes.mensagem(this, "Altera\u00e7\u00f5es realizadas com sucesso!", 5);
        }
        this.dialogoZoom.resetaAngulo();
        this.getBotaoCancelar().setVisible(false);
        this.buttonFechar.setVisible(true);
        this.buttonSalvar.setEnabled(false);
    }

    private void validarBotoesNavegacao() {
        this.buttonAnterior.setVisible(this.imagens.size() > 1);
        this.buttonProximo.setVisible(this.imagens.size() > 1);
        this.buttonAnterior.setEnabled(this.imagens.firstKey() != this.codigoImg);
        this.buttonProximo.setEnabled(this.imagens.lastKey() != this.codigoImg);
    }

    public void setImagem(final Image imagem) {
        this.getPanelCentral().removeAll();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPanel panelImagem = new JPanel(new BorderLayout());
                ImageComponent c = new ImageComponent(imagem);
                ImageIcon ic = new ImageIcon(imagem);
                Dimension preferredSize = new Dimension(ic.getIconWidth() + 4, ic.getIconHeight() + 4);
                panelImagem.setPreferredSize(preferredSize);
                panelImagem.setMinimumSize(preferredSize);
                panelImagem.setMaximumSize(preferredSize);
                panelImagem.add((Component)c, "Center");
                ImagensPreAgendamento.this.getPanelCentral().setLayout(new BorderLayout());
                JScrollPane scroll = new JScrollPane(panelImagem);
                scroll.getHorizontalScrollBar().setMaximum(ic.getIconWidth());
                scroll.getVerticalScrollBar().setMaximum(ic.getIconHeight());
                scroll.setVisible(true);
                ImagensPreAgendamento.this.getPanelCentral().add((Component)scroll, "Center");
                ImagensPreAgendamento.this.getPanelCentral().revalidate();
                ImagensPreAgendamento.this.getPanelCentral().repaint();
            }
        });
    }

    private void habilitarBotoesEdicao() {
        this.getBotaoCancelar().setVisible(true);
        this.getBotaoCancelar().setEnabled(true);
        this.buttonSalvar.setEnabled(true);
        this.buttonFechar.setVisible(false);
    }

    private Image getImagemParaImprimir() {
        if (this.dialogoZoom.getImagemGirada() != null) {
            return this.dialogoZoom.getImagemGirada();
        }
        return this.imagens.get(this.codigoImg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPreAgendamento(int filial, int codigo) {
        Statement st = Conexao.getStatement();
        String sql = "select pig_imagem, pig_codigo from preagendamentoimagem where fil_codigo = " + filial + " and pre_codigo = " + codigo + " order by pig_codigo";
        try {
            ResultSet rs = Conexao.executeQuery(st, sql);
            GridBagConstraints c = new GridBagConstraints();
            c.insets = new Insets(10, 10, 10, 10);
            c.gridx = 0;
            c.gridy = 0;
            while (rs.next()) {
                this.codigoImg = Integer.parseInt(rs.getString("pig_codigo"));
                ImageIcon icon = new ImageIcon(new Base64().decode(rs.getString("pig_imagem")));
                this.imagens.put(this.codigoImg, icon.getImage());
            }
            this.codigoImg = this.imagens.firstKey();
            this.dialogoZoom.setFilial(filial);
            this.setImagem(this.imagens.get(this.codigoImg));
            this.validarBotoesNavegacao();
            rs.close();
        }
        catch (Exception e) {
            boolean bl;
            try {
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel recuperar as imagens do pr\u00e9-agendamento", 1);
                bl = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return true;
    }

    private JLabel miniatura(int codigo, final ImageIcon imagem) {
        int ALTURA = 200;
        int LARGURA = 200;
        BufferedImage alterado = new BufferedImage(200, 200, 2);
        Graphics2D g = alterado.createGraphics();
        g.drawImage(imagem.getImage(), 0, 0, 200, 200, null);
        g.dispose();
        g.setComposite(AlphaComposite.Src);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ImageIcon img = new ImageIcon(alterado);
        JLabel retorno = new JLabel(img){
            private ImageIcon icone;
            {
                this.icone = ImagemUtils.carregaImagemJalis("zoom.gif");
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D gg = (Graphics2D)g;
                gg.drawImage(this.icone.getImage(), this.getWidth() - 25, this.getHeight() - 25, null);
            }
        };
        retorno.setToolTipText("Clique para aumentar a imagem");
        retorno.setCursor(Cursor.getPredefinedCursor(12));
        retorno.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && e.getButton() == 1) {
                    AumentarImagemPreAgendamento au = new AumentarImagemPreAgendamento(ImagensPreAgendamento.this);
                    au.setImagem(imagem.getImage());
                    au.setVisible(true);
                }
            }
        });
        return retorno;
    }
}

