/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.preagendamento;

import jalis.comum.Conexao;
import jalis.laboratorio.recepcao.preagendamento.RequisicaoPreAgendamento;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.SortedMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DialogoZoom
extends JDialog
implements ActionListener {
    private ImageIcon imagem;
    private ImageIcon imagemOriginal;
    private transient BufferedImage imagemGirada;
    private int filial;
    private int codigoImagem;
    private JButton buttonFechar = ComponenteFactory.novoJButton("Fechar", 'F', this);
    private JButton buttonGirar = ComponenteFactory.novoJButton("Girar", 'G', this);
    private JButton buttonOk = ComponenteFactory.novoJButton("Ok", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private int angulo = 0;
    private JPanel panelImagem = new JPanel(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            if (DialogoZoom.this.imagem != null) {
                Graphics2D g2 = (Graphics2D)g;
                g2.drawImage(DialogoZoom.this.imagem.getImage(), 0, 0, DialogoZoom.this.imagem.getIconWidth(), DialogoZoom.this.imagem.getIconHeight(), null);
            }
        }
    };
    private JScrollPane scroll = new JScrollPane(this.panelImagem);

    public DialogoZoom() {
    }

    public DialogoZoom(JDialog owner) {
        super((Dialog)owner, "Visualizando imagem");
        this.setSize(new Dimension(700, 500));
        this.setLocationRelativeTo(owner);
        this.setLayout(new BorderLayout());
        this.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOk, this.buttonGirar, this.buttonFechar, this.buttonCancelar), "South");
        this.add((Component)this.scroll, "Center");
        this.buttonOk.setEnabled(false);
        this.buttonCancelar.setVisible(false);
        this.scroll.setAutoscrolls(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.buttonGirar) {
            this.setImagemGirada(ImagemUtils.girarImagem(this.getImagemOriginal().getImage(), this.getAnguloGirar()));
            this.setImagem(new ImageIcon(this.getImagemGirada()));
            this.buttonOk.setEnabled(true);
            this.buttonCancelar.setVisible(true);
            this.buttonFechar.setVisible(false);
        } else if (e.getSource() == this.buttonOk) {
            this.salvarImagem(this.getImagemGirada());
            this.setImagem(new ImageIcon(this.getImagemGirada()));
        } else if (e.getSource() == this.buttonCancelar && Funcoes.mensagem(this, "As altera\u00e7\u00f5es ser\u00e3o descartadas. Deseja continuar?", 4) == 0) {
            this.resetaAngulo();
            this.setImagem(this.getImagemOriginal());
            this.buttonFechar.setVisible(true);
            this.buttonCancelar.setVisible(false);
            this.buttonOk.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean salvarImagens(SortedMap<Integer, Image> imagens) {
        Statement st = Conexao.getStatement();
        try {
            if (!Funcoes.objectIsNull(imagens) && !imagens.isEmpty()) {
                ArrayList sql = new ArrayList();
                imagens.forEach((codigo, img) -> {
                    String update = null;
                    update = "update preagendamentoimagem set pig_imagem = '" + ImagemUtils.converterImagemParaBase64(img) + "' where fil_codigo = " + this.getFilial() + " and pig_codigo = " + codigo;
                    sql.add(update);
                });
                for (String query : sql) {
                    Conexao.executeUpdate(String.valueOf(this.filial), st, query);
                    Conexao.arquivaSQL();
                }
            }
        }
        catch (Exception e) {
            boolean bl;
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel atualizar as imagens do pr\u00e9-agendamento", 1);
                bl = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return true;
    }

    public void salvarImagem(BufferedImage image) {
        RequisicaoPreAgendamento req = RequisicaoPreAgendamento.getInstancia();
        req.setImagem(this.codigoImagem, image);
        ImageIcon icon = new ImageIcon(image);
        icon.setImage(icon.getImage().getScaledInstance(100, 100, 100));
        for (int i = 0; i <= req.getPainelExames().getComponents().length; ++i) {
            Component botao = req.getPainelExames().getComponent(i);
            if (!(botao instanceof JButton) || !botao.getName().equals(String.valueOf(this.codigoImagem))) continue;
            ((JButton)botao).setIcon(icon);
            break;
        }
        this.buttonFechar.setVisible(true);
        this.buttonCancelar.setVisible(false);
        this.buttonOk.setEnabled(false);
    }

    public void setImagem(ImageIcon imagem) {
        this.imagem = imagem;
        if (this.imagemOriginal == null) {
            this.setImagemOriginal(imagem);
        }
        this.panelImagem.setSize(imagem.getIconWidth(), imagem.getIconHeight());
        this.panelImagem.setPreferredSize(new Dimension(imagem.getIconWidth(), imagem.getIconHeight()));
        this.scroll.getHorizontalScrollBar().setMaximum(imagem.getIconWidth());
        this.scroll.getVerticalScrollBar().setMaximum(imagem.getIconHeight());
    }

    public int getAnguloGirar() {
        this.angulo += 90;
        return this.angulo;
    }

    public void resetaAngulo() {
        this.angulo = 0;
    }

    public void setFilial(int filial) {
        this.filial = filial;
    }

    public int getFilial() {
        return this.filial;
    }

    public void setCodigoImagem(int codigoImagem) {
        this.codigoImagem = codigoImagem;
    }

    public int getCodigoImagem() {
        return this.codigoImagem;
    }

    public BufferedImage getImagemGirada() {
        return this.imagemGirada;
    }

    public void setImagemGirada(BufferedImage imagemGirada) {
        this.imagemGirada = imagemGirada;
    }

    public ImageIcon getImagemOriginal() {
        return this.imagemOriginal;
    }

    public void setImagemOriginal(ImageIcon imagemOriginal) {
        this.imagemOriginal = imagemOriginal;
    }
}

