/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.preagendamento;

import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Paciente;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CadastrarPacientePreAgendamento
extends JDialog
implements DisposeListener {
    private static final int ALTURA_PADRAO_TELA = 720;
    private Paciente paciente;
    private JPanel panelDados;

    public CadastrarPacientePreAgendamento(Frame owner, String filial, String codigo, Registro registro) {
        super(owner, "Cadastro de pacientes");
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(1010, 720);
        ScreenUtil.centralizar(this);
        this.paciente = new Paciente(Variaveis.tipoFilialPadrao);
        this.paciente.defineAcessos();
        if (!Funcoes.textoVazio(filial)) {
            this.paciente.setFilial(filial);
        }
        if (!Funcoes.textoVazio(codigo)) {
            this.paciente.setPaciente(codigo, false);
            this.paciente.setCodigoPacienteEdicao(codigo);
        }
        this.getContentPane().add((Component)this.paciente, "Center");
        this.buildDadosPaciente(registro);
        this.setLocationRelativeTo(owner);
    }

    private void buildDadosPaciente(Registro registro) {
        this.panelDados = new JPanel(new GridLayout(22, 1, 0, 0));
        this.panelDados.setBorder(BorderFactory.createTitledBorder("Dados informados"));
        TTextField textNomePaciente = new TTextField(200, 3);
        TTextField textCodFilial = new TTextField(6, 3);
        TTextField textCodigo = new TTextField(20, 3);
        TTextField textEnderecoPaciente = new TTextField(200, 3);
        TTextField textNumeroEnderecoPaciente = new TTextField(20, 3);
        TTextField textBairroPaciente = new TTextField(200, 3);
        TTextField textCidadePaciente = new TTextField(200, 3);
        TTextField textSexoPaciente = new TTextField(10, 3);
        TTextField textCelularPaciente = new TTextField(20, 3);
        TTextField textFonePaciente = new TTextField(20, 3);
        TTextField textConvenio = new TTextField(50, 3);
        TTextField textMedico = new TTextField(50, 3);
        if (registro != null) {
            textNomePaciente.setText(registro.getString("pre_nomepaciente"));
            textCodigo.setText(registro.getString("pre_codigopaciente"));
            textCodFilial.setText(registro.getString("pre_codigofilialpaciente"));
            textEnderecoPaciente.setText(registro.getString("pre_enderecopaciente"));
            textNumeroEnderecoPaciente.setText(registro.getString("pre_numeroenderecopaciente"));
            textBairroPaciente.setText(registro.getString("pre_bairropaciente"));
            textCidadePaciente.setText(registro.getString("pre_cidadepaciente") + " (" + registro.getString("pre_estadopaciente") + ")");
            textSexoPaciente.setText(Tipos.tipoSexo(registro.getString("pre_sexopaciente")));
            textCelularPaciente.setText(registro.getString("pre_celularpaciente"));
            textFonePaciente.setText(registro.getString("pre_fonepaciente"));
        }
        textNomePaciente.setEditable(false);
        textNomePaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Nome"));
        this.panelDados.add(textNomePaciente);
        textCodFilial.setEditable(false);
        textCodFilial.setCaretPosition(0);
        this.panelDados.add(new JLabel("Filial"));
        this.panelDados.add(textCodFilial);
        textCodigo.setEditable(false);
        textCodigo.setCaretPosition(0);
        this.panelDados.add(new JLabel("C\u00f3digo"));
        this.panelDados.add(textCodigo);
        textEnderecoPaciente.setEditable(false);
        textEnderecoPaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Endere\u00e7o"));
        this.panelDados.add(textEnderecoPaciente);
        textNumeroEnderecoPaciente.setEditable(false);
        textNumeroEnderecoPaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("N\u00famero endere\u00e7o"));
        this.panelDados.add(textNumeroEnderecoPaciente);
        textBairroPaciente.setEditable(false);
        textBairroPaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Bairro"));
        this.panelDados.add(textBairroPaciente);
        textCidadePaciente.setEditable(false);
        textCidadePaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Cidade"));
        this.panelDados.add(textCidadePaciente);
        textSexoPaciente.setEditable(false);
        textSexoPaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Sexo"));
        this.panelDados.add(textSexoPaciente);
        textCelularPaciente.setEditable(false);
        textCelularPaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Celular"));
        this.panelDados.add(textCelularPaciente);
        textFonePaciente.setEditable(false);
        textFonePaciente.setCaretPosition(0);
        this.panelDados.add(new JLabel("Telefone"));
        this.panelDados.add(textFonePaciente);
        this.panelDados.setPreferredSize(new Dimension(135, 720));
        JScrollPane scrollPanel = new JScrollPane(this.panelDados);
        this.getContentPane().add((Component)scrollPanel, "West");
    }

    public int getCodigoPaciente() {
        return this.paciente.getCodigoPaciente();
    }

    public void setFilial(String filial) {
        this.paciente.setFilial(filial);
    }

    public void setCodigoPacienteEdicao(String codigoPacienteEdicao) {
        this.paciente.setCodigoPacienteEdicao(codigoPacienteEdicao);
    }
}

