/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.panel.log.sms;

import jalis.laboratorio.recepcao.panel.log.PanelLog;
import jalis.laboratorio.recepcao.panel.log.sms.PanelRegistroLogSms;
import jalis.model.bean.exportadores.LogSMSBean;
import jalis.service.exportadores.LogSMSService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;

public class PanelLogSms
extends PanelLog {
    LogSMSService logSmsService = new LogSMSService();
    private int qntdDeLogsSms;
    private final int width;

    public PanelLogSms() {
        this.width = 400;
    }

    public PanelLogSms(int width) {
        this.width = width;
    }

    @Override
    public void carregarLog(String codigoFilial, String codigoPaciente) {
        this.removeAll();
        List<LogSMSBean> logSms = this.buscaLogSms(codigoFilial, codigoPaciente);
        int qntdDeLogs = logSms.size();
        this.definirPropriedadesLocais(qntdDeLogs);
        GridBagConstraints c = new GridBagConstraints();
        for (LogSMSBean log : logSms) {
            if (logSms.indexOf(log) == logSms.size() - 1) {
                this.montaUltimoLog(c, log);
                continue;
            }
            this.montaLog(c, log);
        }
    }

    private void definirPropriedadesLocais(int qntdDeLogs) {
        int height = 150 * qntdDeLogs + 15;
        Dimension panelSmsDimension = new Dimension(this.width, height);
        this.setPreferredSize(panelSmsDimension);
        this.setLayout(new GridBagLayout());
    }

    private void montaLog(GridBagConstraints c, LogSMSBean log) {
        ++c.gridy;
        c.anchor = 18;
        c.fill = 1;
        PanelRegistroLogSms sms = new PanelRegistroLogSms(log);
        c.weightx = 1.0;
        this.add((Component)sms, c);
        c.weightx = 0.0;
        ++c.gridy;
        this.add(this.getLinha(this), c);
    }

    private void montaUltimoLog(GridBagConstraints c, LogSMSBean log) {
        ++c.gridy;
        c.anchor = 18;
        c.fill = 1;
        PanelRegistroLogSms sms = new PanelRegistroLogSms(log);
        sms.setPreferredSize(new Dimension(600, 117));
        c.weightx = 1.0;
        this.add((Component)sms, c);
        c.weightx = 0.0;
        c.weighty = 1.0;
        ++c.gridy;
        Component linha = this.getLinha(this);
        linha.setPreferredSize(new Dimension(600, 10));
        this.add(linha, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogSMSBean> buscaLogSms(String codigoFilial, String codigoPaciente) {
        List<LogSMSBean> logSms = null;
        try {
            List<LogSMSBean> list = logSms = this.logSmsService.getByPacCodigo(codigoFilial, codigoPaciente);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return logSms;
        }
    }

    @Override
    public void carregarLogComReq(String codigoFilial, String codigoPaciente, String requisicao) {
        this.removeAll();
        List<LogSMSBean> logSms = this.buscaLogSmsReq(codigoFilial, codigoPaciente, requisicao);
        this.setQntdDeLogsSms(logSms.size());
        this.definirPropriedadesLocais(this.getQntdDeLogsSms());
        GridBagConstraints c = new GridBagConstraints();
        for (LogSMSBean log : logSms) {
            if (logSms.indexOf(log) == logSms.size() - 1) {
                this.montaUltimoLog(c, log);
                continue;
            }
            this.montaLog(c, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogSMSBean> buscaLogSmsReq(String codigoFilial, String codigoPaciente, String codigoRequisicao) {
        List<LogSMSBean> logSms = null;
        try {
            List<LogSMSBean> list = logSms = this.logSmsService.getByPacRecCodigo(codigoFilial, codigoPaciente, codigoRequisicao);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return logSms;
        }
    }

    public int getQntdDeLogsSms() {
        return this.qntdDeLogsSms;
    }

    public void setQntdDeLogsSms(int qntdDeLogsSms) {
        this.qntdDeLogsSms = qntdDeLogsSms;
    }
}

