/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.panel.log.email;

import jalis.laboratorio.recepcao.dialog.log.ReenviadorDeLog;
import jalis.laboratorio.util.EmailUtil;
import jalis.model.bean.exportadores.LogEmailBean;
import jalis.util.Funcoes;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelRegistroLogEmail
extends JPanel {
    private final LogEmailBean bean;
    private JLabel labelLogEmail;
    private JLabel logEmail;
    private JLabel labelDataHora;
    private JLabel dataHora;
    private JLabel labelPaciente;
    private JLabel paciente;
    private JLabel labelRequisicao;
    private JLabel requisicao;
    private JLabel labelDestino;
    private JLabel destino;
    private JLabel labelOrigem;
    private JLabel origem;
    private JLabel labelFilial;
    private JLabel filial;
    private JLabel labelSituacao;
    private JLabel situacao;

    public PanelRegistroLogEmail(LogEmailBean bean) {
        this.setLayout(new GridBagLayout());
        this.bean = bean;
        this.montaListeners();
        this.montaPanel();
    }

    private void montaListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                if (e.getClickCount() == 2) {
                    new ReenviadorDeLog(e.getComponent(), PanelRegistroLogEmail.this.bean);
                }
            }
        });
    }

    private void montaPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        this.labelFilial = new JLabel("Filial: ");
        this.filial = new JLabel(this.bean.getFilial().getCodigo().toString());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.labelFilial, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        this.add((Component)this.filial, constraints);
        this.labelLogEmail = new JLabel("Log E-MAIL: ");
        this.logEmail = new JLabel(this.bean.getCodigo().toString());
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 2;
        this.add((Component)this.labelLogEmail, constraints);
        constraints.gridx = 1;
        constraints.gridy = 2;
        this.add((Component)this.logEmail, constraints);
        this.labelDataHora = new JLabel("Data Hora Envio: ");
        String dataHoraFormatada = this.formataDataHora(this.bean.getDataHora());
        this.dataHora = new JLabel(dataHoraFormatada);
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        this.add((Component)this.labelDataHora, constraints);
        constraints.gridx = 1;
        constraints.gridy = 3;
        constraints.weightx = 1.0;
        this.add((Component)this.dataHora, constraints);
        this.labelPaciente = new JLabel("Paciente: ");
        this.paciente = new JLabel(this.bean.getPaciente() == null ? "" : this.bean.getPaciente().getNome());
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 0.0;
        this.add((Component)this.labelPaciente, constraints);
        constraints.gridx = 1;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        this.add((Component)this.paciente, constraints);
        this.labelRequisicao = new JLabel("Requisi\u00e7\u00e3o: ");
        this.requisicao = new JLabel(this.bean.getRequisicao() == null ? "" : this.bean.getRequisicao().getCodigo().toString());
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.weightx = 0.0;
        this.add((Component)this.labelRequisicao, constraints);
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.weightx = 1.0;
        this.add((Component)this.requisicao, constraints);
        this.labelDestino = new JLabel("Destino Envio: ");
        this.destino = new JLabel(this.bean.getEmail() == null ? "" : this.bean.getEmail());
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.weightx = 0.0;
        this.add((Component)this.labelDestino, constraints);
        constraints.gridx = 1;
        constraints.gridy = 6;
        constraints.weightx = 1.0;
        this.add((Component)this.destino, constraints);
        this.labelOrigem = new JLabel("Origem Envio: ");
        this.origem = new JLabel(this.bean.getOrigem() == null ? "" : this.apresentaOrigem(this.bean.getOrigem()).getDescricao());
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.weightx = 0.0;
        this.add((Component)this.labelOrigem, constraints);
        constraints.gridx = 1;
        constraints.gridy = 7;
        constraints.weightx = 1.0;
        this.add((Component)this.origem, constraints);
        this.labelSituacao = new JLabel("Situa\u00e7\u00e3o: ");
        this.situacao = new JLabel(this.bean.getSituacao() == null ? "" : this.buscaSituacaoEmail(this.bean.getSituacao()));
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.weightx = 0.0;
        constraints.insets = new Insets(0, 10, 20, 0);
        this.add((Component)this.labelSituacao, constraints);
        constraints.gridx = 1;
        constraints.gridy = 8;
        constraints.weightx = 1.0;
        this.add((Component)this.situacao, constraints);
    }

    private EmailUtil.TipoEmail apresentaOrigem(String codigo) {
        for (EmailUtil.TipoEmail tipo : EmailUtil.TipoEmail.values()) {
            if (Funcoes.textoVazio(codigo) || !tipo.getCodigo().toString().equals(codigo)) continue;
            return tipo;
        }
        return null;
    }

    private String formataDataHora(Date data) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:ss");
        return format.format(data);
    }

    private String buscaSituacaoEmail(String situacao) {
        String retorno = "";
        switch (situacao) {
            case "O": {
                retorno = "Enviado";
                return "Enviado";
            }
            case "E": {
                retorno = "Enviando";
                return "Enviando";
            }
            case "F": {
                retorno = "Fila para Envio";
                return "Fila para Envio";
            }
            case "I": {
                retorno = "Email inv\u00e1lido";
                return "Email inv\u00e1lido";
            }
        }
        return retorno;
    }
}

