/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.panel.log.email;

import jalis.laboratorio.recepcao.panel.log.PanelLog;
import jalis.laboratorio.recepcao.panel.log.email.PanelRegistroLogEmail;
import jalis.model.bean.exportadores.LogEmailBean;
import jalis.service.exportadores.LogEmailService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;

public class PanelLogEmail
extends PanelLog {
    LogEmailService logEmailService = new LogEmailService();
    private int qntdDeLogsEmail;
    private final int width;

    public PanelLogEmail() {
        this.width = 400;
    }

    public PanelLogEmail(int width) {
        this.width = width;
    }

    @Override
    public void carregarLog(String codigoFilial, String codigoPaciente) {
        this.removeAll();
        List<LogEmailBean> logEmail = this.buscaLogEmail(codigoFilial, codigoPaciente);
        int qntdDeLogs = logEmail.size();
        this.definePropriedadesLocais(qntdDeLogs);
        GridBagConstraints c = new GridBagConstraints();
        for (LogEmailBean log : logEmail) {
            if (logEmail.indexOf(log) == logEmail.size() - 1) {
                this.montaUltimoLog(c, log);
                continue;
            }
            this.montaLog(c, log);
        }
    }

    private void definePropriedadesLocais(int qntdDeLogs) {
        int height = 150 * qntdDeLogs + 10;
        Dimension panelEmailDimension = new Dimension(this.width, height);
        this.setPreferredSize(panelEmailDimension);
        this.setLayout(new GridBagLayout());
    }

    private void montaLog(GridBagConstraints c, LogEmailBean log) {
        ++c.gridy;
        c.anchor = 18;
        c.fill = 1;
        PanelRegistroLogEmail email = new PanelRegistroLogEmail(log);
        c.weightx = 1.0;
        this.add((Component)email, c);
        c.weightx = 0.0;
        ++c.gridy;
        this.add(this.getLinha(this), c);
    }

    private void montaUltimoLog(GridBagConstraints c, LogEmailBean log) {
        ++c.gridy;
        c.anchor = 18;
        c.fill = 1;
        PanelRegistroLogEmail email = new PanelRegistroLogEmail(log);
        email.setPreferredSize(new Dimension(400, 117));
        c.weightx = 1.0;
        this.add((Component)email, c);
        c.weightx = 0.0;
        c.weighty = 1.0;
        ++c.gridy;
        Component linha = this.getLinha(this);
        linha.setPreferredSize(new Dimension(400, 10));
        this.add(linha, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogEmailBean> buscaLogEmail(String codigoFilial, String codigoPaciente) {
        List<LogEmailBean> logEmail = null;
        try {
            List<LogEmailBean> list = logEmail = this.logEmailService.getByPacCodigo(codigoFilial, codigoPaciente);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return logEmail;
        }
    }

    @Override
    public void carregarLogComReq(String codigoFilial, String codigoPaciente, String requisicao) {
        this.removeAll();
        List<LogEmailBean> logEmail = this.buscaLogEmailReq(codigoFilial, codigoPaciente, requisicao);
        this.setQntdDeLogsEmail(logEmail.size());
        this.definePropriedadesLocais(this.getQntdDeLogsEmail());
        GridBagConstraints c = new GridBagConstraints();
        for (LogEmailBean log : logEmail) {
            if (logEmail.indexOf(log) == logEmail.size() - 1) {
                this.montaUltimoLog(c, log);
                continue;
            }
            this.montaLog(c, log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LogEmailBean> buscaLogEmailReq(String codigoFilial, String codigoPaciente, String codigoRequisicao) {
        List<LogEmailBean> logEmail = null;
        try {
            List<LogEmailBean> list = logEmail = this.logEmailService.getByPacReqCodigo(codigoFilial, codigoPaciente, codigoRequisicao);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return logEmail;
        }
    }

    public int getQntdDeLogsEmail() {
        return this.qntdDeLogsEmail;
    }

    public void setQntdDeLogsEmail(int qntdDeLogsEmail) {
        this.qntdDeLogsEmail = qntdDeLogsEmail;
    }
}

