/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.dialog.log;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.model.AbstractThreadBean;
import jalis.model.bean.exportadores.LogEmailBean;
import jalis.model.bean.exportadores.LogSMSBean;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.TTextFieldTelefone;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.html.HTMLEditorKit;

public class ReenviadorDeLog
extends JDialog {
    JLabel labelReferencia;
    TTextField fieldReferencia;
    JEditorPane fieldMensagem;
    JButton buttonCancelar;
    JButton buttonReenviar;
    private final Component parent;
    private final AbstractThreadBean bean;

    public ReenviadorDeLog(final Component parent, final LogEmailBean bean) {
        this.bean = bean;
        this.setTitle("E-mail enviado");
        this.parent = parent;
        this.setModal(true);
        this.labelReferencia = new JLabel("Email: ");
        this.fieldReferencia = new TTextField(100, 17);
        this.fieldReferencia.setText(bean.getEmail());
        this.fieldReferencia.setEditable(false);
        this.fieldMensagem = new JEditorPane();
        this.fieldMensagem.setEditorKit(new HTMLEditorKit());
        this.fieldMensagem.setText(bean.getMensagem());
        this.fieldMensagem.setEditable(false);
        this.buttonCancelar = new JButton("Cancelar");
        this.buttonReenviar = new JButton("Reenviar E-mail");
        this.buttonReenviar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    EmailUtil.TipoEmail tipo = this.extraiTipoEmailDoBean(bean);
                    String codigoRequisicao = this.extraiCodigoDaRequisicao(bean);
                    String paciente = this.extraiCodigoDoPaciente(bean);
                    boolean emailEnviado = this.enviarEmail(bean, tipo);
                    String destino = ReenviadorDeLog.this.fieldReferencia.getText();
                    if (!emailEnviado && (Funcoes.textoVazio(destino) || destino.matches("([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})(([\\s,;]+)|[\\s]*))+"))) {
                        Funcoes.mensagem(ReenviadorDeLog.this.rootPane, "N\u00e3o foi possivel reenviar o email", 2);
                    }
                    ReenviadorDeLog.this.fechaJanela();
                }
                catch (Exception e2) {
                    ErrorLogger.mostraMensagem(parent, e2.getMessage(), e2.getStackTrace());
                }
            }

            private boolean enviarEmail(LogEmailBean bean2, EmailUtil.TipoEmail tipo) throws Exception {
                String requisicao = this.extraiCodigoDaRequisicao(bean2);
                String paciente = this.extraiCodigoDoPaciente(bean2);
                String destino = ReenviadorDeLog.this.fieldReferencia.getText();
                String email = ReenviadorDeLog.this.fieldMensagem.getText();
                String assunto = this.extraiAssunto(bean2);
                String filial = Variaveis.filialPadrao;
                String extensao = bean2.getEma_extensao();
                String convenio = bean2.getCon_codigo();
                String entidade = bean2.getEnt_codigo();
                byte[] pdf = bean2.getAnexo();
                if (Funcoes.textoVazio(destino) || !destino.matches("([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})(([\\s,;]+)|[\\s]*))+")) {
                    return false;
                }
                Statement st = Conexao.getStatement();
                boolean emailEnviado = false;
                switch (tipo) {
                    case COTACAO_FORNECEDOR: {
                        emailEnviado = EmailUtil.criarLogParaReenvioDeCotacao(filial, destino, email, assunto, extensao, paciente, requisicao, pdf, tipo, true, st, convenio, entidade);
                        break;
                    }
                    case PROPOSTA: {
                        emailEnviado = EmailUtil.criarLogParaReenvioDeProposta(filial, paciente, destino, email, assunto, extensao, requisicao, pdf, tipo, true, st, true, convenio, entidade);
                        break;
                    }
                    case SENHA_WEB_MEDICO: {
                        emailEnviado = EmailUtil.criarLogParaReenvioComMedico(filial, requisicao, paciente, destino, email, assunto, pdf, tipo, true, st, true);
                        break;
                    }
                    case ANIVERSARIO: {
                        emailEnviado = EmailUtil.criarLogParaReenvioSemRequisicao(filial, paciente, destino, email, assunto, tipo, pdf, true, st);
                        break;
                    }
                    case SENHA_WEB_CLIENTE: {
                        emailEnviado = EmailUtil.criarLogParaReenvioSemRequisicao(filial, paciente, destino, email, assunto, tipo, pdf, true, st);
                        break;
                    }
                    case SENHA_WEB: {
                        emailEnviado = EmailUtil.criarLogParaReenvioSemRequisicao(filial, paciente, destino, email, assunto, tipo, pdf, true, st);
                        break;
                    }
                    case SENHA_WEB_COLETADOR: {
                        emailEnviado = EmailUtil.criarLogParaReenvioSemRequisicao(filial, paciente, destino, email, assunto, tipo, pdf, true, st);
                        break;
                    }
                    default: {
                        emailEnviado = EmailUtil.criarLogParaReenvioComRequisicao(filial, requisicao, destino, email, assunto, tipo, pdf, true, st);
                    }
                }
                return emailEnviado;
            }

            private String extraiEmail(LogEmailBean bean2) {
                String email = bean2.getEmail();
                return email;
            }

            private String extraiAssunto(LogEmailBean bean2) {
                String assunto = bean2.getAssunto();
                return assunto;
            }

            private String extraiCodigoDoPaciente(LogEmailBean bean2) {
                String paciente = null;
                if (bean2.getPaciente() != null) {
                    paciente = String.valueOf(bean2.getPaciente().getCodigo());
                }
                return paciente;
            }

            private EmailUtil.TipoEmail extraiTipoEmailDoBean(LogEmailBean bean2) {
                EmailUtil.TipoEmail tipo = EmailUtil.TipoEmail.REQUISICAO;
                if (bean2.getOrigem() != null) {
                    tipo = ReenviadorDeLog.this.buscaTipoEmail(bean2.getOrigem());
                }
                return tipo;
            }

            private String extraiCodigoDaRequisicao(LogEmailBean bean2) {
                String codigo = null;
                if (bean2.getRequisicao() != null) {
                    codigo = bean2.getRequisicao().getCodigo().toString().isEmpty() ? null : bean2.getRequisicao().getCodigo().toString();
                }
                return codigo;
            }
        });
        this.init();
    }

    protected EmailUtil.TipoEmail buscaTipoEmail(String codigo) {
        for (EmailUtil.TipoEmail result : EmailUtil.TipoEmail.values()) {
            if (!result.getCodigo().equals(Integer.parseInt(codigo))) continue;
            return result;
        }
        return null;
    }

    public ReenviadorDeLog(Component parent, final LogSMSBean bean) {
        this.bean = bean;
        this.setTitle("SMS Enviado");
        this.parent = parent;
        this.labelReferencia = new JLabel("Telefone: ");
        this.fieldReferencia = new TTextFieldTelefone(20, ParametrosGerais.getMascaraFone());
        this.fieldReferencia.setText(bean.getCelular());
        this.fieldReferencia.setEditable(false);
        this.fieldMensagem = new JEditorPane();
        this.fieldMensagem.setText(bean.getMensagem());
        this.fieldMensagem.setEditable(false);
        this.buttonCancelar = new JButton("Cancelar");
        this.buttonReenviar = new JButton("Reenviar SMS");
        this.buttonReenviar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Statement st = Conexao.getStatement();
                Statement st2 = Conexao.getStatement();
                try {
                    String mensagem;
                    String numeroDestino;
                    boolean smsEnviado;
                    ExportaSMS.TipoSMS origem = ReenviadorDeLog.this.buscaTipoSMS(bean.getOrigem());
                    String paciente = null;
                    if (bean.getPaciente() != null) {
                        paciente = bean.getPaciente().getCodigo().toString();
                    }
                    String requisicao = null;
                    if (bean.getRequisicao() != null) {
                        requisicao = String.valueOf(bean.getRequisicao().getCodigo());
                    }
                    if (!(smsEnviado = SMSUtil.criarLogParaReenvio(Variaveis.filialPadrao, paciente, requisicao, origem, numeroDestino = ReenviadorDeLog.this.fieldReferencia.getText(), mensagem = ReenviadorDeLog.this.fieldMensagem.getText(), st, st2))) {
                        Funcoes.mensagem(ReenviadorDeLog.this.rootPane, "N\u00e3o foi possivel reenviar o SMS", 2);
                    }
                    ReenviadorDeLog.this.fechaJanela();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        this.init();
    }

    protected ExportaSMS.TipoSMS buscaTipoSMS(String codigo) {
        for (ExportaSMS.TipoSMS result : ExportaSMS.TipoSMS.values()) {
            if (!result.getCodigo().equalsIgnoreCase(codigo)) continue;
            return result;
        }
        return null;
    }

    public void init() {
        this.setSize(400, 230);
        this.parent.setBackground(Color.lightGray);
        this.setLocationRelativeTo(this.parent);
        this.setLayout(new BorderLayout());
        this.montaNorthPanel();
        this.montaCenterPanel();
        this.montaSouthPanel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReenviadorDeLog.this.parent.setBackground(ReenviadorDeLog.this.parent.getParent().getBackground());
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReenviadorDeLog.this.fechaJanela();
            }
        });
        this.buttonReenviar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReenviadorDeLog.this.fechaJanela();
            }
        });
        this.setModal(true);
        this.setVisible(true);
    }

    private void montaSouthPanel() {
        JPanel southPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 0, 6, 133);
        c.anchor = 13;
        c.gridwidth = 0;
        c.weightx = 1.0;
        c.gridy = 0;
        c.gridx = 0;
        this.buttonCancelar.setPreferredSize(new Dimension(120, 26));
        southPanel.add((Component)this.buttonCancelar, c);
        c.insets = new Insets(0, 0, 6, 6);
        ++c.gridx;
        this.buttonReenviar.setPreferredSize(new Dimension(123, 26));
        southPanel.add((Component)this.buttonReenviar, c);
        this.add((Component)southPanel, "South");
    }

    private void montaCenterPanel() {
        JScrollPane centerPanel = new JScrollPane(this.fieldMensagem);
        this.add((Component)centerPanel, "Center");
    }

    private void montaNorthPanel() {
        JPanel northPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.weightx = 1.0;
        c.gridwidth = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(4, 10, 2, 0);
        northPanel.add((Component)this.labelReferencia, c);
        c.insets = new Insets(4, 60, 2, 0);
        ++c.gridx;
        this.fieldReferencia.setPreferredSize(new Dimension(185, 19));
        northPanel.add((Component)this.fieldReferencia, c);
        this.add((Component)northPanel, "North");
    }

    private void fechaJanela() {
        this.dispatchEvent(new WindowEvent(this, 201));
    }
}

