/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.coletar.salux;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.coletar.ColetarMaterial;
import jalis.laboratorio.recepcao.coletar.ThreadDados;
import jalis.laboratorio.recepcao.coletar.salux.ColetarMaterialSalux;
import jalis.laboratorio.recepcao.coletar.salux.FiltroColetaSalux;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.service.recepcao.coletar.ColetarMaterialSaluxService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ThreadDadosSalux
extends ThreadDados {
    public ThreadDadosSalux(ColetarMaterial owner, JList tableUrgente, JList tableNormal, boolean alterarColetado, String filtroColetas, String filtroSituacoesConsiderarUrgente, boolean ordenarPorAlteracao, String filtroConvenios) {
        super(owner, tableUrgente, tableNormal, alterarColetado, null, filtroSituacoesConsiderarUrgente, ordenarPorAlteracao, null, filtroConvenios);
        this.filtroColetaSalux = FiltroColetaSalux.getFiltroColetaSaluxFromValorFiltro(filtroColetas);
    }

    @Override
    public synchronized void atualizaRequisicoes(int rowNormalAnterior, int rowUrgenteAnterior) {
        ColetarMaterialSaluxService service;
        this.buscaDadosSalux(this.getFiltroSituacoesConsiderarUrgente(), this.filtroColetaSalux, this.filtrarConveios());
        int rowNormal = this.tableNormal.getSelectedIndex();
        int rowUrgente = this.tableUrgente.getSelectedIndex();
        int rowExames = ColetarMaterial.tableExame.getSelectionModel().getMinSelectionIndex();
        boolean isSituacaoAlteradaBanco = false;
        DadosRequisicao requisicao = null;
        if (rowNormalAnterior > -1 && rowExames > -1) {
            requisicao = (DadosRequisicao)this.tableNormal.getModel().getElementAt(rowNormalAnterior);
            try {
                service = new ColetarMaterialSaluxService();
                service.carregarDadosExameRequisicao(requisicao, Acesso.getAcesso(ColetarMaterialSalux.ACESSO_DESMARCAR_COLETADO), ParametrosGerais.getOrdenarSetor());
                isSituacaoAlteradaBanco = ColetarMaterial.atualizaObjetosExames(requisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Um erro ocorreu ao atualizar os dados do exames.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (rowUrgenteAnterior > -1) {
            requisicao = (DadosRequisicao)this.tableUrgente.getModel().getElementAt(rowUrgenteAnterior);
            try {
                service = new ColetarMaterialSaluxService();
                service.carregarDadosExameRequisicao(requisicao, Acesso.getAcesso(ColetarMaterialSalux.ACESSO_DESMARCAR_COLETADO), ParametrosGerais.getOrdenarSetor());
                isSituacaoAlteradaBanco = ColetarMaterial.atualizaObjetosExames(requisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Um erro ocorreu ao atualizar os dados do exames.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        ColetarMaterialSalux.tableExame.getSelectionModel().setSelectionInterval(rowExames, rowExames);
        if (isSituacaoAlteradaBanco) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A situa\u00e7\u00e3o dos exames foi alterada por outro usu\u00e1rio.\nVerifique os dados novamente.", 2);
        }
    }

    private void buscaDadosSalux(String filtroSituacoesConsiderarUrgente, FiltroColetaSalux filtroColetaSalux, String filtrarConveios) {
        block15: {
            try {
                int i;
                HashSet requisicoesNaoRemovidas = new HashSet();
                ArrayList<DadosRequisicao> dadosRequisicoesAddF2 = new ArrayList<DadosRequisicao>();
                DefaultListModel m = (DefaultListModel)this.tableUrgente.getModel();
                for (int i2 = 0; i2 < m.getSize(); ++i2) {
                    if (!((DadosRequisicao)m.get(i2)).isAdicionarPorF2()) continue;
                    dadosRequisicoesAddF2.add((DadosRequisicao)m.get(i2));
                }
                DefaultListModel<DadosRequisicao> modeloUrgente = new DefaultListModel<DadosRequisicao>();
                DefaultListModel<DadosRequisicao> modeloNormal = new DefaultListModel<DadosRequisicao>();
                boolean urgenteSelecionado = this.tableUrgente.getSelectedIndex() > -1;
                String codigoSelecionado = null;
                if (urgenteSelecionado) {
                    codigoSelecionado = String.valueOf(((DadosRequisicao)this.tableUrgente.getModel().getElementAt(this.tableUrgente.getSelectedIndex())).getCodigo());
                } else if (this.tableNormal.getSelectedIndex() > -1) {
                    codigoSelecionado = String.valueOf(((DadosRequisicao)this.tableNormal.getModel().getElementAt(this.tableNormal.getSelectedIndex())).getCodigo());
                }
                ColetarMaterialSaluxService service = new ColetarMaterialSaluxService();
                service.setFiltroColetaSalux(filtroColetaSalux);
                service.setConvenios(filtrarConveios);
                service.setSituacoesConsiderarUrgente(filtroSituacoesConsiderarUrgente);
                service.setOrdemPorDataAlteracao(this.ordenarPorAlteracao);
                List<DadosRequisicao> listaDadosRequisicao = service.buscaDadosSalux();
                for (DadosRequisicao dadosRequisicao : listaDadosRequisicao) {
                    if (!DBUtil.campoNull(dadosRequisicao.getBoxColeta())) {
                        dadosRequisicao.setBoxColeta(dadosRequisicao.getBoxColeta());
                    }
                    boolean exameUrgente = this.verificaExameUrgente(String.valueOf(dadosRequisicao.getCodigo()));
                    if (dadosRequisicao.isUrgente().booleanValue() || exameUrgente || this.verificaSituacaoConsiderarUrgente(dadosRequisicao.getCodigoSituacao())) {
                        if (requisicoesNaoRemovidas.contains(dadosRequisicao.getCodigo())) continue;
                        dadosRequisicao.setLisBoxParent(this.tableUrgente);
                        modeloUrgente.addElement(dadosRequisicao);
                        continue;
                    }
                    if (requisicoesNaoRemovidas.contains(dadosRequisicao.getCodigo()) || dadosRequisicoesAddF2.contains(dadosRequisicao)) continue;
                    dadosRequisicao.setLisBoxParent(this.tableNormal);
                    modeloNormal.addElement(dadosRequisicao);
                }
                for (DadosRequisicao dadosRequisicaoF2 : dadosRequisicoesAddF2) {
                    DadosRequisicao aux;
                    int i3;
                    boolean jaAdicionada = false;
                    for (i3 = 0; i3 < modeloUrgente.getSize(); ++i3) {
                        aux = (DadosRequisicao)modeloUrgente.get(i3);
                        if (!aux.equals(dadosRequisicaoF2)) continue;
                        jaAdicionada = true;
                        break;
                    }
                    if (jaAdicionada) continue;
                    for (i3 = 0; i3 < modeloNormal.getSize(); ++i3) {
                        aux = (DadosRequisicao)modeloNormal.get(i3);
                        if (!aux.equals(dadosRequisicaoF2)) continue;
                        jaAdicionada = true;
                        break;
                    }
                    if (jaAdicionada || requisicoesNaoRemovidas.contains(dadosRequisicaoF2.getCodigo())) continue;
                    modeloUrgente.addElement(dadosRequisicaoF2);
                }
                this.tableUrgente.setModel(modeloUrgente);
                this.tableNormal.setModel(modeloNormal);
                if (codigoSelecionado == null) break block15;
                boolean isRemovido = true;
                DadosRequisicao dados = null;
                if (urgenteSelecionado) {
                    for (i = 0; i < this.tableUrgente.getModel().getSize(); ++i) {
                        dados = (DadosRequisicao)this.tableUrgente.getModel().getElementAt(i);
                        if (!String.valueOf(dados.getCodigo()).equalsIgnoreCase(codigoSelecionado)) continue;
                        this.tableUrgente.setSelectedIndex(i);
                        isRemovido = false;
                        break block15;
                    }
                    break block15;
                }
                for (i = 0; i < this.tableNormal.getModel().getSize(); ++i) {
                    dados = (DadosRequisicao)this.tableNormal.getModel().getElementAt(i);
                    if (!String.valueOf(dados.getCodigo()).equalsIgnoreCase(codigoSelecionado)) continue;
                    this.tableNormal.setSelectedIndex(i);
                    isRemovido = false;
                    break;
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.owner, ex.getMessage(), ex.getStackTrace(), "ColetarMaterial (1501)");
            }
        }
    }
}

