/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.coletar.salux;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExameRequisicao;
import jalis.integracaohospitais.util.salux.service.SaluxService;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.coletar.ColetarMaterial;
import jalis.laboratorio.recepcao.coletar.ThreadDados;
import jalis.laboratorio.recepcao.coletar.salux.FiltroColetaSalux;
import jalis.laboratorio.recepcao.coletar.salux.ThreadDadosSalux;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.service.recepcao.coletar.ColetarMaterialSaluxService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.HashMap;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;

public class ColetarMaterialSalux
extends ColetarMaterial {
    private JButton buttonIniciarColeta;
    private JMenuItem itemFiltroColetaTodas;
    private JMenuItem itemFiltroColetaEmColeta;
    private JMenuItem itemFiltroColetaSemMarcacaoColeta;
    private FiltroColetaSalux filtroColetaSalux;
    private static final String LABEL_FILTRO_ATIVO = " ativo";
    public static long ACESSO_DESMARCAR_COLETADO = Long.parseLong("0201500105");
    private ColetarMaterialSaluxService service;

    @Override
    public void jbInit() throws Exception {
        this.carregarAcessos();
        this.service = new ColetarMaterialSaluxService();
        this.definirFiltrosSelecionados();
        super.jbInit();
        this.configurarCompoenetesPersonalizados();
        this.definirFiltroColetaAtivo(this.getMenuFromFiltro());
        Funcoes.criaBarraDescricao(this, "Coleta de material Salux", "Coleta de materiais de Pacientes da integra\u00e7\u00e3o", "coleta_material.jpg", this.labelFoto);
        this.defineAcessos();
        this.carregarListenner();
    }

    private void definirFiltrosSelecionados() {
        String tmp;
        this.filtroEstacoes = "";
        this.filtroColeta = "";
        String filtroColetaSaluxSalvo = ParametrosLocais.getParametro("filtroColetaSalux") != null ? StringUtil.getValor(ParametrosLocais.getParametro("filtroColetaSalux"), "filtro") : FiltroColetaSalux.TODAS.getValorFiltro();
        this.filtroColetaSalux = FiltroColetaSalux.getFiltroColetaSaluxFromValorFiltro(filtroColetaSaluxSalvo);
        String parametros = ParametrosUsuarios.getValor("ColetarMaterial.ordenarPorAlteracao");
        if (!Funcoes.textoVazio(parametros) && !Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ordenarporalteracao"))) {
            this.itemOrdenarPorDataAlteracao.setSelected(Boolean.valueOf(tmp));
        }
    }

    private JMenuItem getMenuFromFiltro() {
        switch (this.filtroColetaSalux) {
            case EM_COLETA: {
                return this.itemFiltroColetaEmColeta;
            }
            case SEM_MARCACAO_COLETA: {
                return this.itemFiltroColetaSemMarcacaoColeta;
            }
        }
        return this.itemFiltroColetaTodas;
    }

    private void configurarCompoenetesPersonalizados() {
        this.tableNormal.setFixedCellHeight(66);
        this.tableUrgente.setFixedCellHeight(this.utilizaFiltroDeSituacoesUrgentes(this.filtroSituacoesConsiderarUrgente) ? 82 : 66);
        this.popMenu.remove(this.itemIgnorarBoxColeta);
        this.menuFiltro.remove(this.itemFiltroEstacoes);
        this.menuFiltro.remove(this.itemFiltroColeta);
        this.menuFiltro.remove(this.itemFiltroConvenios);
        this.menuFiltro.add(this.configurarMenuColeta());
        this.menuFiltro.add(this.itemFiltroConvenios);
        this.buttonChamar.setVisible(false);
        this.buttonSenha.setVisible(false);
        this.buttonIniciarColeta = new JButton("Iniciar Coleta");
        this.panelBotoesA.add(this.buttonIniciarColeta);
    }

    private JMenu configurarMenuColeta() {
        JMenu menuColeta = new JMenu("Coleta");
        this.itemFiltroColetaTodas = ComponenteFactory.novoJMenuItem(FiltroColetaSalux.TODAS.getLabelFiltro(), this);
        this.itemFiltroColetaEmColeta = ComponenteFactory.novoJMenuItem(FiltroColetaSalux.EM_COLETA.getLabelFiltro(), this);
        this.itemFiltroColetaSemMarcacaoColeta = ComponenteFactory.novoJMenuItem(FiltroColetaSalux.SEM_MARCACAO_COLETA.getLabelFiltro(), this);
        menuColeta.add(this.itemFiltroColetaTodas);
        this.itemFiltroColetaTodas.setName("itemFiltroColetaTodas");
        menuColeta.add(this.itemFiltroColetaEmColeta);
        this.itemFiltroColetaEmColeta.setName("itemFiltroColetaEmColeta");
        menuColeta.add(this.itemFiltroColetaSemMarcacaoColeta);
        this.itemFiltroColetaSemMarcacaoColeta.setName("itemFiltroColetaSemMarcacaoColeta");
        return menuColeta;
    }

    private void carregarListenner() {
        this.buttonIniciarColeta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    long requisicao = ColetarMaterialSalux.this.requisicaoSelecionada();
                    if (requisicao > -1L) {
                        DadosRequisicao dadosRequisicao = ColetarMaterialSalux.this.achaObjetoRequisicao(requisicao);
                        SaluxService service = new SaluxService();
                        HashMap<String, Boolean> examesComColetaIniciada = new HashMap<String, Boolean>();
                        for (int i = 0; i < modeloExame.getRowCount(); ++i) {
                            if (!modeloExame.getValueAt(i, 8).toString().equals("T")) continue;
                            DadosExameRequisicao exameRequisicao = (DadosExameRequisicao)modeloExame.getValueAt(i, 13);
                            boolean coletaIniciadaSalux = service.registrarColeta(String.valueOf(dadosRequisicao.getConvenio().getCodigo()), String.valueOf(requisicao), dadosRequisicao.getIdRequisicaoSalux(), exameRequisicao.getSequenciaSalux());
                            examesComColetaIniciada.put(exameRequisicao.getExame().getDescricao(), coletaIniciadaSalux);
                        }
                        boolean coletasIniciadasSalux = examesComColetaIniciada.entrySet().stream().allMatch(exame -> ((Boolean)exame.getValue()).equals(true));
                        dadosRequisicao.setEmColetaSalux(coletasIniciadasSalux);
                        service.atualizarDataInicioColeta(coletasIniciadasSalux, String.valueOf(requisicao), dadosRequisicao.getIdRequisicaoSalux());
                        ColetarMaterialSalux.this.tableUrgente.repaint();
                        ColetarMaterialSalux.this.tableNormal.repaint();
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(ColetarMaterialSalux.this, "Erro ao atualizar situacao do eaxme.\n" + e1.getMessage(), e1.getStackTrace());
                }
            }
        });
    }

    @Override
    public void defineAcessos() {
        this.buttonFechar.setVisible(Acesso.getAcesso(ColetarMaterialSalux.getModuloAcesso()));
        this.buttonColetarTodos.setVisible(Acesso.getAcesso(this.ACESSO_COLETAR_TODOS));
        this.buttonSalvar.setVisible(Acesso.getAcesso(this.ACESSO_COLETAR));
        this.alterarResposta = Acesso.getAcesso(this.ACESSO_ALTERAR_RESPOSTA);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0201500100");
    }

    @Override
    public synchronized void mostraDadosRequisicao(DadosRequisicao requisicao) {
        this.txtCodRequisicao.setText(String.valueOf(requisicao.getCodigo()));
        this.labelVPaciente.setText(requisicao.getPaciente());
        this.labelVPaciente.setNomeSocial(requisicao.getNomeSocial());
        this.labelVIdade.setText(requisicao.getIdade());
        this.labelVIdade.setToolTipText(Funcoes.getIdadePorExtenso(requisicao.getDataNascimento(), requisicao.getReqData()));
        this.labelVSexo.setText(requisicao.getSexo());
        this.labelVUsuarioReq.setText(requisicao.getUsuario());
        this.labelVConvenio.setText(requisicao.getConvenio().getFantasia());
        this.labelVMedico.setText(requisicao.getMedico());
        this.txtClinicos.setText(requisicao.getDadosClinicos());
        this.observacaoSelecionada = requisicao.getObs();
        this.biometriaPaciente = requisicao.getBiometriaPaciente();
        this.integracaoHospital = requisicao.getIntegracaoHospital();
        this.configuraBotaoChamar(requisicao.getBoxColeta());
        this.controlaCampos(false);
        this.fotoPaciente = null;
        if (!DBUtil.campoNull(requisicao.getFoto()) && !Funcoes.textoVazio(requisicao.getFoto())) {
            String imagem64 = requisicao.getFoto();
            try {
                this.fotoPaciente = new ImageIcon(new Base64().decode(imagem64));
                this.labelFoto.setIcon(new ImageIcon(this.fotoPaciente.getImage().getScaledInstance(90, 80, 4)));
                this.labelFoto.revalidate();
                this.labelFoto.repaint();
                this.labelFoto.getTopLevelAncestor().repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Erro ao carregar foto.\n" + ex.getMessage(), ex.getStackTrace());
            }
            this.posicionaComponentes();
        } else {
            if (this.labelFoto != null) {
                this.labelFoto.setIcon(null);
                this.labelFoto.revalidate();
                this.labelFoto.repaint();
            }
            if (this.labelFoto != null && this.labelFoto.getTopLevelAncestor() != null) {
                this.labelFoto.getTopLevelAncestor().repaint();
            }
        }
        try {
            Integer[] guias = RecepcaoUtil.verificaMultiGuias(Variaveis.filialPadrao, String.valueOf(requisicao.getCodigo()));
            this.labelMultiguia.setVisible(guias != null && guias.length > 0);
            this.posicionaComponentes();
            if (guias != null && guias.length > 0) {
                StringBuilder buf = new StringBuilder();
                Integer[] integerArray = guias;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int s = integerArray[i];
                    buf.append(buf.toString().length() > 0 ? "," : "").append(s);
                }
                this.labelMultiguia.setText("Multiguia" + (guias.length > 1 ? "s: " : ": ") + buf.toString());
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ColetarMaterial (1091)");
        }
        try {
            requisicao = this.service.carregarDadosExameRequisicao(requisicao, Acesso.getAcesso(ACESSO_DESMARCAR_COLETADO), ParametrosGerais.getOrdenarSetor());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, "Erro ao carregar dados dos exames.\n" + e.getMessage(), e.getStackTrace());
        }
        ColetarMaterialSalux.atualizaObjetosExames(requisicao);
        this.labelVUsuario.setText("");
        this.labelVDataHora.setText("");
        this.txtInfo.setText("");
        this.status = 3;
        this.controlaCampos(false);
        if (modeloExame.getRowCount() > 0) {
            tableExame.setRowSelectionInterval(0, 0);
        }
        if (modeloExame.getRowCount() > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ColetarMaterial.tableExame.grabFocus();
                }
            });
        }
        this.itemImprimirEtqColetaExame.setText("Etiqueta de coleta (selecionada)");
        this.itemImprimirEtqTriagemExame.setText("Etiqueta de triagem (selecionada)");
    }

    @Override
    protected void buscaDados() {
        this.thread = new ThreadDadosSalux(this, this.tableUrgente, this.tableNormal, Acesso.getAcesso(ACESSO_DESMARCAR_COLETADO), this.filtroColetaSalux.getValorFiltro(), this.filtroSituacoesConsiderarUrgente, this.itemOrdenarPorDataAlteracao.isSelected(), this.filtroConvenios);
        ThreadDados.setPodeExecutar(true);
        this.thread.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.itemFiltroColetaTodas) {
            this.definirFiltroColetaAtivo((JMenuItem)e.getSource());
        }
        if (e.getSource() == this.itemFiltroColetaEmColeta) {
            this.definirFiltroColetaAtivo((JMenuItem)e.getSource());
        }
        if (e.getSource() == this.itemFiltroColetaSemMarcacaoColeta) {
            this.definirFiltroColetaAtivo((JMenuItem)e.getSource());
        }
    }

    private void definirFiltroColetaAtivo(JMenuItem item) {
        this.itemFiltroColetaTodas.setText(item.getName().equals(FiltroColetaSalux.TODAS.getNomeFiltro()) ? FiltroColetaSalux.TODAS.getLabelFiltro().concat(LABEL_FILTRO_ATIVO) : FiltroColetaSalux.TODAS.getLabelFiltro());
        this.itemFiltroColetaEmColeta.setText(item.getName().equals(FiltroColetaSalux.EM_COLETA.getNomeFiltro()) ? FiltroColetaSalux.EM_COLETA.getLabelFiltro().concat(LABEL_FILTRO_ATIVO) : FiltroColetaSalux.EM_COLETA.getLabelFiltro());
        this.itemFiltroColetaSemMarcacaoColeta.setText(item.getName().equals(FiltroColetaSalux.SEM_MARCACAO_COLETA.getNomeFiltro()) ? FiltroColetaSalux.SEM_MARCACAO_COLETA.getLabelFiltro().concat(LABEL_FILTRO_ATIVO) : FiltroColetaSalux.SEM_MARCACAO_COLETA.getLabelFiltro());
        this.salvarFiltroColetaAtivo(item);
    }

    private void salvarFiltroColetaAtivo(JMenuItem item) {
        for (FiltroColetaSalux f : FiltroColetaSalux.values()) {
            if (!item.getName().equalsIgnoreCase(f.getNomeFiltro())) continue;
            this.filtroColetaSalux = f;
            this.thread.setFiltroColetaSalux(f);
            break;
        }
        StringBuilder filtroSelecionado = new StringBuilder("<filtro>").append(this.filtroColetaSalux.getValorFiltro()).append("</filtro>");
        ParametrosLocais.setParametro("filtroColetaSalux", filtroSelecionado.toString());
        ParametrosLocais.salvaParametros();
    }

    private void carregarAcessos() {
        this.ACESSO_ALTERAR_OBS = Long.parseLong("0201500101");
        this.ACESSO_ALTERAR_RESPOSTA = Long.parseLong("0201500102");
        this.ACESSO_COLETAR = Long.parseLong("0201500103");
        this.ACESSO_COLETAR_TODOS = Long.parseLong("0201500104");
        ACESSO_DESMARCAR_COLETADO = Long.parseLong("0201500105");
        this.ACESSO_ESTORNAR = Long.parseLong("0201500106");
        this.ACESSO_FILTRO = Long.parseLong("0201500107");
        this.ACESSO_IGNORAR_COLETOR = Long.parseLong("0201500108");
        this.ACESSO_IMPRIMIR_ANEXO = Long.parseLong("0201500109");
        this.ACESSO_IMPRIMIR_ANEXO_COBRANCA = Long.parseLong("0201500110");
        this.ACESSO_IMPRIMIR_CAPA = Long.parseLong("0201500111");
        this.ACESSO_IMPRIMIR_COMPROVANTE = Long.parseLong("0201500112");
        this.ACESSO_IMPRIMIR_ETQ_COLETA = Long.parseLong("0201500113");
        this.ACESSO_IMPRIMIR_ETQ_TRIAGEM = Long.parseLong("0201500114");
        this.ACESSO_IMPRIMIR_ETQ_COLETA_SELECIONADA = Long.parseLong("0201500115");
        this.ACESSO_IMPRIMIR_ETQ_TRIAGEM_SELECIONADA = Long.parseLong("0201500116");
        this.ACESSO_IMPRIMIR_RECIBO = Long.parseLong("0201500117");
        this.ACESSO_RECOLETA = Long.parseLong("0201500118");
        this.ACESSO_MARCAR_EXTERNO = Long.parseLong("0201500119");
        this.ACESSO_NAO_ALTERAR_SITUACAO_SEM_ETIQUETA_IMPRESSA = Long.parseLong("0201500120");
        ACESSO_NAO_RECEBER_MATERIAL_EM_RECOLETA = Long.parseLong("0201500121");
        this.ACESSO_NAO_VISUALIZAR_REQUISICAO_CONVENIO_APOIADO = Long.parseLong("0201500122");
        this.itemIgnorarBoxColeta.setVisible(false);
        this.itemFiltroEstacoes.setVisible(false);
    }

    @Override
    protected void posicionaCodigo(String codigo) {
        if (!Funcoes.isNumeric(codigo)) {
            return;
        }
        boolean requisicaoEmExibicao = this.requisicaoEmExibicao(codigo = this.pegaCodigoRequisicao(codigo));
        this.controlaCampos(!requisicaoEmExibicao);
        if (!requisicaoEmExibicao) {
            try {
                Registro reg = this.service.pesquisarRequisicaoPorCodigo(codigo);
                if (Funcoes.textoVazio(reg.getString("req_codigo"))) {
                    Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada", 2);
                    this.txtCodRequisicao.selectAll();
                    this.txtCodRequisicao.grabFocus();
                    return;
                }
                if (this.requisicaoPertenceOutraEstacao(reg)) {
                    return;
                }
                DadosRequisicao dadosRequisicao = this.service.getDadosRequisicao(reg);
                if (dadosRequisicao != null) {
                    this.mostraDadosRequisicao(dadosRequisicao);
                    dadosRequisicao.setLisBoxParent(this.tableUrgente);
                    dadosRequisicao.setAdicionarPorF2(true);
                    ((DefaultListModel)this.tableUrgente.getModel()).addElement(dadosRequisicao);
                    int pos = ((DefaultListModel)this.tableUrgente.getModel()).getSize() - 1;
                    this.tableUrgente.setSelectedIndex(pos);
                    this.tableUrgente.scrollRectToVisible(this.tableUrgente.getCellBounds(pos, pos));
                }
                if (tableExame.getRowCount() > 0) {
                    tableExame.setRowSelectionInterval(0, 0);
                    tableExame.grabFocus();
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ColetarMaterialSalux (567)");
            }
        }
    }

    private boolean requisicaoPertenceOutraEstacao(Registro reg) {
        boolean pertenceOutraEstacao = false;
        if (!Funcoes.textoVazio(Variaveis.codigoEstacao) && Integer.parseInt(Variaveis.codigoEstacao) != reg.getInt("est_codigo")) {
            pertenceOutraEstacao = this.coletaConfirmada();
        }
        return pertenceOutraEstacao;
    }

    private boolean coletaConfirmada() {
        if (Funcoes.mensagem(this, "A requisi\u00e7\u00e3o pertence a outra esta\u00e7\u00e3o, \ndeseja continuar a coleta?", 4) == 1) {
            if (this.tableNormal.getSelectedIndex() > -1) {
                this.atualizaDadosSelecaoNormal();
            } else if (this.tableUrgente.getSelectedIndex() > -1) {
                this.atualizaDadosSelecaoUrgente();
            }
            return true;
        }
        return false;
    }

    private boolean requisicaoEmExibicao(String codigo) {
        boolean emExibicao = false;
        JList tabela = this.tableNormal;
        if (!Funcoes.textoVazio(codigo)) {
            int i;
            tabela = this.tableUrgente;
            DefaultListModel m = (DefaultListModel)tabela.getModel();
            for (i = 0; i < m.getSize(); ++i) {
                if (((DadosRequisicao)m.get(i)).getCodigo() != Integer.parseInt(codigo)) continue;
                tabela.setSelectedIndex(i);
                tabela.scrollRectToVisible(tabela.getCellBounds(i, i));
                emExibicao = true;
                break;
            }
            tabela = this.tableNormal;
            m = (DefaultListModel)tabela.getModel();
            for (i = 0; i < m.getSize(); ++i) {
                if (((DadosRequisicao)m.get(i)).getCodigo() != Integer.parseInt(codigo)) continue;
                tabela.setSelectedIndex(i);
                tabela.scrollRectToVisible(tabela.getCellBounds(i, i));
                emExibicao = true;
                break;
            }
        }
        return emExibicao;
    }
}

