/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.coletar.ghosp;

import jalis.comum.Acesso;
import jalis.comum.Variaveis;
import jalis.laboratorio.recepcao.coletar.ColetarMaterial;
import jalis.laboratorio.recepcao.coletar.ThreadDados;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.util.DialogoFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class ColetarMaterialGHosp
extends ColetarMaterial {
    protected JLabel labelAla;
    protected JLabel labelVAla;
    protected JLabel labelSetor;
    protected JLabel labelVSetor;
    protected JPanel panelInfoColeta;
    protected JLabel labelVColeta;
    protected JMenuItem itemFiltroAla;
    protected String filtroAlas;
    protected JMenu menuEtiquetaColeta;
    protected JMenu menuEtiquetaTriagem;
    protected JMenuItem itemImprimirEtiquetaColetaRequisicao;
    protected JMenuItem itemImprimirEtiquetaTriagemRequisicao;
    protected JMenuItem itemImprimirEtiquetaColetaTodas;
    protected JMenuItem itemImprimirEtiquetaTriagemTodas;

    @Override
    public void jbInit() throws Exception {
        this.carregarAcessos();
        this.labelAla = new JLabel("Ala:");
        this.labelVAla = new JLabel();
        this.labelSetor = new JLabel("Setor:");
        this.labelVSetor = new JLabel();
        this.itemFiltroAla = ComponenteFactory.novoJMenuItem("Ala", this);
        this.menuEtiquetaColeta = new JMenu("Etiqueta de Coleta");
        this.menuEtiquetaTriagem = new JMenu("Etiqueta de Triagem");
        this.itemImprimirEtiquetaColetaRequisicao = ComponenteFactory.novoJMenuItem("Requisi\u00e7\u00e3o", this);
        this.itemImprimirEtiquetaTriagemRequisicao = ComponenteFactory.novoJMenuItem("Requisi\u00e7\u00e3o", this);
        this.itemImprimirEtiquetaColetaTodas = ComponenteFactory.novoJMenuItem("Todas", this);
        this.itemImprimirEtiquetaTriagemTodas = ComponenteFactory.novoJMenuItem("Todas", this);
        this.filtroAlas = "";
        this.adicionarPanelInfoColeta();
        super.jbInit();
        this.menuFiltro.add(this.itemFiltroAla);
        this.tableNormal.setFixedCellHeight(60);
        this.tableUrgente.setFixedCellHeight(this.utilizaFiltroDeSituacoesUrgentes(this.filtroSituacoesConsiderarUrgente) ? 76 : 60);
        Funcoes.criaBarraDescricao(this, "Coleta de material G-Hosp", "Coleta de materiais de Pacientes da integra\u00e7\u00e3o", "recepcao/coleta_material.jpg", this.labelFoto);
        this.defineAcessos();
    }

    private void adicionarPanelInfoColeta() {
        this.panelInfoColeta = new JPanel();
        this.panelInfoColeta.setLayout(new BoxLayout(this.panelInfoColeta, 0));
        this.labelVColeta = new JLabel();
        this.panelInfoColeta.add(new JLabel("Coleta:  "));
        this.panelInfoColeta.add(this.labelVColeta);
    }

    @Override
    protected void buscaDados() {
        this.thread = new ThreadDados(this, this.tableUrgente, this.tableNormal, Acesso.getAcesso(ACESSO_DESMARCAR_COLETADO), this.filtroColeta.contains("'") || Funcoes.textoVazio(this.filtroColeta) ? this.filtroColeta : "'" + this.filtroColeta.replaceAll(",", "','") + "'", this.filtroSituacoesConsiderarUrgente, this.itemOrdenarPorDataAlteracao.isSelected(), this.filtroEstacoes, this.filtroConvenios, true);
        ThreadDados.setPodeExecutar(true);
        this.thread.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        long requisicao = this.requisicaoSelecionada();
        super.actionPerformed(e);
        if (e.getSource() == this.itemFiltroAla) {
            this.filtroAlas();
            this.thread.setFiltroAlas(this.filtroAlas);
        } else if (e.getSource() == this.itemImprimirEtiquetaColetaRequisicao && requisicao > -1L) {
            this.imprimirEtiquetaColeta(requisicao);
        } else if (e.getSource() == this.itemImprimirEtiquetaTriagemRequisicao && requisicao > -1L) {
            this.imprimirEtiquetaTriagem(requisicao);
        } else if (e.getSource() == this.itemImprimirEtiquetaColetaTodas) {
            this.imprimirEtiquetasColetaTodas();
        } else if (e.getSource() == this.itemImprimirEtiquetaTriagemTodas) {
            this.imprimirEtiquetasTriagemTodas();
        }
    }

    private void imprimirEtiquetasColetaTodas() {
        DadosRequisicao requisicao;
        int i;
        for (i = 0; i < this.tableUrgente.getModel().getSize(); ++i) {
            requisicao = (DadosRequisicao)this.tableUrgente.getModel().getElementAt(i);
            this.imprimirEtiquetaColeta(requisicao.getCodigo());
        }
        for (i = 0; i < this.tableNormal.getModel().getSize(); ++i) {
            requisicao = (DadosRequisicao)this.tableNormal.getModel().getElementAt(i);
            this.imprimirEtiquetaColeta(requisicao.getCodigo());
        }
    }

    private void imprimirEtiquetasTriagemTodas() {
        DadosRequisicao requisicao;
        int i;
        for (i = 0; i < this.tableUrgente.getModel().getSize(); ++i) {
            requisicao = (DadosRequisicao)this.tableUrgente.getModel().getElementAt(i);
            this.imprimirEtiquetaTriagem(requisicao.getCodigo());
        }
        for (i = 0; i < this.tableNormal.getModel().getSize(); ++i) {
            requisicao = (DadosRequisicao)this.tableNormal.getModel().getElementAt(i);
            this.imprimirEtiquetaTriagem(requisicao.getCodigo());
        }
    }

    private void filtroAlas() {
        DialogoFiltro item = new DialogoFiltro((JFrame)this.getTopLevelAncestor(), "Alas", true);
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        if (!Funcoes.textoVazio(this.filtroAlas)) {
            map.put(new Integer(0), this.filtroAlas.replaceAll("'", "").split(","));
        }
        item.setDados(map, "alahospital", new String[]{"ala_codigo", "ala_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, "fil_codigo = " + Variaveis.filialPadrao);
        item.setVisible(true);
        StringBuilder bui = new StringBuilder();
        String[] sel = item.getSelecionados(0);
        this.itemFiltroAla.setText("Ala");
        if (item.ok()) {
            if (sel != null && sel.length > 0) {
                for (int i = 0; i < sel.length; ++i) {
                    bui.append("'");
                    bui.append(sel[i]).append("'");
                    if (i >= sel.length - 1) continue;
                    bui.append(",");
                }
            }
            this.filtroAlas = bui.toString();
            bui.delete(0, bui.length());
            bui.append("<filtro>");
            bui.append(this.filtroAlas);
            bui.append("</filtro>");
            if (sel != null && sel.length > 0) {
                this.itemFiltroAla.setText("Ala ativo");
            } else {
                this.itemFiltroAla.setText("Ala");
                this.filtroAlas = "";
            }
        } else if (!Funcoes.textoVazio(this.filtroAlas)) {
            this.itemFiltroAla.setText("Ala ativo");
        }
    }

    @Override
    protected void posicionaComponentes() {
        super.posicionaComponentes();
        this.labelAla.setBounds(new Rectangle(this.panelExame.getX(), 129, 40, 14));
        this.labelVAla.setBounds(new Rectangle(this.panelExame.getX() + 73, 129, this.panelCentro.getWidth() - (this.panelExame.getX() + 78), 20));
        this.labelSetor.setBounds(new Rectangle(this.panelExame.getX(), 150, 40, 20));
        this.labelVSetor.setBounds(new Rectangle(this.panelExame.getX() + 73, 150, this.panelCentro.getWidth() - (this.panelExame.getX() + 78), 20));
        ScreenUtil.setBorda(new Component[]{this.labelVAla, this.labelVSetor}, BorderFactory.createTitledBorder(""));
        this.labelAla.updateUI();
        this.panelCentro.add(this.labelAla);
        this.panelCentro.add(this.labelVAla);
        this.panelCentro.add(this.labelSetor);
        this.panelCentro.add(this.labelVSetor);
        this.panelCentro.revalidate();
        this.panelCentro.repaint();
        this.panelColetor.setBounds(new Rectangle(this.panelColetor.getX(), this.panelColetor.getY() + 50, this.panelColetor.getWidth(), this.panelColetor.getHeight()));
        this.panelInfo.add((Component)this.panelInfoColeta, "North");
        this.panelInfo.setBounds(new Rectangle(this.panelInfo.getX(), this.panelInfo.getY() + 50, this.panelInfo.getWidth(), this.panelInfo.getHeight() - 50));
        this.panelExame.setBounds(new Rectangle(this.panelExame.getX(), this.panelExame.getY() + 50, this.panelExame.getWidth(), this.panelExame.getHeight() - 50));
        this.revalidate();
    }

    private void carregarAcessos() {
        this.ACESSO_ALTERAR_OBS = Long.parseLong("0201400101");
        this.ACESSO_ALTERAR_RESPOSTA = Long.parseLong("0201400102");
        this.ACESSO_COLETAR = Long.parseLong("0201400103");
        this.ACESSO_COLETAR_TODOS = Long.parseLong("0201400104");
        ACESSO_DESMARCAR_COLETADO = Long.parseLong("0201400105");
        this.ACESSO_ESTORNAR = Long.parseLong("0201400106");
        this.ACESSO_FILTRO = Long.parseLong("0201400107");
        this.ACESSO_IGNORAR_COLETOR = Long.parseLong("0201400108");
        this.ACESSO_IMPRIMIR_ANEXO = Long.parseLong("0201400109");
        this.ACESSO_IMPRIMIR_ANEXO_COBRANCA = Long.parseLong("0201400110");
        this.ACESSO_IMPRIMIR_CAPA = Long.parseLong("0201400111");
        this.ACESSO_IMPRIMIR_COMPROVANTE = Long.parseLong("0201400112");
        this.ACESSO_IMPRIMIR_ETQ_COLETA = Long.parseLong("0201400113");
        this.ACESSO_IMPRIMIR_ETQ_TRIAGEM = Long.parseLong("0201400114");
        this.ACESSO_IMPRIMIR_ETQ_COLETA_SELECIONADA = Long.parseLong("0201400115");
        this.ACESSO_IMPRIMIR_ETQ_TRIAGEM_SELECIONADA = Long.parseLong("0201400116");
        this.ACESSO_IMPRIMIR_RECIBO = Long.parseLong("0201400117");
        this.ACESSO_RECOLETA = Long.parseLong("0201400118");
        this.ACESSO_MARCAR_EXTERNO = Long.parseLong("0201400119");
        this.ACESSO_NAO_ALTERAR_SITUACAO_SEM_ETIQUETA_IMPRESSA = Long.parseLong("0201400120");
        ACESSO_NAO_RECEBER_MATERIAL_EM_RECOLETA = Long.parseLong("0201400121");
        this.ACESSO_NAO_VISUALIZAR_REQUISICAO_CONVENIO_APOIADO = Long.parseLong("0201400122");
        this.itemIgnorarBoxColeta.setVisible(false);
        this.itemFiltroEstacoes.setVisible(false);
    }

    @Override
    public synchronized void mostraDadosRequisicao(DadosRequisicao requisicao) {
        super.mostraDadosRequisicao(requisicao);
        this.labelVAla.setText(!Funcoes.textoVazio(requisicao.getAla()) ? requisicao.getAla() : "");
        this.labelVSetor.setText(!Funcoes.textoVazio(requisicao.getSetor()) ? requisicao.getSetor() : "");
        if (requisicao.getExame(0).getDataHoraColeta() != null) {
            this.labelVColeta.setText(Funcoes.formataData(requisicao.getExame(0).getDataHoraColeta()).concat(" ").concat(Funcoes.formataHora(requisicao.getExame(0).getDataHoraColeta(), false)));
        }
    }

    @Override
    public void defineAcessos() {
        this.buttonFechar.setVisible(Acesso.getAcesso(ColetarMaterialGHosp.getModuloAcesso()));
        this.buttonColetarTodos.setVisible(Acesso.getAcesso(this.ACESSO_COLETAR_TODOS));
        this.buttonSalvar.setVisible(Acesso.getAcesso(this.ACESSO_COLETAR));
        this.alterarResposta = Acesso.getAcesso(this.ACESSO_ALTERAR_RESPOSTA);
    }

    @Override
    public void limpaCampos() {
        super.limpaCampos();
        this.labelVAla.setText("");
        this.labelVSetor.setText("");
    }

    @Override
    protected void montaMenuOpcoes() {
        if (Acesso.getAcesso(this.ACESSO_FILTRO)) {
            this.menuFiltro.setName("menuFiltro");
            this.popMenu.add(this.menuFiltro);
            this.itemSituacoesConsiderarUrgente.setName("itemSituacoesConsiderarUrgente");
            this.popMenu.add(this.itemSituacoesConsiderarUrgente);
        }
        if (Acesso.getAcesso(this.ACESSO_ESTORNAR)) {
            this.popMenu.add(this.itemEstornar);
            this.itemEstornar.setName("itemEstornar");
        }
        if (Acesso.getAcesso(this.ACESSO_RECOLETA)) {
            this.popMenu.add(this.itemRecoleta);
            this.itemRecoleta.setName("itemRecoleta");
        }
        if (Acesso.getAcesso(this.ACESSO_MARCAR_EXTERNO)) {
            this.popMenu.add(this.itemMarcarExterno);
            this.itemMarcarExterno.setName("itemMarcarExterno");
        }
        this.popMenu.add(this.itemImagens);
        this.itemImagens.setName("itemImagens");
        this.popMenu.add(this.itemObs);
        this.itemObs.setName("itemObs");
        this.popMenu.add(this.itemIgnorarBoxColeta);
        this.itemIgnorarBoxColeta.setName("itemIgnorarBoxColeta");
        this.popMenu.add(this.itemOrdenarPorDataAlteracao);
        this.itemOrdenarPorDataAlteracao.setName("itemOrdenarPorDataAlteracao");
        this.adicionarMenuImprimir();
        this.menuFiltro.add(this.itemFiltroEstacoes);
        this.itemFiltroEstacoes.setName("itemFiltroEstacoes");
        this.menuFiltro.add(this.itemFiltroColeta);
        this.itemFiltroColeta.setName("itemFiltroColeta");
        this.menuFiltro.add(this.itemFiltroConvenios);
        this.itemFiltroConvenios.setName("itemFiltroConvenios");
    }

    private void adicionarMenuImprimir() {
        this.popMenu.add(this.menuImprimir);
        this.menuImprimir.setName("menuImprimir");
        this.menuImprimir.add(this.itemImprimirComprovante);
        this.itemImprimirComprovante.setName("itemImprimirComprovante");
        this.menuImprimir.add(this.itemImprimirAnexo);
        this.itemImprimirAnexo.setName("itemImprimirAnexo");
        this.menuImprimir.add(this.itemImprimirCapa);
        this.itemImprimirCapa.setName("itemImprimirCapa");
        this.menuImprimir.add(this.itemImprimirRecibo);
        this.itemImprimirRecibo.setName("itemImprimirRecibo");
        this.adicionarMenuEtiquetaColeta();
        this.adicionarMenuEtiquetaTriagem();
        this.menuImprimir.add(this.itemImprimirAnexoCobranca);
        this.itemImprimirAnexoCobranca.setName("itemImprimirAnexoCobranca");
    }

    private void adicionarMenuEtiquetaColeta() {
        this.menuEtiquetaColeta.add(this.itemImprimirEtiquetaColetaRequisicao);
        this.menuEtiquetaColeta.setName("itemImprimirColetaRequisicao");
        this.menuEtiquetaColeta.add(this.itemImprimirEtiquetaColetaTodas);
        this.menuEtiquetaColeta.setName("itemImprimirColetaTodas");
        this.menuEtiquetaColeta.add(this.itemImprimirEtqColetaExame);
        this.menuEtiquetaColeta.setName("itemImprimirEtqColetaExame");
        this.menuImprimir.add(this.menuEtiquetaColeta);
    }

    private void adicionarMenuEtiquetaTriagem() {
        this.menuEtiquetaTriagem.add(this.itemImprimirEtiquetaTriagemRequisicao);
        this.menuEtiquetaTriagem.setName("itemImprimirTriagemRequisicao");
        this.menuEtiquetaTriagem.add(this.itemImprimirEtiquetaTriagemTodas);
        this.menuEtiquetaTriagem.setName("itemImprimirTriagemTodas");
        this.menuEtiquetaTriagem.add(this.itemImprimirEtqTriagemExame);
        this.menuEtiquetaTriagem.setName("itemImprimirEtqTriagemExame");
        this.menuImprimir.add(this.menuEtiquetaTriagem);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0201400100");
    }
}

