/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.coletar;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.coletar.ColetarMaterial;
import jalis.laboratorio.recepcao.coletar.salux.FiltroColetaSalux;
import jalis.laboratorio.recepcao.util.DadosRequisicao;
import jalis.service.cadastro.ConvenioService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.ThreadFinalizadaListener;
import jalis.util.logger.ErrorLogger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.DefaultListModel;
import javax.swing.JList;

public class ThreadDados
extends Thread {
    public final ColetarMaterial owner;
    protected JList tableUrgente;
    protected JList tableNormal;
    protected boolean stop = false;
    protected boolean alterarColetado = true;
    protected static boolean podeExecutar = false;
    private String filtroColetas = "";
    protected String filtroAlas = "";
    protected String filtroEstacoes = "";
    protected String filtroConvenios = "";
    protected String filtroSituacoesConsiderarUrgente = "";
    protected boolean ordenarPorAlteracao = false;
    protected boolean acessoColetar = Acesso.getAcesso(Long.parseLong("0200600104"));
    protected ThreadFinalizadaListener listener = null;
    protected boolean isGHosp = false;
    protected FiltroColetaSalux filtroColetaSalux;

    public ThreadDados(ColetarMaterial owner, JList tableUrgente, JList tableNormal, boolean alterarColetado, String filtroColetas, String filtroSituacoesConsiderarUrgente, boolean ordenarPorAlteracao, String filtroEstacoes, String filtroConvenios) {
        super("dados_coleta");
        this.owner = owner;
        this.tableUrgente = tableUrgente;
        this.tableNormal = tableNormal;
        this.setPriority(5);
        this.alterarColetado = alterarColetado;
        this.filtroColetas = filtroColetas;
        this.filtroEstacoes = filtroEstacoes;
        this.filtroConvenios = filtroConvenios;
        this.filtroSituacoesConsiderarUrgente = filtroSituacoesConsiderarUrgente;
        this.ordenarPorAlteracao = ordenarPorAlteracao;
        this.listener = owner;
    }

    public ThreadDados(ColetarMaterial owner, JList tableUrgente, JList tableNormal, boolean alterarColetado, String filtroColetas, String filtroSituacoesConsiderarUrgente, boolean ordenarPorAlteracao, String filtroEstacoes, String filtroConvenios, boolean isGHosp) {
        super("dados_coleta");
        this.owner = owner;
        this.tableUrgente = tableUrgente;
        this.tableNormal = tableNormal;
        this.setPriority(5);
        this.alterarColetado = alterarColetado;
        this.filtroColetas = filtroColetas;
        this.filtroEstacoes = filtroEstacoes;
        this.filtroConvenios = filtroConvenios;
        this.filtroSituacoesConsiderarUrgente = filtroSituacoesConsiderarUrgente;
        this.ordenarPorAlteracao = ordenarPorAlteracao;
        this.isGHosp = isGHosp;
        this.listener = owner;
    }

    public static void setPodeExecutar(boolean podeExecutar) {
        ThreadDados.podeExecutar = podeExecutar;
    }

    public void setOrdenarPorDataAlteracao(boolean b) {
        this.ordenarPorAlteracao = b;
    }

    public void setStop(boolean b) {
        this.stop = b;
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                if (!podeExecutar) continue;
                if (ColetarMaterial.isCarregandoRequisicao) {
                    ThreadDados.sleep(3000L);
                    continue;
                }
                int rowNormal = this.tableNormal.getSelectedIndex();
                int rowUrgente = this.tableUrgente.getSelectedIndex();
                this.fireIniciouExecucao();
                this.atualizaRequisicoes(rowNormal, rowUrgente);
                this.fireFinalizouExecucao();
                if (rowNormal > -1) {
                    this.tableNormal.setSelectedIndex(rowNormal);
                } else if (rowUrgente < 0) {
                    this.tableNormal.setSelectedIndex(0);
                    this.owner.atualizaTableNormal();
                }
                if (rowUrgente > -1) {
                    this.tableUrgente.setSelectedIndex(rowUrgente);
                }
                ThreadDados.sleep(60000L);
            }
            catch (InterruptedException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void fireFinalizouExecucao() {
        this.listener.threadFinalizada(null);
    }

    private void fireIniciouExecucao() {
        this.listener.threadIniciada(null);
    }

    public synchronized void atualizaRequisicoes(int rowNormalAnterior, int rowUrgenteAnterior) {
        this.buscaDados(this.filtrarEstacoes(), this.getFiltroSituacoesConsiderarUrgente(), this.filtrarColetas(), this.filtrarConveios());
        int rowNormal = this.tableNormal.getSelectedIndex();
        int rowUrgente = this.tableUrgente.getSelectedIndex();
        int rowExames = ColetarMaterial.tableExame.getSelectionModel().getMinSelectionIndex();
        boolean isSituacaoAlteradaBanco = false;
        DadosRequisicao requisicao = null;
        if (rowNormalAnterior > -1 && rowExames > -1) {
            requisicao = (DadosRequisicao)this.tableNormal.getModel().getElementAt(rowNormalAnterior);
            try {
                ColetarMaterial.carregarDadosExameRequisicao(requisicao, Acesso.getAcesso(ColetarMaterial.ACESSO_DESMARCAR_COLETADO));
                isSituacaoAlteradaBanco = ColetarMaterial.atualizaObjetosExames(requisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Uma situa\u00e7\u00e3o inesperada ocorreu ao atualizar os dados do exames.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        if (rowUrgenteAnterior > -1) {
            requisicao = (DadosRequisicao)this.tableUrgente.getModel().getElementAt(rowUrgenteAnterior);
            try {
                ColetarMaterial.carregarDadosExameRequisicao(requisicao, Acesso.getAcesso(ColetarMaterial.ACESSO_DESMARCAR_COLETADO));
                isSituacaoAlteradaBanco = ColetarMaterial.atualizaObjetosExames(requisicao);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Uma situa\u00e7\u00e3o inesperada ocorreu ao atualizar os dados do exames.\n" + e.getMessage(), e.getStackTrace());
            }
        }
        ColetarMaterial.tableExame.getSelectionModel().setSelectionInterval(rowExames, rowExames);
        if (isSituacaoAlteradaBanco) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A situa\u00e7\u00e3o dos exames foi alterada por outro usu\u00e1rio.\nVerifique os dados novamente.", 2);
        }
    }

    public String getFiltroSituacoesConsiderarUrgente() {
        return this.filtroSituacoesConsiderarUrgente;
    }

    private boolean getRequisicaoPossuiEtiquetaColetaImpressa(int codigoRequisicao) {
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select (case when (a.exr_dataetqcoleta is not null and a.usr_codetqcoleta is not null) then true else false end) as etiquetaImpressa ");
            sql.append(" from examerequisicao a where a.req_codigo = ");
            sql.append(codigoRequisicao);
            ResultSet resultSet = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            while (resultSet.next()) {
                if (resultSet.getBoolean("etiquetaImpressa")) continue;
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar informa\u00e7\u00e3o se a etiqueta de coleta j\u00e1 foi impressa.", e.getStackTrace());
        }
        return true;
    }

    public String filtrarEstacoes() {
        return this.filtroEstacoes;
    }

    public String filtrarColetas() {
        return this.filtroColetas;
    }

    public String filtrarConveios() {
        return this.filtroConvenios;
    }

    public void setFiltroColetas(String filtro) {
        this.filtroColetas = filtro;
    }

    public void setFiltroEstacoes(String filtro) {
        this.filtroEstacoes = filtro;
    }

    public void setFiltroConvenios(String filtro) {
        this.filtroConvenios = filtro;
    }

    public String getFiltroAlas() {
        return this.filtroAlas;
    }

    public void setFiltroAlas(String filtroAlas) {
        this.filtroAlas = filtroAlas;
    }

    public void setFiltroSituacoesConsiderarUrgente(String filtroSituacoesConsiderarUrgente) {
        this.filtroSituacoesConsiderarUrgente = filtroSituacoesConsiderarUrgente;
    }

    private void buscaDados(String filtroEstacoes, String filtroSituacoesConsiderarUrgente, String filtroColetas, String filtroConvenios) {
        HashSet requisicoesNaoRemovidas = new HashSet();
        ArrayList<DadosRequisicao> dadosRequisicoesAddF2 = new ArrayList<DadosRequisicao>();
        DefaultListModel m = (DefaultListModel)this.tableUrgente.getModel();
        for (int i = 0; i < m.getSize(); ++i) {
            if (!((DadosRequisicao)m.get(i)).isAdicionarPorF2()) continue;
            dadosRequisicoesAddF2.add((DadosRequisicao)m.get(i));
        }
        DefaultListModel<DadosRequisicao> modeloUrgente = new DefaultListModel<DadosRequisicao>();
        DefaultListModel<DadosRequisicao> modeloNormal = new DefaultListModel<DadosRequisicao>();
        boolean urgenteSelecionado = this.tableUrgente.getSelectedIndex() > -1;
        String codigoSelecionado = null;
        if (urgenteSelecionado) {
            codigoSelecionado = String.valueOf(((DadosRequisicao)this.tableUrgente.getModel().getElementAt(this.tableUrgente.getSelectedIndex())).getCodigo());
        } else if (this.tableNormal.getSelectedIndex() > -1) {
            codigoSelecionado = String.valueOf(((DadosRequisicao)this.tableNormal.getModel().getElementAt(this.tableNormal.getSelectedIndex())).getCodigo());
        }
        Statement st = Conexao.getStatement();
        DadosRequisicao d = null;
        try {
            boolean acessoLabApoio;
            StringBuilder buf = new StringBuilder("");
            buf.append(" select a.req_codigo ");
            buf.append("       ,a.req_urgente ");
            buf.append("       ,c.pac_codigo ");
            buf.append("       ,c.pac_nome ");
            buf.append("       ,c.pac_nomesocial ");
            buf.append("       ,a.req_idade ");
            buf.append("       ,a.req_anomes ");
            buf.append("       ,c.pac_obscoleta");
            buf.append("       ,c.pac_sexo ");
            buf.append("       ,coalesce(c.pac_genero, 0) as pac_genero ");
            buf.append("       ,c.pac_foto ");
            buf.append("       ,d.med_nome ");
            buf.append("       ,e.con_fantasia ");
            buf.append("       ,a.con_codigo ");
            buf.append("       ,a.usr_codabertura ");
            buf.append("       ,a.req_obs ");
            buf.append("       ,a.req_integracaohospital ");
            buf.append("       ,c.pac_digital ");
            buf.append("       ,a.req_boxcoleta ");
            buf.append("       ,a.sit_codigo as situacaoRequisicao ");
            buf.append("       ,f.sit_descricao ");
            buf.append("\t\t\t ,a.des_codigo ");
            buf.append("\t\t\t ,c.pac_datanasc ");
            buf.append("\t\t\t ,a.req_data ");
            buf.append("\t\t\t ,a.req_dclinicos ");
            buf.append("\t\t\t ,ala.ala_codigo ");
            buf.append("\t\t\t ,ala.ala_descricao ");
            buf.append("\t\t\t ,a.req_leito ");
            buf.append("\t\t\t ,a.req_quarto ");
            buf.append("     ,(select max(coalesce(exr_datacoletar, exr_datamaterial)) from examerequisicao where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and exr_situacao = '").append("T").append("') as ultimaalteracao ");
            buf.append("   from requisicao a ");
            buf.append("   left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            buf.append("   left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and upper(a.med_crm) = upper(d.med_crm) and a.med_uf = d.med_uf ");
            buf.append("   left join convenios e on a.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
            buf.append("   left join situacao f on a.fil_codigo = f.fil_codigo and a.sit_codigo = f.sit_codigo ");
            buf.append("   left join alahospital ala on a.fil_codigo = ala.fil_codigo and a.ala_codigo = ala.ala_codigo");
            buf.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("    and a.req_data >= current_date  - ").append(String.valueOf(ParametrosGerais.getRetrocessoColeta()));
            buf.append("    and a.req_telacoleta = false ");
            buf.append("    and a.req_excluida = false ");
            if (filtroEstacoes != null && !Funcoes.textoVazio(filtroEstacoes)) {
                buf.append("  and a.est_codigo in (").append(filtroEstacoes).append(") ");
            }
            if (filtroColetas != null && !Funcoes.textoVazio(filtroColetas)) {
                buf.append("  and a.col_codigo in (").append(filtroColetas).append(") ");
            }
            if (this.filtroAlas != null && !Funcoes.textoVazio(this.filtroAlas)) {
                buf.append("  and a.ala_codigo in (").append(this.filtroAlas).append(") ");
            }
            if (filtroConvenios != null && !Funcoes.textoVazio(filtroConvenios)) {
                buf.append("  and a.con_codigo in (").append(filtroConvenios).append(") ");
            }
            if ((acessoLabApoio = Acesso.getAcesso(Long.parseLong("0200600119"))) && new ConvenioService().getPossuiCampoPermitirPesquisaApoio()) {
                buf.append(" and (COALESCE(e.con_permitirpesquisaapoio, false) OR NOT COALESCE(e.con_apoiado, false))  ");
            } else if (acessoLabApoio) {
                buf.append(" and COALESCE(e.con_apoiado, false) = false ");
            }
            if (this.isGHosp) {
                buf.append(" and a.req_dclinicos ILIKE '%ATENDIMENTO%' ");
            }
            buf.append("  order by ");
            if (!this.ordenarPorAlteracao) {
                buf.append("           a.req_data ");
                buf.append("          ,a.req_hora ");
                buf.append("          ,a.req_codigo ");
            } else {
                buf.append(" ultimaalteracao, a.req_codigo ");
            }
            modeloNormal.clear();
            modeloUrgente.clear();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    DadosConvenios conv = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, rs.getInt("con_codigo"));
                    d = new DadosRequisicao(rs.getInt("req_codigo"), rs.getString("pac_codigo"), rs.getString("pac_nome"), rs.getString("pac_nomesocial"), rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes")), Tipos.tipoSexo(rs.getString("pac_sexo")), rs.getString("pac_genero"), rs.getString("usr_codabertura"), conv, rs.getString("med_nome"), rs.getString("req_obs"), rs.getString("req_integracaohospital"), rs.getString("pac_foto"), rs.getString("pac_digital"), rs.getString("pac_obscoleta"), this.getRequisicaoPossuiEtiquetaColetaImpressa(rs.getInt("req_codigo")), rs.getTimestamp("ultimaalteracao"), rs.getString("sit_descricao"), rs.getString("des_codigo"), rs.getDate("pac_datanasc"), rs.getDate("req_data"), rs.getString("req_dclinicos"));
                    if (this.isGHosp) {
                        String codigoAla = rs.getString("ala_codigo");
                        String descricaoAla = rs.getString("ala_descricao");
                        if (Funcoes.objectIsNull(codigoAla)) {
                            codigoAla = "";
                            descricaoAla = "";
                        }
                        d.setAla(codigoAla);
                        d.setSetor(descricaoAla);
                        d.setGHosp(true);
                    }
                    if (!DBUtil.campoNull(rs.getString("req_boxcoleta"))) {
                        d.setBoxColeta(rs.getString("req_boxcoleta"));
                    }
                    boolean exameUrgente = this.verificaExameUrgente(rs.getString("req_codigo"));
                    if (rs.getBoolean("req_urgente") || exameUrgente || this.verificaSituacaoConsiderarUrgente(rs.getString("situacaoRequisicao"))) {
                        if (requisicoesNaoRemovidas.contains(d.getCodigo())) continue;
                        d.setLisBoxParent(this.tableUrgente);
                        modeloUrgente.addElement(d);
                        continue;
                    }
                    if (requisicoesNaoRemovidas.contains(d.getCodigo()) || dadosRequisicoesAddF2.contains(d)) continue;
                    d.setLisBoxParent(this.tableNormal);
                    modeloNormal.addElement(d);
                } while (rs.next());
            }
            for (DadosRequisicao dadosRequisicao : dadosRequisicoesAddF2) {
                DadosRequisicao aux;
                int i;
                boolean jaAdicionada = false;
                for (i = 0; i < modeloUrgente.getSize(); ++i) {
                    aux = (DadosRequisicao)modeloUrgente.get(i);
                    if (!aux.equals(dadosRequisicao)) continue;
                    jaAdicionada = true;
                    break;
                }
                if (jaAdicionada) continue;
                for (i = 0; i < modeloNormal.getSize(); ++i) {
                    aux = (DadosRequisicao)modeloNormal.get(i);
                    if (!aux.equals(dadosRequisicao)) continue;
                    jaAdicionada = true;
                    break;
                }
                if (jaAdicionada || requisicoesNaoRemovidas.contains(dadosRequisicao.getCodigo())) continue;
                modeloUrgente.addElement(dadosRequisicao);
            }
            this.tableUrgente.setModel(modeloUrgente);
            this.tableNormal.setModel(modeloNormal);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this.owner, ex.getMessage(), ex.getStackTrace(), "ColetarMaterial (1501)");
        }
        if (codigoSelecionado != null) {
            boolean isRemovido = true;
            DadosRequisicao dados = null;
            if (urgenteSelecionado) {
                for (int i = 0; i < this.tableUrgente.getModel().getSize(); ++i) {
                    dados = (DadosRequisicao)this.tableUrgente.getModel().getElementAt(i);
                    if (!String.valueOf(dados.getCodigo()).equalsIgnoreCase(codigoSelecionado)) continue;
                    this.tableUrgente.setSelectedIndex(i);
                    isRemovido = false;
                    break;
                }
            } else {
                for (int i = 0; i < this.tableNormal.getModel().getSize(); ++i) {
                    dados = (DadosRequisicao)this.tableNormal.getModel().getElementAt(i);
                    if (!String.valueOf(dados.getCodigo()).equalsIgnoreCase(codigoSelecionado)) continue;
                    this.tableNormal.setSelectedIndex(i);
                    isRemovido = false;
                    break;
                }
            }
            if (isRemovido) {
                this.owner.limpaCampos();
            }
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean verificaExameUrgente(String codigoRequisicao) throws SQLException {
        Statement stExames = Conexao.getStatement();
        StringBuilder buf2 = new StringBuilder();
        buf2.append(" select coalesce(a.exr_urgente, false) as exr_urgente ");
        buf2.append("   from examerequisicao a ");
        buf2.append("  where a.fil_codigo = ").append(Variaveis.filialPadrao);
        buf2.append("    and a.req_codigo = ").append(codigoRequisicao);
        buf2.append("    and a.exr_excluido = false ");
        try (ResultSet rsExames = null;){
            rsExames = stExames.executeQuery(buf2.toString());
            while (rsExames.next()) {
                if (!rsExames.getBoolean("exr_urgente")) continue;
                Boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean verificaSituacaoConsiderarUrgente(String situacaoRequisicao) {
        if (Funcoes.textoVazio(situacaoRequisicao) || Funcoes.textoVazio(this.filtroSituacoesConsiderarUrgente)) {
            return false;
        }
        ArrayList<String> lista = StringUtil.explode(this.filtroSituacoesConsiderarUrgente, ",");
        if (lista != null) {
            for (String aux : lista) {
                if (!situacaoRequisicao.equalsIgnoreCase(aux)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOrdenarPorAlteracao() {
        return this.ordenarPorAlteracao;
    }

    public void setOrdenarPorAlteracao(boolean ordenarPorAlteracao) {
        this.ordenarPorAlteracao = ordenarPorAlteracao;
    }

    public void setFiltroColetaSalux(FiltroColetaSalux filtroColetaSalux) {
        this.filtroColetaSalux = filtroColetaSalux;
    }
}

