/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.caixarecepcao;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixarecepcao.ValorPagoVO;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class CaixaRecepcaoDao {
    public boolean atualizarRequisicao(Caixa caixa, String codigoFilial, String codigoRequisicao, boolean deviaGuiaRepasse) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.delete(0, buf.length());
        buf.append("update requisicao set ");
        boolean repasseSelecionado = caixa.getConvenioRepasseSelecionado() != null;
        buf.append(" req_notacaixa = '");
        buf.append(StringUtil.textoDB(caixa.getObs()));
        buf.append("', req_totpago = ");
        buf.append(Funcoes.limpaDecimal(Funcoes.formataDecimal(caixa.getValorRecebido())));
        buf.append(", req_total = ");
        buf.append(Funcoes.limpaDecimal(Funcoes.formataDecimal(caixa.getSubTotal().add(new BigDecimal(String.valueOf(caixa.getValorAcrescimo()))).subtract(new BigDecimal(String.valueOf(caixa.getValorDesconto()))).doubleValue())));
        buf.append(", req_desconto = ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getDesconto())));
        buf.append(", req_vlrdesconto = ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getValorDesconto())));
        buf.append(", req_acrescimo = ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getAcrescimo())));
        buf.append(", req_vlracrescimo = ");
        buf.append(Funcoes.limpaDecimal(String.valueOf(caixa.getValorAcrescimo())));
        buf.append(", con_codrepasse = ");
        buf.append(!repasseSelecionado ? "null" : Integer.valueOf(caixa.getConvenioRepasseSelecionado().getCodigo()));
        buf.append(", req_vlrexames = ");
        buf.append(repasseSelecionado ? Integer.valueOf(0) : Funcoes.limpaDecimal(String.valueOf(caixa.getValorExames())));
        buf.append(", req_vlrmateriais = ");
        buf.append(repasseSelecionado ? Integer.valueOf(0) : Funcoes.limpaDecimal(String.valueOf(caixa.getValorMateriais())));
        if (deviaGuiaRepasse && !caixa.isDeveGuiaRepasse()) {
            buf.append(",req_deveguiaRepasse = false, ");
            buf.append("req_datarecebeuguiarepasse = '").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new Date())).append("',");
            buf.append("usr_codguiarepasse = '").append(StringUtil.textoDB(Variaveis.login)).append("'");
        } else if (!deviaGuiaRepasse && caixa.isDeveGuiaRepasse()) {
            buf.append(",req_deveguiaRepasse = true, ");
            buf.append("req_datarecebeuguiarepasse = null,");
            buf.append("usr_codguiarepasse = null");
        }
        buf.append(", req_guiarepasse = '").append(StringUtil.textoDB(caixa.getGuiaRepasse())).append("', ");
        buf.append("req_guiaprincipalrepasse = '").append(StringUtil.textoDB(caixa.getGuiaPrincipalRepasse())).append("', ");
        buf.append("req_matricularepasse = '").append(StringUtil.textoDB(caixa.getMatriculaRepasse())).append("', ");
        buf.append("req_nomeplanorepasse = '").append(StringUtil.textoDB(caixa.getPlanoRepasse())).append("', ");
        buf.append("req_validadeguiarepasse = ").append(caixa.getValidadeGuiaRepasse() != null ? "'" + Funcoes.formataData("MM/dd/yyyy", caixa.getValidadeGuiaRepasse()) + "'" : "null").append(", ");
        buf.append("req_validadecarteirarepasse = ").append(caixa.getValidadeCarteiraRepasse() != null ? "'" + Funcoes.formataData("MM/dd/yyyy", caixa.getValidadeCarteiraRepasse()) + "'" : "null");
        buf.append(" where fil_codigo = ");
        buf.append(codigoFilial);
        buf.append(" and req_codigo = ");
        buf.append(codigoRequisicao);
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codigoFilial, st, buf.toString());
        return repasseSelecionado;
    }

    public boolean atualizarExameRequisicao(DadosExames dadosExame, DadosMaterial dadosMaterial, DadosConvenios convenioRepasse, DadosConvenios caixaConvenioSelecionado, String codigoFilial, String codigoRequisicao, String tipoCalculo, boolean repasseSelecionado) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.setLength(0);
        buf.append("update examerequisicao set ");
        if (!repasseSelecionado && convenioRepasse != null) {
            buf.append(" exr_valorchexamerepasse = null");
            buf.append(", exr_valorchrepasse = null");
            buf.append(", exr_valorcustorepasse = null");
            buf.append(", exr_valorucorepasse = null");
            buf.append(", exr_valorporterepasse = null");
            buf.append(", exr_porterepasse = null ");
        } else if (repasseSelecionado) {
            if (tipoCalculo.equals("P")) {
                buf.append(" exr_valorchexamerepasse = ").append(dadosExame.getValorExame() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorExame())) : "null");
                buf.append(", exr_valorchrepasse = ").append(dadosExame.getValorCH() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH())) : "null");
                buf.append(", exr_valorcustorepasse = ").append(dadosExame.getCusto() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getCusto())) : "null");
                buf.append(", exr_valorucorepasse = ").append(dadosExame.getUco() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getUco())) : "null");
                buf.append(", exr_valorporterepasse = ").append(dadosExame.getValorPorte() != null ? Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorPorte())) : "null");
                if (dadosExame.getPorte() != null && !Funcoes.textoVazio(dadosExame.getPorte())) {
                    buf.append(", exr_porterepasse = '").append(StringUtil.textoDB(dadosExame.getPorte())).append("'");
                } else {
                    buf.append(", exr_porterepasse = null ");
                }
            } else {
                DadosExames exameTmp = ExameUtil.getDadosExame(codigoFilial, dadosExame.getCodigo(), dadosMaterial);
                ExameUtil.calculaPrecoExame(codigoFilial, dadosExame, dadosMaterial, caixaConvenioSelecionado, false, false, false, Integer.parseInt(codigoRequisicao), null, Integer.parseInt(dadosExame.getCodMetodo()));
                buf.append(" exr_valorchexamerepasse = ").append(exameTmp.getValorExame() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getValorExame())) : "null");
                buf.append(", exr_valorchrepasse = ").append(exameTmp.getValorCH() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getValorCH())) : "null");
                buf.append(", exr_valorcustorepasse = ").append(exameTmp.getCusto() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getCusto())) : "null");
                buf.append(", exr_valorucorepasse = ").append(exameTmp.getUco() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getUco())) : "null");
                buf.append(", exr_valorporterepasse = ").append(exameTmp.getValorPorte() != null ? Funcoes.limpaDecimal(String.valueOf(exameTmp.getValorPorte())) : "null");
                if (exameTmp.getPorte() != null && !Funcoes.textoVazio(exameTmp.getPorte())) {
                    buf.append(", exr_porterepasse = '").append(StringUtil.textoDB(exameTmp.getPorte())).append("'");
                } else {
                    buf.append(", exr_porterepasse = null ");
                }
            }
        }
        buf.append(" where fil_codigo = ").append(codigoFilial);
        buf.append(" and req_codigo = ").append(codigoRequisicao);
        buf.append(" and exa_codigo = '").append(dadosExame.getCodigo()).append("'");
        buf.append(" and mco_codigo = ").append(dadosMaterial.getCodigo());
        Statement st = Conexao.getStatement();
        Conexao.executeUpdate(codigoFilial, st, buf.toString());
        return false;
    }

    public ValorPagoVO buscaValorPago(String codigoFilial, String codigoRequisicao) throws SQLException {
        StringBuffer buf = new StringBuffer();
        buf.append("select a.req_totpago, b.des_enviarweb from requisicao a ");
        buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(codigoFilial);
        buf.append(" and a.req_codigo = ");
        buf.append(codigoRequisicao);
        Statement st = Conexao.getStatement();
        ResultSet rsValorPago = Conexao.executeQuery(st, buf.toString());
        ValorPagoVO valorPagoVO = null;
        while (rsValorPago.next()) {
            valorPagoVO = new ValorPagoVO();
            valorPagoVO.setCodigoFilial(codigoFilial);
            valorPagoVO.setCodigoRequisicao(codigoRequisicao);
            valorPagoVO.setValorTotalPago(rsValorPago.getDouble("req_totpago"));
            valorPagoVO.setCodigoDestinoEnviarWeb(rsValorPago.getBoolean("des_enviarweb"));
        }
        return valorPagoVO;
    }
}

