/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.caixarecepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.padroes.FrmPadrao;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.recepcao.PendenciasPaciente;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.CaixaListener;
import jalis.laboratorio.recepcao.caixarecepcao.CaixaRecepcaoService;
import jalis.laboratorio.recepcao.caixarecepcao.MostrarExames;
import jalis.laboratorio.recepcao.caixarecepcao.RenderizarCaixaRecepcao;
import jalis.laboratorio.recepcao.caixarecepcao.ValorPagoVO;
import jalis.laboratorio.recepcao.util.EstornoCaixaListener;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.service.cadastro.RequisicaoTaxaService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class CaixaRecepcao
extends FrmPadrao
implements ActionListener,
EstornoCaixaListener,
CaixaListener {
    private JPanel panelCentro = new JPanel(null);
    private JTable tableExame = new JTable();
    private JScrollPane scrollExame = new JScrollPane(this.tableExame);
    private JPanel panelCaixa = new JPanel(new BorderLayout());
    private JPanel panelRodape = new JPanel(new BorderLayout());
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelOpcoes = new JPanel(new FlowLayout(0));
    private ModeloGridTable modeloExame = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame", "Coleta", "Entrega", "Sit"});
    private JButton buttonNovo = new JButton("Novo");
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonBuscaRequisicao = new JButton();
    private JLabel labelRequisicao = new JLabel("Requisi\u00e7\u00e3o:");
    private TTextField txtCodRequisicao = new TTextField(12, 1);
    private JLabel labelVPaciente = new JLabel();
    private JLabel labelConvenio = new JLabel("Conv\u00eanio:");
    private JLabel labelVConvenio = new JLabel();
    private JLabel labelMedico = new JLabel("M\u00e9dico:");
    private JLabel labelVMedico = new JLabel();
    private JLabel labelDataPrevista = new JLabel("Data prevista");
    private JButton buttonImprimir = new JButton("Imprimir \u25bc");
    private JButton buttonExames = ComponenteFactory.novoJButton("Exames", 'x', this);
    private JPopupMenu menuImprimir = new JPopupMenu();
    private JMenuItem itemImprimirComprovante = new JMenuItem("Comprovante");
    private JMenuItem itemImprimirRecibo = new JMenuItem("Recibo");
    private JMenuItem itemImprimirCapa = new JMenuItem("Capa");
    private JMenuItem itemImprimirAnexo = new JMenuItem("Anexo de faturamento");
    private JMenuItem itemImprimirAtestadoPaciente = new JMenuItem("Atestado paciente");
    private JMenuItem itemImprimirAtestadoAcompanhante = new JMenuItem("Atestado acompanhante");
    private JMenuItem itemImprimirAnexoCobranca = new JMenuItem("Anexo de cobran\u00e7a");
    private JMenuItem itemImprimirNotaFiscal = new JMenuItem("Nota fiscal");
    private TTextField textFilial = new TTextField(5, 1);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial:", 'l', null, this.textFilial);
    private JButton buttonFilial = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CaixaRecepcao.this.pesquisarFilial();
        }
    }, true);
    private int status = 1;
    private double saldo = 0.0;
    private Caixa caixa = new Caixa(this);
    private DadosConvenios convenio;
    private DadosConvenios convenioRepasse = null;
    private final long ACESSO_ALTERAR_DESCONTO = Long.parseLong("0201000101");
    private final long ACESSO_ALTERAR_ACRESCIMO = Long.parseLong("0201000102");
    private final long ACESSO_MOVIMENTAR_CAIXA = Long.parseLong("0201000103");
    private final long ACESSO_IMPRIMIR_COMPROVANTE = Long.parseLong("0201000104");
    private final long ACESSO_IMPRIMIR_RECIBO = Long.parseLong("0201000105");
    private final long ACESSO_IMPRIMIR_CAPA = Long.parseLong("0201000106");
    private final long ACESSO_IMPRIMIR_ATESTADO_PACIENTE = Long.parseLong("0201000107");
    private final long ACESSO_IMPRIMIR_ATESTADO_ACOMPANHANTE = Long.parseLong("0201000108");
    private final long ACESSO_IMPRIMIR_ANEXO = Long.parseLong("0201000109");
    private final long ACESSO_ALTERAR_DATA_CAIXA = Long.parseLong("0201000110");
    private final long ACESSO_ALTERAR_CONTA_CAIXA = Long.parseLong("0201000111");
    private final long ACESSO_ESTORNAR_PAGAMENTO = Long.parseLong("0201000112");
    private final long ACESSO_MOVIMENTAR_SEM_PAGAMENTO = Long.parseLong("0201000113");
    private final long ACESSO_ESTORNO_REPASSE_CAIXA = Long.parseLong("0201000114");
    private final long ACESSO_SALVAR_SEM_PAGADOR = Long.parseLong("0201000115");
    private final long ACESSO_IMPRIMIR_ANEXO_COBRANCA = Long.parseLong("0201000116");
    private final long ACESSO_GERAR_NOTA_FISCAL = Long.parseLong("0201000117");
    private final int COLUNA_EXAME_DADOS_MATERIAL = 1;
    private final int COLUNA_EXAME_DADOS_EXAMES = 6;
    boolean integrar = !ParametrosGerais.getTipoIntegracao().equals("N");
    boolean convenioMovimentaCaixa = true;
    boolean deviaGuiaRepasse = false;
    private int codigoPaciente = -1;
    protected boolean flagDialogAberto = false;

    public CaixaRecepcao() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (176)");
        }
    }

    public void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        Funcoes.criaBarraDescricao(this, "Caixa", "Movimenta\u00e7\u00e3o de pagamentos para requisi\u00e7\u00f5es", "recepcao/caixa.jpg");
        this.menuImprimir.add(this.itemImprimirComprovante);
        this.menuImprimir.add(this.itemImprimirRecibo);
        this.menuImprimir.add(this.itemImprimirCapa);
        this.menuImprimir.add(this.itemImprimirAnexo);
        this.menuImprimir.add(this.itemImprimirAtestadoPaciente);
        this.menuImprimir.add(this.itemImprimirAtestadoAcompanhante);
        this.menuImprimir.add(this.itemImprimirAnexoCobranca);
        this.menuImprimir.add(this.itemImprimirNotaFiscal);
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelRodape, "South");
        this.mensagemCaixaSemRequisicao();
        this.panelRodape.add((Component)this.panelOpcoes, "West");
        this.panelRodape.add((Component)this.panelBotoes, "East");
        this.panelRodape.add((Component)new JPanel(), "Center");
        if (this.integrar) {
            this.panelCentro.add(this.labelFilial);
            this.panelCentro.add(this.textFilial);
            this.panelCentro.add(this.buttonFilial);
        }
        this.panelBotoes.add(this.buttonNovo);
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonCancelar);
        this.panelBotoes.add(this.buttonFechar);
        this.panelCentro.add(this.panelCaixa);
        this.panelCentro.add(this.buttonBuscaRequisicao);
        this.panelCentro.add(this.labelRequisicao);
        this.panelCentro.add(this.txtCodRequisicao);
        this.panelCentro.add(this.labelVPaciente);
        this.panelCentro.add(this.labelConvenio);
        this.panelCentro.add(this.labelVConvenio);
        this.panelCentro.add(this.labelMedico);
        this.panelCentro.add(this.labelVMedico);
        this.panelOpcoes.add(this.buttonExames);
        this.panelOpcoes.add(this.buttonImprimir);
        ((BorderLayout)this.panelCaixa.getLayout()).setVgap(0);
        ScreenUtil.setBorda(new Component[]{this.labelVPaciente, this.labelVMedico, this.labelVConvenio}, BorderFactory.createTitledBorder(""));
        this.posicionaComponentes();
        this.textFilial.setText(Variaveis.filialPadrao);
        ScreenUtil.addActionMap(this, KeyStroke.getKeyStroke(73, 2, true), "INFOREQUISICAO", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(CaixaRecepcao.this.txtCodRequisicao.getText())) {
                    GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)CaixaRecepcao.this.getRootPane().getGlassPane();
                    InfoRequisicao info = CaixaRecepcao.this.getTopLevelAncestor() instanceof Frame ? new InfoRequisicao((Frame)CaixaRecepcao.this.getTopLevelAncestor(), glassPaneMensagem) : new InfoRequisicao((Dialog)CaixaRecepcao.this.getTopLevelAncestor(), glassPaneMensagem);
                    info.setRequisicao(CaixaRecepcao.this.getCodigoFilial(), Long.parseLong(CaixaRecepcao.this.txtCodRequisicao.getText()));
                    info.setVisible(true);
                    CaixaRecepcao.this.getRootPane().setGlassPane(glassPaneMensagem);
                }
            }
        });
        this.buttonNovo.setMnemonic('N');
        this.buttonSalvar.setMnemonic('S');
        this.buttonCancelar.setMnemonic('C');
        this.buttonFechar.setMnemonic('F');
        this.buttonImprimir.setMnemonic('I');
        this.buttonBuscaRequisicao.setFocusable(false);
        this.panelCaixa.setBorder(BorderFactory.createTitledBorder("Caixa"));
        this.panelCaixa.setPreferredSize(new Dimension(100, 100));
        this.tableExame.setModel(this.modeloExame);
        this.tableExame.setDefaultRenderer(Object.class, new RenderizarCaixaRecepcao());
        Funcoes.imagemPesquisa(this.buttonBuscaRequisicao);
        this.modeloExame.setColumnSize(new int[]{60, 35, 0, 80, 80, 30}, this.tableExame);
        Funcoes.defineUpperCase(this, ParametrosGerais.getUpperCase());
        this.controlaCampos(false);
        this.habilitaMenuOpcoes();
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaixaRecepcao.this.setVisible(false);
            }
        });
        this.buttonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Funcoes.mensagem(CaixaRecepcao.this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
                    CaixaRecepcao.this.cancelar();
                }
            }
        });
        this.buttonNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaixaRecepcao.this.novo();
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaixaRecepcao.this.salvar(true);
            }
        });
        this.buttonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaixaRecepcao.this.menuImprimir.show(CaixaRecepcao.this.panelOpcoes, CaixaRecepcao.this.buttonImprimir.getX(), CaixaRecepcao.this.buttonImprimir.getY() + CaixaRecepcao.this.buttonImprimir.getHeight());
            }
        });
        this.panelCentro.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CaixaRecepcao.this.posicionaComponentes();
            }
        });
        this.txtCodRequisicao.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(CaixaRecepcao.this.txtCodRequisicao.getText()) && !e.isTemporary() && e.getOppositeComponent() != CaixaRecepcao.this.buttonFechar && e.getOppositeComponent() != CaixaRecepcao.this.buttonCancelar && CaixaRecepcao.this.processarNumeroTubo(CaixaRecepcao.this.textFilial, CaixaRecepcao.this.txtCodRequisicao)) {
                    CaixaRecepcao.this.mostraDadosRequisicao(CaixaRecepcao.this.txtCodRequisicao.getText(), true);
                }
            }
        });
        this.buttonBuscaRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaixaRecepcao.this.buscaRequisicao();
            }
        });
        this.itemImprimirComprovante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CaixaRecepcao.this.salvar(false)) {
                    try {
                        Impressao.imprimirComprovante(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                        Conexao.arquivaSQL();
                    }
                    catch (IOException | SQLException ex) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException ec) {
                            ec.printStackTrace();
                        }
                        ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (374)");
                    }
                }
            }
        });
        this.itemImprimirRecibo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CaixaRecepcao.this.salvar(false)) {
                    try {
                        Impressao.imprimirRecibo(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (386)");
                    }
                }
            }
        });
        this.itemImprimirCapa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CaixaRecepcao.this.salvar(false)) {
                    try {
                        Impressao.imprimirCapa(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (398)");
                    }
                }
            }
        });
        this.itemImprimirAnexo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CaixaRecepcao.this.salvar(false)) {
                    try {
                        Impressao.imprimirAnexo(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (410)");
                    }
                }
            }
        });
        this.itemImprimirAnexoCobranca.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CaixaRecepcao.this.salvar(false)) {
                    try {
                        Impressao.imprimirAnexoCobranca(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace());
                    }
                }
            }
        });
        this.itemImprimirNotaFiscal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CaixaRecepcao.this.salvar(false)) {
                    CaixaRecepcao.this.caixa.setCodigoRequisicao(CaixaRecepcao.this.getCodigoFilial(), Integer.parseInt(CaixaRecepcao.this.txtCodRequisicao.getText()), true);
                    CaixaRecepcao.this.caixa.gerarNotaFiscal();
                }
            }
        });
        this.itemImprimirAtestadoPaciente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(CaixaRecepcao.this.txtCodRequisicao.getText())) {
                    new Thread("Thread - imprimir atestado paciente"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirAtestadoPaciente(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (425)");
                            }
                        }
                    }.start();
                }
            }
        });
        this.itemImprimirAtestadoAcompanhante.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Funcoes.textoVazio(CaixaRecepcao.this.txtCodRequisicao.getText())) {
                    new Thread("Thread - imprimir atestado acompanhante"){

                        @Override
                        public void run() {
                            try {
                                Impressao.imprimirAtestadoAcompanhante(CaixaRecepcao.this.getCodigoFilial(), CaixaRecepcao.this.txtCodRequisicao.getText());
                            }
                            catch (SQLException ex) {
                                ErrorLogger.mostraMensagem(CaixaRecepcao.this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (441)");
                            }
                        }
                    }.start();
                }
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !(e.getSource() instanceof JButton)) {
                    RecepcaoUtil.buscaDadosFilial(CaixaRecepcao.this, CaixaRecepcao.this.textFilial, CaixaRecepcao.this.buttonFilial);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                CaixaRecepcao.this.textFilial.selectAll();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registro getDadosPagador() {
        Registro retorno = null;
        if (this.codigoPaciente > -1) {
            Statement st;
            block5: {
                StringBuilder buf = new StringBuilder();
                buf.append(" select COALESCE(pac_nomepagador, pac_nome) as nomePaciente ");
                buf.append("       ,COALESCE(pac_cpfpagador, pac_cpf) as cpfPaciente ");
                buf.append("       ,pac_codigo as codPaciente ");
                buf.append("   from paciente pac ");
                buf.append(" where fil_codigo = ").append(this.getCodigoFilial());
                buf.append("   and pac_codigo = ").append(this.codigoPaciente);
                ResultSet rs = null;
                st = Conexao.getStatement();
                try {
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (!rs.next()) break block5;
                    retorno = new Registro(rs);
                }
                catch (Exception e) {
                    try {
                        ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "CaixaRecepcao: 439");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    private void mensagemCaixaSemMovimentacao() {
        if (this.panelCaixa.getComponentCount() > 0) {
            this.panelCaixa.removeAll();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel l = new JLabel("Movimenta\u00e7\u00e3o de caixa n\u00e3o permitida para o conv\u00eanio");
                l.setVerticalAlignment(0);
                l.setHorizontalAlignment(0);
                CaixaRecepcao.this.panelCaixa.add((Component)l, "Center");
                CaixaRecepcao.this.panelCaixa.revalidate();
                CaixaRecepcao.this.panelCaixa.repaint();
            }
        });
    }

    private void mensagemCaixaSemRequisicao() {
        if (this.panelCaixa.getComponentCount() > 0) {
            this.panelCaixa.removeAll();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel l = new JLabel("Selecione uma requisi\u00e7\u00e3o para pagamento");
                l.setVerticalAlignment(0);
                l.setHorizontalAlignment(0);
                CaixaRecepcao.this.panelCaixa.add((Component)l, "Center");
                CaixaRecepcao.this.panelCaixa.revalidate();
                CaixaRecepcao.this.panelCaixa.repaint();
            }
        });
    }

    private void pesquisarFilial() {
        Hashtable resultado = Pesquisas.filial(this.getTopLevelAncestor(), false);
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void habilitaMenuOpcoes() {
        this.itemImprimirComprovante.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_COMPROVANTE));
        this.itemImprimirRecibo.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_RECIBO));
        this.itemImprimirCapa.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_CAPA));
        this.itemImprimirAnexo.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_ANEXO));
        this.itemImprimirAtestadoPaciente.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_ATESTADO_PACIENTE));
        this.itemImprimirAtestadoAcompanhante.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_ATESTADO_ACOMPANHANTE));
        this.itemImprimirAnexoCobranca.setVisible(Acesso.getAcesso(this.ACESSO_IMPRIMIR_ANEXO_COBRANCA));
    }

    private boolean buscaRequisicao() {
        boolean retorno;
        Hashtable resultado = Pesquisas.requisicao(this.getTopLevelAncestor(), this.getCodigoFilial(), false, false, false);
        boolean bl = retorno = resultado != null;
        if (resultado != null) {
            this.txtCodRequisicao.setText(resultado.get("req_codigo").toString());
        }
        this.txtCodRequisicao.requestFocus();
        return retorno;
    }

    private void posicionaComponentes() {
        int diferenca;
        this.panelCaixa.setBounds(new Rectangle(5, 46, this.panelCentro.getWidth() - 8, this.panelCentro.getHeight() - 46));
        this.revalidate();
        int n = diferenca = this.integrar ? 175 : 0;
        if (this.integrar) {
            this.labelFilial.setBounds(new Rectangle(this.panelCaixa.getX(), 7, 75, 14));
            this.textFilial.setBounds(new Rectangle(this.panelCaixa.getX() + 73, 5, 80, 20));
            this.buttonFilial.setBounds(new Rectangle(this.panelCaixa.getX() + 154, 5, 20, 20));
        } else {
            this.labelFilial.setVisible(false);
            this.textFilial.setVisible(false);
            this.buttonFilial.setVisible(false);
        }
        this.labelRequisicao.setBounds(new Rectangle(this.panelCaixa.getX() + diferenca, 7, 75, 14));
        this.txtCodRequisicao.setBounds(new Rectangle(this.panelCaixa.getX() + 73 + diferenca, 5, 80, 20));
        this.labelVPaciente.setBounds(new Rectangle(this.panelCaixa.getX() + 175 + diferenca, 5, this.panelCentro.getWidth() - (this.panelCaixa.getX() + 180) - diferenca, 20));
        this.buttonBuscaRequisicao.setBounds(new Rectangle(this.panelCaixa.getX() + 155 + diferenca, 5, 20, 20));
        this.labelConvenio.setBounds(new Rectangle(this.panelCaixa.getX(), 28, 140, 14));
        this.labelVConvenio.setBounds(new Rectangle(this.panelCaixa.getX() + 73, 26, this.panelCentro.getWidth() / 2 - (this.panelCaixa.getX() + 78), 20));
        this.labelMedico.setBounds(new Rectangle(this.labelVConvenio.getX() + this.labelVConvenio.getWidth() + 5, 28, 140, 14));
        this.labelVMedico.setBounds(new Rectangle(this.labelMedico.getX() + 55, 26, this.panelCentro.getWidth() / 2 - (this.panelCaixa.getX() + 55), 20));
    }

    private String getCodigoFilial() {
        if (!Funcoes.textoVazio(this.textFilial.getText())) {
            return this.textFilial.getText();
        }
        return Variaveis.filialPadrao;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0201000100");
    }

    public void defineAcessos() {
        this.buttonFechar.setVisible(Acesso.getAcesso(CaixaRecepcao.getModuloAcesso()));
    }

    private void limpaCampos() {
        this.modeloExame.clear();
        this.txtCodRequisicao.clear();
        this.labelVPaciente.setText("");
        this.labelVConvenio.setText("");
        this.labelVMedico.setText("");
        this.labelDataPrevista.setText("");
        this.saldo = 0.0;
        this.status = 1;
        this.caixa.limpaValores();
        this.convenio = null;
        this.convenioRepasse = null;
        this.deviaGuiaRepasse = false;
        this.codigoPaciente = -1;
        this.caixa = new Caixa(this);
        this.posicionaComponentes();
        this.controlaCampos(false);
    }

    private void controlaCampos(boolean habilitaRequisicao) {
        this.controlaCampos(habilitaRequisicao, true);
    }

    private void controlaCampos(boolean habilitaRequisicao, boolean mudarFoco) {
        this.buttonNovo.setEnabled(this.status == 1);
        this.buttonSalvar.setEnabled(this.status == 3 && this.convenioMovimentaCaixa);
        this.buttonCancelar.setEnabled(this.status == 3);
        this.buttonFechar.setEnabled(this.status == 1);
        this.buttonImprimir.setEnabled(this.status == 3);
        this.buttonExames.setEnabled(this.status == 3);
        this.txtCodRequisicao.setEnabled(habilitaRequisicao);
        this.buttonBuscaRequisicao.setEnabled(habilitaRequisicao);
        this.textFilial.setEnabled(habilitaRequisicao);
        this.buttonFilial.setEnabled(habilitaRequisicao);
        if (mudarFoco && habilitaRequisicao && this.status == 1) {
            if (this.integrar) {
                ScreenUtil.requisitarFoco(this.textFilial);
            } else {
                ScreenUtil.requisitarFoco(this.txtCodRequisicao);
            }
        }
        this.itemImprimirNotaFiscal.setVisible(Acesso.getAcesso(this.ACESSO_GERAR_NOTA_FISCAL) && this.caixa.getValorRecebido() > 0.0);
    }

    private void cancelar() {
        this.limpaCampos();
        this.status = 1;
        this.mensagemCaixaSemRequisicao();
    }

    private void novo() {
        this.limpaCampos();
        this.status = 1;
        this.controlaCampos(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean salvar(boolean limpaCampos) {
        Statement st;
        boolean retorno;
        block14: {
            retorno = false;
            this.caixa.validarFinalizar();
            int podeSalvar = 0;
            podeSalvar = this.caixa.podeSalvarCaixa();
            if (podeSalvar != 0) {
                if (podeSalvar == 1) {
                    Funcoes.mensagem(this, "O pagamento n\u00e3o pode ser gravado pois as informa\u00e7\u00f5es de caixa est\u00e3o incompletas", 1);
                }
                return false;
            }
            if (this.caixa.getValorDesconto() > this.caixa.getValorExames() + this.caixa.getValorMateriais() + this.caixa.getValorAcrescimo() + this.caixa.getTotalTaxa().doubleValue()) {
                Funcoes.mensagem(this, "Valor de desconto no caixa acima do valor permitido", 1);
                this.caixa.posicionaFoco(2);
                return false;
            }
            if (this.caixa.getSaldo() - this.caixa.getValorRecebido() > 0.0 && this.caixa.getConvenioRepasseSelecionado() == null && Funcoes.mensagem(this, "A requisi\u00e7\u00e3o est\u00e1 com saldo devedor, deseja manter esse saldo?", 4) == 1) {
                return false;
            }
            st = Conexao.getStatement();
            try {
                CaixaRecepcaoService serviceCaixaRecepcao = new CaixaRecepcaoService();
                boolean repasseSelecionado = serviceCaixaRecepcao.atualizaRequisicao(this.caixa, this.getCodigoFilial(), this.txtCodRequisicao.getText(), this.deviaGuiaRepasse);
                String[] comandoExameRequisicao = new String[8];
                comandoExameRequisicao[0] = "codigoBase";
                comandoExameRequisicao[1] = Variaveis.codigoBaseWeb;
                comandoExameRequisicao[2] = "codigoRequisicao";
                comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(this.getCodigoFilial(), this.txtCodRequisicao.getText(), st);
                comandoExameRequisicao[4] = "valorRequisicao";
                comandoExameRequisicao[5] = repasseSelecionado ? "0" : Funcoes.limpaDecimal(String.valueOf(this.caixa.getValorTotal()));
                comandoExameRequisicao[6] = "valorPagoRequisicao";
                ValorPagoVO valorPagoVO = serviceCaixaRecepcao.buscaValorPago(this.getCodigoFilial(), this.txtCodRequisicao.getText());
                comandoExameRequisicao[7] = Funcoes.limpaDecimal(String.valueOf(valorPagoVO.getValorTotalPago()));
                DBUtil.insereExportaWeb(this.getCodigoFilial(), st, "requisicao", valorPagoVO.isCodigoDestinoEnviarWeb() ? "A" : "D", comandoExameRequisicao);
                if (repasseSelecionado || this.convenioRepasse != null) {
                    String tipoCalculo = "P";
                    if (repasseSelecionado) {
                        tipoCalculo = ConvenioUtil.getTipoCalculoConvenioRepasse(st, this.getCodigoFilial(), String.valueOf(this.convenio.getCodigo()), String.valueOf(this.caixa.getConvenioRepasseSelecionado().getCodigo()));
                    }
                    for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
                        DadosExames dadosExame = (DadosExames)this.modeloExame.getValueAt(i, 6);
                        DadosMaterial dadosMaterial = (DadosMaterial)this.modeloExame.getValueAt(i, 1);
                        serviceCaixaRecepcao.atualizarExameRequisicao(dadosExame, dadosMaterial, this.convenioRepasse, this.caixa.getConvenioRepasseSelecionado(), this.getCodigoFilial(), this.txtCodRequisicao.getText(), tipoCalculo, repasseSelecionado);
                    }
                }
                this.caixa.gravarValores(this.getCodigoFilial(), Long.parseLong(this.txtCodRequisicao.getText()), limpaCampos, true);
                Conexao.arquivaSQL();
                retorno = true;
                if (limpaCampos) {
                    this.limpaCampos();
                    this.controlaCampos(false);
                    this.mensagemCaixaSemRequisicao();
                    break block14;
                }
                SplashMensagem splash = new SplashMensagem();
                splash.mostrar("Atualizando valores de caixa");
                this.mostraDadosRequisicao(this.txtCodRequisicao.getText(), false);
                splash.apagar();
            }
            catch (Exception sqlex) {
                try {
                    try {
                        Conexao.anulaSQL();
                        ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "CaixaRecepcao (798)");
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "CaixaRecepcao (801)");
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mostraDadosRequisicao(String codigo, boolean mostrarMensagens) {
        Statement st3;
        Statement st2;
        Statement st;
        block22: {
            if (codigo == null || Funcoes.textoVazio(codigo)) {
                this.txtCodRequisicao.clear();
                this.txtCodRequisicao.grabFocus();
                return;
            }
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            st3 = Conexao.getStatement();
            StringBuffer buf = new StringBuffer("select d.fil_codigo as filialpaciente, d.pac_nome, d.pac_cpf, a.req_total, a.req_totpago, d.pac_foto, d.pac_imprimircarteira, ");
            buf.append("d.pac_sexo, b.con_fantasia, c.med_nome, a.req_notacaixa, a.req_desconto, a.req_vlrdesconto, a.pac_codigo, ");
            buf.append(" a.req_acrescimo, a.req_vlracrescimo, a.req_vlrexames, a.req_vlrmateriais, a.con_codigo, ");
            buf.append("a.req_dataentregaprev, a.req_horaentregaprev, a.req_avisarpaciente, a.req_deveguia, a.req_data, a.req_obs, ");
            buf.append("a.con_codrepasse, a.req_guiarepasse, a.req_matricularepasse, a.req_validadeguiarepasse,  ");
            buf.append("a.req_validadecarteirarepasse, a.req_guiaprincipalrepasse, coalesce(a.req_deveguiarepasse, false) as req_deveguiarepasse, a.req_nomeplanorepasse ");
            buf.append(" ,COALESCE(pac_nomepagador, pac_nome) as nomePagador, COALESCE(pac_cpfpagador, pac_cpf) as cpfPagador, req_totaltaxa  as totalTaxa, b.con_utilizarcasasdecimais, b.con_tipoarredondamentopreco, b.con_casasprecoexame ");
            buf.append("from requisicao a ");
            buf.append("left join paciente d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo ");
            buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            buf.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf = c.med_uf ");
            buf.append("where a.fil_codigo = ");
            buf.append(this.getCodigoFilial());
            buf.append(" and a.req_codigo = ");
            buf.append(codigo);
            buf.append(" and a.req_excluida = false ");
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.convenio = ConvenioUtil.getDadosConvenios(this.getCodigoFilial(), rs.getInt("con_codigo"));
                    this.caixa.setDadosConvenio(this.convenio);
                    if (rs.getDouble("req_totpago") < rs.getDouble("req_total")) {
                        this.saldo = rs.getDouble("req_total") - rs.getDouble("req_totpago");
                    }
                    this.caixa.limpaValores();
                    this.caixa.setValorExames(rs.getDouble("req_vlrexames"));
                    this.caixa.setValorMateriais(rs.getDouble("req_vlrmateriais"));
                    this.caixa.setTotalTaxa(rs.getBigDecimal("totalTaxa"));
                    this.caixa.setPercentualAcrescimo(Funcoes.textoVazio(rs.getString("req_acrescimo")) ? 0.0 : rs.getDouble("req_acrescimo"));
                    this.caixa.setValorAcrescimo(Funcoes.textoVazio(rs.getString("req_vlracrescimo")) ? 0.0 : rs.getDouble("req_vlracrescimo"));
                    this.caixa.setPercentualDesconto(Funcoes.textoVazio(rs.getString("req_desconto")) ? 0.0 : rs.getDouble("req_desconto"));
                    this.caixa.setValorDesconto(Funcoes.textoVazio(rs.getString("req_vlrdesconto")) ? 0.0 : rs.getDouble("req_vlrdesconto"));
                    this.caixa.setDestacarSaldo(true);
                    this.caixa.setFilial(this.getCodigoFilial());
                    this.caixa.setConveniosRepasse(ConvenioUtil.getConveniosRepasse(st2, st3, this.getCodigoFilial(), String.valueOf(this.convenio.getCodigo())));
                    this.caixa.setPermitirEstornarRepasseConvenio(Acesso.getAcesso(this.ACESSO_ESTORNO_REPASSE_CAIXA));
                    if (!DBUtil.campoNull(rs.getString("con_codrepasse"))) {
                        this.convenioRepasse = ConvenioUtil.getDadosConvenios(this.getCodigoFilial(), rs.getInt("con_codrepasse"));
                        this.caixa.setConvenioRepasseSelecionado(this.convenioRepasse);
                    }
                    this.deviaGuiaRepasse = rs.getBoolean("req_deveguiarepasse");
                    this.caixa.setGuiaPrincipalRepasse(rs.getString("req_guiaprincipalrepasse"));
                    this.caixa.setGuiaRepasse(rs.getString("req_guiarepasse"));
                    this.caixa.setMatriculaRepasse(rs.getString("req_matricularepasse"));
                    this.caixa.setDeveGuiaRepasse(rs.getBoolean("req_deveguiarepasse"));
                    this.caixa.setValidadeCarteiraRepasse(rs.getDate("req_validadecarteirarepasse"));
                    this.caixa.setValidadeGuiaRepasse(rs.getDate("req_validadeguiarepasse"));
                    this.caixa.setPlanoRepasse(rs.getString("req_nomeplanorepasse"));
                    this.caixa.setObs(rs.getString("req_notacaixa"));
                    this.caixa.setDadosPagador(rs.getInt("pac_codigo"), rs.getString("nomePagador"), rs.getString("cpfPagador"));
                    this.caixa.setDataRequisicao(rs.getDate("req_data"));
                    this.caixa.setHabilitaAcrescimoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_ACRESCIMO));
                    this.caixa.setHabilitaDescontoPago(Acesso.getAcesso(this.ACESSO_ALTERAR_DESCONTO));
                    this.caixa.setPermitirEstornoPagamento(Acesso.getAcesso(this.ACESSO_ESTORNAR_PAGAMENTO));
                    this.caixa.setMovimentarCaixa(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_CAIXA));
                    this.caixa.setAlterarData(Acesso.getAcesso(this.ACESSO_ALTERAR_DATA_CAIXA));
                    boolean exigir = ParametrosGerais.getExigirDadosPagadorDmed() ? !Acesso.getAcesso(this.ACESSO_SALVAR_SEM_PAGADOR) : false;
                    this.caixa.setSalvarSemPagador(!exigir);
                    this.caixa.setAlterarConta(Acesso.getAcesso(this.ACESSO_ALTERAR_CONTA_CAIXA));
                    this.caixa.setNaoMovimentarCaixaSemPagamento(Acesso.getAcesso(this.ACESSO_MOVIMENTAR_SEM_PAGAMENTO));
                    this.caixa.setDadosConvenio(this.convenio);
                    this.caixa.setCodigoRequisicao(this.getCodigoFilial(), Integer.parseInt(codigo), true);
                    this.codigoPaciente = rs.getInt("pac_codigo");
                    this.labelVPaciente.setText(rs.getString("pac_nome"));
                    this.labelVConvenio.setText(rs.getString("con_fantasia"));
                    this.labelVMedico.setText(rs.getString("med_nome"));
                    if (!rs.getBoolean("req_avisarpaciente")) {
                        String data = DBUtil.campoNull(rs.getString("req_dataentregaprev")) ? "" : Funcoes.formataData(rs.getDate("req_dataentregaprev"));
                        String hora = DBUtil.campoNull(rs.getString("req_horaentregaprev")) ? "" : Funcoes.formataHora(rs.getTime("req_horaentregaprev"), false);
                        this.labelDataPrevista.setText(data + " \u00e0s " + hora);
                    } else {
                        this.labelDataPrevista.setText("Avisar paciente");
                    }
                    if (rs.getBoolean("req_deveguia") && mostrarMensagens) {
                        Funcoes.mensagem(this, "Requisi\u00e7\u00e3o sem guia", 2);
                    }
                    if (rs.getBoolean("pac_imprimircarteira")) {
                        Funcoes.mensagem(this, "O paciente tem carteira para ser impressa", 2);
                    }
                    String obs = rs.getString("req_obs");
                    String paciente = rs.getString("pac_codigo");
                    String mensagem = RecepcaoUtil.getMensagemPendenciaPaciente(st, this.getCodigoFilial(), paciente, codigo);
                    if (mostrarMensagens && (!Funcoes.textoVazio(mensagem) || Funcoes.textoVazio(mensagem) && !Funcoes.textoVazio(obs) && ParametrosGerais.getPendenciaPaciente() != 0)) {
                        PendenciasPaciente pendenciasPaciente;
                        String titulo = "Alerta";
                        String[] opcoes = new String[]{"OK", "Ver pend\u00eancias"};
                        char[] atalho = new char[]{'O', 'V'};
                        int resposta = Funcoes.showPerguntaOpcoes(Laboratorio.getInstancia(), titulo, mensagem, opcoes, atalho, 2);
                        if (resposta == 1 && !Funcoes.objectIsNull(pendenciasPaciente = PendenciasPaciente.novaInstancia(this))) {
                            pendenciasPaciente.carregaRequisicoes(this.textFilial.getText().trim(), paciente.trim(), codigo);
                            pendenciasPaciente.setVisible(true);
                        }
                    }
                    this.modeloExame.clear();
                    buf.delete(0, buf.length());
                    buf.append("select a.exa_codigo, a.mco_codigo, a.exr_datamaterial, a.exr_dataentregaprev, ");
                    buf.append("a.exr_situacao, a.exr_vlrchexame, COALESCE(a.exr_vlrexame, 0) as exr_vlrexame, a.exr_vlrmaterial, a.exr_valorporte, ");
                    buf.append("a.exr_valorcusto, a.exr_porte, a.exr_valoruco, a.exr_valorchexamerepasse, ");
                    buf.append("a.exr_valorchrepasse, a.exr_valorporterepasse, a.exr_valorcustorepasse, ");
                    buf.append("a.exr_valorucorepasse, a.exr_porterepasse, COALESCE(a.exr_vlrbalcaoconvenio, 0) as exr_vlrbalcaoconvenio ");
                    buf.append("from examerequisicao a ");
                    if (ParametrosGerais.getOrdenarSetor()) {
                        buf.append("left join examesetor b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
                    }
                    buf.append("left join examematcoleta d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.mco_codigo = d.mco_codigo ");
                    buf.append("where a.fil_codigo = ");
                    buf.append(this.getCodigoFilial());
                    buf.append(" and a.req_codigo = ");
                    buf.append(codigo);
                    buf.append(" and a.exr_excluido = false ");
                    if (ParametrosGerais.getOrdenarSetor()) {
                        buf.append(" and b.ese_default = true ");
                    }
                    buf.append("order by ");
                    if (ParametrosGerais.getOrdenarSetor()) {
                        buf.append("b.set_codigo, ");
                    }
                    buf.append("d.emc_pagina, d.emc_ordem, a.exa_codigo, a.mco_codigo ");
                    rs = Conexao.executeQuery(st, buf.toString());
                    double percentualBalcaoConvenio = 0.0;
                    while (rs.next()) {
                        percentualBalcaoConvenio = rs.getDouble("exr_vlrbalcaoconvenio");
                        DadosMaterial mat = ExameUtil.getDadosMaterial(this.getCodigoFilial(), rs.getInt("mco_codigo"));
                        DadosExames d = ExameUtil.getDadosExame(this.getCodigoFilial(), rs.getString("exa_codigo"), mat);
                        mat.setShowAbreviatura(true);
                        d.setValorCH(rs.getBigDecimal("exr_vlrchexame"));
                        d.setValorExame(rs.getBigDecimal("exr_vlrexame"));
                        d.setValorMaterial(rs.getBigDecimal("exr_vlrmaterial"));
                        d.setValor(d.getValorExame().add(d.getValorMaterial()));
                        d.setValorPorte(rs.getBigDecimal("exr_valorporte"));
                        d.setCusto(rs.getBigDecimal("exr_valorcusto"));
                        d.setPorte(rs.getString("exr_porte"));
                        d.setUco(rs.getBigDecimal("exr_valoruco"));
                        d.setValorExameRepasse(rs.getBigDecimal("exr_valorchexamerepasse"));
                        d.setValorCHRepasse(rs.getBigDecimal("exr_valorchrepasse"));
                        d.setValorPorteRepasse(rs.getBigDecimal("exr_valorporterepasse"));
                        d.setCustoRepasse(rs.getBigDecimal("exr_valorcustorepasse"));
                        d.setPorteRepasse(rs.getString("exr_porterepasse"));
                        d.setUcoRepasse(rs.getBigDecimal("exr_valorucorepasse"));
                        this.modeloExame.addLine(new Object[]{d.getCodigo(), mat, d.getDescricao(), DBUtil.campoNull(rs.getString("exr_datamaterial")) ? null : Funcoes.timestampToDate(rs.getString("exr_datamaterial")), DBUtil.campoNull(rs.getString("exr_dataentregaprev")) ? null : Funcoes.timestampToDate(rs.getString("exr_dataentregaprev")), rs.getString("exr_situacao"), d});
                    }
                    this.status = 3;
                    Set requisicaoTaxaBeans = new RequisicaoTaxaService().load(" where fil_codigo = " + this.getCodigoFilial() + " and req_codigo = " + codigo);
                    if (requisicaoTaxaBeans != null && !requisicaoTaxaBeans.isEmpty()) {
                        this.convenioMovimentaCaixa = true;
                    } else {
                        boolean bl = this.convenioMovimentaCaixa = this.convenio.getCobraExame() && this.convenio.getPercentualBalcao() > 0.0 || this.convenio.getPercentualBalcaoMaterial() > 0.0 || this.convenio.isPerguntarPercentualBalcaoExames() && percentualBalcaoConvenio > 0.0;
                    }
                    if (this.convenioMovimentaCaixa) {
                        this.panelCaixa.removeAll();
                        this.panelCaixa.add(this.caixa);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CaixaRecepcao.this.panelCaixa.revalidate();
                                CaixaRecepcao.this.panelCaixa.repaint();
                                CaixaRecepcao.this.caixa.repaint();
                                CaixaRecepcao.this.caixa.posicionaFoco(1);
                            }
                        });
                    } else {
                        this.mensagemCaixaSemMovimentacao();
                    }
                    break block22;
                }
                Funcoes.mensagem(this, "Requisi\u00e7\u00e3o n\u00e3o localizada", 2);
                this.txtCodRequisicao.selectAll();
                ScreenUtil.requisitarFoco(this.txtCodRequisicao);
            }
            catch (Exception sqlex) {
                try {
                    ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "ReceberMaterial (1402)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2, st3);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2, st3);
            }
        }
        Conexao.fecharStatement(st, st2, st3);
        this.controlaCampos(this.status == 1, false);
    }

    public void setFlagDialogAberto(boolean isAberto) {
        this.flagDialogAberto = isAberto;
        this.desabilitaMenus();
    }

    public void desabilitaMenus() {
    }

    @Override
    public void pressioneiF2() {
        if (this.txtCodRequisicao.hasFocus()) {
            this.buscaRequisicao();
        } else if (this.textFilial.hasFocus()) {
            this.pesquisarFilial();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonExames) {
            this.mostrarExames();
        }
    }

    private void mostrarExames() {
        MostrarExames m = MostrarExames.novaInstancia((Frame)this.getTopLevelAncestor());
        m.setTabelaExames(this.tableExame);
        m.setLocationRelativeTo(this.getTopLevelAncestor());
        m.setVisible(true);
    }

    @Override
    public void valorEstornado(double valor) {
    }

    @Override
    public void repasseEstornado(DadosConvenios convenio) {
        BigDecimal totalExames = new BigDecimal(0);
        BigDecimal totalMateriais = new BigDecimal(0);
        for (int i = 0; i < this.modeloExame.getRowCount(); ++i) {
            if (!(this.modeloExame.getValueAt(i, 6) instanceof DadosExames)) continue;
            DadosExames e = (DadosExames)this.modeloExame.getValueAt(i, 6);
            totalExames = totalExames.add(e.getValorExame());
            totalMateriais = totalMateriais.add(e.getValorMaterial());
        }
        if (convenio != null && convenio.getCobraExame() && convenio.getValorMinimoRequisicao() > 0.0 && totalExames.compareTo(new BigDecimal(convenio.getValorMinimoRequisicao())) < 0) {
            this.caixa.setValorExames(convenio.getValorMinimoRequisicao());
        } else {
            this.caixa.setValorExames(totalExames.doubleValue());
        }
        this.caixa.setValorMateriais(totalMateriais.doubleValue());
    }
}

