/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.caixa.modeloscaixa;

import jalis.comum.dados.DadosConvenios;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.Pagamento;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.util.Date;

public class PagamentoRepasse
extends Pagamento {
    public DadosConvenios convenio = null;
    public String codigoGuia = null;
    public String codigoGuiaPrincipal = null;
    public Date validadeGuia = null;
    public Date validadeCarteira = null;
    public boolean deveGuia = false;
    public boolean isFaturado = false;
    public String plano = null;
    public String matricula = null;
    public String usuarioFaturamento = null;
    public Date dataFaturamento = null;
    public boolean isIBCM = false;

    public PagamentoRepasse(String usuario, Date dataHora, double valor, String tipoPagamento, boolean salvo, boolean faturado, boolean isIBCM) {
        super(null, null, null, null, usuario, dataHora, null, tipoPagamento, null, valor, salvo, null, null, null);
        this.isFaturado = faturado;
        this.isIBCM = isIBCM;
    }

    @Override
    public boolean isOk(Caixa caixa) {
        if (this.deveGuia) {
            return true;
        }
        if (this.convenio == null) {
            Funcoes.mensagem(caixa, "O conv\u00eanio deve ser selecionado.", 2);
            ScreenUtil.requisitarFoco(caixa.comboRepasse);
            return false;
        }
        if (this.convenio.isObrigaNomePlano() && Funcoes.textoVazio(this.plano)) {
            Funcoes.mensagem(caixa, "Plano ser preenchido.", 2);
            ScreenUtil.requisitarFoco(caixa.textPlano);
            return false;
        }
        if (this.convenio.getValidadeGuia() && this.validadeGuia == null) {
            Funcoes.mensagem(caixa, "A validade da guia deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(caixa.textValidadeGuia);
            return false;
        }
        if (this.convenio.getExigeCodigoGuia() && Funcoes.textoVazio(this.codigoGuia)) {
            Funcoes.mensagem(caixa, "O c\u00f3digo da guia deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(caixa.textGuia);
            return false;
        }
        if (this.convenio.isObrigaValidadeCarteira() && this.validadeCarteira == null) {
            Funcoes.mensagem(caixa, "A validade da carteira deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(caixa.textValidadeCartao);
            return false;
        }
        if (this.convenio.getExigeMatricula() && Funcoes.textoVazio(this.matricula)) {
            Funcoes.mensagem(caixa, "A matr\u00edcula deve ser preenchida.", 2);
            ScreenUtil.requisitarFoco(caixa.textMatricula);
            return false;
        }
        return true;
    }
}

