/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.caixa.modeloscaixa;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.ContaCorrente;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.util.Date;

public class Pagamento {
    public Integer codigoFilial = -1;
    public Integer codigoLancamento = -1;
    public Integer codigoEstacao = -1;
    public ContaCorrente contaCaixa = null;
    public String usuario = null;
    public Date dataHora = null;
    public String tipoLancamento = null;
    public String tipoPagamento = null;
    public Double valor = null;
    public boolean salvo;
    public int tipoApropriacao = -1;
    public String situacao = null;
    public String codigoNotaFiscal;
    public String numeroNotaFiscal;
    public String serieNotaFiscal;
    public String numeroRpsNotaFiscal;
    public String situacaoNotaFiscal;
    public boolean adicionado;
    public MotivoCancelamentoVO motivoEstornado;
    public LancamentoBean lancamento = null;
    public LancamentoBean lancamentoDestino = null;

    public Pagamento(LancamentoBean lancamento, String situacao, boolean salvo) {
        ContaCorrente conta = new ContaCorrente();
        conta.setReduzido(lancamento.getContaCorrente() == null ? null : lancamento.getContaCorrente().getReduzido());
        conta.setConta(lancamento.getContaCorrente() == null ? null : lancamento.getContaCorrente().getConta());
        this.valor = lancamento.getValorTotal();
        this.codigoFilial = lancamento.getFilial().getCodigo();
        this.codigoLancamento = lancamento.getCodigo();
        this.codigoEstacao = lancamento.getEstacao().getCodigo();
        this.usuario = lancamento.getUsuario().getCodigo();
        this.dataHora = lancamento.getDataHora();
        this.tipoLancamento = lancamento.getTipo();
        this.tipoPagamento = lancamento.getTipoPagamento();
        this.contaCaixa = conta;
        this.codigoNotaFiscal = lancamento.getNotaFiscal() == null || lancamento.getNotaFiscal().getCodigo() == null ? null : lancamento.getNotaFiscal().getCodigo().toString();
        this.numeroNotaFiscal = lancamento.getNotaFiscal() == null || lancamento.getNotaFiscal().getNumero() == null ? null : lancamento.getNotaFiscal().getNumero().toString();
        this.numeroRpsNotaFiscal = lancamento.getNotaFiscal() == null || lancamento.getNotaFiscal().getNumeroRps() == null ? null : lancamento.getNotaFiscal().getNumeroRps().toString();
        this.situacaoNotaFiscal = lancamento.getNotaFiscal() == null || lancamento.getNotaFiscal().getSituacao() == null ? null : lancamento.getNotaFiscal().getSituacao().toString();
        this.serieNotaFiscal = lancamento.getNotaFiscal() == null || lancamento.getNotaFiscal().getSerie() == null ? null : lancamento.getNotaFiscal().getSerie().getCodigo();
        this.situacao = situacao;
        this.salvo = salvo;
        this.lancamentoDestino = lancamento.getLancamentoDestinoTransferencia();
        this.tipoApropriacao = 4;
    }

    public Pagamento(Integer codigoFilial, Integer codigoLancamento, Integer codigoEstacao, ContaCorrente contaCaixa, String usuario, Date dataHora, String tipoLancamento, String tipoPagamento, String situacao, double valor, boolean salvo, String codigoNotaFiscal, String numeroNotaFiscal, String serieNotaFiscal) {
        this.valor = valor;
        this.codigoFilial = codigoFilial;
        this.codigoLancamento = codigoLancamento;
        this.codigoEstacao = codigoEstacao;
        this.contaCaixa = contaCaixa;
        this.usuario = usuario;
        this.dataHora = dataHora;
        this.tipoLancamento = tipoLancamento;
        this.tipoPagamento = tipoPagamento;
        this.situacao = situacao;
        this.codigoNotaFiscal = codigoNotaFiscal;
        this.numeroNotaFiscal = numeroNotaFiscal;
        this.serieNotaFiscal = serieNotaFiscal;
        this.salvo = salvo;
        this.tipoApropriacao = 4;
    }

    public boolean isNotaFiscalGerada() {
        return this.codigoNotaFiscal != null;
    }

    public boolean isOk(Caixa caixa) {
        if (this.codigoFilial == -1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Filial n\u00e3o preenchida - Pagamento. ", null);
            return false;
        }
        if (this.codigoEstacao == -1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Esta\u00e7\u00e3o n\u00e3o preenchida - Pagamento. ", null);
            return false;
        }
        if (this.contaCaixa == null) {
            Funcoes.mensagem(caixa, "A conta caixa deve ser selecionada.", 2);
            ScreenUtil.requisitarFoco(caixa.comboCaixa);
            return false;
        }
        if (this.dataHora == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Data/hora n\u00e3o preenchida - Pagamento. ", null);
            return false;
        }
        if (this.situacao == null) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Situa\u00e7\u00e3o n\u00e3o preenchida - Pagamento. ", null);
            return false;
        }
        if (Funcoes.textoVazio(this.tipoLancamento)) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Tipo de lan\u00e7amento n\u00e3o preenchido - Pagamento. ", null);
            return false;
        }
        if (Funcoes.textoVazio(this.tipoPagamento)) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Tipo de pagamento n\u00e3o preenchido - Pagamento. ", null);
            return false;
        }
        if (this.valor == null || this.valor == 0.0) {
            this.valor = caixa.getValorTotal() - caixa.getValorRecebido();
        }
        return true;
    }

    public void setSalvo(boolean salvo) {
        this.salvo = salvo;
    }
}

