/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.caixa;

import jalis.comum.Tipos;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.Pagamento;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoBoleto;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoCartao;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoCheque;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoChequePreDatado;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoDeposito;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoFuncionario;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoPix;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoPromissoria;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoRepasse;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoTransferenciaBancaria;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.service.financeiro.LancamentoService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.MatteBorder;

public class ListRenderer
extends JLabel
implements ListCellRenderer {
    private boolean exibirInfoAdicionais = false;

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            Pagamento aux = (Pagamento)value;
            this.setFont(new Font(this.getFont().getName(), 0, 11));
            StringBuilder buf = new StringBuilder("");
            buf.append("<html>");
            if (this.exibirInfoAdicionais && aux != null) {
                this.pegaNomePagador(aux, buf);
            }
            if (aux != null && aux.tipoPagamento != null) {
                buf.append("<b>Tipo:</b> ").append(Tipos.tipoPagamento(aux.tipoPagamento)).append("<br>");
            }
            if (aux != null && aux.dataHora != null) {
                if (this.exibirInfoAdicionais) {
                    buf.append("<b>Data/Hora:</b> ").append(Funcoes.formataData("dd/MM/yyyy - HH:mm", aux.dataHora)).append("<br>");
                } else {
                    buf.append("<b>Data:</b> ").append(Funcoes.formataData("dd/MM/yyyy", aux.dataHora)).append("<br>");
                }
            }
            if (aux != null && aux.contaCaixa != null) {
                buf.append("<b>Conta:</b> ").append(aux.contaCaixa.getConta()).append("<br>");
            }
            if (aux != null && aux.usuario != null) {
                buf.append("<b>Usu\u00e1rio:</b> ").append(aux.usuario).append("<br>");
            }
            if (aux instanceof PagamentoCartao) {
                buf.append("<b>Bandeira:</b> ").append(((PagamentoCartao)aux).bandeira).append("<br>");
                buf.append("<b>N\u00fam.:</b> ").append(((PagamentoCartao)aux).numero).append("<br>");
                buf.append("<b>Validade:</b> ").append(Funcoes.formataData("MM/yy", ((PagamentoCartao)aux).validade)).append("<br>");
            }
            if (aux instanceof PagamentoTransferenciaBancaria) {
                buf.append("<b>Banco:</b> ").append(((PagamentoTransferenciaBancaria)aux).banco).append("<br>");
                buf.append("<b>Ag\u00eancia:</b> ").append(((PagamentoTransferenciaBancaria)aux).agencia).append("<br>");
                buf.append("<b>Conta:</b> ").append(((PagamentoTransferenciaBancaria)aux).conta).append("<br>");
                buf.append("<b>Transfer\u00eancia:</b> ").append(((PagamentoTransferenciaBancaria)aux).transferencia).append("<br>");
            }
            if (aux instanceof PagamentoCheque) {
                buf.append("<b>Banco:</b> ").append(((PagamentoCheque)aux).banco).append("<br>");
                buf.append("<b>Ag\u00eancia:</b> ").append(((PagamentoCheque)aux).agencia).append("<br>");
                buf.append("<b>Conta:</b> ").append(((PagamentoCheque)aux).conta).append("<br>");
                buf.append("<b>N\u00famero:</b> ").append(((PagamentoCheque)aux).numeroCheque).append("<br>");
            }
            if (aux instanceof PagamentoChequePreDatado) {
                buf.append("<b>Vencimento:</b> ").append(Funcoes.formataData("dd/MM/yyyy", ((PagamentoChequePreDatado)aux).data)).append("<br>");
            }
            if (aux instanceof PagamentoPromissoria) {
                buf.append("<b>N\u00famero:</b> ").append(((PagamentoPromissoria)aux).numero).append("<br>");
            }
            if (aux instanceof PagamentoBoleto) {
                buf.append("<b>Documento:</b> ").append(((PagamentoBoleto)aux).documento).append("<br>");
                buf.append("<b>Vencimento:</b> ").append(Funcoes.formataData("dd/MM/yyyy", ((PagamentoBoleto)aux).data)).append("<br>");
            }
            if (aux instanceof PagamentoRepasse) {
                buf.append("<b>Conv\u00eanio:</b> ").append(((PagamentoRepasse)aux).convenio != null ? ((PagamentoRepasse)aux).convenio.getRazaoSocial() : "--------").append("<br>");
                if (((PagamentoRepasse)aux).isIBCM) {
                    buf.append("<b>Cat.IPE:</b> ").append(((PagamentoRepasse)aux).plano).append("<br>");
                } else {
                    buf.append("<b>Plano:</b> ").append(((PagamentoRepasse)aux).plano).append("<br>");
                }
                buf.append("<b>Validade Guia:</b> ").append(Funcoes.formataData("dd/MM/yyyy", ((PagamentoRepasse)aux).validadeGuia)).append("<br>");
                buf.append("<b>Guia:</b> ").append(((PagamentoRepasse)aux).codigoGuia).append("<br>");
                buf.append("<b>Val. Carteira:</b> ").append(Funcoes.formataData("dd/MM/yyyy", ((PagamentoRepasse)aux).validadeCarteira)).append("<br>");
                buf.append("<b>Guia Principal:</b> ").append(((PagamentoRepasse)aux).codigoGuiaPrincipal).append("<br>");
                buf.append("<b>Matr\u00edcula:</b> ").append(((PagamentoRepasse)aux).matricula).append("<br>");
                if (((PagamentoRepasse)aux).deveGuia) {
                    buf.append("<b>Deve guia:</b>").append("<br>");
                }
                if (((PagamentoRepasse)aux).isFaturado) {
                    buf.append("<font color = RED><b>Data Fat.:</b> ").append(Funcoes.formataData("dd/MM/yyyy", ((PagamentoRepasse)aux).dataFaturamento)).append("<br>");
                    buf.append("<b>Usu\u00e1rio Fat.:</b> ").append(((PagamentoRepasse)aux).usuarioFaturamento).append("</font><br>");
                }
            }
            if (aux instanceof PagamentoDeposito) {
                buf.append("<b>Banco:</b> ").append(((PagamentoDeposito)aux).banco).append("<br>");
                buf.append("<b>Ag\u00eancia:</b> ").append(((PagamentoDeposito)aux).agencia).append("<br>");
                buf.append("<b>Conta:</b> ").append(((PagamentoDeposito)aux).conta).append("<br>");
                buf.append("<b>Vencimento:</b> ").append(Funcoes.formataData("dd/MM/yyyy", ((PagamentoDeposito)aux).data)).append("<br>");
            }
            if (aux instanceof PagamentoFuncionario) {
                buf.append("<b>Nome Func.:</b>").append(((PagamentoFuncionario)aux).getNome()).append("<br>");
                buf.append("<b>Setor:</b> ").append(((PagamentoFuncionario)aux).getSetor()).append("<br>");
                buf.append("<b>Autorizado por:</b> ").append(((PagamentoFuncionario)aux).getAutorizadoPor()).append("<br>");
            }
            if (aux == null || aux.tipoLancamento == null || aux.tipoLancamento.equalsIgnoreCase("C")) {
                buf.append("<b>Valor Pago:</b> R$ ").append(Funcoes.formataDecimal(aux.valor)).append("<br>");
            } else {
                buf.append("<b>Valor Estornado:</b> R$ ").append(Funcoes.formataDecimal(aux.valor)).append("<br>");
            }
            if (aux.lancamentoDestino != null) {
                buf.append("<font color = RED><b>Pagamento transferido</b><br>");
                buf.append("&#8195;<b>C\u00f3digo:</b> ").append(aux.lancamentoDestino.getCodigo()).append("<br>");
                buf.append("&#8195;<b>Esta\u00e7\u00e3o:</b> ").append(aux.lancamentoDestino.getEstacao().getCodigo()).append("<br>");
                buf.append("&#8195;<b>Data:</b> ").append(Funcoes.formataData(aux.lancamentoDestino.getDataHora())).append("<br>");
                buf.append("&#8195;<b>Usu\u00e1rio:</b> ").append(aux.lancamentoDestino.getUsuario().getCodigo()).append("<br>");
                buf.append("&#8195;<b>Conta:</b> ").append(aux.lancamentoDestino.getContaCorrente().getConta());
            }
            if (aux instanceof PagamentoPix) {
                buf.append("<b>Banco:</b> ").append(!Funcoes.textoVazio(((PagamentoPix)aux).banco) ? ((PagamentoPix)aux).banco : "").append("<br>");
                buf.append("<b>Ag\u00eancia:</b> ").append(((PagamentoPix)aux).agencia).append("<br>");
                buf.append("<b>Conta:</b> ").append(((PagamentoPix)aux).conta).append("<br>");
            }
            buf.append("</html>");
            this.setText(buf.toString());
            if (aux.salvo) {
                this.setBackground(list.getSelectionBackground());
            } else {
                this.setBackground(list.getBackground());
            }
            Color corBorda = Color.BLACK;
            this.setBorder(new MatteBorder(0, 0, 1, 0, corBorda));
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(aux != null && aux.tipoLancamento != null && aux.tipoLancamento.equalsIgnoreCase("D") ? Color.RED : list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(aux != null && aux.tipoLancamento != null && aux.tipoLancamento.equalsIgnoreCase("D") ? Color.RED : list.getForeground());
            }
        }
        int qtdeLinhas = StringUtil.contaOcorrencias(this.getText(), "<br>");
        this.setSize(20, ++qtdeLinhas * 10);
        this.setOpaque(true);
        return this;
    }

    public void exibirInfoAdicionais() {
        this.exibirInfoAdicionais = true;
    }

    private void pegaNomePagador(Pagamento aux, StringBuilder buf) {
        try {
            if (aux.lancamento != null && !Funcoes.textoVazio(aux.lancamento.getNomePagador())) {
                buf.append("<b>Nome do Pagador:</b> ").append(aux.lancamento.getNomePagador()).append("<br>");
            } else {
                LancamentoBean lanctoBean = (LancamentoBean)new LancamentoService().get(String.valueOf(aux.codigoFilial), String.valueOf(aux.codigoLancamento), String.valueOf(aux.codigoEstacao));
                if (lanctoBean != null) {
                    aux.lancamento = lanctoBean;
                    if (!Funcoes.textoVazio(lanctoBean.getNomePagador())) {
                        buf.append("<b>Nome do Pagador:</b> ").append(lanctoBean.getNomePagador()).append("<br>");
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "Falha ao buscar dados do pagador", e.getStackTrace());
        }
    }
}

