/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao.caixa;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.caixa.Caixa;
import jalis.laboratorio.recepcao.caixa.CaixaDao;
import jalis.laboratorio.recepcao.caixa.TipoPagamento;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.ContaCorrente;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.Pagamento;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoBoleto;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoCartao;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoCheque;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoChequePreDatado;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoDeposito;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoFuncionario;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoPix;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoPromissoria;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoRepasse;
import jalis.laboratorio.recepcao.caixa.modeloscaixa.PagamentoTransferenciaBancaria;
import jalis.laboratorio.recepcao.util.SolicitarMotivoCancelamento;
import jalis.laboratorio.util.faturamento.eletronico.FaturamentoEletronico;
import jalis.laboratorio.util.faturamento.eletronico.Ibcm;
import jalis.model.bean.financeiro.LancamentoBean;
import jalis.model.vo.cadastro.financeiro.MotivoCancelamentoVO;
import jalis.service.cadastro.ConvenioService;
import jalis.service.financeiro.LancamentoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CaixaService {
    private Caixa caixa;
    private int casas = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode round = ParametrosGerais.getArredondamentoPrecoExame();
    private CaixaDao caixaDao;
    private List<Pagamento> pagamentosEstornados = new ArrayList<Pagamento>();

    public CaixaService(Caixa caixa) {
        this.caixa = caixa;
        this.caixaDao = new CaixaDao();
    }

    public ArrayList<Pagamento> buscaPagamentos(String requisicao, String codigoFilial) {
        if (requisicao == null) {
            return null;
        }
        try {
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), this.caixaDao.buscarPagamentos(requisicao, codigoFilial));
            ArrayList<Pagamento> pagamentos = new ArrayList<Pagamento>();
            while (rs.next()) {
                LancamentoBean lanctoBean = (LancamentoBean)new LancamentoService().get(codigoFilial, rs.getString("codigoLancamento"), rs.getString("codigoEstacao"));
                Pagamento pgto = new Pagamento(lanctoBean, lanctoBean.getSituacao(), true);
                pagamentos.add(pgto);
            }
            return pagamentos;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar dados da nota fiscal.\n" + e.getMessage(), e.getStackTrace());
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void adicionaPagamento(boolean focalizaCampo) {
        if (!this.validaValorPago()) {
            return;
        }
        if (!this.validaDataVencimentoBoleto(this.caixa.textVencimentoBoleto)) {
            return;
        }
        if (!this.validarData(this.caixa.textValidadeCartao.getText())) {
            return;
        }
        Date dataPagamento = this.getDataPagamento();
        if (dataPagamento == null) {
            return;
        }
        double restante = this.caixa.getValorRestante();
        double pago = this.getValorPago(restante);
        double troco = this.getValorTroco(restante, Double.valueOf(this.caixa.textValorPago.getText()));
        double desconto = this.getValorDesconto();
        double acrescimo = this.getValorAcrescimo();
        String valor = "";
        TipoPagamento aux = (TipoPagamento)((Object)this.caixa.comboFormaPagamento.getSelectedItem());
        ContaCorrente conta = (ContaCorrente)this.caixa.comboCaixa.getSelectedItem();
        TipoPagamento pagamento = (TipoPagamento)((Object)this.caixa.comboFormaPagamento.getSelectedItem());
        if (this.validaTipoPagamento(aux.codigo, TipoPagamento.CARTAO_CREDITO.codigo) || this.validaTipoPagamento(aux.codigo, TipoPagamento.CARTAO_DEBITO.codigo)) {
            PagamentoCartao pgto = new PagamentoCartao(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            pgto.bandeira = this.caixa.comboBandeira.getSelectedItem().toString();
            pgto.numero = this.caixa.textNumeroCartao.getTextDB();
            if (!Funcoes.textoVazio(this.caixa.textValidadeCartao)) {
                pgto.validade = Funcoes.getData("MM/yy", this.caixa.textValidadeCartao.getText());
            }
            if (!this.validarPagamento(pgto, Double.valueOf(Funcoes.limpaDecimal(this.caixa.textValorPago.getText())))) {
                return;
            }
        } else if (this.validaTipoPagamento(aux.codigo, TipoPagamento.DINHEIRO.codigo) || this.validaTipoPagamento(aux.codigo, TipoPagamento.TIPO_PGTO_DEBITO_AUTOMATICO.codigo) || this.validaTipoPagamento(aux.codigo, TipoPagamento.TIPO_PGTO_ONLINE.codigo)) {
            Pagamento pgto = new Pagamento(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, "O", pago, false, null, null, null);
            if (!this.validarPagamento(pgto, Double.valueOf(Funcoes.limpaDecimal(pago)))) {
                return;
            }
            this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).add(new BigDecimal(String.valueOf(pago)).setScale(this.casas, this.round)).setScale(this.casas, this.round));
        } else if (this.validaTipoPagamento(aux.codigo, TipoPagamento.CAUCAO.codigo) || this.validaTipoPagamento(aux.codigo, TipoPagamento.CHEQUE.codigo) || this.validaTipoPagamento(aux.codigo, TipoPagamento.PREDATADO.codigo)) {
            PagamentoCheque pgto = null;
            pgto = aux.codigo == TipoPagamento.CAUCAO.codigo || aux.codigo == TipoPagamento.CHEQUE.codigo ? new PagamentoCheque(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null) : new PagamentoChequePreDatado(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            pgto.banco = this.caixa.textBanco.getTextDB();
            pgto.agencia = this.caixa.textAgencia.getTextDB();
            pgto.conta = this.caixa.textContaCorrente.getTextDB();
            pgto.numeroCheque = this.caixa.textNumeroCheque.getTextDB();
            if (aux.codigo == TipoPagamento.PREDATADO.codigo && !Funcoes.textoVazio(this.caixa.textDataPreDatado.getText())) {
                ((PagamentoChequePreDatado)pgto).data = Funcoes.getData("dd/MM/yyyy", this.caixa.textDataPreDatado.getText());
            }
            if (!pgto.isOk(this.caixa)) return;
            Pagamento auxIdentico = this.verificaPagamentoIdentico(pgto);
            if (auxIdentico != null) {
                valor = this.caixa.textValorPago.getText();
                if (auxIdentico != pgto) {
                    Pagamento pagamento2 = auxIdentico;
                    pagamento2.valor = pagamento2.valor + Double.valueOf(Funcoes.limpaDecimal(this.caixa.textValorPago.getText()));
                    this.caixa.listPagamentos.repaint();
                }
            } else {
                valor = pgto.valor.toString();
                this.caixa.limparInformacoesPagamentos();
                this.caixa.modeloListaAnteriores.addElement(pgto);
            }
            if (!Funcoes.textoVazio(valor)) {
                this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).add(new BigDecimal(valor)).setScale(this.casas, this.round));
            }
        } else if (aux.codigo == TipoPagamento.TIPO_PGTO_DESCONTO_FOLHA.codigo) {
            PagamentoFuncionario pgto = new PagamentoFuncionario(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            pgto.setNome(this.caixa.textNomeFuncionario.getTextDB());
            pgto.setSetor(this.caixa.textSetorDescFolha.getTextDB());
            pgto.setAutorizadoPor(this.caixa.textAutorizadoDescFolha.getTextDB());
            if (!pgto.isOk(this.caixa)) return;
            Pagamento auxIdentico = this.verificaPagamentoIdentico(pgto);
            if (auxIdentico != null) {
                valor = this.caixa.textValorPago.getText();
                if (auxIdentico != pgto) {
                    Pagamento pagamento3 = auxIdentico;
                    pagamento3.valor = pagamento3.valor + Double.valueOf(Funcoes.limpaDecimal(this.caixa.textValorPago.getText()));
                    this.caixa.listPagamentos.repaint();
                }
            } else {
                valor = pgto.valor.toString();
                this.caixa.limparInformacoesPagamentos();
                this.caixa.modeloListaAnteriores.addElement(pgto);
            }
            if (!Funcoes.textoVazio(valor)) {
                this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).add(new BigDecimal(valor)).setScale(this.casas, this.round));
            }
        } else if (aux.codigo == TipoPagamento.PROMISSORIA.codigo) {
            PagamentoPromissoria pgto = new PagamentoPromissoria(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            pgto.numero = this.caixa.textNumeroPromissoria.getTextDB();
            if (!Funcoes.textoVazio(this.caixa.textDataPromissoria)) {
                pgto.dataHora = Funcoes.getData("dd/MM/yyyy", this.caixa.textDataPromissoria.getTextDB());
            }
            if (!pgto.isOk(this.caixa)) return;
            Pagamento auxIdentico = this.verificaPagamentoIdentico(pgto);
            if (auxIdentico != null) {
                valor = this.caixa.textValorPago.getText();
                if (auxIdentico != pgto) {
                    Pagamento pagamento4 = auxIdentico;
                    pagamento4.valor = pagamento4.valor + Double.valueOf(Funcoes.limpaDecimal(this.caixa.textValorPago.getText()));
                    this.caixa.listPagamentos.repaint();
                }
            } else {
                valor = pgto.valor.toString();
                this.caixa.limparInformacoesPagamentos();
                this.caixa.modeloListaAnteriores.addElement(pgto);
            }
            if (!Funcoes.textoVazio(valor)) {
                this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).add(new BigDecimal(valor)).setScale(this.casas, this.round));
            }
        } else if (aux.codigo == TipoPagamento.REPASSE.codigo) {
            if (desconto > 0.0) {
                Funcoes.mensagem(this.caixa, "N\u00e3o \u00e9 poss\u00edvel utilizar desconto para pagamentos de repasse.", 2);
                this.caixa.textDesconto.setText(Funcoes.formataDecimal(0));
                this.caixa.textPercentualDesconto.setText(Funcoes.formataDecimal(0));
                return;
            }
            if (acrescimo > 0.0) {
                Funcoes.mensagem(this.caixa, "N\u00e3o \u00e9 poss\u00edvel utilizar acr\u00e9scimo para pagamentos de repasse.", 2);
                this.caixa.textAcrescimo.setText(Funcoes.formataDecimal(0));
                this.caixa.textPercentualAcrescimo.setText(Funcoes.formataDecimal(0));
                return;
            }
            if (restante != pago) {
                Funcoes.mensagem(this.caixa, "O valor do repasse deve ser o valor integral do caixa.", 2);
                this.caixa.textValorPago.setText(Funcoes.formataDecimal(restante));
                ScreenUtil.requisitarFoco(this.caixa.textValorPago);
                return;
            }
            PagamentoRepasse pgto = new PagamentoRepasse(Variaveis.login, dataPagamento, pago, TipoPagamento.REPASSE.tipo, false, false, false);
            pgto.convenio = (DadosConvenios)this.caixa.comboRepasse.getSelectedItem();
            pgto.isIBCM = this.isProtocoloIBCM(pgto.convenio);
            pgto.codigoGuia = this.caixa.textGuia.getTextDB();
            pgto.codigoGuiaPrincipal = this.caixa.textGuiaPrincipal.getTextDB();
            pgto.plano = this.caixa.textPlano.getTextDB();
            pgto.matricula = this.caixa.textMatricula.getTextDB();
            pgto.deveGuia = this.caixa.checkDeveGuia.isSelected();
            if (!Funcoes.textoVazio(this.caixa.textValidadeGuia)) {
                pgto.validadeGuia = Funcoes.getData("dd/MM/yyyy", this.caixa.textValidadeGuia.getText());
            }
            if (!Funcoes.textoVazio(this.caixa.textValidadeCarteira)) {
                pgto.validadeCarteira = Funcoes.getData("dd/MM/yyyy", this.caixa.textValidadeCarteira.getText());
            }
            if (!pgto.isOk(this.caixa)) return;
            Pagamento auxIdentico = this.verificaPagamentoIdentico(pgto);
            if (auxIdentico != null) {
                valor = this.caixa.textValorPago.getText();
                if (auxIdentico != pgto) {
                    Pagamento pagamento5 = auxIdentico;
                    pagamento5.valor = pagamento5.valor + Double.valueOf(Funcoes.limpaDecimal(this.caixa.textValorPago.getText()));
                    this.caixa.listPagamentos.repaint();
                }
            } else {
                valor = pgto.valor.toString();
                this.caixa.limparInformacoesPagamentos();
                this.caixa.modeloListaAnteriores.addElement(pgto);
            }
            if (!Funcoes.textoVazio(valor)) {
                this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).add(new BigDecimal(valor)).setScale(this.casas, this.round));
            }
        } else if (aux.codigo == TipoPagamento.DEPOSITO.codigo) {
            PagamentoDeposito pgto = new PagamentoDeposito(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            pgto.banco = this.caixa.textBanco.getTextDB();
            pgto.agencia = this.caixa.textAgencia.getTextDB();
            pgto.conta = this.caixa.textContaCorrente.getTextDB();
            if (!Funcoes.textoVazio(this.caixa.textDataPreDatado)) {
                pgto.data = Funcoes.getData("dd/MM/yyyy", this.caixa.textDataPreDatado.getTextDB());
            }
            if (!pgto.isOk(this.caixa)) return;
            Pagamento auxIdentico = this.verificaPagamentoIdentico(pgto);
            if (auxIdentico != null) {
                valor = this.caixa.textValorPago.getText();
                if (auxIdentico != pgto) {
                    Pagamento pagamento6 = auxIdentico;
                    pagamento6.valor = pagamento6.valor + Double.valueOf(Funcoes.limpaDecimal(this.caixa.textValorPago.getText()));
                    this.caixa.listPagamentos.repaint();
                }
            } else {
                valor = pgto.valor.toString();
                this.caixa.limparInformacoesPagamentos();
                this.caixa.modeloListaAnteriores.addElement(pgto);
            }
            if (!Funcoes.textoVazio(valor)) {
                this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).add(new BigDecimal(valor)).setScale(this.casas, this.round));
            }
        } else if (aux.codigo == TipoPagamento.BOLETO.codigo) {
            PagamentoBoleto pgto = new PagamentoBoleto(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            pgto.documento = this.caixa.textDocumentoBoleto.getText();
            if (!Funcoes.textoVazio(this.caixa.textVencimentoBoleto)) {
                pgto.data = Funcoes.getData("dd/MM/yyyy", this.caixa.textVencimentoBoleto.getText());
            }
            if (!pgto.isOk(this.caixa)) return;
            this.caixa.limparInformacoesPagamentos();
            this.caixa.modeloListaAnteriores.addElement(pgto);
        } else if (aux.codigo == TipoPagamento.TRANSFERENCIA_BANCARIA.codigo) {
            PagamentoTransferenciaBancaria pgto = new PagamentoTransferenciaBancaria(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            if (!Funcoes.textoVazio(this.caixa.textDataTransferenciaBancaria) && Funcoes.verificaData(this.caixa.textDataTransferenciaBancaria.getText())) {
                pgto.data = Funcoes.getData("dd/MM/yyyy", this.caixa.textDataTransferenciaBancaria.getText());
            }
            if (!Funcoes.textoVazio(this.caixa.textDataPix) && Funcoes.verificaData(this.caixa.textDataPix.getText())) {
                pgto.data = Funcoes.getData("dd/MM/yyyy", this.caixa.textDataPix.getText());
            }
            pgto.banco = this.caixa.textBancoTransfenrencia.getTextDB();
            pgto.agencia = this.caixa.textAgenciaTransfenrencia.getTextDB();
            pgto.conta = this.caixa.textContaTransfenrencia.getTextDB();
            pgto.transferencia = this.caixa.textTransferenciaBancaria.getTextDB();
            if (!pgto.isOk(this.caixa)) return;
            this.caixa.limparInformacoesPagamentos();
            this.caixa.modeloListaAnteriores.addElement(pgto);
        } else if (this.validaTipoPagamento(aux.codigo, TipoPagamento.PIX.codigo)) {
            PagamentoPix pgto = new PagamentoPix(Integer.parseInt(this.caixa.getCodigoFilial()), -1, Integer.parseInt(Variaveis.codigoEstacao), conta, Variaveis.login, dataPagamento, "C", pagamento.tipo, pago, false, null, null, null);
            if (!Funcoes.textoVazio(this.caixa.textDataPix)) {
                pgto.data = Funcoes.getData("dd/MM/yyyy", this.caixa.textDataPix.getText());
            }
            pgto.banco = this.caixa.textBanco.getTextDB();
            pgto.agencia = this.caixa.textAgencia.getTextDB();
            pgto.conta = this.caixa.textContaCorrente.getTextDB();
            pgto.pix = this.caixa.textPix.getText();
            if (!pgto.isOk(this.caixa)) return;
            this.caixa.limparInformacoesPagamentos();
            this.caixa.modeloListaAnteriores.addElement(pgto);
        }
        if (troco > 0.0) {
            Funcoes.mensagem(this.caixa, "Troco devido: R$ " + Funcoes.formataDecimal(troco) + ".", 5);
        }
        this.caixa.textValorPago.clear();
        this.caixa.recalculaValores();
        this.caixa.mostraValores(null);
        this.caixa.controlaCampos();
        this.caixa.limparInformacoesPagamentos();
        this.caixa.montaInformacoesPagamento(this.caixa.getValorRecebido() < this.caixa.getValorTotal() && !(this.caixa.getValorTotal() < 0.0));
        if (!focalizaCampo) return;
        if (this.caixa.getValorRecebido() < this.caixa.getValorTotal() && !(this.caixa.getValorTotal() < 0.0)) {
            ScreenUtil.requisitarFoco(this.caixa.textValorPago);
            return;
        } else {
            ScreenUtil.requisitarFoco(this.caixa.textNomePagador);
        }
    }

    private boolean validarPagamento(Pagamento pgto, double valorPago) {
        if (pgto.isOk(this.caixa)) {
            Pagamento auxIdentico = this.verificaPagamentoIdentico(pgto);
            if (auxIdentico != null && auxIdentico != pgto) {
                Pagamento pagamento = auxIdentico;
                pagamento.valor = pagamento.valor + valorPago;
                this.caixa.listPagamentos.repaint();
            } else {
                this.caixa.limparInformacoesPagamentos();
                this.caixa.modeloListaAnteriores.addElement(pgto);
            }
            return true;
        }
        return false;
    }

    private boolean validaTipoPagamento(int aux, int codigo) {
        return aux == codigo;
    }

    private double getValorAcrescimo() {
        if (!Funcoes.textoVazio(this.caixa.textAcrescimo)) {
            return Double.parseDouble(this.caixa.textAcrescimo.getText());
        }
        return 0.0;
    }

    private double getValorDesconto() {
        if (!Funcoes.textoVazio(this.caixa.textDesconto)) {
            return Double.parseDouble(this.caixa.textDesconto.getText());
        }
        return 0.0;
    }

    private double getValorTroco(double restante, double pago) {
        BigDecimal valorPago = new BigDecimal(String.valueOf(pago)).setScale(this.casas, this.round);
        BigDecimal valorRestante = new BigDecimal(String.valueOf(restante)).setScale(this.casas, this.round);
        return valorPago.subtract(valorRestante).doubleValue();
    }

    public double getValorPago(double restante) {
        double valorPago = Double.valueOf(this.caixa.textValorPago.getText());
        if (valorPago > restante) {
            return restante;
        }
        return valorPago;
    }

    public boolean isZero(Double aux) {
        return aux == 0.0;
    }

    private Date getDataPagamento() {
        Date dataPagamento = new Date();
        try {
            if (!Funcoes.textoVazio(this.caixa.textData) && !Funcoes.textoVazio(this.caixa.textHora)) {
                dataPagamento = Funcoes.getData("dd/MM/yyyy HH:mm", this.caixa.textData.getText() + " " + this.caixa.textHora.getText());
            }
        }
        catch (Exception e) {
            Funcoes.mensagem(this.caixa, "A data do caixa \u00e9 inv\u00e1lida.", 2);
            this.caixa.textData.selectAll();
            ScreenUtil.requisitarFoco(this.caixa.textData);
            return null;
        }
        return dataPagamento;
    }

    public boolean validarData(String data) {
        if (!Funcoes.textoVazio(data) && Funcoes.verificaData("MM/yy", data)) {
            int mesAtual = Funcoes.retornaMes(Funcoes.getDataHoraAtual());
            int anoAtual = Funcoes.retornaAno(Funcoes.getDataHoraAtual());
            Date mesInformado = Funcoes.getData("MM/yy", data);
            int mes = Funcoes.retornaMes(mesInformado);
            int ano = Funcoes.retornaAno(mesInformado);
            if (anoAtual > ano || mesAtual > mes && anoAtual == ano) {
                return false;
            }
        }
        return true;
    }

    public boolean validaDataVencimentoBoleto(TTextField textVencimentoBoleto) {
        if (!Funcoes.textoVazio(this.caixa.textVencimentoBoleto)) {
            boolean validou = textVencimentoBoleto.isValidarConteudo();
            if (!Funcoes.verificaDataAtual(textVencimentoBoleto.getText())) {
                if (!validou) {
                    Funcoes.mensagem(this.caixa, "Data inv\u00e1lida.", 2);
                }
                ScreenUtil.requisitarFoco(textVencimentoBoleto);
                return false;
            }
        }
        return true;
    }

    private boolean validaValorPago() {
        if (Funcoes.textoVazio(this.caixa.textValorPago)) {
            Funcoes.mensagem(this.caixa, "O valor pago deve ser preenchido.", 2);
            ScreenUtil.requisitarFoco(this.caixa.textValorPago);
            return false;
        }
        if (Double.valueOf(this.caixa.textValorPago.getText()) <= 0.0) {
            Funcoes.mensagem(this.caixa, "O valor pago deve ser maior que zero.", 2);
            this.caixa.textValorPago.selectAll();
            ScreenUtil.requisitarFoco(this.caixa.textValorPago);
            return false;
        }
        return true;
    }

    private Pagamento verificaPagamentoIdentico(Pagamento pgto) {
        for (int i = 0; i < this.caixa.modeloListaAnteriores.getSize(); ++i) {
            Pagamento aux = (Pagamento)this.caixa.modeloListaAnteriores.get(i);
            if (aux.salvo || !pgto.tipoPagamento.equalsIgnoreCase(aux.tipoPagamento) || !pgto.codigoFilial.equals(aux.codigoFilial) || pgto.codigoEstacao.intValue() != aux.codigoEstacao.intValue() || pgto.contaCaixa.getReduzido() != aux.contaCaixa.getReduzido() || !pgto.usuario.equalsIgnoreCase(aux.usuario) || !pgto.tipoLancamento.equalsIgnoreCase(aux.tipoLancamento)) continue;
            if (pgto instanceof PagamentoCheque && ((PagamentoCheque)pgto).banco.equalsIgnoreCase(((PagamentoCheque)aux).banco) && ((PagamentoCheque)pgto).agencia.equalsIgnoreCase(((PagamentoCheque)aux).agencia) && ((PagamentoCheque)pgto).conta.equalsIgnoreCase(((PagamentoCheque)aux).conta) && ((PagamentoCheque)pgto).numeroCheque.equalsIgnoreCase(((PagamentoCheque)aux).numeroCheque)) {
                if (pgto instanceof PagamentoChequePreDatado) {
                    if (((PagamentoChequePreDatado)pgto).data.equals(((PagamentoChequePreDatado)aux).data)) {
                        return aux;
                    }
                    Funcoes.mensagem(this.caixa, "O cheque j\u00e1 foi usado em um pagamento.", 2);
                    ScreenUtil.requisitarFoco(this.caixa.textDataPreDatado);
                    return pgto;
                }
                return aux;
            }
            if (pgto instanceof PagamentoDeposito) {
                if (!((PagamentoDeposito)pgto).banco.equalsIgnoreCase(((PagamentoDeposito)aux).banco) || !((PagamentoDeposito)pgto).agencia.equalsIgnoreCase(((PagamentoDeposito)aux).agencia) || !((PagamentoDeposito)pgto).conta.equalsIgnoreCase(((PagamentoDeposito)aux).conta) || !((PagamentoDeposito)pgto).data.equals(((PagamentoDeposito)aux).data)) continue;
                return aux;
            }
            if (pgto instanceof PagamentoCartao) {
                if (!((PagamentoCartao)pgto).bandeira.equalsIgnoreCase(((PagamentoCartao)aux).bandeira) || !((PagamentoCartao)pgto).numero.equalsIgnoreCase(((PagamentoCartao)aux).numero) || !((PagamentoCartao)pgto).validade.equals(((PagamentoCartao)aux).validade)) continue;
                return aux;
            }
            if (pgto instanceof PagamentoPromissoria) {
                if (!((PagamentoPromissoria)pgto).numero.equalsIgnoreCase(((PagamentoPromissoria)aux).numero)) continue;
                return aux;
            }
            if (pgto instanceof PagamentoFuncionario) {
                if (!((PagamentoFuncionario)pgto).getNome().equalsIgnoreCase(((PagamentoFuncionario)aux).getNome())) continue;
                return aux;
            }
            if (pgto instanceof PagamentoRepasse) {
                if (!((PagamentoRepasse)pgto).codigoGuia.equalsIgnoreCase(((PagamentoRepasse)aux).codigoGuia) || !((PagamentoRepasse)pgto).codigoGuiaPrincipal.equalsIgnoreCase(((PagamentoRepasse)aux).codigoGuiaPrincipal) || !((PagamentoRepasse)pgto).validadeGuia.equals(((PagamentoRepasse)aux).validadeGuia) || !((PagamentoRepasse)pgto).validadeCarteira.equals(((PagamentoRepasse)aux).validadeCarteira) || ((PagamentoRepasse)pgto).deveGuia != ((PagamentoRepasse)aux).deveGuia || !((PagamentoRepasse)pgto).plano.equalsIgnoreCase(((PagamentoRepasse)aux).plano) || !((PagamentoRepasse)pgto).matricula.equalsIgnoreCase(((PagamentoRepasse)aux).matricula) || ((PagamentoRepasse)pgto).convenio.getCodigo() != ((PagamentoRepasse)aux).convenio.getCodigo()) continue;
                return aux;
            }
            if (pgto instanceof PagamentoBoleto) {
                if (!((PagamentoBoleto)pgto).data.equals(((PagamentoBoleto)aux).data)) continue;
                return aux;
            }
            if (pgto instanceof PagamentoTransferenciaBancaria) {
                if (!((PagamentoTransferenciaBancaria)pgto).banco.equalsIgnoreCase(((PagamentoTransferenciaBancaria)aux).banco) || !((PagamentoTransferenciaBancaria)pgto).agencia.equalsIgnoreCase(((PagamentoTransferenciaBancaria)aux).agencia) || !((PagamentoTransferenciaBancaria)pgto).conta.equalsIgnoreCase(((PagamentoTransferenciaBancaria)aux).conta) || !((PagamentoTransferenciaBancaria)pgto).data.equals(((PagamentoTransferenciaBancaria)aux).data)) continue;
                return aux;
            }
            if (pgto instanceof PagamentoPix) {
                if (!((PagamentoPix)pgto).banco.equalsIgnoreCase(((PagamentoPix)aux).banco) || !((PagamentoPix)pgto).agencia.equalsIgnoreCase(((PagamentoPix)aux).agencia) || !((PagamentoPix)pgto).conta.equalsIgnoreCase(((PagamentoPix)aux).conta) || !((PagamentoPix)pgto).data.equals(((PagamentoPix)aux).data)) continue;
                return aux;
            }
            return aux;
        }
        return null;
    }

    public boolean isProtocoloIBCM(DadosConvenios convenio) {
        if (convenio != null) {
            FaturamentoEletronico protocolo = null;
            try {
                protocolo = new ConvenioService().getProtocoloEletronico(this.caixa.getCodigoFilial(), String.valueOf(convenio.getCodigo()));
                return protocolo instanceof Ibcm;
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.caixa, "N\u00e3o foi poss\u00edvel buscar protocolo eletr\u00f4nico do conv\u00eanio.\n" + ex.getMessage(), ex.getStackTrace());
                return false;
            }
        }
        return false;
    }

    public void calculaValorDesconto(boolean valorAlterado) {
        this.caixa.textValorPago.clear();
        if (this.caixa.getSubTotal().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (this.isValorAlterado(this.caixa.textPercentualDesconto.getText(), this.caixa.getValorDescontoPercentualAnterior()) || this.caixa.confereDesconto() || valorAlterado) {
            if (Funcoes.isNumeric(this.caixa.textPercentualDesconto.getText())) {
                BigDecimal aux = new BigDecimal(Funcoes.limpaDecimal(this.caixa.textPercentualDesconto.getText())).setScale(2, this.round);
                if (aux.compareTo(BigDecimal.ZERO) < 0) {
                    this.caixa.mostrandoJanela = true;
                    this.limpaCamposDeconto();
                    Funcoes.mensagem(this.caixa.getTopLevelAncestor(), "O percentual de desconto n\u00e3o pode ser inferior a 0%.", 2);
                    this.caixa.mostrandoJanela = false;
                    return;
                }
                if (aux.doubleValue() == new BigDecimal(String.valueOf(this.caixa.getDesconto())).setScale(2, RoundingMode.FLOOR).doubleValue()) {
                    aux = this.caixa.percentualDesconto;
                }
                this.caixa.setValorDescontoPercentualAnterior(this.caixa.textPercentualDesconto.getText());
                if (aux.compareTo(new BigDecimal("100").setScale(this.casas, this.round)) > 0) {
                    if (!this.caixa.mostrandoJanela) {
                        this.caixa.mostrandoJanela = true;
                        this.limpaCamposDeconto();
                        Funcoes.mensagem(this.caixa.getTopLevelAncestor(), "O percentual de desconto n\u00e3o pode ultrapassar 100%.", 2);
                        this.caixa.mostrandoJanela = false;
                    }
                    return;
                }
                this.caixa.percentualDesconto = aux;
                this.caixa.valorDesconto = this.caixa.getSubTotal().setScale(this.casas, this.round).multiply(this.caixa.percentualDesconto.setScale(4)).setScale(this.casas, this.round).divide(new BigDecimal("100").setScale(this.casas, this.round), this.round).setScale(2, this.round);
            } else {
                this.caixa.percentualDesconto = BigDecimal.ZERO;
                this.caixa.valorDesconto = BigDecimal.ZERO;
            }
        }
        if (!Funcoes.textoVazio(this.caixa.getValorDescontoAnterior())) {
            BigDecimal valorRestante = this.caixa.getSubTotal().setScale(this.casas, this.round).add(new BigDecimal(String.valueOf(this.caixa.getValorAcrescimo())).setScale(this.casas, this.round)).subtract(new BigDecimal(String.valueOf(this.caixa.getValorRecebido())).setScale(this.casas, this.round));
            if (this.caixa.getValorDesconto() > valorRestante.doubleValue() && valorRestante.compareTo(BigDecimal.ZERO) > 0) {
                this.caixa.valorDesconto = valorRestante.setScale(this.casas, this.round);
            }
        }
        if (this.caixa.getValorMinimoRequisicao() != null && this.caixa.getValorMinimoRequisicao().compareTo(BigDecimal.ZERO) > 0 && this.caixa.getValorMinimoRequisicao().compareTo(this.caixa.valorExames.add(this.caixa.valorMateriais)) >= 0) {
            this.caixa.valorDesconto = BigDecimal.ZERO;
            this.caixa.percentualDesconto = BigDecimal.ZERO;
            this.caixa.textPercentualDesconto.setText(Funcoes.formataDecimal(this.caixa.percentualDesconto.setScale(2, this.round).doubleValue()));
        }
        this.caixa.textDesconto.setText(Funcoes.formataDecimal(this.caixa.valorDesconto.setScale(2, this.round).doubleValue()));
        this.caixa.setValorDescontoAnterior(this.caixa.textDesconto.getText());
        this.caixa.setTotal(this.caixa.getSubTotal().setScale(this.casas, this.round).subtract(this.caixa.valorDesconto.setScale(this.casas, this.round)).subtract(new BigDecimal(String.valueOf(this.caixa.getValorRecebido())).setScale(this.casas, this.round)).setScale(this.casas, this.round));
        this.caixa.labelVlrTotalPagar.setText(Funcoes.formataDecimal(this.caixa.getTotal().doubleValue()));
        this.caixa.recalculaValores();
        this.caixa.mostraValores(this.caixa.textPercentualDesconto);
    }

    public void calculaPercentualDesconto() {
        this.caixa.textValorPago.clear();
        if (this.caixa.getSubTotal().compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        if (this.isValorAlterado(this.caixa.textDesconto.getText(), this.caixa.getValorDescontoAnterior())) {
            if (Funcoes.isNumeric(this.caixa.textDesconto.getText())) {
                BigDecimal vlrDesconto = new BigDecimal(Funcoes.limpaDecimal(this.caixa.textDesconto.getText())).setScale(2, this.round);
                if (vlrDesconto.compareTo(BigDecimal.ZERO) < 0) {
                    this.caixa.mostrandoJanela = true;
                    this.limpaCamposDeconto();
                    Funcoes.mensagem(this.caixa.getTopLevelAncestor(), "O valor do desconto n\u00e3o pode ser inferior a 0.", 2);
                    this.caixa.mostrandoJanela = false;
                    return;
                }
                this.caixa.setValorDescontoAnterior(this.caixa.textDesconto.getText());
                BigDecimal vlrAcrescimo = new BigDecimal(String.valueOf(this.caixa.getValorAcrescimo())).setScale(2, this.round);
                BigDecimal vlrRecebido = new BigDecimal(String.valueOf(this.caixa.getValorRecebido())).setScale(2, this.round);
                BigDecimal vlrRestante = this.caixa.getSubTotal().setScale(2, this.round).add(vlrAcrescimo).subtract(vlrRecebido);
                if (vlrDesconto.compareTo(vlrRestante) > 0 && vlrRestante.compareTo(BigDecimal.ZERO) > 0) {
                    if (!this.caixa.mostrandoJanela) {
                        this.caixa.mostrandoJanela = true;
                        this.limpaCamposDeconto();
                        Funcoes.mensagem(this.caixa.getTopLevelAncestor(), "O valor de desconto n\u00e3o pode ultrapassar o valor dos exames.", 2);
                        this.caixa.mostrandoJanela = false;
                    }
                    this.caixa.textDesconto.setText(Funcoes.formataDecimal(0.0));
                    return;
                }
                this.caixa.valorDesconto = vlrDesconto;
                if (vlrRestante.doubleValue() > 0.0 && this.caixa.restante.compareTo(BigDecimal.ZERO) >= 0) {
                    this.caixa.percentualDesconto = new BigDecimal("100").setScale(4).multiply(this.caixa.valorDesconto.setScale(this.casas, this.round)).setScale(4).divide(this.caixa.getSubTotal().setScale(4), RoundingMode.UP).setScale(4, RoundingMode.UP);
                }
            } else {
                this.caixa.valorDesconto = BigDecimal.ZERO;
                this.caixa.percentualDesconto = BigDecimal.ZERO;
            }
        }
        this.caixa.textPercentualDesconto.setText(Funcoes.formataDecimal(this.caixa.percentualDesconto.setScale(2, RoundingMode.FLOOR).doubleValue()));
        if (this.caixa.getValorMinimoRequisicao() != null && this.caixa.getValorMinimoRequisicao().compareTo(BigDecimal.ZERO) > 0 && this.caixa.getValorMinimoRequisicao().compareTo(this.caixa.valorExames.add(this.caixa.valorMateriais)) >= 0) {
            this.caixa.valorDesconto = BigDecimal.ZERO;
            this.caixa.percentualDesconto = BigDecimal.ZERO;
            this.caixa.textPercentualDesconto.setText(Funcoes.formataDecimal(this.caixa.percentualDesconto.setScale(2, this.round).doubleValue()));
        }
        BigDecimal valorTotal = this.caixa.getSubTotal().setScale(this.casas, this.round).subtract(this.caixa.valorDesconto.setScale(this.casas, this.round)).subtract(new BigDecimal(this.caixa.getValorRecebido()).setScale(this.casas, this.round));
        this.caixa.setTotal(valorTotal);
        this.caixa.labelVlrTotalPagar.setText(Funcoes.formataDecimal(this.caixa.getTotal().doubleValue()));
        this.caixa.recalculaValores();
        this.caixa.mostraValores(this.caixa.textDesconto);
    }

    public boolean isValorAlterado(String valor, String valorAnterior) {
        return !valor.equals(valorAnterior);
    }

    public void limpaCamposDeconto() {
        this.caixa.setValorDesconto(BigDecimal.ZERO.doubleValue());
        this.caixa.setValorDescontoAnterior(String.valueOf(BigDecimal.ZERO));
        this.caixa.setPercentualDesconto(BigDecimal.ZERO.doubleValue());
        this.caixa.setValorDescontoPercentualAnterior(String.valueOf(BigDecimal.ZERO));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void estonarPagamentos() {
        Pagamento pagamento = (Pagamento)this.caixa.listPagamentos.getSelectedValue();
        SolicitarMotivoCancelamento motivo = null;
        MotivoCancelamentoVO motivoVO = new MotivoCancelamentoVO();
        if (pagamento != null && pagamento.isNotaFiscalGerada()) {
            String numero = "\nN\u00famero: " + pagamento.numeroNotaFiscal;
            numero = !Funcoes.textoVazio(pagamento.codigoNotaFiscal) && Funcoes.textoVazio(pagamento.numeroNotaFiscal) ? "\nRPS: " + String.valueOf(pagamento.numeroRpsNotaFiscal) : numero + " Situa\u00e7\u00e3o: " + Tipos.tipoSituacaoNotaFiscal(pagamento.situacaoNotaFiscal, true);
            numero = numero + " S\u00e9rie: " + pagamento.serieNotaFiscal;
            Funcoes.mensagem(this.caixa, "N\u00e3o \u00e9 poss\u00edvel estornar o pagamento, pois, h\u00e1 uma nota fiscal gerada para o mesmo." + numero, 2);
            return;
        }
        if (pagamento != null && pagamento.salvo) {
            int resp;
            motivo = SolicitarMotivoCancelamento.novaInstancia(Laboratorio.getInstancia(), false);
            if (!motivo.temMotivosCancelamento()) {
                Funcoes.mensagem(this.caixa, "N\u00e3o existe nenhuma motivo cadastrado, o lan\u00e7amento n\u00e3o pode ser estornado.", 2);
                return;
            }
            if (!(pagamento instanceof PagamentoRepasse)) {
                motivo.setVisible(true);
                if (!motivo.getOK()) {
                    Funcoes.mensagem(this.caixa, "Estorno cancelado", 2);
                    pagamento.motivoEstornado = new MotivoCancelamentoVO();
                    return;
                }
                motivoVO.setCodigo(motivo.getCodigoMotivo());
                motivoVO.setDescricao(motivo.getDescricaoMotivo());
                pagamento.motivoEstornado = motivoVO;
                this.pagamentosEstornados.add(pagamento);
            }
            this.caixa.modeloListaAnteriores.removeElement(pagamento);
            this.caixa.isCaixaAlterado = true;
            if (pagamento != null && pagamento instanceof PagamentoRepasse && (resp = Funcoes.mensagem(this.caixa, "Deseja usar os dados do repasse sendo estornado?", 4, true)) == 0) {
                this.caixa.recalculaValores();
                this.caixa.controlaCampos();
                this.caixa.textPlano.setText(((PagamentoRepasse)pagamento).plano == null ? "" : ((PagamentoRepasse)pagamento).plano);
                this.caixa.textValidadeGuia.setText(((PagamentoRepasse)pagamento).validadeGuia == null ? "" : Funcoes.formataData("dd/MM/yyyy", ((PagamentoRepasse)pagamento).validadeGuia));
                this.caixa.textGuia.setText(((PagamentoRepasse)pagamento).codigoGuia == null ? "" : ((PagamentoRepasse)pagamento).codigoGuia);
                this.caixa.textValidadeCarteira.setText(((PagamentoRepasse)pagamento).validadeCarteira == null ? "" : Funcoes.formataData("dd/MM/yyyy", ((PagamentoRepasse)pagamento).validadeCarteira));
                this.caixa.textGuiaPrincipal.setText(((PagamentoRepasse)pagamento).codigoGuiaPrincipal == null ? "" : ((PagamentoRepasse)pagamento).codigoGuiaPrincipal);
                this.caixa.textMatricula.setText(((PagamentoRepasse)pagamento).matricula == null ? "" : ((PagamentoRepasse)pagamento).matricula);
                if (((PagamentoRepasse)pagamento).convenio == null) {
                    this.caixa.comboRepasse.setSelectedIndex(0);
                } else {
                    this.caixa.comboRepasse.setSelectedItem(((PagamentoRepasse)pagamento).convenio);
                }
                ScreenUtil.requisitarFoco(this.caixa.comboRepasse);
                this.caixa.comboFormaPagamento.setSelectedItem((Object)TipoPagamento.REPASSE);
                return;
            }
        } else {
            this.caixa.modeloListaAnteriores.removeElement(pagamento);
        }
        if (this.caixa.getTotalPago().setScale(this.casas, this.round).compareTo(new BigDecimal(String.valueOf(pagamento.valor)).setScale(this.casas, this.round)) > 0) {
            this.caixa.setTotalPago(this.caixa.getTotalPago().setScale(this.casas, this.round).subtract(new BigDecimal(String.valueOf(pagamento.valor)).setScale(this.casas, this.round)));
        }
        this.calculaValorDesconto(true);
        this.caixa.controlaCampos();
    }

    public void salvarPagamentosEstornados() throws Exception {
        for (Pagamento pagamento : this.pagamentosEstornados) {
            LancamentoBean lanctoAux = null;
            lanctoAux = pagamento.lancamentoDestino != null ? pagamento.lancamentoDestino : (LancamentoBean)new LancamentoService().get(this.caixa.getCodigoFilial(), String.valueOf(pagamento.codigoLancamento), String.valueOf(pagamento.codigoEstacao));
            if (this.isNotNull(lanctoAux)) {
                lanctoAux.setDescricaoCancelado(pagamento.motivoEstornado.getDescricao());
                lanctoAux.setMotivoCancelado(pagamento.motivoEstornado);
            }
            new LancamentoService().estornoCancelamento(lanctoAux, "R", false, null);
            this.caixaDao.atualizaPagamentoRequisicao(this.caixa.getCodigoFilial(), this.caixa.getCodigoRequisicao(), pagamento, this.caixa.getValorRecebidoSalvo(), Conexao.getStatement());
        }
        this.pagamentosEstornados.clear();
    }

    private boolean isNotNull(LancamentoBean lanctoAux) {
        return lanctoAux != null;
    }

    public List<Pagamento> getPagamentosEstornados() {
        return this.pagamentosEstornados;
    }

    public String pacientePessoaJuridica(String filial, String codigoPac) throws SQLException {
        return this.caixaDao.pacientePessoaJuridica(filial, codigoPac);
    }
}

