/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.recepcao.AbrirRequisicao;
import jalis.model.bean.recepcao.RequisicaoLogBean;
import jalis.model.utils.ThreadDaoException;
import jalis.service.recepcao.RequisicaoLogService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VisualizaHistoricoRequisicao
extends JDialog
implements ActionListener {
    private static final int COLUNA_OBJETO = 4;
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private ModeloGridTable modeloHistorico = new ModeloGridTable(new String[]{"Suplemento", "Data", "Usu\u00e1rio", "Exames"});
    private JTable tableHistorico = new JTable(this.modeloHistorico);
    private JScrollPane scrollHistorico = new JScrollPane(this.tableHistorico);
    private JButton buttonVisualizar = new JButton("Visualizar");
    private JButton buttonCancelar = new JButton("Cancelar");
    private RequisicaoLogService requisicaoLogService = new RequisicaoLogService();
    private Window owner = null;
    private GlassPaneMensagem glassPaneMensagem = null;
    private ArrayList<RequisicaoLogBean> listaLogs = null;

    public VisualizaHistoricoRequisicao(Window owner, String filial, String codigoRequisicao, GlassPaneMensagem glassPane) {
        super(owner, "Selecione o hist\u00f3rico");
        this.owner = owner;
        this.glassPaneMensagem = glassPane;
        this.setModal(true);
        this.montaTela();
        this.buscaLogs(filial, codigoRequisicao);
        this.setLocationRelativeTo(owner);
    }

    private void montaTela() {
        this.setSize(700, 300);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollHistorico, "Center");
        this.add((Component)this.panelBotoes, "South");
        this.modeloHistorico.setColumnSize(new int[]{100, 100, 100, 0}, this.tableHistorico);
        this.buttonVisualizar.setMnemonic('V');
        this.buttonVisualizar.addActionListener(this);
        this.panelBotoes.add(this.buttonVisualizar);
        this.buttonCancelar.setMnemonic('C');
        this.buttonCancelar.addActionListener(this);
        this.panelBotoes.add(this.buttonCancelar);
        this.tableHistorico.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                VisualizaHistoricoRequisicao.this.controlaCampos();
            }
        });
        this.tableHistorico.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VisualizaHistoricoRequisicao.this.visualizarHistorico();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }
        });
    }

    private void controlaCampos() {
        int row = this.tableHistorico.getSelectedRow();
        this.buttonVisualizar.setEnabled(row >= 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonVisualizar) {
            this.visualizarHistorico();
        } else if (e.getSource() == this.buttonCancelar) {
            this.setVisible(false);
        }
    }

    private void visualizarHistorico() {
        int row = this.tableHistorico.getSelectedRow();
        if (row < 0) {
            return;
        }
        RequisicaoLogBean bean = (RequisicaoLogBean)this.modeloHistorico.getValueAt(row, 4);
        AbrirRequisicao janela = new AbrirRequisicao((Frame)this.owner, this.glassPaneMensagem, true);
        janela.setXml(bean);
        janela.setVisible(true);
    }

    private void buscaLogs(String codigoFilial, String codigoRequisicao) {
        HashMap<String, Object> chaves = new HashMap<String, Object>();
        chaves.put("fil_codigo", codigoFilial);
        chaves.put("req_codigo", codigoRequisicao);
        chaves.put("rlo_tipo", "D");
        try {
            ArrayList<RequisicaoLogBean> listaLogs = this.requisicaoLogService.getBeans(chaves);
            this.preencheDadosLogs(listaLogs);
        }
        catch (ThreadDaoException e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar logs.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void preencheDadosLogs(ArrayList<RequisicaoLogBean> listaLogs) {
        this.modeloHistorico.clear();
        if (listaLogs != null) {
            Collections.sort(listaLogs);
            Collections.reverse(listaLogs);
            for (int i = 0; i < listaLogs.size(); ++i) {
                RequisicaoLogBean aux = listaLogs.get(i);
                String xmlRequisicao = StringUtil.getValor(aux.getXml(), "requisicao");
                String xmlExames = StringUtil.getValor(aux.getXml(), "exames");
                String[] xmlExame = StringUtil.getValores(xmlExames, "exame");
                StringBuilder codigo = new StringBuilder();
                for (int j = 0; j < xmlExame.length; ++j) {
                    String[] campos = StringUtil.getValores(xmlExame[j], "campo");
                    for (int k = 0; k < campos.length; ++k) {
                        String nome = StringUtil.getValor(campos[k], "nome");
                        String valor = StringUtil.getValor(campos[k], "valor");
                        if (!nome.equalsIgnoreCase("exa_codigo") || Funcoes.textoVazio(valor.trim())) continue;
                        codigo.append(valor.trim());
                        if (j >= xmlExame.length - 1) continue;
                        codigo.append(", ");
                    }
                }
                if (aux == null || Funcoes.textoVazio(codigo.toString())) continue;
                this.modeloHistorico.addLine(new Object[]{"s" + aux.getNrSuplemento(), Funcoes.formataData("dd/MM/yyyy HH:mm", aux.getDataHora()), aux.getUsuario().getCodigo(), codigo.toString(), aux});
            }
        }
    }

    public ArrayList<RequisicaoLogBean> getListaLogs() {
        return this.listaLogs;
    }
}

