/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class VisualizaHistoricoExamesRealizados
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Hist\u00f3rico de Exames realizados";
    ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Exame", "Mat.", "Conv\u00eanio", "Data", "Hora"});
    JTable tableHistoricoExames = new JTable(this.modeloExames);
    JScrollPane scrollHistoricoExames = new JScrollPane(this.tableHistoricoExames);

    public static VisualizaHistoricoExamesRealizados novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new VisualizaHistoricoExamesRealizados((Dialog)pai, TITULO);
        }
        if (pai instanceof Frame) {
            return new VisualizaHistoricoExamesRealizados((Frame)pai, TITULO);
        }
        return null;
    }

    public VisualizaHistoricoExamesRealizados(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public VisualizaHistoricoExamesRealizados(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    private void montaTela() {
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setSize(new Dimension(750, 350));
        this.setModal(true);
        this.modeloExames.setColumnSize(new int[]{70, 0, 40, 100, 80, 50}, this.tableHistoricoExames);
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setText("Fechar");
        panel.add((Component)this.scrollHistoricoExames, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buscaDados(String filial, String codPaciente) {
        Statement st;
        block5: {
            st = Conexao.getStatement();
            try {
                if (st == null) break block5;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.exa_codigo, a.exc_hora, a.exc_data, a.req_codigo, b.exa_descricao, ");
                buf.append("e.mco_abreviatura, d.con_fantasia from examescontrole a ");
                buf.append("left join exames b on a.fil_codigo=b.fil_codigo and upper(a.exa_codigo)=upper(b.exa_codigo) ");
                buf.append("left join requisicao c on a.fil_codigo=c.fil_codigo and a.req_codigo=c.req_codigo ");
                buf.append("left join convenios d on a.fil_codigo=d.fil_codigo and c.con_codigo=d.con_codigo ");
                buf.append("left join materialcoleta e on a.fil_codigo = e.fil_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("where a.fil_codigo=");
                buf.append(filial);
                buf.append(" and a.pac_codigo=");
                buf.append(codPaciente);
                buf.append(" and c.req_excluida = false ");
                buf.append(" order by a.exa_codigo, a.mco_codigo");
                ResultSet rsAnt = Conexao.executeQuery(st, buf.toString());
                if (rsAnt == null) break block5;
                while (rsAnt.next()) {
                    this.modeloExames.addLine(new String[]{rsAnt.getString("exa_codigo"), rsAnt.getString("exa_descricao"), rsAnt.getString("mco_abreviatura"), rsAnt.getString("con_fantasia"), Funcoes.formataData(rsAnt.getDate("exc_data")), Funcoes.formataHora(rsAnt.getTime("exc_hora"), false)});
                }
            }
            catch (Exception sqlex) {
                try {
                    ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "VisualizaHistoricoExamesRealizados");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }
}

