/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.panel.log.email.PanelLogEmail;
import jalis.laboratorio.recepcao.panel.log.sms.PanelLogSms;
import jalis.util.Funcoes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VisualizaHistoricoEnvioEmailSMS
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Hist\u00f3rico de Envio (Email/SMS)";
    private String filial;
    private String codigoPaciente;
    private JScrollPane scrollPaneEmail;
    private PanelLogEmail panelEmail;
    private JScrollPane scrollPaneSms;
    private PanelLogSms panelSms;

    public static VisualizaHistoricoEnvioEmailSMS novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new VisualizaHistoricoEnvioEmailSMS((Dialog)pai, TITULO);
        }
        if (pai instanceof Frame) {
            return new VisualizaHistoricoEnvioEmailSMS((Frame)pai, TITULO);
        }
        return null;
    }

    public VisualizaHistoricoEnvioEmailSMS(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public VisualizaHistoricoEnvioEmailSMS(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    private void montaTela() {
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setSize(new Dimension(750, 400));
        this.setModal(true);
        Dimension envioChildDimension = new Dimension(350, 300);
        this.panelEmail = new PanelLogEmail();
        this.panelEmail.setPreferredSize(envioChildDimension);
        this.panelEmail.setBorder(BorderFactory.createTitledBorder("E-MAIL"));
        this.scrollPaneEmail = new JScrollPane(this.panelEmail);
        this.panelSms = new PanelLogSms();
        this.panelSms.setPreferredSize(envioChildDimension);
        this.panelSms.setBorder(BorderFactory.createTitledBorder("SMS"));
        this.scrollPaneSms = new JScrollPane(this.panelSms);
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setText("Fechar");
        this.scrollPaneEmail.getVerticalScrollBar().setUnitIncrement(16);
        this.scrollPaneSms.getVerticalScrollBar().setUnitIncrement(16);
        panel.add((Component)this.scrollPaneEmail, "West");
        panel.add((Component)this.scrollPaneSms, "Center");
    }

    public void carregaLogEmailSms() {
        if (this.panelEmail != null) {
            this.carregaLogEmail();
        }
        if (this.panelSms != null) {
            this.carregaLogSms();
        }
    }

    private void carregaLogSms() {
        if (!Funcoes.textoVazio(this.getCodigoPaciente())) {
            this.panelSms.carregarLog(this.getCodigoFilial(), this.getCodigoPaciente());
        }
    }

    private void carregaLogEmail() {
        if (!Funcoes.textoVazio(this.getCodigoPaciente())) {
            this.panelEmail.carregarLog(this.getCodigoFilial(), this.getCodigoPaciente());
        }
    }

    public String getCodigoFilial() {
        return this.filial;
    }

    public void setCodigoFilial(String filial) {
        this.filial = filial;
    }

    public String getCodigoPaciente() {
        return this.codigoPaciente;
    }

    public void setCodigoPaciente(String codigoPaciente) {
        this.codigoPaciente = codigoPaciente;
    }
}

