/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.recepcao.Agendamento;
import jalis.laboratorio.recepcao.Horario;
import jalis.laboratorio.recepcao.LabelDataAgenda;
import jalis.laboratorio.recepcao.LabelDataAgendaListener;
import jalis.laboratorio.recepcao.PanelAgendamento;
import jalis.model.bean.cadastro.SalaAtendimentoBean;
import jalis.model.vo.cadastro.SalaAtendimentoVO;
import jalis.service.cadastro.SalaAtendimentoService;
import jalis.service.recepcao.AgendamentoService;
import jalis.servidor.Cliente;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SolicitarDataHoraAgendamento
extends JDialog
implements DisposeListener,
ActionListener,
LabelDataAgendaListener,
WindowListener {
    private JLabel labelData = new JLabel("Data:");
    private JLabel labelHora = new JLabel("Hora:");
    private JLabel labelObservacao = new JLabel("Observa\u00e7\u00e3o:");
    private TTextField textData = new TTextField(10, 4);
    private TTextField textHora = new TTextField(5, 6);
    private JTextArea areaObservacao = new JTextArea();
    private JScrollPane scrollObservacao = new JScrollPane(this.areaObservacao);
    private JButton buttonBuscaData = new JButton();
    private JButton buttonOK = new JButton("OK");
    private JButton buttonCancelar = new JButton("Cancelar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JScrollPane scrollAgenda = new JScrollPane();
    private final JComboBox comboSalaAtendimento = new JComboBox();
    private Date dataHoraSelecionada = null;
    private boolean isOk = false;
    private boolean isDiferenciado = false;
    private boolean isAdicionando = false;
    private boolean isDuplicando = false;
    private PanelAgendamento agendaEdicao = null;
    private SalaAtendimentoBean salaAtendimento = null;
    private LabelDataAgenda labelDataAgenda = null;
    private JPanel panelDados = ComponenteFactory.novoJPanel(new GridBagLayout(), new Dimension(250, 100), new TitledBorder("Dados pr\u00e9-agendamento"));

    public SolicitarDataHoraAgendamento(SalaAtendimentoBean salaAtendimento, boolean isDiferenciado, boolean isDuplicando, Date dataHoraSelecionada, boolean apresentarPreAgendamento) {
        super(Laboratorio.getInstancia());
        this.setTitle("Requisi\u00e7\u00e3o");
        this.salaAtendimento = salaAtendimento;
        this.isDiferenciado = isDiferenciado;
        this.isDuplicando = isDuplicando;
        this.dataHoraSelecionada = dataHoraSelecionada;
        this.agendaEdicao = new PanelAgendamento(new Agendamento(), salaAtendimento, dataHoraSelecionada, false);
        this.labelDataAgenda = new LabelDataAgenda(this, dataHoraSelecionada, true, 2);
        boolean apresentarContador = this.salaAtendimento != null && this.salaAtendimento.getApresentarContador() != null && this.salaAtendimento.getApresentarContador() != false;
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(320 + (apresentarPreAgendamento ? 250 : 0), 250 + (isDiferenciado ? 0 : 200));
        this.setLocationRelativeTo(Agendamento.getInstancia());
        this.setResizable(false);
        if (!isDiferenciado) {
            if (apresentarContador) {
                this.setTitle("Selecione a posi\u00e7\u00e3o");
            } else {
                this.setTitle("Selecione o novo hor\u00e1rio");
            }
        } else {
            this.setTitle("Informe a data diferenciada");
        }
        this.montaTela(apresentarPreAgendamento);
        this.buscaSalasAtendimento(salaAtendimento);
    }

    public void setObservacao(String observacao) {
        this.areaObservacao.setText(observacao);
        this.areaObservacao.setCaretPosition(0);
    }

    public void setDadosPreAgendamento(String data, String horario, String unidade) {
        JLabel labelData = ComponenteFactory.novoJLabel(data, new Dimension(100, 20));
        JLabel labelHorario = ComponenteFactory.novoJLabel(horario, new Dimension(100, 20));
        JLabel labelUnidade = ComponenteFactory.novoJLabel(unidade, new Dimension(100, 20));
        ScreenUtil.setBorda(new Component[]{labelData, labelHorario, labelUnidade}, BorderFactory.createTitledBorder(""));
        Insets insetsZero = new Insets(0, 0, 0, 0);
        Insets insetsQuatro = new Insets(0, 0, 4, 0);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelDados.add((Component)new JLabel("Data"), c);
        ++c.gridy;
        c.insets = insetsQuatro;
        this.panelDados.add((Component)labelData, c);
        ++c.gridy;
        c.insets = insetsZero;
        this.panelDados.add((Component)new JLabel("Hor\u00e1rio"), c);
        ++c.gridy;
        c.insets = insetsQuatro;
        this.panelDados.add((Component)labelHorario, c);
        ++c.gridy;
        c.insets = insetsZero;
        this.panelDados.add((Component)new JLabel("Unidade"), c);
        ++c.gridy;
        c.insets = insetsQuatro;
        this.panelDados.add((Component)labelUnidade, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.panelDados.add((Component)new JPanel(), c);
    }

    private void montaTela(boolean apresentarPreAgendamento) {
        JPanel panelCentral = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)panelCentral, "Center");
        if (apresentarPreAgendamento) {
            this.getContentPane().add((Component)this.panelDados, "West");
        }
        this.scrollAgenda.setViewportView(this.agendaEdicao);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        this.comboSalaAtendimento.setPreferredSize(new Dimension(20, 20));
        this.comboSalaAtendimento.setMinimumSize(new Dimension(20, 20));
        if (this.isDiferenciado) {
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.weightx = 1.0;
            c.fill = 2;
            panelCentral.add((Component)this.comboSalaAtendimento, c);
            ++c.gridy;
            c.gridwidth = 1;
            c.weightx = 0.0;
            c.fill = 0;
            this.labelData.setDisplayedMnemonic('D');
            this.labelData.setLabelFor(this.textData);
            panelCentral.add((Component)this.labelData, c);
            ++c.gridx;
            this.textData.setPreferredSize(new Dimension(100, 20));
            this.textData.setMinimumSize(new Dimension(100, 20));
            panelCentral.add((Component)this.textData, c);
            ++c.gridx;
            this.buttonBuscaData.setPreferredSize(new Dimension(20, 20));
            this.buttonBuscaData.setMinimumSize(new Dimension(20, 20));
            Funcoes.imagemPesquisa(this.buttonBuscaData);
            this.buttonBuscaData.setFocusable(false);
            panelCentral.add((Component)this.buttonBuscaData, c);
            c.gridx = 0;
            ++c.gridy;
            this.labelHora.setDisplayedMnemonic('H');
            this.labelHora.setLabelFor(this.textHora);
            panelCentral.add((Component)this.labelHora, c);
            ++c.gridx;
            this.textHora.setPreferredSize(new Dimension(70, 20));
            this.textHora.setMinimumSize(new Dimension(70, 20));
            panelCentral.add((Component)this.textHora, c);
        } else {
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 3;
            c.weightx = 1.0;
            c.fill = 2;
            panelCentral.add((Component)this.comboSalaAtendimento, c);
            ++c.gridy;
            panelCentral.add((Component)this.labelDataAgenda, c);
            ++c.gridy;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            this.scrollAgenda.setVerticalScrollBarPolicy(20);
            this.scrollAgenda.setHorizontalScrollBarPolicy(31);
            this.scrollAgenda.getVerticalScrollBar().setUnitIncrement(5);
            panelCentral.add((Component)this.scrollAgenda, c);
        }
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.3;
        this.labelObservacao.setDisplayedMnemonic('b');
        this.labelObservacao.setLabelFor(this.areaObservacao);
        panelCentral.add((Component)this.labelObservacao, c);
        ++c.gridx;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 1;
        this.areaObservacao.setLineWrap(true);
        this.scrollObservacao.setVerticalScrollBarPolicy(20);
        this.scrollObservacao.setHorizontalScrollBarPolicy(31);
        panelCentral.add((Component)this.scrollObservacao, c);
        c.gridx = 0;
        c.gridwidth = 3;
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        this.buttonOK.setMnemonic('O');
        this.buttonCancelar.setMnemonic('C');
        this.panelBotoes.add(this.buttonOK);
        this.panelBotoes.add(this.buttonCancelar);
        panelCentral.add((Component)this.panelBotoes, c);
        this.comboSalaAtendimento.addActionListener(this);
        this.buttonOK.addActionListener(this);
        this.buttonCancelar.addActionListener(this);
        this.buttonBuscaData.addActionListener(this);
        if (this.labelDataAgenda != null) {
            this.labelDataAgenda.addListener(this);
        }
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    SolicitarDataHoraAgendamento.this.buttonBuscaData.doClick();
                }
            }
        });
        Funcoes.montaEnter((JComponent)this.getContentPane());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            if (this.validaCampos()) {
                if (this.agendaEdicao != null) {
                    this.agendaEdicao.pararThread();
                }
                this.isOk = true;
                this.setVisible(false);
                return;
            }
            this.isOk = false;
        } else {
            if (e.getSource() == this.buttonCancelar) {
                if (this.isAdicionando && Funcoes.mensagem(this, "O agendamento ser\u00e1 cancelado e a requisi\u00e7\u00e3o ser\u00e1 mantida e liberada para uso fora do agendamento.\n Deseja continuar e cancelar o agendamento?", 4) == 1) {
                    return;
                }
                if (this.agendaEdicao != null) {
                    Agendamento.setConfirmaCancelamento(Funcoes.mensagem(this, "A requisi\u00e7\u00e3o ser\u00e1 cancelada. Deseja continuar?", 4));
                    if (Agendamento.getConfirmaCancelamento() == 1) {
                        this.setVisible(true);
                        return;
                    }
                    this.agendaEdicao.pararThread();
                }
                this.isOk = false;
                this.setVisible(false);
                return;
            }
            if (e.getSource() == this.buttonBuscaData) {
                Funcoes.mostraData(this.textData, this.buttonBuscaData, (JPanel)this.getContentPane(), true);
            } else if (e.getSource() == this.comboSalaAtendimento) {
                if (this.isAdicionando) {
                    return;
                }
                if (this.comboSalaAtendimento.getSelectedItem() != null && this.comboSalaAtendimento.getSelectedItem() instanceof SalaAtendimentoBean) {
                    this.atualizarDadosAgendas();
                }
            }
        }
    }

    private void atualizarDadosAgendas() {
        SalaAtendimentoBean sala = (SalaAtendimentoBean)this.comboSalaAtendimento.getSelectedItem();
        this.configurarAgendas(sala);
        try {
            this.agendaEdicao.buscaAgendamentos(sala, sala.getFilial().getCodigo(), this.labelDataAgenda.getData());
            this.agendaEdicao.revalidate();
            this.agendaEdicao.repaint();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar os agendamentos.\n" + e.getMessage(), e.getStackTrace());
        }
    }

    private void configurarAgendas(SalaAtendimentoBean sala) {
        if (sala != null) {
            this.agendaEdicao.setQuantidadeColetadores(sala.getQtdeColetadores());
            this.agendaEdicao.setApresentarContador(sala.getApresentarContador() != null && sala.getApresentarContador() != false);
            this.agendaEdicao.validaDiaSemana(sala, this.labelDataAgenda.getData());
        }
    }

    private boolean validaCampos() {
        SalaAtendimentoBean salaAtual = (SalaAtendimentoBean)this.comboSalaAtendimento.getSelectedItem();
        if (!this.isDiferenciado) {
            if (Horario.horarioSelecionado == null) {
                Funcoes.mensagem(this, "Um hor\u00e1rio deve ser selecionado na agenda.", 2);
                return false;
            }
            Integer horaSelecionada = Horario.horarioSelecionado.horaInicial;
            Integer minutoSelecionado = Horario.horarioSelecionado.minutoInicial;
            Date dataSelecionada = this.labelDataAgenda.getData();
            if (horaSelecionada == null || dataSelecionada == null || Horario.horarioSelecionado.isBloqueado) {
                Funcoes.mensagem(this, "Agendamento n\u00e3o permitido.", 2);
                return false;
            }
            Calendar calAux = Calendar.getInstance();
            calAux.setTime(dataSelecionada);
            calAux.set(11, horaSelecionada);
            calAux.set(12, minutoSelecionado);
            Date dataAux = calAux.getTime();
            Integer qtdeBloqueada = Cliente.getInstancia().getQuantidadeAgendamentos(salaAtual.getCodigo(), dataAux);
            if (Horario.horarioSelecionado.getQuantidadeAgendamentos() + qtdeBloqueada >= salaAtual.getQtdeColetadores()) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel fazer mais agendamentos no hor\u00e1rio selecionado.", 2);
                return false;
            }
            Calendar calMax = Calendar.getInstance();
            Date hoje = new Date();
            calMax.setTime(hoje);
            calMax.add(5, ParametrosGerais.getQtdeMaxAgendamento());
            if (ParametrosGerais.getQtdeMaxAgendamento() > 0 && dataAux.compareTo(calMax.getTime()) > 0) {
                Funcoes.mensagem(this, "A data selecionada atinge o limite m\u00e1ximo permitido. (Max. " + ParametrosGerais.getQtdeMaxAgendamento() + " dias)", 2);
                return false;
            }
            Calendar aux = Calendar.getInstance();
            aux.setTime(dataSelecionada);
            aux.set(11, horaSelecionada);
            aux.set(12, minutoSelecionado);
            Date dataCompletaAux = aux.getTime();
            if (!salaAtual.getApresentarContador().booleanValue() && dataCompletaAux.compareTo(new Date()) < 0) {
                Funcoes.mensagem(this, "A data/hora selecionada \u00e9 anterior \u00e0 data atual.", 2);
                return false;
            }
            if (Horario.horarioSelecionado.isHorarioDiferenciado && !Acesso.getAcesso(Agendamento.getModuloIncluirDiferenciado())) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remarcar o agendamento em um hor\u00e1rio diferenciado.\nO usu\u00e1rio n\u00e3o possui acesso \u00e0 essa opera\u00e7\u00e3o.", 2);
                return false;
            }
            if (Horario.horarioSelecionado.isBloqueado) {
                Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel remarcar o agendamento em um hor\u00e1rio bloqueado. ", 2);
                return false;
            }
            if (dataCompletaAux.compareTo(this.dataHoraSelecionada) == 0 && !this.isDuplicando) {
                Funcoes.mensagem(this, "O agendamento n\u00e3o pode ser duplicado no mesmo hor\u00e1rio.", 2);
                return false;
            }
        } else {
            if (Funcoes.textoVazio(this.textData)) {
                Funcoes.mensagem(this, "A data do agendamento deve ser informada.", 2);
                return false;
            }
            if (Funcoes.textoVazio(this.textHora)) {
                Funcoes.mensagem(this, "A hora do agendamento deve ser informada.", 2);
                return false;
            }
            Date dataAux = Funcoes.getData("dd/MM/yyyy HH:mm", this.textData.getText() + " " + this.textHora.getText());
            this.agendaEdicao = new PanelAgendamento(salaAtual, dataAux, true);
            this.agendaEdicao.atualizaAgendamentos();
            if (this.agendaEdicao.getHorario(new Time(dataAux.getTime())) != null && this.agendaEdicao.getHorario((Time)new Time((long)dataAux.getTime())).isBloqueado) {
                Funcoes.mensagem(this, "O hor\u00e1rio informado est\u00e1 bloqueado.", 2);
                return false;
            }
            if (dataAux.compareTo(new Date()) < 0) {
                Funcoes.mensagem(this, "O hor\u00e1rio informado \u00e9 anterior \u00e0 data atual.", 2);
                return false;
            }
            try {
                Integer qtdeBloqueada = Cliente.getInstancia().getQuantidadeAgendamentos(salaAtual.getCodigo(), dataAux);
                int qtde = new AgendamentoService().getQuantidadeAgendamentosDataHora(Variaveis.filialPadrao, (SalaAtendimentoVO)salaAtual.toVO(), dataAux);
                if (qtde + qtdeBloqueada >= salaAtual.getQtdeColetadores()) {
                    Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel fazer mais agendamentos no hor\u00e1rio selecionado.", 2);
                    return false;
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar se h\u00e1 disponibilidade do hor\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
                return false;
            }
            if (dataAux.compareTo(this.dataHoraSelecionada) == 0 && !this.isDuplicando) {
                Funcoes.mensagem(this, "O agendamento n\u00e3o pode ser duplicado no mesmo hor\u00e1rio.", 2);
                return false;
            }
        }
        return true;
    }

    public boolean isOk() {
        return this.isOk;
    }

    public SalaAtendimentoBean getSalaAtendimento() {
        if (this.isOk) {
            return (SalaAtendimentoBean)this.comboSalaAtendimento.getSelectedItem();
        }
        return null;
    }

    public Date getDataHora() {
        if (this.isOk) {
            if (!this.isDiferenciado) {
                Calendar aux = Calendar.getInstance();
                aux.setTime(this.labelDataAgenda.getData());
                aux.set(11, Horario.horarioSelecionado.horaInicial);
                aux.set(12, Horario.horarioSelecionado.minutoInicial);
                return aux.getTime();
            }
            return Funcoes.getData("dd/MM/yyyy HH:mm", this.textData.getText() + " " + this.textHora.getText());
        }
        return null;
    }

    public String getObservacao() {
        if (this.isOk) {
            return this.areaObservacao.getText();
        }
        return null;
    }

    @Override
    public void retrocederData() {
        Horario.horarioSelecionado = null;
        SalaAtendimentoBean salaAtual = (SalaAtendimentoBean)this.comboSalaAtendimento.getSelectedItem();
        this.labelDataAgenda.setData(Funcoes.subtraiDias(this.labelDataAgenda.getData(), 1));
        this.agendaEdicao.validaDiaSemana(salaAtual, this.labelDataAgenda.getData());
        this.agendaEdicao.buscaAgendamentos(salaAtual, Integer.parseInt(Variaveis.filialPadrao), this.labelDataAgenda.getData());
    }

    @Override
    public void avancarData() {
        Horario.horarioSelecionado = null;
        SalaAtendimentoBean salaAtual = (SalaAtendimentoBean)this.comboSalaAtendimento.getSelectedItem();
        this.labelDataAgenda.setData(Funcoes.somaDias(this.labelDataAgenda.getData(), 1));
        this.agendaEdicao.validaDiaSemana(salaAtual, this.labelDataAgenda.getData());
        this.agendaEdicao.buscaAgendamentos(salaAtual, Integer.parseInt(Variaveis.filialPadrao), this.labelDataAgenda.getData());
    }

    @Override
    public void windowOpened(WindowEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SolicitarDataHoraAgendamento.this.toFront();
                if (!SolicitarDataHoraAgendamento.this.isDiferenciado) {
                    Horario aux = SolicitarDataHoraAgendamento.this.agendaEdicao.getHorario(new Time(SolicitarDataHoraAgendamento.this.dataHoraSelecionada.getTime()));
                    if (aux != null) {
                        aux.selecionar();
                        SolicitarDataHoraAgendamento.this.agendaEdicao.scrollRectToVisible(aux.getBounds());
                    }
                    ScreenUtil.requisitarFoco(SolicitarDataHoraAgendamento.this.areaObservacao);
                } else {
                    ScreenUtil.requisitarFoco(SolicitarDataHoraAgendamento.this.textData);
                }
            }
        });
    }

    @Override
    @Deprecated
    public void windowClosing(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowClosed(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowIconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowActivated(WindowEvent e) {
    }

    @Override
    @Deprecated
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void calendarioSelecionado(LabelDataAgenda source, Date data) {
        Horario.horarioSelecionado = null;
        SalaAtendimentoBean salaAtual = (SalaAtendimentoBean)this.comboSalaAtendimento.getSelectedItem();
        this.labelDataAgenda.setData(data);
        this.agendaEdicao.validaDiaSemana(salaAtual, this.labelDataAgenda.getData());
        this.agendaEdicao.buscaAgendamentos(salaAtual, Integer.parseInt(Variaveis.filialPadrao), this.labelDataAgenda.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaSalasAtendimento(SalaAtendimentoBean salaAtual) {
        this.isAdicionando = true;
        this.comboSalaAtendimento.removeAllItems();
        try {
            ArrayList salas = new ArrayList(new SalaAtendimentoService().load(" where fil_codigo = " + Integer.parseInt(Variaveis.filialPadrao) + " and sal_inativa = false"));
            Collections.sort(salas, new Comparator<SalaAtendimentoBean>(){

                @Override
                public int compare(SalaAtendimentoBean o1, SalaAtendimentoBean o2) {
                    if (o1 != null && o2 != null) {
                        return o1.getDescricao().compareTo(o2.getDescricao());
                    }
                    return 0;
                }
            });
            SalaAtendimentoBean auxSelecionada = null;
            if (salas != null && salas.size() > 0) {
                for (SalaAtendimentoBean sala : salas) {
                    this.comboSalaAtendimento.addItem(sala);
                    if (sala.getCodigo().intValue() != salaAtual.getCodigo().intValue()) continue;
                    auxSelecionada = sala;
                }
            }
            this.comboSalaAtendimento.setSelectedItem(auxSelecionada);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar salas de atendimento.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            this.isAdicionando = false;
        }
    }
}

