/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.cadastro.PacienteVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SelecionarPacienteExistente
extends AbstractDialogoOKCancelar
implements ActionListener {
    private final int COLUNA_NOME_PACINETE = 1;
    private final int COLUNA_DADOS_PACIENTE = 8;
    private Boolean isOK = false;
    private boolean isCadastrarNovo = false;
    private ArrayList<PacienteVO> pacientes = new ArrayList();
    private PacienteVO paciente = new PacienteVO();
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Nome", "Nome Social", "CPF", "RG", "Nascimento", "Celular", "Nome da m\u00e3e", ""});
    private JTable tablePaciente = ComponenteFactory.novoJTable((TableModel)this.modelo, 70, 0, 180, 100, 100, 80, 100, 160, 1);
    private JScrollPane scrollPaciente = new JScrollPane(this.tablePaciente);
    private JButton buttonNovo = ComponenteFactory.novoJButton("Cadastrar novo", 'N', this);

    public SelecionarPacienteExistente(JFrame owner, ArrayList<PacienteVO> pacientes) {
        super((Frame)owner, "Cadastros existentes");
        this.pacientes.addAll(pacientes);
        this.montaTela(owner);
    }

    private void montaTela(JFrame owner) {
        this.getBotaoOK().setText("Selecionar");
        this.setLayout(new BorderLayout());
        this.setSize(985, 200);
        this.modelo.setColumnSize(new int[]{70, 0, 180, 100, 100, 80, 100, 160, 1}, this.tablePaciente);
        this.add((Component)this.scrollPaciente, "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
        this.carregaDados();
        this.modelo.ordenarColuna(1);
        this.getPanelBotoesDireita().remove(this.getBotaoCancelar());
        this.getPanelBotoesDireita().add(this.buttonNovo);
        this.getPanelBotoesDireita().add(this.getBotaoCancelar());
    }

    private void carregaDados() {
        for (PacienteVO pac : this.pacientes) {
            this.modelo.addLine(new Object[]{pac.getCodigo(), pac.getNome(), pac.getNomeSocial(), pac.getCpf(), pac.getRg(), Funcoes.formataData("dd/MM/yyyy", pac.getDataNascimento()), pac.getCelular(), pac.getNomeMae(), pac});
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
        if (e.getSource() == this.buttonOK) {
            this.getPacienteSelecionado();
        }
        if (e.getSource() == this.buttonNovo) {
            this.isCadastrarNovo = true;
            this.dispose();
        }
    }

    private void getPacienteSelecionado() {
        if (this.tablePaciente.getSelectedRow() >= 0) {
            this.isOK = true;
            this.paciente = (PacienteVO)this.modelo.getValueAt(this.tablePaciente.getSelectedRow(), 8);
            this.dispose();
        } else {
            Funcoes.mensagem(this, "Selecione um paciente", 2);
        }
    }

    public boolean isOK() {
        return this.isOK;
    }

    public boolean isCadastrarNovo() {
        return this.isCadastrarNovo;
    }

    public PacienteVO getPaciente() {
        return this.paciente;
    }
}

