/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class SelecionarMaterialAlimentos
extends AbstractDialogoOKCancelar {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Material"});
    private JTable table = new JTable(this.modelo);

    public static SelecionarMaterialAlimentos novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new SelecionarMaterialAlimentos((Frame)pai, "Selecionar material");
        }
        if (pai instanceof Dialog) {
            return new SelecionarMaterialAlimentos((Dialog)pai, "Selecionar material");
        }
        return null;
    }

    public SelecionarMaterialAlimentos(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    public SelecionarMaterialAlimentos(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela(pai);
    }

    private void montaTela(Container pai) {
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)new JLabel("Selecione o material para a requisi\u00e7\u00e3o"), "North");
        this.getPanelCentral().add((Component)new JScrollPane(this.table), "Center");
        this.setSize(new Dimension(300, 250));
        this.setLocationRelativeTo(pai);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                ScreenUtil.requisitarFoco(SelecionarMaterialAlimentos.this.table);
            }
        });
    }

    public void limparMateriais() {
        this.modelo.clear();
    }

    public void adicionaMaterial(MaterialColetaVO material) {
        this.modelo.addLine(new Object[]{material});
    }

    public int getMaterialSelecionado() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return -1;
        }
        return this.modelo.getRowCount() > 0 ? ((MaterialColetaVO)this.table.getValueAt(this.table.getSelectedRow(), 0)).getCodigo() : -1;
    }

    @Override
    public boolean acaoOk() {
        if (this.getMaterialSelecionado() < 0) {
            Funcoes.mensagem(this, "Nenhum material foi selecionado para criar as requisi\u00e7\u00f5es.", 2);
            ScreenUtil.requisitarFoco(this.table);
            return false;
        }
        return true;
    }
}

