/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.recepcao.ButtonEditor;
import jalis.laboratorio.recepcao.ButtonRenderer;
import jalis.laboratorio.recepcao.selecionarimagem.DescricaoImagem;
import jalis.model.vo.recepcao.RequisicaoImagensVO;
import jalis.service.recepcao.RequisicaoImagensService;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.commons.codec.binary.Base64;
import uk.co.mmscomputing.device.scanner.Scanner;
import uk.co.mmscomputing.device.scanner.ScannerIOMetadata;
import uk.co.mmscomputing.device.scanner.ScannerListener;

public class SelecionarImagem
extends AbstractDialogoOKCancelar {
    public static int TIPO_IMAGEM_PACIENTE = 1;
    public static int TIPO_IMAGEM_REQUISICAO = 2;
    public static int COLUNA_DESCRICAO = 0;
    public static int COLUNA_TIPO = 3;
    public static int COLUNA_BOTAO = 4;
    public static int COLUNA_OBJETO = 5;
    private String mensagemInformarDescricao = "A descri\u00e7\u00e3o do anexo deve ser informada";
    private boolean isVerficouRegistros = false;
    private int tipo = TIPO_IMAGEM_REQUISICAO;
    private String filial;
    private String requisicao;
    private String paciente;
    private List<RequisicaoImagensVO> listaRequisicoesImagens = new ArrayList<RequisicaoImagensVO>();
    private List<RequisicaoImagensVO> listaRequisicoesImagensExcluidos = new ArrayList<RequisicaoImagensVO>();
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"Descri\u00e7\u00e3o", "Data", "Usu\u00e1rio", "Tipo", "", ""});
    private JTable table = new JTable(this.modelo){

        @Override
        public Class<?> getColumnClass(int column) {
            if (SelecionarImagem.this.isColunaBotao(column)) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return SelecionarImagem.this.isColunaBotao(column);
        }
    };
    private JScrollPane scroll = new JScrollPane(this.table);
    private JButton buttonAdicionar = ComponenteFactory.novoJButton("Adicionar", 'A', this);
    private JButton buttonCapturar = ComponenteFactory.novoJButton("Capturar", 'p', this);

    public SelecionarImagem(Dialog pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public SelecionarImagem(Frame pai, String titulo) {
        super(pai, titulo);
        this.montaTela();
        this.setLocationRelativeTo(pai);
    }

    public static SelecionarImagem novaInstancia(Object pai) {
        if (pai instanceof Dialog) {
            return new SelecionarImagem((Dialog)pai, "Anexos");
        }
        if (pai instanceof Frame) {
            return new SelecionarImagem((Frame)pai, "Anexos");
        }
        return null;
    }

    public void setTipo(int tipo) {
        this.tipo = tipo;
    }

    private void montaTela() {
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumn("").setCellRenderer(new ButtonRenderer());
        this.table.getColumn("").setCellEditor(new ButtonEditor(this, this.table));
        this.setResizable(false);
        this.getPanelBotoesEsquerda().setLayout(new FlowLayout(2));
        this.getPanelBotoesEsquerda().add(this.buttonAdicionar);
        if (this.temScanner()) {
            this.getPanelBotoesEsquerda().add(this.buttonCapturar);
        }
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)this.scroll, "Center");
        this.table.getColumnModel().getColumn(COLUNA_OBJETO).setMaxWidth(0);
        this.table.getColumnModel().getColumn(COLUNA_OBJETO).setMinWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(COLUNA_OBJETO).setMaxWidth(0);
        this.table.getTableHeader().getColumnModel().getColumn(COLUNA_OBJETO).setMinWidth(0);
        this.setSize(new Dimension(600, 400));
        this.modelo.setColumnSize(new int[]{0, 120, 90, 76, 35, 0}, this.table);
        this.table.setRowHeight(20);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (SelecionarImagem.this.table.getRowCount() > 0) {
                    SelecionarImagem.this.table.setRowSelectionInterval(0, 0);
                    ScreenUtil.requisitarFoco(SelecionarImagem.this.table);
                }
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                int linha = SelecionarImagem.this.table.getSelectedRow();
                if (linha >= 0) {
                    if (e.getKeyCode() == 113) {
                        RequisicaoImagensVO requisicaoImagensVO = (RequisicaoImagensVO)SelecionarImagem.this.modelo.getValueAt(linha, COLUNA_OBJETO);
                        DescricaoImagem descricaoImagem = DescricaoImagem.novaInstancia(SelecionarImagem.this);
                        descricaoImagem.setDescricao(requisicaoImagensVO.getDescricaoRequisicaoImagens());
                        descricaoImagem.setTipoOperacao(DescricaoImagem.getDescricaoOperacao(requisicaoImagensVO.getTipoOperacao()));
                        descricaoImagem.setVisible(true);
                        if (!descricaoImagem.getDescricao().isEmpty()) {
                            SelecionarImagem.this.listaRequisicoesImagens.remove(requisicaoImagensVO);
                            requisicaoImagensVO.setDescricaoRequisicaoImagensEdicao(descricaoImagem.getDescricao());
                            requisicaoImagensVO.setTipoOperacaoEdicao(descricaoImagem.getTipoOperacao());
                            requisicaoImagensVO.setFlagSalvar(true);
                            SelecionarImagem.this.listaRequisicoesImagens.add(requisicaoImagensVO);
                            SelecionarImagem.this.modelo.setValueAt(descricaoImagem.getDescricao(), linha, COLUNA_DESCRICAO);
                            SelecionarImagem.this.modelo.setValueAt(DescricaoImagem.getDescricaoOperacao(descricaoImagem.getTipoOperacao()), linha, COLUNA_TIPO);
                        } else {
                            Funcoes.mensagem(SelecionarImagem.this, SelecionarImagem.this.mensagemInformarDescricao, 1);
                        }
                    }
                    if (e.getKeyCode() == 127 && SelecionarImagem.this.linhaSelecionada(linha) && SelecionarImagem.this.autorizaExclus\u00e3o()) {
                        RequisicaoImagensVO codigo = (RequisicaoImagensVO)SelecionarImagem.this.modelo.getValueAt(linha, COLUNA_OBJETO);
                        Statement st = Conexao.getStatement();
                        try {
                            StringBuilder buf = new StringBuilder();
                            if (SelecionarImagem.this.isRequisicao()) {
                                for (RequisicaoImagensVO requisicaoImagensVO : SelecionarImagem.this.listaRequisicoesImagens) {
                                    if (!requisicaoImagensVO.getCodigoRequisicaoImagens().equals(codigo.getCodigoRequisicaoImagens())) continue;
                                    requisicaoImagensVO.setFlagSalvar(true);
                                    SelecionarImagem.this.listaRequisicoesImagens.remove(requisicaoImagensVO);
                                    SelecionarImagem.this.listaRequisicoesImagensExcluidos.add(requisicaoImagensVO);
                                    break;
                                }
                            } else {
                                buf.append("delete from pacienteimagens ");
                                buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                                buf.append("  and pim_codigo = ").append(codigo);
                                Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                                Conexao.arquivaSQL();
                            }
                            SelecionarImagem.this.modelo.removeLine(linha);
                        }
                        catch (Exception e2) {
                            try {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(SelecionarImagem.this, "N\u00e3o foi poss\u00edvel remover a imagem", e2.getStackTrace());
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st);
                        }
                        Conexao.fecharStatement(st);
                    }
                }
            }
        });
    }

    private boolean temScanner() {
        return !Funcoes.textoVazio(ParametrosLocais.getParametro("scannerCaptura")) && !ParametrosLocais.getParametro("scannerCaptura").equals("Sem scanner");
    }

    private boolean autorizaExclus\u00e3o() {
        return Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0;
    }

    private boolean linhaSelecionada(int linha) {
        return linha > -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.botaoPressionado(e, this.buttonAdicionar)) {
            this.adicionarImagem();
        } else if (this.botaoPressionado(e, this.buttonCapturar)) {
            this.capturarImagem();
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean botaoPressionado(ActionEvent e, JButton button) {
        return e.getSource() == button;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adicionarImagem() {
        ImageIcon imagem = null;
        JFileChooser fc = ComponenteFactory.novoJFileChooser();
        fc.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de imagem ou PDF", "bmp", "jpg", "jpeg", "gif", "png", "pdf"));
        if (fc.showOpenDialog(this) == 0) {
            imagem = new ImageIcon(fc.getSelectedFile().getPath());
            double tamPDF = fc.getSelectedFile().length();
            if (tamPDF < 1.0) {
                Funcoes.mensagem(this, "PDF Inv\u00e1lido", 1);
                return;
            }
        } else {
            return;
        }
        String extensaoDoArquivo = SelecionarImagem.getFileExtension(fc.getSelectedFile().getPath());
        if (this.possuiImagem(imagem)) {
            if (!extensaoDoArquivo.equals("pdf")) {
                this.salvarArquivos(ImagemUtils.imageToByte(imagem.getImage()), extensaoDoArquivo);
            } else {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(fc.getSelectedFile().getPath());
                    int numberBytes = inputStream.available();
                    byte[] bytearray = new byte[numberBytes];
                    int count = inputStream.read(bytearray);
                    if (count > 0) {
                        this.salvarArquivos(bytearray, extensaoDoArquivo);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public static String getFileExtension(String filename) {
        if (filename.contains(".")) {
            return filename.substring(filename.lastIndexOf(".") + 1);
        }
        return "";
    }

    private boolean possuiImagem(ImageIcon imagem) {
        return imagem != null;
    }

    private void capturarImagem() {
        Scanner scanner = Scanner.getDevice();
        try {
            scanner.addListener(new ScannerListener(){

                public void update(ScannerIOMetadata.Type type, ScannerIOMetadata siom) {
                    if (type.equals(ScannerIOMetadata.ACQUIRED)) {
                        BufferedImage bufferedImage = siom.getImage();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
                            SelecionarImagem.this.salvarArquivos(ImagemUtils.imageToByte(bufferedImage), null);
                        }
                        catch (IOException e) {
                            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel converter a imagem importada", e.getStackTrace());
                            e.printStackTrace();
                        }
                    }
                }
            });
            scanner.select(ParametrosLocais.getParametro("scannerCaptura"));
            scanner.acquire();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel capturar imagem", e.getStackTrace());
            e.printStackTrace();
        }
    }

    private void salvarArquivos(byte[] byt, String extensaoDoArquivo) {
        if (byt != null) {
            DescricaoImagem descricaoImagem = DescricaoImagem.novaInstancia(this);
            descricaoImagem.setVisible(true);
            if (!Funcoes.textoVazio(descricaoImagem.getDescricao())) {
                if (this.tipo == TIPO_IMAGEM_REQUISICAO) {
                    Integer codigoImagem = 1;
                    if (this.tabelaPreenchida()) {
                        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                            Integer imagemModelo = 0;
                            if (this.modelo.getValueAt(i, COLUNA_BOTAO) != null) {
                                imagemModelo = Integer.valueOf(this.modelo.getValueAt(i, COLUNA_BOTAO).toString());
                            }
                            if (!this.maiorNumero(codigoImagem, imagemModelo)) continue;
                            codigoImagem = Integer.valueOf(this.modelo.getValueAt(i, COLUNA_BOTAO).toString()) + 1;
                        }
                    }
                    RequisicaoImagensVO requisicaoImagens = new RequisicaoImagensVO();
                    requisicaoImagens.setCodigoRequisicaoImagens(codigoImagem.toString());
                    requisicaoImagens.setCodigoFilial(this.filial);
                    requisicaoImagens.setCodigoUsuario(Variaveis.login);
                    requisicaoImagens.setDataHora(new Date());
                    requisicaoImagens.setDescricaoRequisicaoImagens(descricaoImagem.getDescricao());
                    requisicaoImagens.setTipoOperacao(descricaoImagem.getTipoOperacao());
                    requisicaoImagens.setImagem(SelecionarImagem.transformarBase64(byt));
                    requisicaoImagens.setExtensao(extensaoDoArquivo);
                    requisicaoImagens.setFlagSalvar(true);
                    this.listaRequisicoesImagens.add(requisicaoImagens);
                    this.modelo.addLine(new Object[]{requisicaoImagens.getDescricaoRequisicaoImagens(), Funcoes.formataData("dd/MM/yyyy kk:mm", requisicaoImagens.getDataHora()), requisicaoImagens.getCodigoUsuario(), DescricaoImagem.getDescricaoOperacao(requisicaoImagens.getTipoOperacao()), requisicaoImagens.getCodigoRequisicaoImagens(), requisicaoImagens});
                } else {
                    Statement st = Conexao.getStatement();
                    StringBuilder buf = new StringBuilder();
                    buf.append("insert into pacienteimagens(fil_codigo, pac_codigo, pim_descricao, pim_datahora, usr_codigo, pim_imagem) values (");
                    buf.append(this.filial).append(", ");
                    buf.append(this.paciente).append(", ");
                    buf.append(StringUtil.textoDBEscape(descricaoImagem.getDescricao())).append(", ");
                    buf.append("'").append(Funcoes.formataData("MM-dd-yyyy kk:mm:ss", new Date())).append("', ");
                    buf.append(StringUtil.textoDBEscape(Variaveis.login)).append(", ");
                    buf.append(StringUtil.textoDBEscape(SelecionarImagem.transformarBase64(byt))).append(")");
                    try {
                        Conexao.executeUpdate(Variaveis.filialPadrao, st, buf);
                        Conexao.arquivaSQL();
                        if (this.tipo == TIPO_IMAGEM_PACIENTE) {
                            this.setPaciente(this.filial, this.paciente);
                        }
                    }
                    catch (SQLException e) {
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel adicionar a imagem", e.getStackTrace(), "SelecionarImagem (173)");
                    }
                }
            } else {
                Funcoes.mensagem(this, this.mensagemInformarDescricao, 1);
            }
        }
    }

    public static String transformarBase64(byte[] bt) {
        return new Base64().encodeAsString(bt);
    }

    private boolean tabelaPreenchida() {
        return this.modelo.getRowCount() > 0;
    }

    private boolean maiorNumero(Integer codigoImagem, Integer codigoTabela) {
        return codigoImagem <= codigoTabela;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaciente(String filial, String paciente) {
        if (filial == null || paciente == null) {
            return;
        }
        this.filial = filial;
        this.paciente = paciente;
        this.modelo.clear();
        StringBuilder buf = new StringBuilder();
        buf.append("select pim_codigo, pim_descricao, pim_datahora, usr_codigo ");
        buf.append("from pacienteimagens ");
        buf.append("where fil_codigo = ").append(filial);
        buf.append("  and pac_codigo = ").append(paciente);
        buf.append(" order by pim_descricao ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                this.modelo.addLine(new String[]{rs.getString("pim_descricao"), Funcoes.formataData("dd/MM/yyyy kk:mm", rs.getTimestamp("pim_datahora")), rs.getString("usr_codigo"), rs.getString("pim_codigo")});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar imagens do paciente", e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    public void setRequisicao(String filial, String requisicao) {
        if (filial != null) {
            this.filial = filial;
        }
        if (filial == null || Funcoes.textoVazio(requisicao)) {
            return;
        }
        this.requisicao = requisicao;
        this.modelo.clear();
        RequisicaoImagensVO requisicaoImagem = new RequisicaoImagensVO();
        requisicaoImagem.setCodigoFilial(filial);
        requisicaoImagem.setCodigoRequisicao(requisicao);
        try {
            RequisicaoImagensService service = new RequisicaoImagensService();
            this.listaRequisicoesImagens = service.buscaRequisicaoImagens(requisicaoImagem);
            for (RequisicaoImagensVO requisicaoImagensVO : this.listaRequisicoesImagens) {
                this.modelo.addLine(new Object[]{requisicaoImagensVO.getDescricaoRequisicaoImagens(), Funcoes.formataData("dd/MM/yyyy kk:mm", requisicaoImagensVO.getDataHora()), requisicaoImagensVO.getCodigoUsuario(), DescricaoImagem.getDescricaoOperacao(requisicaoImagensVO.getTipoOperacao()), requisicaoImagensVO.getCodigoRequisicaoImagens(), requisicaoImagensVO});
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar imagens da requisi\u00e7\u00e3o", e.getStackTrace());
        }
    }

    private boolean isColunaBotao(int column) {
        return COLUNA_BOTAO == column;
    }

    private boolean isRequisicao() {
        return this.tipo == TIPO_IMAGEM_REQUISICAO;
    }

    public List<RequisicaoImagensVO> getListaRequisicoesImagens() {
        if (!this.isVerficouRegistros) {
            this.isVerficouRegistros = true;
            this.verificarRegistrosParaRetorno();
        }
        return this.listaRequisicoesImagens;
    }

    public void setListaRequisicoesImagens(List<RequisicaoImagensVO> listaRequisicoesImagens) {
        this.listaRequisicoesImagens = listaRequisicoesImagens;
        for (RequisicaoImagensVO requisicaoImagensVO : listaRequisicoesImagens) {
            this.modelo.addLine(new Object[]{requisicaoImagensVO.getDescricaoRequisicaoImagens(), Funcoes.formataData("dd/MM/yyyy kk:mm", requisicaoImagensVO.getDataHora()), requisicaoImagensVO.getCodigoUsuario(), DescricaoImagem.getDescricaoOperacao(requisicaoImagensVO.getTipoOperacao()), requisicaoImagensVO.getCodigoRequisicaoImagens(), requisicaoImagensVO});
        }
        this.table.getColumn("").setCellEditor(new ButtonEditor(this, this.table));
    }

    public List<RequisicaoImagensVO> getListaRequisicoesImagensExcluidos() {
        if (!this.isVerficouRegistros) {
            this.isVerficouRegistros = true;
            this.verificarRegistrosParaRetorno();
        }
        return this.listaRequisicoesImagensExcluidos;
    }

    public void setListaRequisicoesImagensExcluidos(List<RequisicaoImagensVO> listaRequisicoesImagensExcluidos) {
        this.listaRequisicoesImagensExcluidos = listaRequisicoesImagensExcluidos;
    }

    private void verificarRegistrosParaRetorno() {
        ArrayList<RequisicaoImagensVO> listaRequisicoesImagensAux = new ArrayList<RequisicaoImagensVO>();
        listaRequisicoesImagensAux.addAll(this.listaRequisicoesImagensExcluidos);
        for (RequisicaoImagensVO requisicaoImagensVO : listaRequisicoesImagensAux) {
            if (!requisicaoImagensVO.isFlagSalvar()) continue;
            this.listaRequisicoesImagensExcluidos.remove(requisicaoImagensVO);
            if (this.getOK()) {
                this.listaRequisicoesImagensExcluidos.add(requisicaoImagensVO);
                continue;
            }
            requisicaoImagensVO.setFlagSalvar(false);
            this.listaRequisicoesImagens.add(requisicaoImagensVO);
        }
        listaRequisicoesImagensAux.clear();
        listaRequisicoesImagensAux.addAll(this.listaRequisicoesImagens);
        for (RequisicaoImagensVO requisicaoImagensVO : listaRequisicoesImagensAux) {
            if (!requisicaoImagensVO.isFlagSalvar()) continue;
            this.listaRequisicoesImagens.remove(requisicaoImagensVO);
            if (!this.getOK()) continue;
            requisicaoImagensVO.setFlagSalvar(false);
            if (!Funcoes.objectIsNull(requisicaoImagensVO.getDescricaoRequisicaoImagensEdicao())) {
                requisicaoImagensVO.setDescricaoRequisicaoImagens(requisicaoImagensVO.getDescricaoRequisicaoImagensEdicao());
                requisicaoImagensVO.setTipoOperacao(requisicaoImagensVO.getTipoOperacaoEdicao());
            }
            this.listaRequisicoesImagens.add(requisicaoImagensVO);
        }
    }
}

