/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableModel;

public class SelecionaExamesUnimed
extends AbstractDialogoOKCancelar
implements ActionListener {
    JLabel labelJalis = new JLabel("C\u00f3digo AMB:");
    JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    TTextField textJalis = new TTextField(50, 3);
    TTextField textDescricao = new TTextField(200, 3);
    ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Descri\u00e7\u00e3o"});
    JTable tableExames = ComponenteFactory.novoJTable((TableModel)this.modeloExames, 35, 10, 65);
    JScrollPane scrollExames = new JScrollPane(this.tableExames);
    final int COLUNA_CODIGO = 0;
    final int COLUNA_DESCRICAO = 1;
    final int COLUNA_MODELO = 2;
    final int COLUNA_METODOLOGIA = 3;
    final int COLUNA_MATERIAL = 4;

    public static SelecionaExamesUnimed novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new SelecionaExamesUnimed((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new SelecionaExamesUnimed((Dialog)owner);
        }
        return null;
    }

    public SelecionaExamesUnimed(Frame owner) {
        super(owner, "Selecione o exame correspondente");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public SelecionaExamesUnimed(Dialog owner) {
        super(owner, "Selecione o exame correspondente");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public void setGuia(String guia) {
        this.setTitle("Selecione o exame correspondente da guia " + guia);
    }

    private void iniciar() {
        this.setSize(new Dimension(750, 300));
        this.setResizable(false);
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.tableExames.setModel(this.modeloExames);
        Dimension d = new Dimension(20, 20);
        this.scrollExames.setPreferredSize(d);
        d = new Dimension(20, 20);
        this.textJalis.setPreferredSize(d);
        d = new Dimension(110, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        this.modeloExames.setColumnSize(new int[]{100, 200, 700}, this.tableExames);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelJalis, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.textJalis, c);
        c.fill = 17;
        c.gridwidth = 0;
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 0;
        c.fill = 2;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.textDescricao, c);
        c.fill = 17;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.scrollExames, c);
        this.textDescricao.setEditable(false);
        this.textJalis.setEditable(false);
        this.setUsuarioPodeCancelar(false);
        this.buttonCancelar.setVisible(false);
        this.tableExames.registerKeyboardAction(null, KeyStroke.getKeyStroke(10, 0), 1);
        this.tableExames.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ScreenUtil.requisitarFoco(SelecionaExamesUnimed.this.buttonOK);
                }
            }
        });
        ScreenUtil.requisitarFoco(this.textJalis);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK && this.tableExames.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Selecione o exame correspondente.", 2);
            return;
        }
        super.actionPerformed(e);
    }

    public void setExames(List<Registro> exames) {
        for (Registro c : exames) {
            ExameVO exameVO = (ExameVO)c.getValor("objetoExame");
            this.modeloExames.addLine(new Object[]{exameVO.getCodigo(), c.getValor("mco_descricao"), c.getValor("exa_descricao"), c});
            this.textDescricao.setText("" + c.getValor("descricaoExame"));
            this.textJalis.setText("" + c.getValor("exame"));
        }
        this.tableExames.getSelectionModel().setSelectionInterval(0, 0);
    }

    public Registro getExame() {
        if (this.tableExames.getSelectedRow() >= 0) {
            return (Registro)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 3);
        }
        return null;
    }

    public void setTextLabel(String conteudoAMB, String conteudoDescricao) {
        this.labelJalis.setText(conteudoAMB);
        this.labelDescricao.setText(conteudoDescricao);
    }

    public void setTextTTextField(String conteudoAMB, String conteudoDescricao) {
        this.textJalis.setText(conteudoAMB);
        this.textDescricao.setText(conteudoDescricao);
    }
}

