/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.tempuri.TAgeExa;
import org.tempuri.TExaAge;

public class SelecionaExamesIDSSaude
extends AbstractDialogoOKCancelar
implements ActionListener {
    JLabel labelIDS = new JLabel("C\u00f3digo IDS:");
    JLabel labelSigla = new JLabel("Sigla:");
    JLabel labelDescricao = new JLabel("Descri\u00e7\u00e3o:");
    JLabel labelCodigoSUS = new JLabel("C\u00f3d. SUS:");
    TTextField textIDS = new TTextField(50, 3);
    TTextField textSigla = new TTextField(20, 3);
    TTextField textDescricao = new TTextField(200, 3);
    TTextField textCodigoSUS = new TTextField(100, 3);
    ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3d.", "Descri\u00e7\u00e3o", "Modelo", "Metodologia", "Material"});
    JTable tableExames = new JTable(this.modeloExames);
    JScrollPane scrollExames = new JScrollPane(this.tableExames);
    final int COLUNA_CODIGO = 0;
    final int COLUNA_DESCRICAO = 1;
    final int COLUNA_MODELO = 2;
    final int COLUNA_METODOLOGIA = 3;
    final int COLUNA_MATERIAL = 4;

    public static SelecionaExamesIDSSaude novaInstancia(Object owner) {
        if (owner instanceof Frame) {
            return new SelecionaExamesIDSSaude((Frame)owner);
        }
        if (owner instanceof Dialog) {
            return new SelecionaExamesIDSSaude((Dialog)owner);
        }
        return null;
    }

    public SelecionaExamesIDSSaude(Frame owner) {
        super(owner, "Selecione o exame correspondente");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public SelecionaExamesIDSSaude(Dialog owner) {
        super(owner, "Selecione o exame correspondente");
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    private void iniciar() {
        this.setSize(new Dimension(750, 300));
        this.setResizable(false);
        Dimension d = new Dimension(20, 20);
        this.scrollExames.setPreferredSize(d);
        d = new Dimension(20, 20);
        this.textIDS.setPreferredSize(d);
        d = new Dimension(110, 20);
        this.textDescricao.setPreferredSize(d);
        this.textDescricao.setMinimumSize(d);
        d = new Dimension(20, 20);
        this.textSigla.setPreferredSize(d);
        this.textSigla.setMinimumSize(d);
        d = new Dimension(200, 20);
        this.textCodigoSUS.setPreferredSize(d);
        this.textCodigoSUS.setMinimumSize(d);
        this.modeloExames.setColumnSize(new int[]{70, 0, 150, 150, 150}, this.tableExames);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelIDS, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 2;
        c.weightx = 1.0;
        panel.add((Component)this.textIDS, c);
        c.fill = 17;
        c.gridwidth = 1;
        ++c.gridx;
        c.insets = new Insets(1, 20, 0, 0);
        c.weightx = 0.0;
        panel.add((Component)this.labelSigla, c);
        ++c.gridx;
        c.fill = 2;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.textSigla, c);
        c.fill = 17;
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.labelDescricao, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.fill = 2;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.textDescricao, c);
        c.fill = 17;
        ++c.gridx;
        c.insets = new Insets(0, 20, 0, 0);
        panel.add((Component)this.labelCodigoSUS, c);
        ++c.gridx;
        c.insets = new Insets(1, 1, 0, 0);
        panel.add((Component)this.textCodigoSUS, c);
        ++c.gridx;
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 10;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(10, 0, 0, 0);
        panel.add((Component)this.scrollExames, c);
        this.textCodigoSUS.setEditable(false);
        this.textDescricao.setEditable(false);
        this.textIDS.setEditable(false);
        this.textSigla.setEditable(false);
        this.setUsuarioPodeCancelar(false);
        this.buttonCancelar.setVisible(false);
        ScreenUtil.requisitarFoco(this.textIDS);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK && this.tableExames.getSelectedRow() < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Selecione o exame correspondente.", 2);
            return;
        }
        super.actionPerformed(e);
    }

    public void setExames(List<Registro> exames) {
        this.modeloExames.clear();
        for (Registro c : exames) {
            ExameVO exameVO = (ExameVO)c.getValor("objetoExame");
            TExaAge exame = (TExaAge)c.getValor("exame");
            TAgeExa tAgeExa = (TAgeExa)c.getValor("tAgeExa");
            this.modeloExames.addLine(new Object[]{exameVO.getCodigo(), c.getValor("exa_descricao"), c.getValor("lay_descricao"), c.getValor("met_descricao"), c.getValor("mco_descricao"), c});
            this.textCodigoSUS.setText("" + exame.getProcedimentoSUS());
            this.textDescricao.setText(exame.getDescricao());
            this.textIDS.setText("" + exame.getCodigo());
            this.textSigla.setText(exame.getSigla());
        }
        this.tableExames.getSelectionModel().setSelectionInterval(0, 0);
    }

    public Registro getExame() {
        if (this.tableExames.getSelectedRow() >= 0) {
            return (Registro)this.modeloExames.getValueAt(this.tableExames.getSelectedRow(), 5);
        }
        return null;
    }
}

