/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.recepcao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.DisposeListener;
import jalis.model.vo.cadastro.ConvenioVO;
import jalis.service.cadastro.ConvenioService;
import jalis.util.ConvenioUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;

public class SelecionaConvenio
extends AbstractDialogoOKCancelar
implements DisposeListener,
ActionListener {
    private static final String CONVENIO_PROIBIDO = "Conv\u00eanio proibido";
    private static final String CONVENIO_BLOQUEADO_PARA_FILIAL = "Conv\u00eanio bloqueado para filial.";
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private TTextField textCodigoConvenio = new TTextField(5, 1);
    private JButton buttonBuscaConvenio = ComponenteFactory.novoJButton(this, true);
    private JLabel labelDescricaoConvenio = ComponenteFactory.novoJLabel("", null, new TitledBorder(""));
    private JButton buttonOKConvenio = new JButton("OK");
    private JTable table = new JTable();
    private JScrollPane scroll = new JScrollPane(this.table);
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Conv\u00eanio"});
    private static final String SELECIONA_CONVENIO = "SelecionaConvenio";
    private static final String ULTIMOS_CONVENIOS = "Orcamento.ultimosConvenios";
    private boolean abrirVazio = false;
    private Map<String, String> conveniosBloqueadosProibidos = new HashMap<String, String>();

    public static SelecionaConvenio novaInstancia(Object owner) {
        return owner instanceof Dialog ? new SelecionaConvenio((Dialog)owner) : new SelecionaConvenio((Frame)owner);
    }

    public SelecionaConvenio(Dialog owner) {
        super(owner, "Selecionar conv\u00eanio");
        this.montaTela();
    }

    public SelecionaConvenio(Frame owner) {
        super(owner, "Selecionar conv\u00eanio");
        this.montaTela();
    }

    public void setAbrirVazio(boolean abrirVazio) {
        this.abrirVazio = abrirVazio;
    }

    private void montaTela() {
        this.setModal(true);
        this.setSize(new Dimension(340, 306));
        this.setLocationRelativeTo(this.getParent());
        this.buttonOKConvenio.setMargin(new Insets(2, 2, 2, 2));
        this.table.setModel(this.modelo);
        this.modelo.setColumnSize(new int[]{70, 0}, this.table);
        JPanel panel = this.getPanelCentral();
        panel.setLayout(this.grid);
        this.montaCampoPesquisa(panel);
        this.montaTabela(panel);
        this.iniciaAcaoDaTela();
    }

    private void iniciaAcaoDaTela() {
        this.adicionaAcaoAbrirTela();
        this.acaoApagarLinha();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SelecionaConvenio.this.textCodigoConvenio.selectAll();
                SelecionaConvenio.this.textCodigoConvenio.grabFocus();
            }
        });
        this.acaoPerdeFoco();
        this.acaoOkConvenio();
        this.acaoF12();
    }

    private void acaoF12() {
        this.textCodigoConvenio.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113 && SelecionaConvenio.this.textCodigoConvenio.hasFocus()) {
                    SelecionaConvenio.this.buscaConvenio();
                }
            }
        });
    }

    private void acaoOkConvenio() {
        this.buttonOKConvenio.addActionListener(action -> {
            if (!this.labelDescricaoConvenio.getText().equals("N\u00e3o cadastrado") && !Funcoes.textoVazio(this.textCodigoConvenio.getText()) && this.modelo.localizar(0, this.textCodigoConvenio.getText()) < 0) {
                try {
                    Statement st = Conexao.getStatement();
                    if (st != null) {
                        DadosConvenios dados = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(this.textCodigoConvenio.getText()));
                        this.validaAddLine(dados);
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), SELECIONA_CONVENIO);
                }
            }
            this.textCodigoConvenio.selectAll();
            this.labelDescricaoConvenio.setText("");
            this.textCodigoConvenio.clear();
            this.textCodigoConvenio.grabFocus();
        });
    }

    private void validaAddLine(DadosConvenios dados) {
        if (dados != null && dados.getTabela() > -1) {
            boolean convenioBloqueado = this.convenioBloqueado(this.textCodigoConvenio.getText());
            if (this.convenioProibido(dados, this.textCodigoConvenio.getText()) || convenioBloqueado) {
                String mensagem = convenioBloqueado ? CONVENIO_BLOQUEADO_PARA_FILIAL : CONVENIO_PROIBIDO;
                Funcoes.mensagem(this, mensagem, 2);
                return;
            }
            this.modelo.addLine(new Object[]{this.textCodigoConvenio.getText(), this.labelDescricaoConvenio.getText(), dados});
        } else {
            Funcoes.mensagem(this, "Conv\u00eanio sem tabela definida", 1);
        }
    }

    private void acaoPerdeFoco() {
        this.textCodigoConvenio.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!Funcoes.textoVazio(SelecionaConvenio.this.textCodigoConvenio.getText())) {
                    try {
                        ConvenioVO convenio = (ConvenioVO)new ConvenioService().getVO(Variaveis.filialPadrao, SelecionaConvenio.this.textCodigoConvenio.getText());
                        if (convenio != null) {
                            SelecionaConvenio.this.labelDescricaoConvenio.setText(convenio.getFantasia());
                        } else {
                            SelecionaConvenio.this.labelDescricaoConvenio.setText("N\u00e3o cadastrado");
                        }
                    }
                    catch (Exception ex) {
                        ErrorLogger.mostraMensagem(SelecionaConvenio.this, ex.getMessage(), ex.getStackTrace(), SelecionaConvenio.SELECIONA_CONVENIO);
                    }
                }
            }
        });
    }

    private void acaoApagarLinha() {
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (SelecionaConvenio.this.table.getSelectedRow() > -1 && e.getKeyCode() == 127 && Funcoes.mensagem(SelecionaConvenio.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                    SelecionaConvenio.this.conveniosBloqueadosProibidos.remove(String.valueOf(SelecionaConvenio.this.modelo.getLine(SelecionaConvenio.this.table.getSelectedRow()).get("C\u00f3digo")));
                    SelecionaConvenio.this.modelo.removeLine(SelecionaConvenio.this.table.getSelectedRow());
                }
            }
        });
    }

    private void adicionaAcaoAbrirTela() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                try {
                    if (!Variaveis.tipoFilialPadrao.equals("A") && !SelecionaConvenio.this.abrirVazio) {
                        SelecionaConvenio.this.buscaUltimosConvenios();
                    }
                }
                catch (SQLException sqlex) {
                    ErrorLogger.mostraMensagem(SelecionaConvenio.this, sqlex.getMessage(), sqlex.getStackTrace(), SelecionaConvenio.SELECIONA_CONVENIO);
                }
            }
        });
    }

    private void montaTabela(JPanel panel) {
        this.constraints.gridx = 2;
        this.constraints.gridy = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.labelDescricaoConvenio.setPreferredSize(new Dimension(70, 20));
        this.labelDescricaoConvenio.setMinimumSize(new Dimension(70, 20));
        panel.add((Component)this.labelDescricaoConvenio, this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 4;
        this.constraints.fill = 1;
        this.constraints.weighty = 1.0;
        panel.add((Component)this.scroll, this.constraints);
    }

    private void montaCampoPesquisa(JPanel panel) {
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 18;
        panel.add((Component)new JLabel("Conv\u00eanio"), this.constraints);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.textCodigoConvenio.setPreferredSize(new Dimension(70, 20));
        this.textCodigoConvenio.setMinimumSize(new Dimension(70, 20));
        panel.add((Component)this.textCodigoConvenio, this.constraints);
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.buttonBuscaConvenio.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaConvenio.setMinimumSize(new Dimension(20, 20));
        panel.add((Component)this.buttonBuscaConvenio, this.constraints);
        this.constraints.gridx = 3;
        this.constraints.gridy = 1;
        this.buttonOKConvenio.setPreferredSize(new Dimension(40, 20));
        this.buttonOKConvenio.setMinimumSize(new Dimension(40, 20));
        panel.add((Component)this.buttonOKConvenio, this.constraints);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonBuscaConvenio) {
            this.buscaConvenio();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public boolean acaoOk() {
        if (!this.conveniosBloqueadosProibidos.isEmpty()) {
            Funcoes.mensagem(this, this.conveniosBloqueadosProibidos.values().iterator().next(), 2);
            return false;
        }
        if (this.modelo.getRowCount() <= 0 && Funcoes.mensagem(this, "N\u00e3o h\u00e1 conv\u00eanios selecionados para o or\u00e7amento, deseja continuar?", 4) == 0 || this.modelo.getRowCount() > 0) {
            if (!this.abrirVazio) {
                this.gravaUltimosConvenios();
            }
            this.ok = true;
            return true;
        }
        return false;
    }

    private boolean convenioBloqueado(String codigoConvenio) {
        return Acesso.getAcesso(200100109L) && !new ConvenioService().permiteAdicionarConvenio(codigoConvenio, Variaveis.filialPadrao);
    }

    private boolean convenioProibido(DadosConvenios dados, String codigoConvenio) {
        return Acesso.getAcesso(200100109L) && dados.getProibido();
    }

    private void buscaUltimosConvenios() throws SQLException {
        String xml = ParametrosUsuarios.getValor(ULTIMOS_CONVENIOS);
        String[] lista = StringUtil.getValores(xml, "codigo");
        this.modelo.clear();
        this.conveniosBloqueadosProibidos = new HashMap<String, String>();
        for (String s : lista) {
            DadosConvenios dados = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, Integer.parseInt(s));
            if (this.convenioProibido(dados, s) || this.convenioBloqueado(s)) continue;
            try {
                Statement st = Conexao.getStatement();
                String convenioCodigo = String.valueOf(dados.getCodigo());
                if (st == null || !Funcoes.isNumeric(s) || dados == null || this.modelo.localizar(0, convenioCodigo) >= 0 || dados.getTabela() <= -1) continue;
                this.verificaConvenioProibidoBloqueado(dados, convenioCodigo);
                this.modelo.addLine(new Object[]{convenioCodigo, dados.getFantasia(), dados});
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), SELECIONA_CONVENIO);
            }
        }
    }

    private void verificaConvenioProibidoBloqueado(DadosConvenios dados, String convenioCodigo) {
        if (this.convenioBloqueado(convenioCodigo)) {
            this.conveniosBloqueadosProibidos.put(convenioCodigo, CONVENIO_BLOQUEADO_PARA_FILIAL);
        } else if (this.convenioProibido(dados, convenioCodigo)) {
            this.conveniosBloqueadosProibidos.put(convenioCodigo, CONVENIO_PROIBIDO);
        }
    }

    private void gravaUltimosConvenios() {
        StringBuilder xml = new StringBuilder("<convenios>");
        if (ParametrosLocais.existeParametro("naoArmazenarConvenioOrcamento") && !ParametrosLocais.getParametro("naoArmazenarConvenioOrcamento").isEmpty() && ParametrosLocais.getParametro("naoArmazenarConvenioOrcamento").equals("0")) {
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                xml.append(StringUtil.getTag("codigo", this.modelo.getValueAt(i, 0).toString()));
            }
        }
        xml.append("</convenios>");
        ParametrosUsuarios.setValor(ULTIMOS_CONVENIOS, xml.toString());
    }

    private void buscaConvenio() {
        Hashtable resultado = Pesquisas.convenio(this, true, false);
        if (resultado != null) {
            this.textCodigoConvenio.setText(resultado.get("con_codigo").toString());
        }
        this.textCodigoConvenio.requestFocus();
    }

    @Override
    public boolean getOK() {
        return this.ok;
    }

    public List<DadosConvenios> getConvenios() {
        ArrayList<DadosConvenios> a = new ArrayList<DadosConvenios>();
        for (int i = 0; i < this.modelo.getRowCount(); ++i) {
            if (!(this.modelo.getValueAt(i, 2) instanceof DadosConvenios)) continue;
            DadosConvenios c = (DadosConvenios)this.modelo.getValueAt(i, 2);
            a.add(c);
        }
        return !a.isEmpty() ? a : null;
    }
}

